<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="!uiModel.editMode">
		<cv:msg key="header.addInterfaces" bundle="settingsJs" />
	</h1>
	<h1 data-ng-if="uiModel.editMode">
		<cv:msg key="header.editInterfaces" bundle="settingsJs" />
	</h1>
</div>
<form name="addEditInterfacesForm" data-ng-submit="saveInterfaces()" novalidate autocomplete="off">
	<div class="setup-content">
		<span class="{{uiModel.serverMessage.type}}" data-ng-bind="uiModel.serverMessage.message"></span>
		<div class="bootstrap-wrapper">
			<div class="panel-body">			
				<div class="form-group row">
					<label for="interfacesOnClient1" class="col-sm-5">
						<cv:msg key="label.clientInterfacesFor" bundle="settingsJs" params="{{uiModel.clientEntityOne.name}}"/>
					</label>
					<div class="col-sm-7">
						<cv-editable-select
     						data-ng-if="!uiModel.isSourceClientGroup"
							name="interface1"
							cv-model="uiModel.pipeLineInfo.client1.name"
							dropdown-options="uiModel.interfacesOnClient1"
							dropdown-place-holder="<cv:msg key="label.selectInterface" bundle="settingsJs" />">
						</cv-editable-select>
						
						<cv-editable-select
						    data-ng-if="uiModel.isSourceClientGroup"
							name="interface1"
							cv-model="uiModel.pipeLineInfo.client1.name"
							dropdown-options="uiModel.interfacesOnClient1"
							input-place-holder="<cv:msg key="label.noDefaultInterfaces" bundle="settingsJs"/>"
							dropdown-place-holder=""
						</cv-editable-select>					   
					</div>
				</div>
				
				<div class="form-group row">
					<label for="interfacesOnClient2" class="col-sm-5">
						<cv:msg key="label.clientInterfacesFor" bundle="settingsJs" params="{{uiModel.clientEntityTwo.name}}"/>
					</label>
					<div class="col-sm-7">
						<cv-editable-select
						    data-ng-if="!uiModel.isDestClientGroup"
							name="interface2"
							cv-model="uiModel.pipeLineInfo.client2.name"
							dropdown-options="uiModel.interfacesOnClient2"
							dropdown-place-holder="<cv:msg key="label.selectInterface" bundle="settingsJs" />">
						</cv-editable-select>
						<cv-editable-select
						    data-ng-if="uiModel.isDestClientGroup"
							name="interface2"
							cv-model="uiModel.pipeLineInfo.client2.name"
							dropdown-options="uiModel.interfacesOnClient2"
							input-place-holder="<cv:msg key="label.noDefaultInterfaces" bundle="settingsJs"/>"
							dropdown-place-holder=""
						</cv-editable-select>
					</div>
				</div>
							
				<div class="form-group">
					<input type="checkbox" id="status" name="status" data-ng-model="uiModel.pipeLineStatus" />
					<label for="status"><cv:msg key="label.enabled" bundle="users"/></label>
				</div>
			</div>			
		</div>
	
		<div class="button-container">
			<button id="addInterfaces_button_#8581" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="close()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="addInterfaces_button_#0718" type="submit" class="btn btn-primary cvBusyOnAjax"  
					data-ng-disabled="addEditInterfacesForm.$invalid"
					data-ng-if="uiModel.editMode"><cv:msg key="Save" bundle="messages" /></button>
			<button id="addInterfaces_button_#5915" type="submit" class="btn btn-primary cvBusyOnAjax" 
					data-ng-disabled="addEditInterfacesForm.$invalid"
					data-ng-if="!uiModel.editMode"><cv:msg key="Add" bundle="messages" /></button>
		</div>
	</div>
</form>