<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="!model.editMode">
		<cv:msg key="label.addConfiguration" bundle="settingsJs" />
	</h1>
	<h1 data-ng-if="model.editMode">
		<cv:msg key="label.editConfiguration" bundle="settingsJs" />
	</h1>
</div>
<div class="bootstrap-wrapper">
	<form name="snmpConfigurationForm" data-ng-submit="saveConfiguration()" novalidate>
		<div class="form-group">
			<div class="col-sm-5">
				<label for="hostname"><cv:msg key="header.hostname" bundle="vmsJs" /></label>
			</div>
			<div class="col-sm-7">
				<input type="text" id="hostname" name="hostname" data-ng-model="model.snmpInfo.hostName" data-ng-change="model.duplicateHostName=false;" autofocus required/>
				<span class="help-block" data-ng-show="needsAttention(snmpConfigurationForm.hostname)"><cv:msg key="error.vcenterHostRequired" bundle="restore" /></span>
				<span class="help-block" data-ng-show="model.duplicateHostName"><cv:msg key="error.duplicateHostName" bundle="settingsJs" /></span>
			</div>
		</div>
		
		<div class="form-group">
			<div class="col-sm-5"><label for="encryptionAlgorithm"><cv:msg key="label.authenticationAlgorithm" bundle="settingsJs" /></label></div>
			<div class="col-sm-7">
				<select data-ng-change="encryptionChanged()" id="encryptionAlgorithm" name="encryptionAlgorithm" data-ng-model="model.snmpInfo.encryptAlgorithm" data-ng-options="algorithm for algorithm in model.encryptionAlgorithms" required>
				</select>
			</div>
		</div>
		
		<div>
			<div class="form-group">
				<div class="col-sm-5"><label for="username"><cv:msg key="label.userName" bundle="users" /></label></div>
				<div class="col-sm-7">
					<input type="text" id="username" name="username" data-ng-model="model.snmpInfo.userAccount.userName" data-ng-change="userNameChanged()" required/>
					<span class="help-block" data-ng-show="needsAttention(snmpConfigurationForm.username)"><cv:msg key="error.vm.userName" bundle="vms" /></span>
				</div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-5"><label for="password"><cv:msg key="label.password" bundle="settingsJs" /></label></div>
				<div class="col-sm-7">
					<input type="password" id="password" name="password" data-ng-model="model.password" data-ng-minlength="8" required/>
					<span class="help-block" data-ng-show="needsAttention(snmpConfigurationForm.password)"><cv:msg key="error.vm.password" bundle="vms" /></span>
					<span class="help-block" data-ng-show="snmpConfigurationForm.password.$error.minlength"><cv:msg key="error.passwordMinLength" bundle="settingsJs"/></span>
				</div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-5"><label for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="users" /></div>
				<div class="col-sm-7">
					<input type="password" id="confirmPassword" name="confirmPassword" data-ng-model="model.confirmPassword" required/>
					<span class="help-block" data-ng-show="needsAttention(snmpConfigurationForm.confirmPassword)"><cv:msg key="error.confirmPassword" bundle="settingsJs" /></span>
					<span class="help-block" data-ng-show="snmpConfigurationForm.confirmPassword.$touched && snmpConfigurationForm.confirmPassword.$valid && !hasPasswordsMatched()">
		            	<cv:msg key="error.passwordNotMatched" bundle="setup" />
		           	</span>
				</div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-5">
					<label for="privacyAlgorithm"><cv:msg key="label.privacyAlgorithm" bundle="settingsJs" /></label>
				</div>
				<div class="col-sm-7">
					<select id="privacyAlgorithm" name="privacyAlgorithm" data-ng-model="model.snmpInfo.privacyAlgorithm" 
						data-ng-options="algorithm for algorithm in model.privacyAlgorithms" required></select>
					<span class="help-block" data-ng-show="!snmpConfigurationForm.privacyAlgorithm.$valid">
				            	<cv:msg key="error.privacyAlgorithm" bundle="setup" />
			           	</span>
				</div>
			</div>
		
			<div class="form-group" data-ng-show="model.snmpInfo.privacyAlgorithm!=model.privacyAlgorithms[0]">
				<div class="col-sm-5">
					<label for="privacyPassword">
						<cv:msg key="label.privacyPassword" bundle="settingsJs" /></label>
				</div>
				<div class="col-sm-7">
					<input type="password" id="privacyPassword" name="privacyPassword" data-ng-model="model.privacyPassword" 
						data-ng-minlength="8" data-ng-required="model.snmpInfo.privacyAlgorithm!=model.privacyAlgorithms[0]" />
					<span class="help-block" data-ng-show="needsAttention(snmpConfigurationForm.privacyPassword)"><cv:msg key="error.privacyPassword" bundle="settingsJs" /></span>
					<span class="help-block" data-ng-show="snmpConfigurationForm.privacyPassword.$error.minlength"><cv:msg key="error.passwordMinLength" bundle="settingsJs"/></span>
				</div>
			</div>
			
			<div class="form-group" data-ng-show="model.snmpInfo.privacyAlgorithm!=model.privacyAlgorithms[0]">
				<div class="col-sm-5">
					<label for="confirmPrivacyPassword">
					<cv:msg key="label.confirmPrivacyPassword" bundle="settingsJs" /></label>
				</div>
				<div class="col-sm-7">
					<input type="password" id="confirmPrivacyPassword" name="confirmPrivacyPassword" data-ng-model="model.confirmPrivacyPassword" 
						data-ng-required="model.snmpInfo.privacyAlgorithm!=model.privacyAlgorithms[0]"/>
					<span class="help-block" data-ng-show="needsAttention(snmpConfigurationForm.confirmPrivacyPassword)"><cv:msg key="error.confirmPrivacyPassword" bundle="settingsJs" /></span>
					<span class="help-block" data-ng-show="model.snmpInfo.privacyAlgorithm!=model.privacyAlgorithms[0] && snmpConfigurationForm.confirmPrivacyPassword.$touched && snmpConfigurationForm.confirmPrivacyPassword.$valid && !hasPrivacyPasswordsMatched()">
		            	<cv:msg key="error.passwordNotMatched" bundle="setup" />
		           	</span>
				</div>
			</div>
		</div>
						
		<div class="modal-footer">
			<button id="addEditSNMPV3Configuration_button_#0780" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="close()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="addEditSNMPV3Configuration_button_#9836" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button> 
		</div>
	</form>
</div>
