<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
    <cv:cvMessages bundle="localization.emailTemplate"></cv:cvMessages>
</script>
<div>
	<div class="setup-title" ng-switch="editing">
		<div ng-switch-when="replication">
			<h1><cv:msg key="title.editReplicationSettings" bundle="settingsJs"/></h1>
		</div>
		<div ng-switch-when="alert">
			<h1><cv:msg key="title.addAlert" bundle="settingsJs"/></h1>
		</div>
		<div ng-switch-when="connectivity">
			<h1><cv:msg key="title.editConnectivity" bundle="settingsJs"/></h1>
		</div>
		<div ng-switch-when="MonitoringClients">
			<h1><cv:msg key="title.addMonitoringNodes" bundle="settingsJs"/></h1>
		</div>
	</div>
	<div data-ng-controller="configureCvLiveSyncModalController" class="bootstrap-wrapper form-horizontal modal-margin" ng-switch="editing">
		<form name="configureCvLiveSyncModalForm" novalidate data-cv-submit="onSave()" autocomplete="off" data-ng-hide="formConfig.hide">
			<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
			<div ng-switch-when="replication">
				<div class="group margin-bottom-10">
					<span class="col-xs-12 col-md-4 col-lg-4" id="enableAutomaticFailover" class="cv-label">
						<cv:msg key="label.enableAutomaticFailover" bundle="settingsJs"/>
					</span>
					<div class="col-xs-12 col-md-4">
						<toggle-control id="enableAutomaticFailover"
							status="locals.enableAutomaticFailover ? 'enabled-activity' : 'disabled-activity'"
							data-ng-click="toggleLocal('enableAutomaticFailover')">
						</toggle-control>
					</div>
				</div>				
				<label class="col-xs-12 col-md-4 col-lg-4" id="syncInterval" class="cv-label">
					<cv:msg key="label.interval" bundle="settingsJs"/>
				</label>
				<div class="col-xs-12 col-md-8">
					<input id="syncInterval" type="number" name="input" ng-model="locals.liveSyncRPO" min="1" max="1440">
					<span><cv:msg key="label.minutes" bundle="settingsJs"/></span>
				</div>
					<label class="col-xs-12 col-md-4 col-lg-4" id="failoverPolicy">
						<cv:msg key="label.storagePolicy" bundle="profiles"/>
					</label>
					<div class="col-xs-12 col-md-8">
						<span ng-if="lists.backupStoragePolicy && lists.backupStoragePolicy.length > 0">
							<isteven-multi-select id="CvLiveSyncModal_isteven-multi-select_#8884" name="ArrayControllers" input-model="lists.backupStoragePolicy" output-model="locals.backupStoragePolicy" 
									button-label="storagePolicyName" item-label="storagePolicyName" tick-property="ticked" 
									class="isteven-multi-select user-group-select"
									helper-elements="reset" disable-property="disabled" hide-search-button="true"
									search-limit="10" selection-mode="single">
							</isteven-multi-select>
						</span>
						<span ng-if="!lists.backupStoragePolicy || lists.backupStoragePolicy.length === 0">
							<cv:msg key="label.noneAvailable" bundle="settingsJs" />
						</span>
					</div>
			</div>
			<div ng-switch-when="connectivity">
				<label class="col-xs-12 col-md-4 col-lg-4" id="proxyClientGroup" class="cv-label">
					<cv:msg key="label.clientGroup" bundle="settingsJs"/>
				</label>
				<div class="col-xs-12 col-md-8">
					<span data-ng-if="lists.proxyClientGroup.length > 0">
						<isteven-multi-select id="CvLiveSyncModal_isteven-multi-select_#2523" name="ArrayControllers" input-model="lists.proxyClientGroup" output-model="locals.proxyClientGroup" 
								button-label="clientGroupName" item-label="clientGroupName" tick-property="ticked" 
								class="isteven-multi-select user-group-select"
								helper-elements="reset" disable-property="disabled" hide-search-button="true"
								search-limit="10" selection-mode="single">
						</isteven-multi-select>
					</span>
					<span data-ng-if="lists.proxyClientGroup.length === 0">
						<cv:msg key="label.noneAvailable" bundle="settingsJs" />
					</span>
				</div>
			</div>
			<div ng-switch-when="MonitoringClients">
				<div class="margin-left-right servergroup-modal-height">
					<cv-kendo-grid data-ng-if="availableClientsGridOptions" cv-grid-options="availableClientsGridOptions"></cv-kendo-grid>
				</div>
			</div>
			<div class="setup-content" ng-switch-when="alert">
				<label id="alertName" class="cv-label"><cv:msg key="label.alertName" bundle="alerts" />
					<input id="alertName" type="text" name="alertName" data-ng-model="locals.alertName" id="alertName" maxlength="128" required />
				</label>
				<div class="col-xs-12 no-padding padding-top-20 padding-left-15">
					<h4 class="col-xs-12 float-left text-left padding-bottom-10 padding-top-20"><cv:msg key="label.recipients" bundle="alerts" /></h4>
					<div class="col-xs-12 padding-bottom-20 add-users group plan-usergroup-invite left-align-select2">
						<label id="toUserList" class="no-margin no-padding col-xs-12"><cv:msg key="label.toUser" bundle="alerts"/>
							<input id="toUserList" name="toUserList" class="alert-add-user-input">
						</label>
						<div id="toEmailErrorMessage" class="col-xs-12 invite-error-message error serverMessage">
							<cv:msg key="error.validEmailError" bundle="alertsJs"/>
						</div>
					</div>
					<div class="col-xs-12 padding-bottom-20 add-users group plan-usergroup-invite left-align-select2">
						<label id="ccUserList" class="no-margin no-padding col-xs-12"><cv:msg key="emailTemplates.label.cc" bundle="emailTemplate"/>
							<input id="ccUserList" name="ccUserList" class="alert-add-user-input">
						</label>
						<div id="ccEmailErrorMessage" class="col-xs-12 invite-error-message error serverMessage">
							<cv:msg key="error.validEmailError" bundle="alertsJs"/>
						</div>
					</div>
					<div class="col-xs-12 padding-bottom-20 add-users group plan-usergroup-invite left-align-select2">
						<label id="bccUserList" class="no-margin no-padding col-xs-12"><cv:msg key="emailTemplates.label.bcc" bundle="emailTemplate"/>
							<input id="bccUserList" name="bccUserList" class="alert-add-user-input">
						</label>
						<div id="bccEmailErrorMessage" class="col-xs-12 invite-error-message error serverMessage">
							<cv:msg key="error.validEmailError" bundle="alertsJs"/>
						</div>
					</div>
				</div>
			</div>
			<div class="button-container">
				<button id="CvLiveSyncModal_button_#7841" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
					data-ng-click="onCancelModal()">
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button data-ng-if="editing === 'MonitoringClients'" id="CvLiveSyncModal_button_#4583" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<cv:msg key="Add" bundle="messages" />
				</button>
				<button data-ng-if="editing !== 'MonitoringClients'" id="CvLiveSyncModal_button_#4582" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<cv:msg key="Save" bundle="messages" />
				</button>
			</div>	
		</form>
	</div>
</div>