import { commonAllAgentsModule } from 'common/js/modules';

var mod = commonAllAgentsModule;

mod.factory('globalAddActionsFactory', [
	'cvLoc',
	'$state',
	'subscriptionsUIFactory',
	'serverUIFactory',
	'rolesFactory',
	'addProxyDialogFactory',
	'profileUIFactory',
	'usersFactory',
	'userGroupsUIFactory',
	'nasFactory',
	'editArrayFactory',
	'clientGroupsFactory',
	'devicesFactory',
	'pushInstallSoftwareFactory',
	'cvPermissionFactory',
	'cvNavigationFactory',
	'PERMISSIONS',
	function(
		cvLoc,
		$state,
		subscriptionsUIFactory,
		serverUIFactory,
		rolesFactory,
		addProxyDialogFactory,
		profileUIFactory,
		usersFactory,
		userGroupsUIFactory,
		nasFactory,
		editArrayFactory,
		clientGroupsFactory,
		devicesFactory,
		pushInstallSoftwareFactory,
		cvPermissionFactory,
		cvNavigationFactory,
		PERMISSIONS
	) {
		var factory = {};

		var STATENAMES = _.cloneDeep(cvNavigationFactory.LIST_STATENAMES);

		// List of all the entities the user can add from global search
		factory.ENTITIES = [
			{
				entityType: 'ADD_VM_GROUPS',
				addEntityName: cvLoc('label.nav.vmGroups'),
				addStateName: STATENAMES.VM_GROUPS,
				permissionIds: [],
				handler: function() {
					serverUIFactory.openAddCollectionDialog();
				}
			},
			{
				entityType: 'ADD_KUBERNETES_APPLICATION_GROUPS',
				addEntityName: cvLoc('label.globalActions.applicationGroup'),
				addStateName: STATENAMES.APPLICATION_GROUPS,
				permissionIds: [],
				handler: function() {
					serverUIFactory.openAddCollectionDialog(...Array(2), true);
				}
			},
			{
				entityType: 'ADD_COMPANY',
				addEntityName: cvLoc('label.nav.subscriptions'),
				addStateName: STATENAMES.COMPANY,
				permissionIds: [PERMISSIONS.CREATE_COMPANY],
				handler: function() {
					subscriptionsUIFactory.addSubscriptionWindow();
				}
			},
			{
				entityType: 'ADD_ROLES',
				addEntityName: cvLoc('label.nav.roles'),
				addStateName: STATENAMES.ROLES,
				permissionIds: [PERMISSIONS.CREATE_ROLE],
				handler: function() {
					rolesFactory.showAddRoleDialog();
				}
			},
			{
				entityType: 'ADD_GATEWAY',
				addEntityName: cvLoc('label.globalSearch.gateway'),
				addStateName: STATENAMES.GATEWAY,
				permissionIds: [],
				handler: function() {
					addProxyDialogFactory.showAddProxyDialog();
				}
			},
			{
				entityType: 'ADD_SERVER_PLAN',
				addEntityName: cvLoc('label.globalSearch.serverPlan'),
				addStateName: STATENAMES.PLAN,
				permissionIds: [PERMISSIONS.CREATE_PLAN],
				handler: function() {
					profileUIFactory.createServerPlan();
				}
			},
			{
				entityType: 'ADD_LAPTOP_PLAN',
				addEntityName: cvLoc('label.globalSearch.laptopPlan'),
				addStateName: STATENAMES.PLAN,
				permissionIds: [PERMISSIONS.CREATE_PLAN],
				handler: function() {
					profileUIFactory.createLaptopPlan();
				}
			},
			{
				entityType: 'ADD_EXCHANGE_MAILBOX_PLAN',
				addEntityName: cvLoc('label.globalSearch.exchangeMailboxPlan'),
				addStateName: STATENAMES.PLAN,
				permissionIds: [PERMISSIONS.CREATE_PLAN],
				handler: function() {
					profileUIFactory.configureExchangePlan();
				}
			},
			{
				entityType: 'ADD_DC_PLAN',
				addEntityName: cvLoc('label.globalSearch.addDCPlan'),
				addStateName: STATENAMES.PLAN,
				permissionIds: [PERMISSIONS.CREATE_PLAN],
				handler: function() {
					profileUIFactory.createEdiscoveryPlan();
				}
			},
			{
				entityType: 'ADD_USERS',
				addEntityName: cvLoc('label.nav.users'),
				addStateName: STATENAMES.USERS,
				permissionIds: [PERMISSIONS.USER_MANAGEMENT],
				handler: function() {
					usersFactory.openAddUserModal();
				}
			},
			{
				entityType: 'ADD_USERS_GROUPS',
				addEntityName: cvLoc('label.nav.userGroups'),
				addStateName: STATENAMES.USER_GROUPS,
				permissionIds: [PERMISSIONS.USER_GROUP_MANAGEMENT],
				handler: function() {
					userGroupsUIFactory.addUserGroup();
				}
			},
			{
				entityType: 'ADD_NAS_SERVER',
				addEntityName: cvLoc('label.globalActions.nasServer'),
				addStateName: STATENAMES.FS_SERVER,
				permissionIds: [PERMISSIONS.MANAGE_INSTALLATION],
				handler: function() {
					nasFactory.openCreateNewNASClient();
				}
			},
			{
				entityType: 'ADD_NUTANIX_FILES',
				addEntityName: cvLoc('label.globalActions.nutanixFiles'),
				addStateName: STATENAMES.FS_SERVER,
				permissionIds: [PERMISSIONS.MANAGE_INSTALLATION],
				handler: function() {
					nasFactory.openCreateNewNutanixFilesClient();
				}
			},
			{
				entityType: 'ADD_QUMULO_FILES',
				addEntityName: cvLoc('label.globalActions.qumuloFilestorage'),
				addStateName: STATENAMES.FS_SERVER,
				permissionIds: [PERMISSIONS.MANAGE_INSTALLATION],
				handler: function() {
					nasFactory.openCreateQumuloFilesClient();
				}
			},
			{
				entityType: 'ADD_HYPERVISOR_SERVER',
				addEntityName: cvLoc('label.globalActions.hypervisor'),
				addStateName: STATENAMES.HYPERVISOR,
				permissionIds: [PERMISSIONS.MANAGE_INSTALLATION],
				handler: function() {
					serverUIFactory.showAddServerDialog();
				}
			},
			{
				entityType: 'ADD_KUBERNETES_CLUSTER',
				addEntityName: cvLoc('label.globalActions.cluster'),
				addStateName: STATENAMES.CLUSTER,
				permissionIds: [PERMISSIONS.MANAGE_INSTALLATION],
				handler: function() {
					serverUIFactory.showAddServerDialog(true);
				}
			},
			{
				entityType: 'ADD_SERVER_GROUP',
				addEntityName: cvLoc('label.globalActions.serverGroup'),
				addStateName: STATENAMES.SERVER_GROUP,
				permissionIds: [PERMISSIONS.CREATE_CLIENT_GROUP],
				handler: function() {
					clientGroupsFactory.addEditClientGroup(undefined, false);
				}
			},
			{
				entityType: 'ADD_LAPTOP',
				addEntityName: cvLoc('label.globalActions.laptop'),
				addStateName: STATENAMES.LAPTOP,
				permissionIds: [PERMISSIONS.MANAGE_INSTALLATION],
				handler: function() {
					devicesFactory._showAddDeviceDialog();
				}
			},
			{
				entityType: 'ADD_FS_SERVER',
				addEntityName: cvLoc('label.globalActions.windowsUnixSystem'),
				addStateName: STATENAMES.FS_SERVER,
				permissionIds: [PERMISSIONS.MANAGE_INSTALLATION],
				handler: function() {
					const defaultFSParam = pushInstallSoftwareFactory.getDefaultPushInstallFSParams();
					pushInstallSoftwareFactory.openPushInstallDialog(defaultFSParam, '');
				}
			},
			{
				entityType: 'ADD_ARRAY',
				addEntityName: cvLoc('label.nav.snapArrays'),
				handler: function() {
					editArrayFactory.goToCreateSnapArray();
				}
			}
		];

		factory.cachedEntities = null;

		// This function returns the list of all supported actions that are available to add
		factory.getSupportedAddAction = function(val) {
			// If previously computed then do not compute again
			if (factory.cachedEntities !== null) {
				return filterArray(factory.cachedEntities, val);
			}
			// allow only actions for which the user can see the page & has permissions for
			factory.cachedEntities = factory.ENTITIES.reduce(function(arr, item) {
				if (
					$state.href(item.addStateName) &&
					cvPermissionFactory.userHasPermissions(
						item.permissionIds,
						_.has(cv, 'userPermissions') ? cv.userPermissions : []
					)
				) {
					arr.push(item);
				}
				return arr;
			}, []);

			// return list of filtered result based on what user has typed ans sort it in ascending order
			return filterArray(
				factory.cachedEntities.sort(function(a, b) {
					return a.addEntityName > b.addEntityName ? 1 : -1;
				}),
				val
			);
		};

		// Filter the array based on what user has typed
		var filterArray = function(arr, val) {
			return arr.filter(function(obj) {
				var strToCheck = obj.addEntityName.toLowerCase();
				if (strToCheck.includes(val.toLowerCase())) {
					return true;
				}
				return false;
			});
		};

		// When an action is clicked called its relevant method to execute
		factory.performAction = function(itemType, callback) {
			for (let i = 0; i < factory.ENTITIES.length; i++) {
				if (factory.ENTITIES[i].entityType === itemType) {
					if (callback) {
						callback();
					}
					factory.ENTITIES[i].handler();
					return;
				}
			}

			if (callback) {
				callback({
					noResultsFound: true
				});
			}
		};

		factory.lookupAction = function(str) {
			let stringToFind = str.join(' ');
			for (let i = 0; i < factory.ENTITIES.length; i++) {
				let actionName = factory.ENTITIES[i].addEntityName.toLowerCase();
				if (actionName.indexOf(stringToFind) != -1) {
					return factory.ENTITIES[i].entityType;
				}
			}
			return -1;
		};

		return factory;
	}
]);

export default mod;
