import { commonAllAgentsModule } from 'common/js/modules';

var mod = commonAllAgentsModule;

mod.factory('globalActionsFactory', [
	'vmGroupsFactory',
	'settingsService',
	'cvPermissionFactory',
	'orderByFilter',
	'ENTITY_TYPES',
	'vendorTypes',
	'editArrayFactory',
	'serverUIFactory',
	'virtualMachineFactory',
	'subscriptionsUIFactory',
	'serversPageFactory',
	'devicesFactory',
	'fileServersPageFactory',
	'clientGroupsFactory',
	'usersFactory',
	'userGroupsUIFactory',
	'commcellUtils',
	'mediaAgentListFactory',
	'distributedStorageFactory',
	function(
		vmGroupsFactory,
		settingsService,
		cvPermissionFactory,
		orderByFilter,
		ENTITY_TYPES,
		vendorTypes,
		editArrayFactory,
		serverUIFactory,
		virtualMachineFactory,
		subscriptionsUIFactory,
		serversPageFactory,
		devicesFactory,
		fileServersPageFactory,
		clientGroupsFactory,
		usersFactory,
		userGroupsUIFactory,
		commcellUtils,
		mediaAgentListFactory,
		distributedStorageFactory
	) {
		var factory = {};

		factory.entityTypes = {
			'1': {
				stateName: 'clientGroupDetails',
				ENTITY_TYPES: 'CLIENT_ENTITY'
			},
			'2': {
				stateName: 'serverGroups',
				ENTITY_TYPES: 'CLIENT_GROUP_ENTITY'
			},
			'3': {
				stateName: 'hypervisors',
				ENTITY_TYPES: 'CLIENT_ENTITY'
			},
			'4': {
				stateName: 'vmGroups',
				ENTITY_TYPES: 'SUBCLIENT_ENTITY'
			},
			'5': {
				stateName: 'userVMs',
				ENTITY_TYPES: 'CLIENT_ENTITY'
			},
			'11': {
				stateName: 'userGroups',
				ENTITY_TYPES: 'USERGROUP_ENTITY'
			},
			'12': {
				stateName: 'users',
				ENTITY_TYPES: 'USER_ENTITY'
			},
			'14': {
				stateName: 'devices',
				ENTITY_TYPES: 'CLIENT_ENTITY'
			},
			'16': {
				stateName: 'subscriptions',
				ENTITY_TYPES: 'PROVIDER_ENTITY'
			},
			'19': {
				stateName: 'mediaAgent',
				ENTITY_TYPES: 'MEDIAAGENT_ENTITY'
			},
			'25': {
				stateName: 'fsServersList',
				ENTITY_TYPES: 'CLIENT_ENTITY'
			},
			'31': {
				stateName: 'archiveFileServers',
				ENTITY_TYPES: 'CLIENT_ENTITY'
			},
			'37': {
				stateName: 'distributedStorages',
				ENTITY_TYPES: 'DISTRIBUTED_STORAGE_ENTITY'
			}
		};

		factory.getActionsList = function(type, obj) {
			var result, allActions, createPermissionObj;
			switch (type) {
				case 1:
					//Servers Page
					createPermissionObj = obj.detailedProperty.serverProperty.clientProperties;
					obj.updatedDetailedProperty = serversPageFactory.convertResponse(createPermissionObj);
					allActions = serversPageFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.CLIENT_ENTITY, allActions);
					break;
				case 2:
					//Server Groups
					createPermissionObj = obj.detailedProperty.serverGroupProperty.groups;
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = clientGroupsFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.CLIENT_GROUP_ENTITY, allActions);
					break;
				case 3:
				case 32:
					let clientObj = obj.detailedProperty.hyperVisorProperty.VSPseudoClientsList;

					let backupEnabled = false;
					let restoreEnabled = false;

					if (
						clientObj.clientActivityControl &&
						clientObj.clientActivityControl.activityControlOptions &&
						clientObj.clientActivityControl.activityControlOptions.length > 0
					) {
						for (let i = 0; i < clientObj.clientActivityControl.activityControlOptions.length; i++) {
							if (clientObj.clientActivityControl.activityControlOptions[i].activityType === 1) {
								backupEnabled = clientObj.clientActivityControl.activityControlOptions[i].enableActivityType;
							}
							if (clientObj.clientActivityControl.activityControlOptions[i].activityType === 2) {
								restoreEnabled = clientObj.clientActivityControl.activityControlOptions[i].enableActivityType;
							}
						}
					}

					createPermissionObj = {
						attributes: {},
						backupsEnabled: backupEnabled,
						clientId: clientObj.client.clientId,
						clientName: clientObj.client.clientName,
						hostName: clientObj.client.hostName,
						instanceId: clientObj.instance.instanceId,
						localizedType: vendorTypes.getVendorLocalizedType(vendorTypes.getVendorName(clientObj.VSInstanceType)),
						name: clientObj.client.displayName,
						restoresEnabled: restoreEnabled,
						customState: type === 32 ? 'clusters' : 'hypervisors',
						customHref:
							type === 32 ? '#/clusters/' + clientObj.client.clientId : '#/servers/' + clientObj.client.clientId,
						status: clientObj.status,
						type: vendorTypes.getVendorName(clientObj.VSInstanceType),
						entityListPageState: serverUIFactory.getEntityListPageState(
							vendorTypes.getVendorName(clientObj.VSInstanceType)
						)
					};
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = serverUIFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.CLIENT_ENTITY, allActions);
					break;
				case 4:
				case 34:
					createPermissionObj = {
						sc: {
							commonProperties: obj.detailedProperty.vmGroupProperty.subClientProperties.commonProperties,
							subClientEntity: obj.detailedProperty.vmGroupProperty.subClientProperties.subClientEntity,
							vsaSubclientProp: {
								vendorType: vendorTypes.getVendorName(
									obj.detailedProperty.vmGroupProperty.subClientProperties.vsaSubclientProp.vendorType
								)
							},
							globalSearch: true
						}
					};

					obj.updatedDetailedProperty = createPermissionObj;
					allActions = vmGroupsFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.SUBCLIENT_ENTITY, allActions);
					break;
				case 5:
				case 33:
					createPermissionObj = obj.detailedProperty.vmProperty.vmStatusInfoList;
					obj.updatedDetailedProperty = virtualMachineFactory.convertResponse(createPermissionObj);
					allActions = virtualMachineFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(
						parseInt(createPermissionObj.client.clientId),
						ENTITY_TYPES.CLIENT_ENTITY,
						allActions
					);
					break;
				case 11:
					createPermissionObj = obj.detailedProperty.userGroupProperty.userGroups;
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = userGroupsUIFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(
						parseInt(createPermissionObj.userGroupEntity.userGroupId),
						ENTITY_TYPES.USERGROUP_ENTITY,
						allActions
					);
					break;
				case 12:
					createPermissionObj = obj.detailedProperty.userProperty.users;
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = usersFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(
						parseInt(createPermissionObj.userEntity.userId),
						ENTITY_TYPES.USER_ENTITY,
						allActions
					);
					break;
				case 14:
					// Laptops
					createPermissionObj = obj.detailedProperty.deviceProperty.clientsFileSystem;
					obj.updatedDetailedProperty = devicesFactory.convertResponse(createPermissionObj);
					allActions = devicesFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.CLIENT_ENTITY, allActions);
					break;
				case 16:
					// Companies
					createPermissionObj = obj.detailedProperty.companyProperty.providers;
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = subscriptionsUIFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.PROVIDER_ENTITY, allActions);
					break;
				case 19:
					// MediaAgent
					createPermissionObj = obj;
					obj.updatedDetailedProperty = createPermissionObj;
					const mediaAgent = { mediaAgentId: obj.id, mediaAgentName: obj.name, versionInfo: obj.versionInfo };
					allActions = mediaAgentListFactory.computePermittedActionsForMediaAgent({ mediaAgent });
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.MEDIAAGENT_ENTITY, allActions);
					break;
				case 21:
					// Arrays
					createPermissionObj = {
						arrayName: {
							name: obj.name,
							id: obj.id
						}
					};
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = editArrayFactory.getActions(createPermissionObj);
					result = factory.wrapActionNameForEntity(allActions);
					break;
				case 25:
					//File servers
					createPermissionObj = obj.detailedProperty.fileServerProperty.clientProperties;
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = fileServersPageFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.CLIENT_ENTITY, allActions);
					break;
				case 31:
					//File servers
					createPermissionObj = obj.detailedProperty.archiveServerProperty.clientProperties;
					obj.updatedDetailedProperty = createPermissionObj;
					createPermissionObj.isArchiveClient = true;
					allActions = fileServersPageFactory.getActions(createPermissionObj, true);
					result = factory.getPermissionForEntity(parseInt(obj.id), ENTITY_TYPES.CLIENT_ENTITY, allActions);
					break;
				case 37:
					//Distributed storage - Hedvig Cluster
					createPermissionObj = obj.detailedProperty.distributedStorageProperty.distributedStorageInfo;
					obj.updatedDetailedProperty = createPermissionObj;
					allActions = distributedStorageFactory.getActions(createPermissionObj);
					result = factory.getPermissionForEntity(
						parseInt(obj.id),
						ENTITY_TYPES.DISTRIBUTED_STORAGE_ENTITY,
						allActions
					);
					break;
			}
			return result;
		};

		factory.doAction = function(type, item, obj) {
			var entityName = _.get(factory.entityTypes[type], 'ENTITY_TYPES', 'CLIENT_ENTITY');
			var entityListPageState = _.get(factory.entityTypes[type], 'stateName', undefined);
			var vmClientId = _.get(obj.detailedProperty, 'vmProperty.vmStatusInfoList.client.clientId', 0);
			if (item && item.onClick && typeof item.onClick === 'function') {
				item.onClick(
					item.value,
					obj.updatedDetailedProperty,
					ENTITY_TYPES[entityName],
					item,
					type === 5 ? vmClientId : parseInt(obj.id),
					obj.name,
					entityListPageState
				);
			}
		};

		factory.getPermissionForEntity = async function(id, type, actions) {
			var data = await settingsService.getEntityCapabilities(id, type);

			if (data.data && data.data.length > 0) {
				var permission = data.data.map(function(permissionEntity) {
					return permissionEntity.permissionId;
				});
			}

			//filter out actions by permission ids
			var permittedActionList = actions.filter(function(action) {
				return cvPermissionFactory.filterPermittedActions(action, permission);
			});

			permittedActionList = orderByFilter(permittedActionList, ['rank', 'label']);

			permittedActionList = await factory.wrapActionNameForEntity(permittedActionList);

			return permittedActionList;
		};

		factory.wrapActionNameForEntity = async function(actions) {
			var actionList = actions.map(function(obj) {
				obj.entityActionName = obj.label;
				return obj;
			});

			return actionList;
		};

		factory.getCommCellActionsList = entity => {
			return commcellUtils.getActionsList(entity);
		};

		factory.getCommCellActionsList = entity => {
			return commcellUtils.getActionsList(entity);
		};

		factory.performCommCellIntent = intent => {
			commcellUtils.performAction(intent);
		};

		return factory;
	}
]);

export default mod;
