import { cvModuleSettingsModule } from 'common/js/modules';
('use strict');
var settingsModule = cvModuleSettingsModule;

settingsModule.factory('cvManageIdleClientsFactory', [
	'profileService',
	'subscriptionService',
	'subscriptionsUIFactory',
	function(profileService, subscriptionService, subscriptionsUIFactory) {
		var factory = {};
		factory.LEVEL = {
			COMPANY: 'COMPANY',
			COMMCELL: 'COMMCELL',
			PLAN: 'PLAN'
		};

		factory.setManageInactiveDevices = (autoRetireDevices, entityId, level) => {
			if (
				!_.isUndefined(level) &&
				!_.isNull(level) &&
				!_.isNull(entityId) &&
				!_.isUndefined(entityId) &&
				!_.isNull(autoRetireDevices) &&
				!_.isUndefined(autoRetireDevices)
			) {
				if (level == factory.LEVEL.COMPANY) {
					let orgInfo = subscriptionsUIFactory.getOrganizationUpdateRequestBasePayLoad(entityId);
					orgInfo.organizationProperties.autoRetireDevices = autoRetireDevices;
					return subscriptionService.updateOrganizationProperty(entityId, orgInfo);
				} else if (level === factory.LEVEL.COMMCELL) {
					return subscriptionService.updateCommcellFields({
						id: !_.isNull(entityId) && !_.isUndefined(entityId) ? entityId : 0,
						autoRetireDevices: autoRetireDevices
					});
				} else if (level === factory.LEVEL.PLAN) {
					let options = {
						autoRetireDevices: autoRetireDevices
					};
					return profileService.updateManageInactiveDevices(entityId, options);
				}
			}
		};

		return factory;
	}
]);
export default settingsModule;
