import 'commonForAllAgents/js/controllers/downloadSoftware.ctrl.js';
import 'commonForAllAgents/js/services/userPreference.svc.js';
import 'modules/settings/js/controllers/copySoftware.ctrl.js';
import 'commonForAllAgents/js/controllers/installUpdateJob.ctrl.js';
import 'modules/settings/js/services/settings.svc.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'storage/js/services/storage.svc.js';
import { Constants } from 'ediscovery/casemanager/js/controllers/caseConstants.js';
import { cvModuleSettingsModule } from 'common/js/modules';

cvModuleSettingsModule.factory('commcellUtils', [
	'$uibModal',
	'$dialogs',
	'downloadSoftwareService',
	'downloadSoftwareFactory',
	'scheduleUIFactory',
	'settingsService',
	'storageService',
	'jobService',
	'cvUtil',
	'cvLoc',
	'$filter',
	'$location',
	'CLOUD_TYPE_LIST',
	'userPrefService',
	function(
		$modal,
		$dialogs,
		downloadSoftwareService,
		downloadSoftwareFactory,
		scheduleUIFactory,
		settingsService,
		storageService,
		jobService,
		cvUtil,
		cvLoc,
		$filter,
		$location,
		CLOUD_TYPE_LIST,
		userPrefService
	) {
		var factory = {};

		factory.openDRRunJob = () => {
			$modal.open({
				templateUrl: 'modules/settings/partials/disasterDRbackup.jsp',
				backdrop: 'static',
				controller: 'disasterDRBackupModalController',
				windowClass: 'backupOptionsDialog',
				controllerAs: 'drCtrl'
			});
		};

		factory.editDRBackup = async (drBackInfo, loadDrBackupInfo) => {
			if (loadDrBackupInfo) {
				drBackInfo = await factory.loadDrBackupInfo();
				if (drBackInfo && drBackInfo.libraryLoadError) {
					return;
				}
			}
			return $modal.open({
				templateUrl: 'modules/settings/partials/drBackup.jsp',
				backdrop: 'static',
				controller: 'editDRBackupModalController',
				controllerAs: 'drCtrl',
				resolve: {
					drBackInfo
				}
			});
		};

		factory.loadDownloadSoftwareInfo = async () => {
			let model = {
				clientInfo: {},
				downloadOption: '1',
				servicePackList: [],
				selectedServicePack: '',
				hotfixPackList: [],
				selectedHotfixPack: '',
				configuredSchedules: [],
				majorSP: '',
				installedSP: '',
				currentSPInstalled: '',
				availableSP: '',
				scheduleName: '',
				downloadSoftwareInfo: {},
				taskInfo: {},
				downloadUsingInternet: true,
				showCopySoftware: cvConfig.showCopySoftware,
				immediateOptions: {},
				impersonateUser: true,
				syncUpdateCaches: true,
				credentials: {},
				notifyUserOnJobCompletion: false,
				copySchedule: {},
				latestServicePack: cvLoc('label.latestServicePack'),
				latestHotfixes: cvLoc('label.latestHotfixes')
			};
			let existingJob = {};

			try {
				model = await loadDownloadSoftwareSchedule(model);
				model = await getCachedDetails(model);
				existingJob = await getExistingJobs();
				let servicePacks = await loadServicePacks(model);
				model = _.merge(model, servicePacks);
				console.log(model, existingJob);
			} catch (err) {
				return _.get(err, 'data', err.message);
			}

			return { ...model, ...existingJob };
		};

		factory.openDownloadSoftwareDialog = async isSchedule => {
			let model = {};
			try {
				model = await factory.loadDownloadSoftwareInfo();
			} catch (err) {
				return _.get(err, 'data', err.message);
			}

			if (!isSchedule) {
				model.downloadOption = 1; //For immediate, this is always default option & winX64
				if (model.majorSP != model.installedSP) model.downloadOption = 0;
				model.immediateOptions = angular.copy(model.downloadSoftwareInfo.options.adminOpts.updateOption);
				if (model.immediateOptions.unixDownloadPackages) {
					model.immediateOptions.unixDownloadPackages = null;
				}
				model.immediateOptions.windowsDownloadPackages = {};
				model.immediateOptions.windowsDownloadPackages.windows32 = false;
				model.immediateOptions.windowsDownloadPackages.windowsX64 = true;
			} else {
				if (model.downloadSoftwareInfo.options.adminOpts.updateOption.isSpDelayedDays) {
					if (model.downloadSoftwareInfo.options.adminOpts.updateOption.isHotfixesDownload) {
						model.downloadOption = 1;
					} else {
						model.downloadOption = 0;
					}
				} else {
					model.downloadOption = 2;
					if (model.downloadSoftwareInfo.options.adminOpts.updateOption.spName) {
						model.selectedServicePack = model.downloadSoftwareInfo.options.adminOpts.updateOption.spName;
					}
				}
			}

			model.clientInfo = {
				clientId: 0,
				clientName: '',
				isSchedule
			};

			downloadSoftwareFactory.openDownloadSoftwareDialog(model);
		};

		factory.addInstallUpdateSchedule = () => {
			let attrs = {
				hideBackupLevelOptions: true,
				operationType: 'INSTALL_UPDATES',
				subTaskType: 'ADMIN',
				hideTimeInCommServeTimezone: true
			};
			scheduleUIFactory.addSchedule(
				{
					source: 'dr',
					isInstallUpdateSchedule: true
				},
				true,
				'Server',
				false,
				undefined,
				undefined,
				attrs
			);
		};

		factory.runInstallUpdateJob = () => {
			$modal.open({
				templateUrl: appUtil.appRoot + 'commonForAllAgents/partials/installUpdateJob.jsp',
				backdrop: 'static',
				controller: 'installUpdateJobCtrl as installCtrl'
			});
		};

		const _loadLibraryList = (data, exportSettings) => {
			let libraryList = cvUtil.sortAscending(data, 'library.libraryName');
			if (libraryList.length) {
				let cloudLibList = [];
				_.forEach(libraryList, library => {
					if (_.toUpper(library.manufacturer) == 'CLOUD') {
						let cloudTypeList = CLOUD_TYPE_LIST.CloudType;
						_.forEach(cloudTypeList, cloudType => {
							if (cloudType.id === library.libraryVendorId) {
								library.library.libraryVendorName = cloudType.name;
							}
						});
						cloudLibList.push(library);
						if (library.library.libraryId == exportSettings.cloudLibrary.libraryId) {
							exportSettings.cloudLibrary = library.library;
						}
					}
				});
				exportSettings.cloudLibList = cloudLibList;
			}

			return exportSettings;
		};

		factory.loadDrBackupInfo = async () => {
			let errors = {};
			let data = {};
			try {
				data = await settingsService.getDrbackup();
			} catch (err) {
				errors.backupLoadError = true;
				errors.msg = _.get(err, 'data', err.message);
				return errors;
			}
			let exportSetings = {};
			if (data && data.data) {
				exportSetings = data.data.properties;
				try {
					const libraries = await storageService.getAllLibraries('All');
					exportSetings = _loadLibraryList(libraries.data || [], exportSetings);
				} catch (err) {
					errors.libraryLoadError = true;
					errors.msg = _.get(err, 'data', err.message);
					return errors;
				}
			}

			return exportSetings;
		};

		const loadServicePacks = model => {
			return downloadSoftwareService.getServicePackInfo().then(data => {
				if (data && data.data) {
					let servicePackInfo = data.data;
					model.hotfixPackList = [];
					model.servicePackList = servicePackInfo.SPCUList ? servicePackInfo.SPCUList.map(x => x.SPName) : [];
					_.forEach(_.get(servicePackInfo, 'SPCUList'), sp => {
						model.hotfixPackList.push({
							msGroup: true,
							name: $filter('getVersionString')(sp.SPName).slice(0, -2)
						});
						_.forEach(_.get(sp, 'CU'), cu => {
							model.hotfixPackList.push({
								name: sp.SPName + '.' + cu.Num + ' (' + cu.FriendlyName + ')',
								model: cu,
								sp: sp.SPName
							});
						});
						model.hotfixPackList.push({
							name: $filter('getVersionString')(sp.SPName).slice(0, -2),
							model: {
								Num: 0
							},
							sp: sp.SPName
						});
						model.hotfixPackList.push({
							msGroup: false
						});
					});
					if (model.hotfixPackList.length) _.set(model.hotfixPackList, '[1].selected', true);
					if (servicePackInfo.InstalledSP) {
						model.currentSPInstalled = $filter('getVersionString')(servicePackInfo.InstalledSP);
						model.installedSP = servicePackInfo.InstalledSP.replace('+', '').split(' ')[0]; //Handling for HPK1 case
					}
					/*
					 * if (servicePackInfo.MajorSP) { //Making logic as per GUI, from SPNameList 1st element is picked
					 * as Latest available service pack model.majorSP = servicePackInfo.MajorSP.replace("+",
					 * ""); }
					 */
					if (model.servicePackList && model.servicePackList.length > 0 && !model.selectedServicePack) {
						model.selectedServicePack = model.servicePackList[0];
					}
					if (servicePackInfo.MainstreamSP) {
						model.availableSP = $filter('getVersionString')(servicePackInfo.MainstreamSP);
						model.majorSP = servicePackInfo.MainstreamSP.replace('+', '');
					}

					if (model.installedSP == model.majorSP) {
						model.downloadOption = 1; //If Major service pack available and Current service pack installed
						//on the CommServe are same then, will disable & unselect Latest service pack and Service pack and hot fixes options
						//and only Latest Hotfixes for the installed service pack option will be enabled and selected.
					}

					if (model.availableSP && !_.endsWith(model.latestServicePack, model.availableSP))
						model.latestServicePack += ' : ' + model.availableSP;
					if (model.currentSPInstalled && !_.endsWith(model.latestHotfixes, model.currentSPInstalled))
						model.latestHotfixes += ' : ' + model.currentSPInstalled;
				}
				return model;
			});
		};

		const getCachedDetails = model => {
			return settingsService.getGlobalParam('copySoftwareCache').then(result => {
				let cachedModel = JSON.parse(_.get(result, 'data.globalParamsResultList[0].value', '{}'));
				if (model.showCopySoftware) {
					_.merge(model, cachedModel);
					_.set(model, 'selected', cachedModel.selected);
					_.set(model, 'excluded', cachedModel.excluded);
				}
				model.cachedModel = cachedModel;
				return model;
			});
		};

		const getExistingJobs = () => {
			return jobService
				.getJobs(
					angular.toJson({
						jobFilter: {
							jobTypeList: [Constants.PATCHDOWNLOAD],
							completedJobLookupTime: 0
						}
					})
				)
				.then(result => {
					return _.get(result, 'data.jobs[0].jobSummary');
				});
		};

		const loadDownloadSoftwareSchedule = model => {
			return downloadSoftwareFactory.loadDownloadSoftwareSchedule().then(taskInfo => {
				if (downloadSoftwareFactory.defaultDownloadSoftwareInfo) {
					model.taskInfo = taskInfo.data;
					model.scheduleName = downloadSoftwareFactory.defaultDownloadSoftwareInfo.subTask.subTaskName;
					model.configuredSchedules = []; //Only one schedule saved at a time, so remove create and add edited schedule
					model.downloadSoftwareInfo = downloadSoftwareFactory.defaultDownloadSoftwareInfo;
					model.configuredSchedules.push(
						scheduleUIFactory.convertSubTaskInfoToSchedule(downloadSoftwareFactory.defaultDownloadSoftwareInfo)
					);
					return model;
				}
			});
		};

		const _getDisasterRecoveryActions = () => {
			return [
				{
					onClick: factory.openDRRunJob,
					value: 'RUN'
				},
				{
					onClick: factory.editDRBackup.bind(null, null, true),
					value: 'EDIT'
				}
			];
		};

		const _getDownloadSoftwareActions = () => {
			return [
				{
					onClick: factory.openDownloadSoftwareDialog.bind(null, false),
					value: 'RUN'
				},
				{
					onClick: factory.openDownloadSoftwareDialog.bind(null, true),
					value: 'SCHEDULE'
				}
			];
		};

		const _getInstallUpdateActions = () => {
			return [
				{
					onClick: factory.runInstallUpdateJob,
					value: 'RUN'
				},
				{
					onClick: factory.addInstallUpdateSchedule,
					value: 'ADD'
				}
			];
		};

		factory.getActionsList = entity => {
			let actions = [];
			switch (entity) {
				case 'DISASTER_RECOVERY':
					actions = _getDisasterRecoveryActions();
					break;
				case 'DOWNLOAD_COPY_SOFTWARE':
					actions = _getDownloadSoftwareActions();
					break;
				case 'INSTALL_UPDATES_SCHEDULE':
					actions = _getInstallUpdateActions();
			}

			return actions;
		};

		factory.setAccessibility = enableAcbility => {
			$dialogs.confirm(
				cvLoc('label.accessibilityMode'),
				enableAcbility
					? cvLoc('label.turnOnAccessibilityConfirmation')
					: cvLoc('label.turnOffAccessibilityConfirmation'),
				{
					noFunction: function() {},

					yesFunction: function() {
						userPrefService
							.setBooleanUserPref('cvAccessibility', enableAcbility)
							.success(result => {
								userPrefService
									.updateUserPrefs()
									.success(updateResult => {
										location.reload();
									})
									.error(errUpdate => {
										cvToaster.showErrorMessage({
											ttl: '5000', //5 sec
											message: errUpdate
										});
									});
							})
							.error(err => {
								cvToaster.showErrorMessage({
									ttl: '5000', //5 sec
									message: err
								});
							});
					}
				}
			);
		};

		factory.openAbout = () => {
			$modal.open({
				templateUrl: appUtil.appRoot + 'common/partials/aboutTemplate.jsp',
				backdrop: 'static',
				windowClass: 'confirm-dialog',
				controller: [
					'$scope',
					'$uibModalInstance',
					'settingsService',
					function($scope, $modalInstance, settingsService) {
						$scope.ok = function() {
							$modalInstance.close();
						};
						settingsService
							.getCommserveDetails()
							.success(function(responseData) {
								$scope.versionDetails = responseData;
							})
							.error(function(err) {
								$scope.fetchError = err;
							});
					}
				]
			});
		};

		factory.goToFeedback = () => {
			if ($location.path() === '/feedback') {
				return;
			}
			const refPath = $location.absUrl();
			$location.path('/feedback').search({
				ref: refPath
			});
		};

		factory.performAction = intent => {
			switch (_.toUpper(intent.action)) {
				case 'ABOUT':
					factory.openAbout();
					break;
				case 'TURNOFAC':
					factory.setAccessibility(false);
					break;
				case 'TURNONAC':
					factory.setAccessibility(true);
					break;
				case 'FEEDBACK':
					factory.goToFeedback();
					break;
				case 'HELP':
					location.url = cvConfig.helpLink;
					break;
				case 'USERPREF':
					$location.url('/userPreference');
					break;
				case 'LOGOUT':
					location.href = 'logout.do';
					break;
			}
		};
		return factory;
	}
]);
