/**
 * Adds a pages dropdown with each entry in the dropdown pointing to a new page
 */

var cvCommon = angular.module('cvCommon');

cvCommon.directive('cvPageViews', function() {
	return {
		scope: {},
		bindToController: {
			list: '=', // List of pages to display
			init: '=', // function to call on page init
			currentPage: '=' // refers to the current page displayed
		},
		controller: 'cvPageViewsController',
		controllerAs: 'pageViewsController',
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/settings/partials/pageViews.jsp'
	};
});

cvCommon.controller('cvPageViewsController', [
	'cvLoc',
	'$state',
	function(cvLoc, $state) {
		var self = this;
		this.$onInit = function() {
			self.pages = {};
			self.pages.list = this.list;
			self.pages.init = this.init;

			if (self.currentPage) {
				self.pages.currentPage = self.currentPage;
			} else {
				self.pages.currentPage =
					self.pages.list && self.pages.list.length > 0 && self.pages.list.find(page => page.isDefault);
			}
		};
	}
]);

export default cvCommon;
