import { acAppDirectivesModule } from 'common/js/modules';

var acAppDirectives = acAppDirectivesModule;

acAppDirectives.directive('cvTfaDirective', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/cvTFAToggle.jsp',
			bindToController: {
				sourcePage: '@?',
				subscriptionData: '='
			},
			controllerAs: 'TFAToggleCtrl',
			controller: [
				'$scope',
				'$log',
				'cvLoc',
				'cvUtil',
				'$uibModal',
				'subscriptionsUIFactory',
				'subscriptionService',
				'$q',
				'ADDITIONAL_SETTING_CATEGORY',
				function(
					$scope,
					$log,
					cvLoc,
					cvUtil,
					$modal,
					subscriptionsUIFactory,
					subscriptionService,
					$q,
					ADDITIONAL_SETTING_CATEGORY
				) {
					const self = this;
					this.$onInit = function() {
						// Remove additional setting after feature is released
						self.showLaptopAssignmentFeature = cvUtil.getAdditionalSettingValue(
							'showLaptopAssignmentFeature',
							ADDITIONAL_SETTING_CATEGORY.ADMINCONSOLE,
							false
						);
						self.tfaOptionTypes = subscriptionsUIFactory.getTFAOptionTypes();
						self.init = function() {
							self.initToggle();
							self.initializeEditState();
						};

						self.initToggle = function() {
							self.enableTwoFactorAuth = _.get(self.subscriptionData, 'enableTwoFactorAuthentication', false)
								? 'enabled-activity'
								: 'disabled-activity';
						};

						self.initializeEditState = function() {
							self.showEditLink = _.get(self.subscriptionData, 'enableTwoFactorAuthentication', false);
						};

						self.stateChange = function(enableTwoFactorAuthentication) {
							self.subscriptionData.enableTwoFactorAuthentication = enableTwoFactorAuthentication;
							self.init();
						};

						self.enableDisableTwoFactorAuth = function(mode) {
							if (mode === 'edit' || self.enableTwoFactorAuth === 'disabled-activity') {
								const deferred = $q.defer();
								$modal.open({
									templateUrl: appUtil.appRoot + 'modules/settings/partials/manageTFAOptions.jsp',
									windowClass: 'small-size',
									backdrop: 'static',
									controllerAs: 'manageTFAOptionsCtrl',
									controller: [
										'$scope',
										'$uibModalInstance',
										'subscriptionsUIFactory',
										'subscriptionService',
										'cvLoc',
										'$log',
										'$dialogs',
										'$q',
										'subscriptionId',
										'domainName',
										'sourcePage',
										function(
											$scope,
											$modalInstance,
											subscriptionsUIFactory,
											subscriptionService,
											cvLoc,
											$log,
											$dialogs,
											$q,
											subscriptionId,
											domainName,
											sourcePage
										) {
											const self = this;
											self.tfaOptionTypes = subscriptionsUIFactory.getTFAOptionTypes();
											self.getSearchConfig = () => ({
												placeholder: 'placeholder.enterUserGroup',
												resetOnSelected: true,
												httpConfig: {
													method: 'GET',
													url: 'getUserGroupSuggestionsListCompany.do',
													params: {
														getCommcellGroups: true,
														getDomainGroups: false,
														//returnDomain : true,
														providerId: self.subscriptionId,
														includeServiceType: 0x3,
														domain: self.domainName
														// more filters will be added
													}
												},
												payloadPath: 'params.term',
												onSelect: function(group) {
													self.addNewUserGroup(self.convertUserGroup(group));
												},
												iconClass: function(entity) {
													switch (entity.userInfo.userType) {
														case 'EXTERNAL_GROUP':
														case 'COMMCELL_GROUP':
															return 'k-i-myspace';
														case 'USER':
															return 'k-i-user';
														default:
															return 'k-i-email';
													}
												}
											});

											// mock data
											//self.userList = [{"name":"Tenant Users",
											//	"loginName":"UBS\\Tenant Users",
											//	"userInfo": {"id":8,"name":"Tenant Users","userType":"COMMCELL_GROUP"}
											//}];

											// server call to get TFA settings for a company id
											let getTwoFactorAuthenticationInfo = function(id) {
												return subscriptionService
													.getTwoFactorAuthenticationInfo(id)
													.success(function(data) {
														if (self.isInvalidResponse(data)) {
															self.setErrorMessage(cvLoc('error.tfaServerError'));
														} else {
															self.setNullMessage();
															self.initializeModalState(data);
															self.initializeInitialModalState();
															// separated from initialization code because this should not be used to record initial modal state
															self.setDefaultTfaOptionType();
														}
													})
													.error(function(error) {
														self.setErrorMessage(error);
													});
											};

											// use this on initializing modal to set defaults
											self.setDefaultTfaOptionType = function() {
												if (!self.tfaOptionType || self.tfaOptionType === self.tfaOptionTypes.DISABLED) {
													self.tfaOptionType = self.tfaOptionTypes.ALL;
												}
											};

											self.isInvalidResponse = function(data) {
												return !data || !data.twoFactorAuthenticationInfo || !data.twoFactorAuthenticationInfo.mode;
											};

											self.addNewUserGroup = function(obj) {
												let index = self.getUserGroupIndex(obj);
												if (index === -1) self.userList.unshift(obj);
											};

											self.deleteUserGroup = function(group, isUserGroup) {
												let index = self.getUserGroupIndex(group);
												let groups = _.get(self, 'userList', []);
												if (index === -1) return;
												for (let i = index; i < groups.length; ++i) {
													groups[i] = groups[i + 1];
												}
												groups.pop();
											};

											// need to consider cases where id can be similar for 2 different groups
											// use a combination of id, userType when that use case arises
											self.getUserGroupIndex = function(group) {
												let groups = _.get(self, 'userList', []);
												for (let i = 0; i < groups.length; ++i) {
													if (
														group &&
														groups[i] &&
														groups[i].userGroupId &&
														groups[i].userGroupId === group.userGroupId
													) {
														return i;
													}
												}
												return -1;
											};

											// stores initial state of the modal
											self.initializeInitialModalState = function() {
												self.initialTfaOptionType = self.tfaOptionType;
												self.initialUsersList = _.cloneDeep(self.userList);
											};

											self.initializeModalState = function(obj) {
												self.tfaOptionType = obj.twoFactorAuthenticationInfo.mode;
												self.userList = _.get(obj.twoFactorAuthenticationInfo, 'userGroups', []);
											};

											self.init = function() {
												self.sourcePage = sourcePage;
												if (self.sourcePage === 'commcellDetails') {
													self.subscriptionId = 0;
													self.domainName = 'CommCell';
												} else {
													self.subscriptionId = subscriptionId;
													self.domainName = domainName;
												}
												self.searchConfig = self.getSearchConfig();
												getTwoFactorAuthenticationInfo(subscriptionId);
											};

											self.onChange = function() {
												self.setNullMessage();
											};

											// checks if user group list data is unchanged
											self.isIdentical = function(list1, list2) {
												list1 = !list1 ? [] : list1;
												list2 = !list2 ? [] : list2;
												if (list1.length !== list2.length) return false;
												// combination of id and userType as key in hashMap
												let map = {};
												list1.forEach(function(obj) {
													let key = obj.userGroupId; // + " " + obj.userGroupName; add userGroupName if ids are same for different groups
													map[key] = true;
												});
												return list2.every(function(obj) {
													let key = obj.userGroupId; // + " " + obj.userGroupName; add userGroupName if ids are same for different groups
													return map[key] === true;
												});
											};

											// Validate Modal data before submission , set error message to show on top of modal
											self.validateModalData = function() {
												if (!self.tfaOptionType || self.tfaOptionType === self.tfaOptionTypes.DISABLED) {
													self.setErrorMessage(cvLoc('error.tfaNoData'));
													return true;
												} else if (
													self.tfaOptionType === self.tfaOptionTypes.USER_GROUP &&
													_.get(self.userList, 'length', 0) === 0
												) {
													self.setErrorMessage(cvLoc('error.tfaNoUserGroup'));
													return true;
												}
												return false;
											};

											// Don't send data to server when modal has no changes
											self.isModalStateUnchanged = function() {
												if (
													self.initialTfaOptionType !== self.tfaOptionType ||
													!self.isIdentical(self.userList, self.initialUsersList)
												) {
													return false;
												}
												return true;
											};

											self.convertUserGroup = function(group) {
												if (!group || !group.userInfo) return {};
												return { userGroupId: group.userInfo.id, userGroupName: group.loginName };
											};

											self.submit = function() {
												if (self.validateModalData()) {
													return;
												}
												// Validate modal data before sending to server
												// Don't send data to server when modal has no changes
												if (self.isModalStateUnchanged()) {
													$modalInstance.close();
													return;
												}
												// prepare payload for submission
												let twoFactorAuthenticationInfo = {
													mode: self.tfaOptionType,
													userGroups: self.userList
												};

												//Update TFA details code should be split for commcell and company (if payload structure and call varies in future)

												self.setSavingMessage();
												if (self.sourcePage === 'subscriptionsDetails') {
													subscriptionService
														.updateTwoFactorAuthenticationInfo(subscriptionId, twoFactorAuthenticationInfo)
														.success(function(data) {
															deferred.resolve({
																enableTwoFactorAuthentication: true
															});
															$modalInstance.close();
														})
														.error(function(error) {
															self.setErrorMessage(error);
															$log.error(error);
														});
												} else if (sourcePage === 'commcellDetails') {
													subscriptionService
														.updateCommcellFields({
															id: 0,
															twoFactorAuthenticationInfo: twoFactorAuthenticationInfo
														})
														.success(function(data) {
															deferred.resolve({
																enableTwoFactorAuthentication: true
															});
															$modalInstance.close();
														})
														.error(function(error) {
															self.setErrorMessage(error);
															$log.error(error);
														});
												}
											};

											self.cancel = function() {
												$modalInstance.close();
											};

											self.setErrorMessage = function(errorString) {
												self.serverMessage = {
													type: 'error',
													message: errorString
												};
											};

											self.setSavingMessage = function() {
												self.serverMessage = {
													message: cvLoc('Saving'),
													type: 'loader'
												};
											};

											self.setLoadingMessage = function() {
												self.serverMessage = {
													message: cvLoc('Loading'),
													type: 'loader'
												};
											};

											self.setNullMessage = function() {
												self.serverMessage = null;
											};
											self.setLoadingMessage();
										}
									],
									resolve: {
										subscriptionId: function() {
											return self.subscriptionData.id;
										},
										domainName: function() {
											return self.subscriptionData.companyAlias;
										},
										sourcePage: function() {
											return self.sourcePage;
										}
									}
								});

								deferred.promise.then(function(response) {
									self.stateChange(response.enableTwoFactorAuthentication);
								});
							} else {
								let twoFactorAuthenticationInfo = {
									mode: self.tfaOptionTypes.DISABLED
								};
								if (self.sourcePage === 'subscriptionsDetails') {
									subscriptionService
										.updateTwoFactorAuthenticationInfo(self.subscriptionData.id, twoFactorAuthenticationInfo)
										.success(function(data) {
											self.stateChange(false);
										})
										.error(function(error) {
											$log.error(error);
										});
								} else if (self.sourcePage === 'commcellDetails') {
									subscriptionService
										.updateCommcellFields({
											id: 0,
											enableTwoFactorAuthentication: false
										})
										.success(function(data) {
											self.stateChange(false);
										})
										.error(function(failureReason) {
											$log.error(failureReason);
										});
								}
							}
						};
					};
				}
			]
		};
	}
]);

export default acAppDirectives;
