import { cvModuleSettingsModule } from 'common/js/modules';
import 'modules/settings/js/services/userPreference.svc.js';

var mod = cvModuleSettingsModule;

mod.controller('userPreferenceController', [
	'$scope',
	'$stateParams',
	'$uibModal',
	'userPreferencesService',
	'cvToaster',
	function($scope, $stateParams, $modal, userPreferencesService, cvToaster) {
		$scope.resellerRole =
			cv.sessionContext.operatorCompanyId === undefined &&
			cv.providers &&
			cv.providers.length > 0 &&
			cvConfig.showOperators;

		userPreferencesService
			.getUserDefaultCompany()
			.success(function(data) {
				if (data.value && data.value != '0') {
					$scope.operator = {
						id: parseInt(data.value),
						name: ''
					};
					for (var i = 0; i < cv.providers.length; i++) {
						if (cv.providers[i].first == data.value) {
							$scope.operator.name = cv.providers[i].second;
							break;
						}
					}
				} else {
					$scope.operator = {};
				}
			})
			.error(function(data) {
				$scope.operator = {};
				// Show toaster
				cvToaster.showErrorMessage({
					ttl: '5000', //5 sec
					message: data && data.errorMessage ? data.errorMessage : cvLoc('generic_error')
				});
			});

		$scope.editDefaultCompany = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/editDefaultCompany.jsp',
				backdrop: 'static',
				windowClass: 'small-size',
				controller: [
					'$scope',
					'$uibModalInstance',
					'cvLoc',
					'cvUtil',
					'$state',
					'operatorData',
					'userPreferencesService',
					function($scope, $modalInstance, cvLoc, cvUtil, $state, operatorData, userPreferencesService) {
						$scope.providerCompanies = angular.copy(cv.providers);

						$scope.providerCompanies.map(providerEntity => {
							if (providerEntity && operatorData && operatorData.id && providerEntity.first === operatorData.id) {
								providerEntity.selected = true;
							} else {
								providerEntity.selected = false;
							}
						});

						const _isLoggedInUserNonAdmin = _.has(cv, 'sessionContext.loggedInUserRole')
							? cv.sessionContext.loggedInUserRole === 'Role_Tenant_User' ||
							  cv.sessionContext.loggedInUserRole === 'Role_MSP_User'
								? true
								: false
							: false;
						if (
							!_isLoggedInUserNonAdmin ||
							(_isLoggedInUserNonAdmin &&
								(!_.has(cvConfig, 'hideDefaultCompany') ||
									(_.has(cvConfig, 'hideDefaultCompany') && cvConfig.hideDefaultCompany !== true)))
						) {
							$scope.providerCompanies.unshift({
								first: 0,
								second: cvLoc('label.noDefaultCompany'),
								selected: operatorData && operatorData.id ? false : true
							});
						}

						const _setProviderForUser = providerId => {
							//cv.sessionContext.operatorCompanyId = providerId;
							userPreferencesService
								.setUserDefaultCompany(providerId)
								.success(function(data) {
									$state.forceReload();
									$modalInstance.close();
								})
								.error(function(e) {
									$state.forceReload();
									$modalInstance.close();
									$scope.editCompanyMessage = cvUtil.errMsg(e);
								});
						};

						$scope.saveDefaultCompany = function() {
							_setProviderForUser($scope.defaultCompanyArray[0].first);
						};

						$scope.cancel = function() {
							$modalInstance.dismiss();
						};
					}
				],
				resolve: {
					operatorData: function() {
						return $scope.operator;
					}
				}
			});
		};
	}
]);

export default mod;
