export const getColumnTemplate = function(angularLibs) {
	const columnList = [
		getHostName(angularLibs.cvLoc),
		getUsername(angularLibs.cvLoc),
		getEncryptAlgorithm(angularLibs.cvLoc),
		getPrivacyAlgorithm(angularLibs.cvLoc),
		getActionsColumn(angularLibs.cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};
export const getHostName = cvLoc => {
	return {
		hostName: {
			title: cvLoc('header.hostname'),
			template: '<a class="crop k-grid-keyDetail" title="#:hostName#">#:hostName#</a>'
		}
	};
};
export const getUsername = cvLoc => {
	return {
		userName: {
			title: cvLoc('label.userName'),
			template: '<span class="crop" title="#:userAccount.userName#">#:userAccount.userName#</span>'
		}
	};
};
export const getEncryptAlgorithm = cvLoc => {
	return {
		encryptAlgorithm: {
			title: cvLoc('label.authenticationAlgorithm'),
			template: '<span class="crop" title="#:encryptAlgorithm#">#:encryptAlgorithm#</span>'
		}
	};
};

export const getPrivacyAlgorithm = cvLoc => {
	return {
		privacyAlgorithm: {
			title: cvLoc('label.privacyAlgorithm'),
			template: '<span class="crop" title="#:privacyAlgorithm#">#:privacyAlgorithm#</span>'
		}
	};
};

export const getActionsColumn = function(cvLoc) {
	return {
		action: {
			title: cvLoc('label.actions'),
			type: 'string',
			template: `<div class="permittedActions"></div>`,
			disableViewFiltering: true,
			sortable: false,
			disableColumnFilter: true,
			attributes: {
				class: 'permitted-actions'
			}
		}
	};
};
