(function() {
	'use strict';

	var settingsMod = angular.module('cvModule.settings', []);

	var controllers = {};

	settingsMod.filter('decodeURIComponent', function() {
		return window.decodeURIComponent;
	});

	settingsMod.filter('getVersionLabel', [
		'cvLoc',
		function(cvLoc) {
			return function(versionInfo) {
				if (versionInfo && versionInfo.GalaxyRelease) {
					var str = versionInfo.GalaxyRelease.ReleaseString;
					if (versionInfo.version) {
						var str1 = versionInfo.version;
						var array1 = str1.split(',');
						var featureRelease =
							_.get(array1, '[0]') && array1[0].split(':').length > 1 ? array1[0].split(':')[1] : '0';
						var maintainanceRelease =
							_.get(array1, '[1]') && _.get(array1, '[1]').includes('Hotfix Pack:') && array1[1].split(':').length > 1
								? array1[1].split(':')[1].split('(')[0]
								: '0';
						str = str.concat(
							'.',
							featureRelease
								.replace(/\s/g, '')
								.replace('.0SP', '.')
								.replace('SP', '.')
								.replace('HPK', '.')
								.replace('+', '')
								.replace('-', '')
								.replace('a', '.1')
								.replace('b', '.2')
								.replace('c', '.3')
						);
						str =
							3 - str.split('.').length
								? str.concat(
										'.',
										maintainanceRelease
											.replace(/\s/g, '')
											.replace('.0SP', '.')
											.replace('SP', '.')
											.replace('HPK', '.')
											.replace('+', '')
											.replace('-', '')
											.replace('a', '.1')
											.replace('b', '.2')
											.replace('c', '.3')
								  )
								: str;
						str = str + '.0'.repeat(3 - str.split('.').length);
					} else {
						str = str + '.0'.repeat(3 - str.split('.').length);
					}
					return str;
				}
			};
		}
	]);

	settingsMod.filter('getVersionString', [
		'cvLoc',
		function(cvLoc) {
			return function(version) {
				if (version) {
					version = version
						.replace(/\s/g, '')
						.replace('.0SP', '.')
						.replace('SP', '.')
						.replace('HPK', '.')
						.replace('+', '')
						.replace('-', '')
						.replace('a', '.1')
						.replace('b', '.2')
						.replace('c', '.3');
					version = version + '.0'.repeat(3 - version.split('.').length);
					return version;
				}
			};
		}
	]);

	settingsMod.factory('tabsFactory', [
		'cvBreadcrumbsTabsFactory',
		'cvLoc',
		function(cvBreadcrumbsTabsFactory, cvLoc) {
			var factory = {};

			factory.createSettingsTabs = function(selected) {
				var tabs = [];

				if (cv.isPasswordChangeAllowed) {
					tabs.push({
						title: cvLoc('header.label.configurePassword'),
						link: '#changePassword',
						selected: '#changePassword' === selected
					});
				}
				cvBreadcrumbsTabsFactory.addTabs(tabs);
			};

			factory.createPluginTabs = function(selected) {
				var tabs = [];
				tabs.push({
					title: cvLoc('header.label.plugin.vsphere'),
					link: '#plugin',
					selected: '#plugin' === selected
				});
				tabs.push({
					title: cvLoc('header.label.plugin.scvmm'),
					link: '#scvmm',
					selected: '#scvmm' === selected
				});
				cvBreadcrumbsTabsFactory.addTabs(tabs);
			};
			return factory;
		}
	]);

	controllers.configurePasswordController = [
		'$scope',
		'$log',
		'$window',
		'$timeout',
		'cvLoc',
		'cvUtil',
		'settingsService',
		'tabsFactory',
		function($scope, $log, $window, $timeout, cvLoc, cvUtil, settingsService, tabsFactory) {
			/*
			 * If the user is on the commcell level, then the user has access to the setup pages. If this
			 * is the case, then the user can navigate to the Configure Password page without finishing
			 * the core setup. When this happens, we don't show the side nav, but we do show breadcrumbs
			 * to take the user back to the Getting Started page.
			 */
			$scope.showBreadcrumbs =
				cv.isOnCommcellLevel &&
				!cv.sessionContext.setupStepsMap.CORE_SETUP.every(function(finished) {
					return finished;
				});

			$scope.isPasswordChangeAllowed = cv.isPasswordChangeAllowed;

			$scope.configurePassword = function() {
				var encoded = false;
				$scope.configurePasswordMessage = {
					message: '',
					type: ''
				};
				$log.log('Submitting configure password info.');

				if (!encoded) {
					angular.forEach(this.model, function(val, key, obj) {
						obj[key] = Base64.encode(val);
					});
					encoded = true;
				}
				return settingsService
					.setPassword(this.model)
					.success(function() {
						$scope.configurePasswordMessage = cvUtil.infoMsg(cvLoc('info.configurePasswordSuccess'));
						$window.location.href = 'logutOnPasswordChange.do';
					})
					.error(function(e, a) {
						$log.error('change password failed', e, a);
						$scope.configurePasswordMessage = cvUtil.errMsg(
							e == undefined ? cvLoc('error.configurePasswordFailed') : new String(e).trim()
						);
						initializeModel(); //reset to empty
						// resetting the attempted flag to hide error texts
						$scope.cv.configurePasswordForm.setAttempted(false);
						$scope.configurePasswordForm.$setPristine(true);
					});
			};

			initializeModel();
			function initializeModel() {
				$scope.model = {
					oldPassword: '',
					newPassword: '',
					confirmPassword: ''
				};
			}
		}
	];

	controllers.configurePreference = [
		'$scope',
		'$log',
		'$window',
		'cvLoc',
		'cvUtil',
		'tabsFactory',
		'subscriptionService',
		'$stateParams',
		'$uibModal',
		'companyInfo',
		function(
			$scope,
			$log,
			$window,
			cvLoc,
			cvUtil,
			tabsFactory,
			subscriptionService,
			$stateParams,
			$modal,
			companyInfo
		) {
			tabsFactory.createSettingsTabs('#preference');

			$scope.configurePreferenceMessage = cvUtil.emptyMsg();

			subscriptionService
				.getSubscription()
				.success(function(organizationData) {
					var data = organizationData.organizationInfo;
					$scope.configurePreferenceMessage = cvUtil.emptyMsg();
					$scope.domainInfo = {};
					$scope.emailInfo = {};
					$scope.organizationInfo = data.organizationProperties;
					$scope.domainInfo.primaryDomainName = $scope.organizationInfo.primaryDomain;
					$scope.domainInfo.additionalDomainList = $scope.organizationInfo.additionalDomains;
					$scope.emailInfo.name = $scope.organizationInfo.senderName;
					$scope.emailInfo.email = $scope.organizationInfo.senderSmtp;
					if ($scope.domainInfo.additionalDomainList && $scope.domainInfo.additionalDomainList.length > 0) {
						$scope.domainInfo.additionalDomainListMap = $scope.domainInfo.additionalDomainList.map(function(domain) {
							return {
								text: domain,
								link: ''
							};
						});
					}
				})
				.error(function(e) {
					$scope.configurePreferenceMessage = {
						message: cvLoc('error.getSubscription') + '. ' + e,
						type: 'error'
					};
				});

			$scope.modifyEmailsForCompany = function() {
				var modalInstance = $modal.open({
					templateUrl: appUtil.appRoot + 'vsa/partials/editEmailForCompany.jsp',
					backdrop: 'static',
					controller: [
						'$scope',
						'$uibModalInstance',
						'cvLoc',
						'$stateParams',
						'cvUtil',
						'emailInfo',
						'subscriptionService',
						'$state',
						function($scope, $modalInstance, cvLoc, $stateParams, cvUtil, emailInfo, subscriptionService, $state) {
							$scope.modalInfo = {
								email: emailInfo && emailInfo.email ? emailInfo.email : '',
								name: emailInfo && emailInfo.name ? emailInfo.name : ''
							};

							$scope.saveEmailForCompany = function() {
								var objToSend = {
									fromEmail: $scope.modalInfo.email,
									fromName: $scope.modalInfo.name
								};
								subscriptionService
									.updateCompanyInfo(objToSend)
									.success(function(data) {
										$state.forceReload();
										$modalInstance.close();
									})
									.error(function(e) {
										$scope.editDomainMessage = {
											message: e,
											type: 'error'
										};
									});
							};
							$scope.cancel = function() {
								$modalInstance.dismiss();
							};
						}
					],
					resolve: {
						emailInfo: function() {
							return $scope.emailInfo;
						}
					}
				});
			};
		}
	];

	controllers.mspSettingController = [
		'$scope',
		function($scope) {
			$scope.skip = function() {
				$scope.$emit('mspGettingStarted');
			};
		}
	];
	controllers.downloadMediaAgentPackageController = [
		'$scope',
		'$log',
		'cvLoc',
		'cvUtil',
		'storageService',
		'$state',
		'REGEX',
		function($scope, $log, cvLoc, cvUtil, storageService, $state, REGEX) {
			$scope.hasMediaAgent = false;
			$scope.downloadMediaAgentPackageMessage = cvLoc('label.downloadMediaAgentPackageMessage');
			$scope.ovaPackageDownloadLocation = cvLoc('label.here');
			$scope.ovaPackageLink =
				angular.isDefined(cvConfig.downloadMediaAgentPackageLink) && cvConfig.downloadMediaAgentPackageLink !== ''
					? cvConfig.downloadMediaAgentPackageLink
					: '/webconsole/downloadcenter/dc.do';
			storageService
				.GetMAListForStoragePool()
				.success(function(data) {
					if (data.length > 0) {
						$scope.hasMediaAgent = true;
					}
				})
				.error(function(e) {
					$log.error(e);
				});
			$scope.skip = function() {
				$scope.$emit('downloadPackageComplete');
			};
		}
	];

	controllers.configureEmailController = [
		'$scope',
		'$log',
		'cvLoc',
		'cvUtil',
		'settingsService',
		'$state',
		'REGEX',
		'serverService',
		function($scope, $log, cvLoc, cvUtil, settingsService, $state, REGEX, serverService) {
			$scope.isCoreSetupStep = $state.current.name === 'coreSetup';
			$scope.inputAlertFlags = {
				username: false,
				password: false
			};
			$scope.userInfoEdited = false;
			$scope.formConfig = {
				passwordPlaceholder: ''
			};
			$scope.configureEmailMsg = cvUtil.infoMsgLoc('Loading');

			$scope.emailRegex = REGEX.EMAIL;
			$scope.formConfig.doNotValidate = $state.is('coreSetup'); //MR: 212013; Relax validation checks for trial
			//avoid calls in setup screen if its already done
			if (
				$state.is('coreSetup') &&
				cv.sessionContext.setupStepsMap &&
				cv.sessionContext.setupStepsMap['CORE_SETUP'][$scope.setupStep]
			) {
				$scope.formConfig.hide = true;
				$scope.configureEmailMsg = cvUtil.infoMsgLoc('info.emailConfigured');
				if (
					cvUtil.objectContainsNestedProperty('cvApp.globalParams.skipEmailSetup', cvApp) &&
					cvApp.globalParams.skipEmailSetup === '1'
				) {
					$scope.configureEmailMsg = cvUtil.infoMsgLoc('info.skipEmailConfiguration');
				}
				$scope.configureEmailMessage = cvUtil.infoMsgLoc('info.emailConfigured');
			}

			/**
			 * Retrieves from the back end the email that was used when registering the product, and sets
			 * it as the email to use as the sender email.
			 */
			function setEmailAsCloudRegistration() {
				settingsService.getCloudSettings(
					function(email) {
						$scope.model.senderInfo.senderAddress = email;
					},
					function() {
						$scope.model.senderInfo.senderAddress = '';
					}
				);
			}

			$scope.skipEmailConfiguration = function() {
				//This service call is made only when the global param is not set. For every other skip trigger we donot make this call and just skip
				if (!cvUtil.objectContainsNestedProperty('cvApp.globalParams.skipEmailSetup', cvApp)) {
					serverService
						.setGlobalParam('skipEmailSetup', '1')
						.success(function() {
							$scope.$parent.skip();
						})
						.error(function(e) {
							$log.error('Failed to skipEmailSetup');
						});
				} else {
					$scope.$parent.skip();
				}
			};
			settingsService.getEmail(
				function(data) {
					$scope.encryptionOptions = [
						{
							value: 0,
							label: 'None'
						},
						{
							value: 1,
							label: 'TLS'
						},
						{
							value: 2,
							label: 'SSL'
						}
					];

					$scope.dummyModel = {
						encryption: $scope.encryptionOptions[0].value
					};

					$scope.model = data.emailSettings.smtpInfo;
					if (!$scope.model.smtpPort) {
						$scope.model.smtpPort = 25;
					}
					if (!$scope.model.senderInfo) {
						$scope.model.senderInfo = {};
					}
					if (!$scope.model.userInfo) {
						$scope.model.userInfo = {};
					}
					if (!$scope.model.enableSSL) {
						$scope.model.enableSSL = false;
					} else {
						$scope.dummyModel.encryption = $scope.encryptionOptions[2].value;
					}
					if (!$scope.model.startTLS) {
						$scope.model.startTLS = false;
					} else {
						$scope.dummyModel.encryption = $scope.encryptionOptions[1].value;
					}
					if (data && data.emailSettings && data.emailSettings.smtpInfo && data.emailSettings.smtpInfo.smtpServer) {
						$scope.configureEmailMessage = cvUtil.infoMsgLoc('info.emailConfigured');
					}
					if ($scope.model.userInfo && $scope.model.userInfo.userName != '') {
						$scope.formConfig.passwordPlaceholder = cvLoc('placeholder.editUserPassword');
					}

					$scope.errors = {};

					$scope.encryptionChanged = function() {
						if ($scope.dummyModel.encryption == 0) {
							$scope.model.enableSSL = false;
							$scope.model.startTLS = false;
						}
						if ($scope.dummyModel.encryption == 1) {
							$scope.model.enableSSL = false;
							$scope.model.startTLS = true;
						}
						if ($scope.dummyModel.encryption == 2) {
							$scope.model.enableSSL = true;
							$scope.model.startTLS = false;
						}
					};
					/*
					 * If I'm on the core setup page, AND the current step is not completed, that means that
					 * the email is not yet configured. If this is the case, we set the model's sender email
					 * address as what was set in the Register Product form. Otherwise, we set it to the value
					 * that came in.
					 */
					if ($state.is('coreSetup') && !cv.sessionContext.setupStepsMap['CORE_SETUP'][$scope.setupStep]) {
						setEmailAsCloudRegistration();
					} else {
						$scope.model.senderInfo.senderAddress = data.emailSettings.smtpInfo.senderInfo.senderAddress;
					}

					if ($scope.model.senderName == '' && cvApp.acApp == 'ADMIN_CONSOLE' && cvApp.oemId == 16) {
						$scope.model.senderInfo.senderName = 'Commvault One';
					}
				},
				function(e) {
					$scope.model = {
						smtpServer: '',
						smtpPort: 25,
						senderInfo: {},
						userInfo: {}
					};
					setEmailAsCloudRegistration();
				}
			);
			//checking if form data is valid
			function checkFormValidation() {
				var isValid = true;
				if ($scope.formConfig.doNotValidate) {
					//all fields are optional for trial installation
					if ($scope.model.useAuthentication && $scope.userInfoEdited && $scope.model.userInfo) {
						if ($scope.model.userInfo.password) {
							if ($scope.model.userInfo.password != $scope.dummyModel.confirmPassword) {
								$scope.errors.confirmPassword = true;
								isValid = false;
							}
							if (!$scope.model.userInfo.userName || $scope.model.userInfo.userName == '') {
								$scope.errors.username = true;
								isValid = false;
							}
						}
					}
					return isValid;
				}
				if ($scope.model.useAuthentication && $scope.userInfoEdited && $scope.model.userInfo) {
					if (!$scope.model.userInfo.userName || $scope.model.userInfo.userName == '') {
						$scope.errors.username = true;
						isValid = false;
					}
					if (!$scope.model.userInfo.password || $scope.model.userInfo.password == '') {
						$scope.errors.password = true;
						isValid = false;
					} else if ($scope.model.userInfo.password != $scope.dummyModel.confirmPassword) {
						$scope.errors.confirmPassword = true;
						isValid = false;
					}
				}
				if ($scope.configureEmailForm.$error.required) {
					isValid = false;
				}
				return isValid;
			}
			$scope.toggleAuthentication = function() {
				$scope.model.useAuthentication = !$scope.model.useAuthentication;
			};
			$scope.testEmail = function() {
				var configureEmailModel;
				var isFormValid = checkFormValidation();
				//checking if form is valid
				if (!isFormValid) {
					return;
				}
				//creating copy of model
				configureEmailModel = angular.copy($scope.model);
				if (!$scope.userInfoEdited || !configureEmailModel.useAuthentication) {
					delete configureEmailModel.userInfo;
				} else {
					configureEmailModel.userInfo.password = cvUtil.getBytes(configureEmailModel.userInfo.password);
				}
				return settingsService
					.testEmail({
						emailSettings: JSON.stringify({
							smtpInfo: configureEmailModel
						})
					})
					.success(function() {
						$scope.configureEmailMessage = cvUtil.infoMsg(cvLoc('info.testEmailSuccess'));
					})
					.error(function(e, a) {
						$log.error('email test failed', e, a);
						$scope.configureEmailMessage = cvUtil.errMsg(
							cvLoc('error.testEmailFailed') + '. ' + (!e ? '' : new String(e).trim())
						);
					});
			};

			$scope.isReadyForAPICall = function() {
				if ($scope.isAPICall) {
					return;
				} else {
					$scope.configureEmailMessage = cvUtil.infoMsg(cvLoc('info.addEmailSuccess'));
					// Making sure to update the global param when initially the email setup was skipped, and once the setup is completed we mark skipEmailSetup to 0
					if (
						cvUtil.objectContainsNestedProperty('cvApp.globalParams.skipEmailSetup', cvApp) &&
						cvApp.globalParams.skipEmailSetup === '1'
					) {
						serverService
							.setGlobalParam('skipEmailSetup', '0')
							.success(function() {
								$log.info('Email set');
							})
							.error(function(e) {
								$log.error('Failed to skipEmailSetup');
							});
					}

					$scope.$emit(
						'emailAdded',
						_.extend(
							{
								senderEmail: $scope.model.senderInfo.senderAddress,
								senderName: $scope.model.senderInfo.senderName
							},
							$scope.model
						)
					);
				}
			};
			$scope.configureEmail = function() {
				var configureEmailModel;
				var isFormValid = checkFormValidation();
				//checking if form is valid
				if (!isFormValid) {
					return;
				}

				//creating copy of model
				configureEmailModel = angular.copy($scope.model);
				if (!$scope.userInfoEdited || !configureEmailModel.useAuthentication) {
					delete configureEmailModel.userInfo;
				} else {
					configureEmailModel.userInfo.password = cvUtil.getBytes(configureEmailModel.userInfo.password);
				}
				$scope.configureEmailMessage = {
					message: '',
					type: ''
				};
				$log.log('Submitting email setup info.');

				return settingsService
					.setEmail({
						emailSettings: JSON.stringify({
							smtpInfo: configureEmailModel
						})
					})
					.success($scope.isReadyForAPICall)
					.error(function(e, a) {
						$log.error('email setup failed', e, a);
						$scope.configureEmailMessage = cvUtil.errMsg(
							cvLoc('error.addEmailFailed') + ' ' + (e == undefined ? '' : new String(e).trim())
						);
						$scope.$emit('emailAddFailed');
					});
			};

			$scope.cancel = function() {
				$scope.$emit('emailAdded');
			};

			$scope.changeConfig = function() {
				$scope.formConfig.hide = false;
				$scope.configureEmailMessage = cvUtil.emptyMsg();
			};
		}
	];

	controllers.settingsController = [
		'$scope',
		'$log',
		'settingsService',
		function($scope, $log, settingsService) {
			$scope.emailTemplate = 'modules/settings/partials/configureEmail.jsp';

			$scope.changePasswordTemplate = 'modules/settings/partials/changePassword.jsp';

			$scope.registerCloud = 'modules/settings/partials/registerCloud.jsp';

			$scope.plugin = 'modules/settings/partials/configurePlugin.jsp';

			$scope.preference = 'modules/settings/partials/preference.jsp';

			$scope.$on('emailAdded', function() {
				$scope.handleNext('email');
			});

			$scope.handleNext = function(step) {
				if ((step = 'email')) {
					//just reload the page.
					settingsService.getEmail(
						function(data) {
							//console.log('success');
						},
						function(e) {
							console.log(e);
						}
					);
				}
			};
		}
	];

	controllers.registerWithCloudController = [
		'$scope',
		'$log',
		'cvLoc',
		'cvUtil',
		'settingsService',
		'tabsFactory',
		'$state',
		'REGEX',
		'registrationService',
		function($scope, $log, cvLoc, cvUtil, settingsService, tabsFactory, $state, REGEX, registrationService) {
			if ($state.current.name === 'registerCloud') {
				tabsFactory.createSettingsTabs('#registerCloud');
				$scope.hideCancelBtn = true;
			}
			$scope.hideForm = true;
			$scope.model = {};
			$scope.emailRegex = REGEX.EMAIL;
			//avoid calls in setup screen if its already done
			if (
				$state.is('coreSetup') &&
				cv.sessionContext.setupStepsMap &&
				cv.sessionContext.setupStepsMap['CORE_SETUP'][$scope.setupStep]
			) {
				$scope.hideForm = true;
				$scope.registerCloudMessage = cvUtil.infoMsg(cvLoc('info.alreadyRegistered'));
			} else {
				settingsService.getCloudSettings(
					function(data) {
						if (cvConfig.registeredToCloud || data != '') {
							$scope.model = {
								cloudEmail: data
							};
							$scope.hideForm = true;
							$scope.registerCloudMessage = cvUtil.infoMsg(cvLoc('info.alreadyRegistered'));
						} else {
							$scope.hideForm = false;
						}
					},
					function(e) {}
				);
			}

			$scope.registerCloud = function() {
				settingsService
					.registerWithCloud(this.model)
					.success(function() {
						$scope.registerCloudMessage = cvUtil.infoMsg(cvLoc('info.registerCloudSuccess'));
						$scope.$emit('registeredCloud');
					})
					.error(function(e, a) {
						$scope.registerCloudMessage = cvUtil.errMsg(
							cvLoc('error.registerCloudFailed') + '. ' + (e == undefined ? '' : new String(e).trim())
						);
						$scope.$emit('registeredCloudFailed');
					});
			};

			$scope.cancel = function() {
				$scope.$emit('registeredCloud');
			};

			registrationService.getOemId().success(function(oemId) {
				if (oemId) {
					oemId = parseInt(oemId);
					if (oemId == 106 || oemId == 113 || oemId == 16) {
						/** supported OEMS: Virtual server: 106, Edge: 113, CommvaultOne: 16* */
						$scope.isActivationCodeSupported = true;
					}
				}
			});
		}
	];

	controllers.defaultPlanController = [
		'$scope',
		'$log',
		'cvLoc',
		'cvUtil',
		'$location',
		'profileService',
		'subscriptionService',
		'companyInfo',
		'cvToaster',
		function($scope, $log, cvLoc, cvUtil, $location, profileService, subscriptionService, companyInfo, cvToaster) {
			$scope.showLaptopDefault = false;
			$scope.showServerDefault = false;
			$scope.showFsServerDefault = false;
			$scope.showDatabaseDefault = false;
			$scope.model = {};

			$scope.serverPlans = [];
			$scope.laptopPlans = [];
			$scope.fsServerPlans = [];
			$scope.dbPlans = [];

			$scope.defaultPlanMessage = cvUtil.infoMsgLoc('Loading');

			// TODO: the space is intentionally passed to trigger the MSP type. Refactoring needed on Java layer as well
			profileService
				.getProfiles('all', false, 'all')
				.success(function(data) {
					if (data.length > 0) {
						for (var i = 0; i < data.length; i++) {
							if (data[i].planSummary.subtype == 'Laptop') {
								$scope.laptopPlans.push(data[i]);
							} else if (data[i].planSummary.subtype == 'Server') {
								$scope.serverPlans.push(data[i]);
							} else if (data[i].planSummary.subtype == 'FSServer') {
								$scope.fsServerPlans.push(data[i]);
							} else if (data[i].planSummary.subtype == 'Database') {
								$scope.dbPlans.push(data[i]);
							}
						}
						if (
							$scope.laptopPlans.length === 0 &&
							$scope.serverPlans.length === 0 &&
							$scope.fsServerPlans.length === 0 &&
							$scope.dbPlans.length === 0
						) {
							$scope.defaultPlanMessage = {
								message: cvLoc('label.noPlansAssigned'),
								type: 'info'
							};
							return;
						}

						$scope.showLaptopDefault = $scope.laptopPlans.length ? true : false;
						$scope.showServerDefault = $scope.serverPlans.length ? true : false;
						$scope.showFsServerDefault = $scope.fsServerPlans.length ? true : false;
						$scope.showDatabaseDefault = $scope.dbPlans.length ? true : false;
						$scope.model = {
							defaultServer: null,
							defaultLaptop: null,
							defaultFsServer: null,
							defaultDb: null
						};

						subscriptionService
							.getSubscription()
							.success(function(detail) {
								$scope.defaultPlanMessage = cvUtil.emptyMsg();
								if (
									detail.organizationInfo.organizationProperties &&
									detail.organizationInfo.organizationProperties.defaultPlans
								) {
									detail.organizationInfo.organizationProperties.defaultPlans.map(function(data) {
										if (data.subtype === 'Server' && data.plan) {
											$scope.model.defaultServer = data.plan.planId;
										}
										if (data.subtype === 'Laptop' && data.plan) {
											$scope.model.defaultLaptop = data.plan.planId;
										}
										if (data.subtype === 'FSServer' && data.plan) {
											$scope.model.defaultFsServer = data.plan.planId;
										}
										if (data.subtype === 'Database' && data.plan) {
											$scope.model.defaultDb = data.plan.planId;
										}
									});
								}

								if (
									($scope.showLaptopDefault && $scope.model.defaultLaptop === null) ||
									($scope.showServerDefault && $scope.model.defaultServer === null) ||
									($scope.showFsServerDefault && $scope.model.defaultFsServer === null) ||
									($scope.showDatabaseDefault && $scope.model.defaultDb === null)
								) {
									$scope.defaultPlanMessage = {
										message: cvLoc('label.selectAllDefaultPlans'),
										type: 'info'
									};
								} else {
									$scope.defaultPlanMessage = {
										message: cvLoc('label.defaultPlanConfigured'),
										type: 'info'
									};
								}
							})
							.error(function(e) {
								$scope.defaultPlanMessage = {
									message: cvLoc('error.failedToGetDefault'),
									type: 'error'
								};
							});
					} else {
						$scope.defaultPlanMessage = {
							message: cvLoc('error.noProfiles'),
							type: 'error'
						};
					}

					$scope.saveDefaultPlan = function() {
						$scope.defaultPlanMessage = cvUtil.emptyMsg();
						var obj = {};
						if ($scope.showLaptopDefault) {
							obj.laptopPlan = $scope.model.defaultLaptop;
						}
						if ($scope.showServerDefault) {
							obj.serverPlan = $scope.model.defaultServer;
						}
						if ($scope.showFsServerDefault) {
							obj.fsServerPlan = $scope.model.defaultFsServer;
						}
						if ($scope.showDatabaseDefault) {
							obj.dbPlan = $scope.model.defaultDb;
						}

						subscriptionService
							.updateCompanyInfo(obj)
							.success(function(data) {
								$scope.defaultPlanMessage = {
									message: cvLoc('label.defaultPlanSaved'),
									type: 'info'
								};
								$location.path(cvUtil.getAppDashboard());
								cvToaster.showInfoMessage({
									ttl: '3000',
									message: cvLoc('label.defaultPlanSaved')
								});
							})
							.error(function(e) {
								$scope.defaultPlanMessage = {
									message: e,
									type: 'error'
								};
							});
					};
				})
				.error(function(e) {
					$scope.defaultPlanMessage = {
						message: e,
						type: 'error'
					};
				});
		}
	];

	controllers.licenseController = [
		'$scope',
		'$stateParams',
		'$timeout',
		'$window',
		'licenseService',
		'$uibModal',
		'$rootScope',
		'$state',
		'cvUtil',
		'cvLoc',
		'settingsService',
		function(
			$scope,
			$stateParams,
			$timeout,
			$window,
			licenseService,
			$modal,
			$rootScope,
			$state,
			cvUtil,
			cvLoc,
			settingsService
		) {
			/*
			 * If the user is an admin on the commcell level, then the user has access to the setup pages.
			 * If this is the case, then the user can navigate to the License page without finishing the
			 * core setup. When this happens, we don't show the side nav, but we do show breadcrumbs to
			 * take the user back to the Getting Started page.
			 */
			$scope.showBreadcrumbs =
				cv.isOnCommcellLevel &&
				!cv.sessionContext.setupStepsMap.CORE_SETUP.every(function(finished) {
					return finished;
				});

			settingsService.getCloudSettings(
				function(data) {
					if (data != '') {
						$scope.model = {
							cloudEmail: data
						};
						$scope.hideForm = true;
						$scope.registerCloudMessage = cvUtil.infoMsgLoc('info.alreadyRegisteredTo', $scope.model.cloudEmail);
					} else {
						$scope.hideForm = false;
						$scope.registerCloudMessage = cvUtil.infoMsgLoc('info.notRegistered');
					}
				},
				function(e) {
					$scope.registerCloudMessage = cvUtil.errMsgLoc('error.registerCloudFailed');
				}
			);

			$scope.showLicense = true;

			$scope.showLicenseWarning = false;
			$scope.isLicenseExpired = false;

			$scope.usageReportUrl = '';
			$scope.usageLabel = '';

			$scope.updateUsageReportId = function() {
				if ($scope.license.licenseInfo.isLicenseServer == true) {
					$scope.usageLabel = cvLoc('label.licenseServerSummary');
					$scope.usageReportUrl =
						'/webconsole/reportsplus/reportViewer.jsp?reportId=License%20server%20usage%20summary';
				} else {
					$scope.usageLabel = cvLoc('label.licenseSummary');
					$scope.usageReportUrl = '/webconsole/reportsplus/reportViewer.jsp?reportId=License%20summary';
				}

				return;
			};

			licenseService
				.getDetails()
				.success(function(res) {
					$scope.license = res;
					//check if production license expires within 60 days
					if ($scope.license.licenseMode === 'PRODUCTION' && $scope.license.licenseInfo.expiryDate > 0) {
						if (cvUtil.isLicenseExpired($scope.license.licenseInfo.expiryDate)) {
							$scope.isLicenseExpired = true;
						} else if (cvUtil.getDaysforLicenseExpiry($scope.license.licenseInfo.expiryDate) <= 60) {
							$scope.showLicenseWarning = true;
						}
					}

					$scope.updateUsageReportId();
				})
				.error(function() {
					$scope.licenseMessage = cvUtil.errMsgLoc('error.licenseInfoFailedToLoad');
				});

			$scope.registerLicense = function() {
				$scope.registerModalInstance = $modal.open({
					templateUrl: appUtil.appRoot + 'modules/settings/partials/registerCloud.jsp'
				});
			};
			var deregListener = $rootScope.$on('registeredCloud', function(event) {
				$scope.registerModalInstance.dismiss();
				$state.transitionTo(
					$state.current,
					{},
					{
						reload: true,
						inherit: false,
						notify: false
					}
				);
			});

			if ($stateParams.openRegistration) {
				$scope.registerLicense();
			}

			$scope.$on('$destroy', function() {
				deregListener();
			});

			var modalController = function(
				$scope,
				$modalInstance,
				$http,
				cvUtil,
				cvLoc,
				$dialogs,
				cvToaster,
				eulaUrlVal,
				showCheckbox,
				licenseService,
				footerService
			) {
				$scope.title = cvLoc('label.metallicEulaDialog');

				$scope.checkboxSet = {
					show: showCheckbox
				};

				$scope.acceptEulaBtn = true;
				$scope.eulaUrl = eulaUrlVal;
				$scope.message1 = cvLoc('label.metallicEulaTextContent');
				$scope.message2 = cvLoc('label.metallicEulaDialog');

				$scope.cancel = function() {
					$modalInstance.dismiss();
					$dialogs.notify(cvLoc('label.warning'), cvLoc('warning.metallicLicenseNotApplied'));
					$timeout(function() {
						location.reload();
					}, 3000);
				};

				$scope.agree = function() {
					licenseService
						.acceptMetallicEULA()
						.success(function(res) {
							$modalInstance.dismiss();
							cvToaster.showSuccessMessage({
								message: cvLoc('info.updateLicenseSuccessMessage')
							});
						})
						.error(function() {
							cvToaster.showErrorMessage({
								message: cvLoc('error.eulaNotAccepted')
							});
						});
					$timeout(function() {
						location.reload();
					}, 3000);
				};
			};
			var ModalSettings = function(eulaUrlVal, showCheckbox) {
				this.templateUrl = appUtil.appRoot + 'dlo/partials/updateEULA.jsp';
				this.backdrop = 'static';
				this.windowClass = 'confirm-dialog';
				this.controller = [
					'$scope',
					'$uibModalInstance',
					'$http',
					'cvUtil',
					'cvLoc',
					'$dialogs',
					'cvToaster',
					'eulaUrlVal',
					'showCheckbox',
					'licenseService',
					'settingsService',
					modalController
				];
				this.resolve = {
					showCheckbox: function() {
						return showCheckbox;
					},
					eulaUrlVal: function() {
						return eulaUrlVal;
					}
				};
			};

			$scope.showApplyLicenseDialog = function() {
				$modal.open({
					templateUrl: appUtil.appRoot + 'dlo/partials/updateLicense.jsp',
					backdrop: 'static',
					controller: [
						'$scope',
						'$rootScope',
						'$log',
						'$uibModalInstance',
						'$http',
						'cvLoc',
						'cvUtil',
						'$timeout',
						'settingsService',
						'$dialogs',
						'cvToaster',
						function(
							$scope,
							$rootScope,
							$log,
							$modalInstance,
							$http,
							cvLoc,
							cvUtil,
							$timeout,
							settingsService,
							$dialogs,
							cvToaster
						) {
							$scope.onInputChange = function() {
								var reader = new FileReader();
								var file = $scope.files[0];
								if (file) {
									$scope.selectedFile = file.name;
									reader.onload = $scope.fileLoaded;
									reader.filename = file.name;
									reader.readAsText(file);
								}
							};

							$scope.fileLoaded = function(e) {
								document.querySelector('.btn-text').textContent = $scope.selectedFile;
								$scope.fileData = e.target.result;
							};

							$scope.updateMetallicLicense = function() {
								var eulaUrl = '';
								settingsService
									.getGlobalParam('MetallicEulaURL')
									.success(function(data) {
										if (
											!_.isNil(data) &&
											!_.isNil(data.globalParamsResultList) &&
											data.globalParamsResultList.length === 1 &&
											data.globalParamsResultList[0].value != ''
										) {
											eulaUrl = data.globalParamsResultList[0].value;
										} else {
											eulaUrl = 'https://metallic.io/metallic-cloud-storage-terms';
										}

										$modal.open(new ModalSettings(eulaUrl, true));
									})
									.error(function(err) {});
							};

							$scope.updateLicense = function() {
								if ($scope.files != null) {
									var fd = new FormData();
									fd.append('file', $scope.fileData);

									$http
										.post('updateLicense.do', fd, {
											transformRequest: angular.identity,
											headers: {
												'Content-Type': undefined
											}
										})
										.success(function(res) {
											if (res == 8) {
												$modalInstance.dismiss();
												$scope.updateMetallicLicense();
											} else {
												$scope.updateLicenseMessage = cvUtil.infoMsgLoc('info.updateLicenseSuccessMessage');
												$timeout(function() {
													$modalInstance.dismiss();
													location.reload();
												}, 3000);

												//Metallic eula is not applicable or already accepted
											}
										})
										.error(function(err) {
											$scope.updateLicenseMessage = cvUtil.errMsg(err);
										});
								} else {
									$scope.updateLicenseMessage = cvUtil.errMsg('error.licenseFileInvalid');
								}
							};

							$scope.cancel = function() {
								$modalInstance.dismiss();
							};
						}
					]
				});
			};
		}
	];

	controllers.registrationController = [
		'$scope',
		'registrationService',
		function($scope, registrationService) {
			$scope.register = function() {
				registrationService.registrationSubmit($scope.model.emailAddress, $scope.model.userPassword);
			};
		}
	];

	controllers.headerUserSettingsController = [
		'$scope',
		'cvLoc',
		'$location',
		'settingsService',
		'cvToaster',
		'cvUtil',
		'cvMultiCommcell',
		'$uibModal',
		'$state',
		'$rootScope',
		'cvBreadcrumbsTabsFactory',
		'SERVER_ICONS',
		'multiCommcellFactory',
		'commcellRole',
		function(
			$scope,
			cvLoc,
			$location,
			settingsService,
			cvToaster,
			cvUtil,
			cvMultiCommcell,
			$modal,
			$state,
			$rootScope,
			cvBreadcrumbsTabsFactory,
			SERVER_ICONS,
			multiCommcellFactory,
			commcellRole
		) {
			$scope.coreSetupCompleted =
				angular.isDefined(cv.sessionContext.setupStepsMap.CORE_SETUP) &&
				cv.sessionContext.setupStepsMap.CORE_SETUP.every(function(finished) {
					return finished;
				});
			$scope.isMultiComcell = cv.sessionContext.isMultiComcellAware && cv.isCometApp;
			$scope.showCompanyDropdown = cvConfig.showOperators && !cv.isCometApp;
			$scope.showUserSettingsDropdown = _.get(cvConfig, 'showUserSettings', true);
			if ((cvApp.commcellInfo.commcellRole & commcellRole.CLOUDSERVICE) > 0) {
				$scope.commcellName = cvLoc('label.nav.Metallic');
			} else {
				$scope.commcellName = cv.isCometApp ? cvLoc('label.comet') : cv.commcellName;
			}

			var providerId = cv.orgId;

			$scope.providerAdded = false;

			//angular.isArray(cv.providers) && (!cv.isMspAdmin && !cv.isTenantAdmin) && cv.sessionContext.isOperatorLoadedFirstTime
			if (cv.sessionContext.showDefaultCompanySelection) {
				$scope.selectDefaultOperatorCompany = function() {
					var modalInstance = $modal.open({
						templateUrl: appUtil.appRoot + 'modules/settings/partials/defaultOperatorCompanySelection.jsp',
						backdrop: 'static',
						backdropClass: 'modal-company-selection',
						windowClass: 'small-size modal-company-hideCross',
						keyboard: false,
						controller: [
							'$scope',
							'$uibModalInstance',
							'cvLoc',
							'cvUtil',
							'$state',
							'userPreferencesService',
							'settingsService',
							function($scope, $modalInstance, cvLoc, cvUtil, $state, userPreferencesService, settingsService) {
								$scope.providerCompanies = angular.copy(cv.providers);
								var _isLoggedInUserNonAdmin = _.has(cv, 'sessionContext.loggedInUserRole')
									? cv.sessionContext.loggedInUserRole === 'Role_Tenant_User' ||
									  cv.sessionContext.loggedInUserRole === 'Role_MSP_User'
										? true
										: false
									: false;
								if (
									!_isLoggedInUserNonAdmin ||
									(_isLoggedInUserNonAdmin &&
										(!_.has(cvConfig, 'hideDefaultCompany') ||
											(_.has(cvConfig, 'hideDefaultCompany') && cvConfig.hideDefaultCompany !== true)))
								) {
									$scope.providerCompanies.unshift({
										first: 0,
										second: cvLoc('label.noDefaultCompany'),
										selected: true
									});
								}

								var _setProviderForUser = function(providerId) {
									cv.sessionContext.operatorCompanyId = providerId;
									settingsService
										.setCompanyForUser(providerId)
										.success(function(data) {
											location.reload();
											$modalInstance.close();
										})
										.error(function(e) {
											cvToaster.showErrorMessage({
												ttl: '5000',
												message: e
											});
										});
								};

								var _setDefaultCompanyFunction = function(providerId) {
									userPreferencesService
										.setUserDefaultCompany(providerId)
										.success(function(data) {
											_setProviderForUser(providerId);
										})
										.error(function(e) {
											$state.forceReload();
											$modalInstance.close();
											$scope.editCompanyMessage = cvUtil.errMsg(e);
										});
								};

								$scope.setDefaultCompanyLabel = cvLoc('label.setDefaultCompanyLabel');
								$scope.setDefaultCompany = false;
								$scope.saveDefaultCompany = function() {
									if ($scope.setDefaultCompany) {
										_setDefaultCompanyFunction($scope.defaultCompanyArray[0].first);
									} else {
										_setProviderForUser($scope.defaultCompanyArray[0].first);
									}
								};
							}
						]
					});
				};

				$scope.selectDefaultOperatorCompany();
			}

			// for push install job tracking
			$scope.pushstate = {
				isJobRunning: false,
				isOpen: false
			};
			$scope.jobTrackingHeader = cvLoc('label.jobStatusTracker');

			$scope.trackingToggled = function(open) {
				var isJobRunning = $scope.pushstate.isJobRunning;
				if (!open) {
					var isOpen = $scope.pushstate.isOpen;
					$scope.pushstate = {
						isOpen: false,
						isJobRunning: isJobRunning
					};
				} else {
					$scope.pushstate = {
						isOpen: true,
						isJobRunning: isJobRunning
					};
				}
			};

			$scope.commcellListForRedirect = [];
			$scope.groupedCommcellList = [];
			$scope.showCommcellRedirectDropdown = false;

			if (cvConfig.hideMultiCommcellForRouterCommcell === false) {
				$rootScope.$on('commcellDeleted', function(event, commcellName) {
					$scope.showCommcellRedirectDropdown =
						_.get(cvApp, 'commcellInfo.commcellType', '') === 'ROUTERCOMMCELL_AS_GLOBALIDP';

					getServiceCommcellRedirectList();
					//						$scope.commcellListForRedirect = _.filter($scope.commcellListForRedirect, commcell => {
					//							return commcellName !== commcell.commcellName;
					//						});
				});

				$rootScope.$on('commcellAdded', function() {
					getServiceCommcellRedirectList();
				});

				//										$rootScope.$on('commcellDeleted', (event, commcellName) => {
				//											$scope.showCommcellRedirectDropdown = _.get(cvApp,'commcellInfo.commcellType','') === 'ROUTERCOMMCELL_AS_GLOBALIDP';
				//
				//											$scope.commcellListForRedirect = _.filter($scope.commcellListForRedirect, commcell => {
				//												return commcellName !== commcell.commcellName;
				//											});
				//										});
				//
				//										$rootScope.$on('commcellAdded', () => {
				//											getServiceCommcellRedirectList();
				//										});
				getServiceCommcellRedirectList();

				function getServiceCommcellRedirectList() {
					if (
						_.get(cvApp, 'commcellInfo.commcellType') === 'SERVICECOMMCELL' &&
						!_.isEmpty(_.get(cvApp, 'commcellInfo.globalIdpCommcellName', ''))
					) {
						$scope.idpCommCellName = _.get(cvApp, 'commcellInfo.globalIdpCommcellName');
						$scope.showCommcellRedirectDropdown = true;
						return settingsService
							.getRedirectListForUser(cv.loginName || cv.loggedInUserName, false, $scope.idpCommCellName)
							.then(handleResponse, handleError);
					} else if (_.get(cvApp, 'commcellInfo.commcellType') === 'ROUTERCOMMCELL_AS_GLOBALIDP') {
						$scope.idpCommCellName = cv.commcellName;
						$scope.showCommcellRedirectDropdown = true;
						return settingsService
							.getRedirectListForUser(cv.loginName || cv.loggedInUserName, false)
							.then(handleResponse, handleError);
					}
					//Fetch redirect Commcell list if cloud service is configured or the commcell itself is a cloud service
					else if (
						(cvUtil.objectContainsNestedProperty('cv.sessionContext.completedSetups.METALLIC', cv) &&
							cv.sessionContext.completedSetups.METALLIC === true) ||
						cvConfig.isMetallicServiceConfigured == true ||
						(cvApp.commcellInfo.commcellRole & commcellRole.CLOUDSERVICE) > 0 ||
						(cvApp.commcellInfo.commcellRole & commcellRole.ONPRIM_SUBSCRIBER_OF_CLOUDSERVICE) > 0
					) {
						$scope.showCommcellRedirectDropdown = true;
						return settingsService
							.getRedirectListForUser(cv.loginName || cv.loggedInUserName, false)
							.then(handleResponse, handleError);
					}
				}

				function handleResponse(response) {
					$scope.groupedCommcellList = [];

					$scope.commcellListForRedirect = _.forEach(_.get(response, 'data.AvailableRedirects', []), function(
						commcellItem
					) {
						//add comet as first option of redirection list
						if (commcellItem.commcellName === $scope.idpCommCellName) {
							$scope.globalCell = {
								commcellName: cvLoc('label.comet'),
								redirectUrl: _.replace(commcellItem.redirectUrl, /webconsole\/?$/, 'global'),
								skipSAMLRedirect: true
								//'redirectUrl': "http://" + $location.host() + ':' + $location.port() + '/global'
							};
						}
						//If tomcat app for service commcell was created dynamically on master commcell
						//then redirect user to that dynamic app instead of webconsole of service commcell
						let dynamicAppUrl = null;
						if (cvConfig.enableMCCDynamicApp && cvApp.serviceCommcellInfoForWeb) {
							let index = cvApp.serviceCommcellInfoForWeb.findIndex(function(commcellItemForWeb) {
								return commcellItemForWeb.serviceCommcellProperties.commcellName === commcellItem.commcellName;
							});
							if (
								index !== -1 &&
								cvApp.serviceCommcellInfoForWeb[index].webconsoleAppCreated &&
								cvApp.serviceCommcellInfoForWeb[index].adminconsoleAppCreated
							) {
								dynamicAppUrl = cvApp.serviceCommcellInfoForWeb[index].dynamicCommcellUrl;
							}
						}

						if (dynamicAppUrl) {
							commcellItem.redirectUrl =
								$location.protocol() + '://' + $location.host() + ':' + $location.port() + '/' + dynamicAppUrl + '/';
						} else {
							commcellItem.redirectUrl = _.replace(commcellItem.redirectUrl, /[\/]webconsole\/?/, '/adminconsole');
						}
					});

					//Populate Cloud services
					var cloudServiceRedirectList = _.forEach(_.get(response, 'data.cloudServices', []), function(commcellItem) {
						commcellItem.displayName = cvLoc('label.nav.Metallic');
						commcellItem.webconsoleUrl = commcellItem.redirectUrl;
						//redirectUrl will become nextUrl
						commcellItem.redirectUrl = _.replace(commcellItem.redirectUrl, /webconsole\/?$/, 'adminconsole');
						commcellItem.isCloudServiceType = true;
					});

					$scope.commcellListForRedirect.length &&
						$scope.groupedCommcellList.push({
							groupName: cvLoc('label.serviceCommcells'),
							svgIcon: SERVER_ICONS.SERVER,
							redirectLists: _.sortBy($scope.commcellListForRedirect, ['commcellName'])
						});

					cloudServiceRedirectList.length &&
						$scope.groupedCommcellList.push({
							groupName: cvLoc('label.dropdown.cloudServices'),
							iconClass: 'glyphicon glyphicon-cloud',
							redirectLists: _.sortBy(cloudServiceRedirectList, ['commcellName'])
						});

					$scope.globalCell &&
						cvConfig.enableGlobalConsole &&
						$scope.groupedCommcellList.unshift({
							iconClass: 'glyphicon glyphicon-globe',
							redirectLists: [$scope.globalCell]
						});
				}

				function handleError(err) {
					cvToaster.showErrorMessage({
						message: _.get(err, 'data.errorString') || _.get(err, 'data') || cvLoc('generic_error'),
						ttl: '5000'
					});
				}

				$scope.redirectToCommcell = function(event, commcell) {
					if (commcell.skipSAMLRedirect) {
						return;
					}
					event.preventDefault();

					let hashState = location.hash;
					function containsId(breadCrumbLink) {
						return (
							breadCrumbLink.search(/\/\d+/) !== -1 ||
							breadCrumbLink.indexOf('reportDetails') !== -1 ||
							breadCrumbLink.search(/identityServer\/.*/) !== -1 ||
							breadCrumbLink.search(/\?[A-Za-z0-9]*=[A-Za-z0-9]*/) !== -1
						);
					}

					if (containsId(hashState)) {
						var breadCrumbLinks = cvBreadcrumbsTabsFactory.getBreadCrumbs();
						if (breadCrumbLinks && breadCrumbLinks.length > 0) {
							_.forEachRight(breadCrumbLinks, function(breadCrumb) {
								if (!containsId(breadCrumb.link)) {
									hashState = breadCrumb.link;
									return false;
								}
							});
						} else {
							hashState = '';
						}
					}

					if (commcell.isCloudServiceType) {
						multiCommcellFactory.openUrl(commcell.redirectUrl, commcell);
					} else {
						let dummy = document.createElement('a');
						dummy.href = commcell.redirectUrl;
						dummy.port = '';
						const link = dummy.href.replace('http://', 'https://');
						location.href = link + hashState;
					}
				};
			}
		}
	];

	controllers.configurePasswordEncryptionController = [
		'$scope',
		'cvLoc',
		'cvUtil',
		'$dialogs',
		'keyManagementService',
		'settingsService',
		'$uibModalInstance',
		'$state',
		function($scope, cvLoc, cvUtil, $dialogs, keyManagementService, settingsService, $uibModalInstance, $state) {
			$scope.submitShouldBeDisabled = true;
			let selectedKeyManagamentServer = null;
			$scope.init = function(keyManagementServer) {
				$scope.keyProviders = [];
				$scope.configurePreferenceMessage = cvUtil.emptyMsg();
				keyManagementService
					.getAllServers(null)
					.success(function(data) {
						$scope.keyProviders = (data.keyProviders || []).map(function(obj) {
							obj = obj.provider;
							obj.selected = obj.keyProviderName === keyManagementServer;
							$scope.keyManagementServer = obj;
							return obj;
						});
						selectedKeyManagamentServer = $scope.keyProviders.find(function(keyP) {
							return keyP.keyProviderName === keyManagementServer;
						});
					})
					.error(function(e) {
						$scope.configurePswEncMessage = {
							message: cvLoc('error.getKeyManagementServers') + '. ' + e.errorMessage,
							type: 'error'
						};
					});
			};

			$scope.configurePswEncConfig = function() {
				let request = {
					newKeyProviderName: $scope.keyManagementServer[0].keyProviderName,
					rotateMasterKey: true
				};
				settingsService
					.setPasswordEncryptionConfig(request)
					.success(function(res) {
						$uibModalInstance.close($scope.keyManagementServer[0].keyProviderName);
					})
					.error(function(e) {
						$scope.configurePswEncMessage = {
							message: cvLoc('error.passwordEncryptionConfig') + '. ' + e.errorMessage,
							type: 'error'
						};
					});
			};

			$scope.setPswEncConfig = function(data) {
				//checking whether key server has changed
				$scope.submitShouldBeDisabled = selectedKeyManagamentServer.keyProviderName === data.keyProviderName;
			};
		}
	];

	controllers.configureGlobalCCController = [
		'$scope',
		'cvLoc',
		'cvUtil',
		'settingsService',
		'$uibModalInstance',
		'globalCCConfigParams',
		'cvToaster',
		function($scope, cvLoc, cvUtil, settingsService, $uibModalInstance, globalCCConfigParams, cvToaster) {
			$scope.inputGlobalCCList = [];
			$scope.outputGlobalCCList = [];
			$scope.localLang = cvUtil.getIStevenLocLabels();
			if (globalCCConfigParams.globalCCList) {
				globalCCConfigParams.globalCCList.forEach(function(entity) {
					$scope.inputGlobalCCList.push({
						ccDisplayName: entity.webconsoleClient.displayName,
						ccItemDisplayName: entity.webconsoleClient.displayName + ' (' + entity.webconsoleClient.hostName + ') ',
						isSupported: entity.isSupported,
						webconsoleClient: entity.webconsoleClient,
						isPrimary: entity.isPrimary
					});
				});
			}

			$scope.globalCCModified = function(globalCCObj) {
				let item = $scope.outputGlobalCCList.filter(function(obj) {
					return obj.webconsoleClient.clientId === globalCCObj.webconsoleClient.clientId;
				});
				if (item.length > 0) {
					item[0].isSupported = globalCCObj.isSupported;
				} else {
					$scope.outputGlobalCCList.push({
						isSupported: globalCCObj.isSupported,
						webconsoleClient: globalCCObj.webconsoleClient
					});
				}
			};
			$scope.configureGlobalCC = function() {
				$scope.configureGlobalCCMsg = cvUtil.emptyMsg();
				if ($scope.outputGlobalCCList.length == 0) {
					$uibModalInstance.close($scope.inputGlobalCCList);
				}

				settingsService
					.updateGlobalCCList({
						webconsoles: $scope.outputGlobalCCList
					})
					.success(function(data) {
						cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('success.globalCCSave'));
						$uibModalInstance.close($scope.inputGlobalCCList);
					})
					.error(function(e) {
						$scope.configureGlobalCCMsg = cvUtil.errMsgLoc('error.globalCCSaveError');
					});
			};

			$scope.cancel = function() {
				$uibModalInstance.dismiss();
			};
		}
	];

	settingsMod.controller(controllers);
})();

$('#dropdown-menu-multicomcell').on('click', function(e) {
	e.stopPropagation();
});
