import { cvModuleSettingsModule } from 'common/js/modules';

var app = cvModuleSettingsModule;

app.controller('SendLogsSettingsController', [
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'settingsService',
	'serverService',
	'ReportsConstants',
	function(cvBreadcrumbsTabsFactory, cvLoc, settingsService, serverService, ReportsConstants) {
		var self = this;
		var breadCrumbs = [];
		self.scrubStatus = false;

		self.$onInit = function() {
			breadCrumbs.push({
				title: cvLoc('label.nav.system'),
				link: '#nav/settings'
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

			serverService
				.getGlobalParam(ReportsConstants.GX_GLOBAL_PARAMS.FORCE_SCRUB_FILES, true)
				.then(function(data) {
					if (data.data && data.data !== 'null' && data.data === '1') {
						self.scrubStatus = true;
					}
				})
				.catch(function(e) {
					console.log('Failed to retrieve scrub log files info.');
				});
		};

		self.toggleScrubStatus = function() {
			self.scrubStatus = !self.scrubStatus;
			settingsService
				.setGlobalParam(ReportsConstants.GX_GLOBAL_PARAMS.FORCE_SCRUB_FILES, self.scrubStatus ? 1 : 0)
				.then(function(data) {
					console.log('updated global param SendLogsForceScrubFiles');
				})
				.catch(function(err) {
					console.log(err);
					console.log('Failed to update SendLogsForceScrubFiles');
				});
		};
	}
]);

export default app;
