const getDisplayName = cvLoc => ({
	clientName: {
		title: cvLoc('header.label.nodes'),
		type: 'string',
		searchField: 'clientName',
		template: `<span cv-toggle-content="#:clientName#" cv-toggle="tooltip">#:clientName#</span>`
	}
});

const getStatus = cvLoc => ({
	status: {
		title: cvLoc('label.status'),
		type: 'string',
		template: `<span cv-toggle-content="#:status#" cv-toggle="tooltip">#:status#</span>`
	}
});

const getLastSyncTime = cvLoc => ({
	lastSyncTime: {
		title: cvLoc('header.label.lastSyncTime'),
		type: 'string',
		template: `<span cv-toggle-content="#:lastSyncTime#" cv-toggle="tooltip">#:lastSyncTime#</span>`
	}
});

const getVersion = cvLoc => ({
	version: {
		title: cvLoc('header.label.version'),
		type: 'string',
		template: `<span cv-toggle-content="#:version#" cv-toggle="tooltip">#:version#</span>`
	}
});

const getActions = cvLoc => ({
	action: {
		title: cvLoc('label.actions'),
		type: 'string',
		template: `<div class="permittedActions"></div>`,
		disableViewFiltering: true,
		sortable: false,
		disableColumnFilter: true,
		attributes: {
			class: 'permitted-actions'
		}
	}
});
export function getMonitoringNodesGridColumns({ cvLoc }) {
	return {
		...getDisplayName(cvLoc),
		...getStatus(cvLoc),
		...getLastSyncTime(cvLoc),
		...getActions(cvLoc)
	};
}

export function getNodesGridColumns({ cvLoc }) {
	return {
		...getDisplayName(cvLoc),
		...getStatus(cvLoc),
		...getLastSyncTime(cvLoc),
		...getVersion(cvLoc)
	};
}
export function getAvailableNodesGridColumns({ cvLoc }) {
	return {
		...getDisplayName(cvLoc)
	};
}
