import 'adminConsole/js/services/clientGroups.svc.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var app = cvModuleSettingsModule;

app.constant('CLOUD_SERVICES', {
	HEALTH_CHECK: 1,
	ACTIVITY: 3,
	UPGRADE_READINESS: 4,
	AUDIT: 5,
	CHARGE_BACK: 6,
	ALLOW_REMOTE_TROUBLESHOOTING: 7,
	PROACTIVE_SUPPORT: 8,
	SERVICE_PROVIDER_BILLING: 9
});

/**CHARGE-BACK frequency-flags as defined in Java GUI*/
app.constant('CHARGEBACK_FREQUENCY', {
	DAILY: 4,
	WEEKLY: 8,
	MONTHLY: 16
});

app.filter('metricsReportingStatus', [
	'cvLoc',
	function(cvLoc) {
		return function(boolValue) {
			if (boolValue) {
				return cvLoc('enabled.true');
			} else {
				return cvLoc('enabled.false');
			}
		};
	}
]);

app.filter('readableDataCollectionTime', [
	function() {
		return function(dataCollectionTime) {
			var readableTime = '';
			var hours = dataCollectionTime.getHours();
			var minutes = dataCollectionTime.getMinutes();
			var meridian;

			if (hours >= 12) {
				if (hours > 12) hours = hours - 12;

				meridian = 'PM';
			} else {
				meridian = 'AM';
			}
			if (hours < 10) hours = '0' + hours;

			if (minutes < 10) minutes = '0' + minutes;

			readableTime = hours + ':' + minutes + '  ' + meridian;
			return readableTime;
		};
	}
]);

app.directive('cvMetricsReporting', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/metricsReportingTemplate.jsp',
			scope: {
				isPrivate: '='
			},
			controller: [
				'$scope',
				'$uibModal',
				'$log',
				'$dialogs',
				'$state',
				'$q',
				'cvUtil',
				'cvLoc',
				'cvToaster',
				'metricsReportingService',
				'metricsReportingFactory',
				function(
					$scope,
					$modal,
					$log,
					$dialogs,
					$state,
					$q,
					cvUtil,
					cvLoc,
					cvToaster,
					metricsReportingService,
					metricsReportingFactory
				) {
					$scope.editMetrics = function() {
						var modalInstance = $modal.open({
							templateUrl: appUtil.appRoot + 'modules/settings/partials/editMetricsReporting.jsp',
							backdrop: 'static',
							controller: 'editMetricsReportingController',
							resolve: {
								inputParams: function() {
									return {
										isPrivate: $scope.isPrivate == true,
										configuration: $scope.configuration
									};
								}
							}
						});

						modalInstance.result.then(function() {
							var message =
								$scope.isPrivate == true ? cvLoc('info.privateMetricsUpdated') : cvLoc('info.cloudMetricsUpdated');
							cvToaster.showSuccessMessage({
								message: message,
								ttl: 2000
							});
						});
					};

					$scope.toggleMetricsReporting = function() {
						if ($scope.isPrivate) {
							if (
								typeof $scope.configuration.cloud.downloadURL == 'undefined' ||
								typeof $scope.configuration.cloud.uploadURL == 'undefined' ||
								!$scope.configuration.cloud.downloadURL ||
								!$scope.configuration.cloud.uploadURL
							) {
								$scope.editMetrics();
								return;
							}
						}
						$scope.configuration.commcellDiagUsage = !$scope.configuration.commcellDiagUsage;
						metricsReportingService
							.updateConfiguration({
								commcellSurveyConfiguration: $scope.configuration,
								isPrivateCloud: $scope.isPrivate == true
							})
							.then(function(response) {
								if (response && response.data && response.data.errorCode == 0) {
									cvToaster.showSuccessMessage({
										message: cvLoc('info.commcellDiagnosticsAndUsageUpdated'),
										ttl: 2000
									});
								} else {
									$scope.model.serverMessage = {
										message: response.data.errorMessage ? cvLoc('generic_error') : response.data.errorMessage,
										type: 'error'
									};
								}
							});
					};

					$scope.uploadMetrics = function() {
						if ($scope.configuration) {
							$scope.configuration.uploadNow = 1;
							var callBackFunctions = {
								noFunction: function() {},
								yesFunction: function() {
									metricsReportingService
										.updateConfiguration({
											commcellSurveyConfiguration: $scope.configuration,
											isPrivateCloud: $scope.isPrivate == true
										})
										.then(function(response) {
											if (response && response.data && response.data.errorCode == 0) {
												cvToaster.showSuccessMessage({
													message: cvLoc('info.metricsReportingUpload')
												});
											} else {
												$scope.model.serverMessage = {
													message: response.data.errorMessage ? cvLoc('generic_error') : response.data.errorMessage,
													type: 'error'
												};
											}
										});
								}
							};
							$dialogs.confirm(cvLoc('header.confirmUpload'), cvLoc('label.confirmUploadReports'), callBackFunctions);
						}
					};

					var requestsToProcess = {};

					if ($scope.isPrivate) {
						$scope.metricsReportingTitle = cvLoc('header.privateMetricsReporting');
						requestsToProcess.configResp = metricsReportingService.getPrivateMetricsConfiguration();
					} else {
						$scope.metricsReportingTitle = cvLoc('header.cloudMetricsReporting');
						requestsToProcess.configResp = metricsReportingService.getCloudMetricsConfiguration();
					}

					$q.all(requestsToProcess).then(
						function(response) {
							if (angular.isDefined(response.configResp.data)) {
								$scope.configuration = response.configResp.data;
								$scope.configuration.cloud.metricsServerURL = metricsReportingFactory.getMetricsServerUrl(
									$scope.configuration.cloud.uploadURL
								);
							}
						},
						function(errorMessage) {
							var errorString = !angular.isDefined(errorMessage.data) ? cvLoc('generic_error') : errorMessage.data;
							$log.error('Could not load metrics reporting: ' + errorString);
							$scope.serverMessage = cvUtil.errMsg(errorString);
							$scope.configuration = {};
						}
					);
				}
			]
		};
	}
]);

app.factory('metricsReportingFactory', [
	'cvUtil',
	'cvLoc',
	'CLOUD_SERVICES',
	'CHARGEBACK_FREQUENCY',
	'clientGroupService',
	'metricsReportingService',
	function metricsReportingFactory(
		cvUtil,
		cvLoc,
		CLOUD_SERVICES,
		CHARGEBACK_FREQUENCY,
		clientGroupService,
		metricsReportingService
	) {
		metricsReportingFactory.clientGroups = [];

		metricsReportingFactory.getClientGroups = function() {
			return clientGroupService
				.getClientGroups()
				.success(function(clientGroups) {
					if (clientGroups && angular.isArray(clientGroups)) {
						metricsReportingFactory.clientGroups = clientGroups.map(function(cg) {
							return {
								clientGroupId: cg.Id,
								clientGroupName: cg.name
							};
						});
					}
				})
				.error(function(errorMessage) {
					$log.error('Unable to load clientgroups :' + errorMessage);
				});
		};

		metricsReportingFactory.initializeUiModel = function(configuration, isPrivate) {
			var uiModel = {};
			if (configuration) {
				uiModel.commcellDiagUsage = configuration.commcellDiagUsage;
				uiModel.lastCollectionTime = configuration.lastCollectionTime;
				uiModel.lastUploadTime = configuration.lastUploadTime;
				uiModel.nextUploadTime = configuration.nextUploadTime;
				uiModel.uploadFrequency = configuration.uploadFrequency;
				uiModel.dataCollectionEnabled = configuration.dataCollectionTime != -1;
				uiModel.dataCollectionTime = convertSecondsToDateObject(configuration.dataCollectionTime);
				uiModel.isMetricsReportPackageInstalled = configuration.metricsReportPackageInstalled;
				uiModel.URLs = [];
				_.forEach(configuration.HttpServerInfo.httpServer, function(uploadServerURL) {
					uiModel.URLs.push(uploadServerURL.httpServerURL);
				});

				if (configuration.cloud && configuration.cloud.serviceList) {
					uiModel.services = initializeSelectedServices(configuration.cloud.serviceList, isPrivate);
				}
				uiModel.metricsServerURL = metricsReportingFactory.getMetricsServerUrl(configuration.cloud.uploadURL);
			}
			return uiModel;
		};

		metricsReportingFactory.getMetricsServerUrl = function(uploadUrl) {
			let url = '';
			if (uploadUrl) {
				let ctr = 0;
				let lastIndex = 0;
				while (ctr < 3 && uploadUrl.indexOf('/', lastIndex) != -1) {
					ctr++;
					lastIndex = uploadUrl.indexOf('/', lastIndex) + 1;
				}
				if (ctr == 3) {
					url = uploadUrl.substring(0, lastIndex);
				}
			}
			return url;
		};

		metricsReportingFactory.markSelectedClientGroups = function(selectedClientGroups) {
			if (selectedClientGroups) {
				var len = selectedClientGroups.length;
				if (len == 1 && selectedClientGroups[0].clientGroupId == -1) {
					//Nothing to do for all client groups
				} else {
					metricsReportingFactory.clientGroups.forEach(function(clientGroup) {
						for (var i = 0; i < selectedClientGroups.length; i++) {
							if (clientGroup.clientGroupId === selectedClientGroups[i].clientGroupId) {
								clientGroup.selected = true;
								break;
							}
						}
					});
				}
			}
		};

		metricsReportingFactory.isUserInputValid = function(uiModel, model) {
			if (uiModel.commcellDiagUsage) {
				if (model.isPrivate) {
					if (!uiModel.metricsServerURL) {
						model.accordionStatus['generalTab'] = true;
						return false;
					}
					if (uiModel.services[CLOUD_SERVICES.CHARGE_BACK]) {
						var anyOneChargeBackSelected =
							uiModel.services['chargeBackDaily'] ||
							uiModel.services['chargeBackWeekly'] ||
							uiModel.services['chargeBackMonthly'];
						if (!anyOneChargeBackSelected) {
							model.serverMessage = cvUtil.errMsg(cvLoc('error.selectChargeBackOption'));
							model.accordionStatus['generalTab'] = true;
							return false;
						}
					}
				}
				var atleastOneClientGroupSelected = validateClientGroups(uiModel.allClientGroups, uiModel.clientGroups);
				if (!atleastOneClientGroupSelected) {
					model.showClientGroupSelectionError = true;
					model.accordionStatus['configurationTab'] = true;
					return false;
				}

				if (!angular.isDefined(uiModel.uploadFrequency) || uiModel.uploadFrequency < 1 || uiModel.uploadFrequency > 7) {
					model.accordionStatus['configurationTab'] = true;
					return false;
				}
			}
			return true;
		};

		metricsReportingFactory.updateConfigurationObject = function(configurationObj, uiModel, isPrivate) {
			configurationObj.uploadFrequency = uiModel.uploadFrequency;
			configurationObj.dataCollectionTime = uiModel.dataCollectionTime;
			configurationObj.clientGroupList = getSelectedClientGroups(uiModel.allClientGroups, uiModel.clientGroups);
			configurationObj.cloud.serviceList = updateServiceList(configurationObj.cloud.serviceList, uiModel, isPrivate);

			if (uiModel.dataCollectionEnabled)
				configurationObj.dataCollectionTime = convertDateObjectToSeconds(uiModel.dataCollectionTime);
			else configurationObj.dataCollectionTime = -1;

			if (isPrivate) {
				configurationObj.cloud.uploadURL = uiModel.metricsServerURL + 'webconsole/';
				configurationObj.cloud.downloadURL = uiModel.metricsServerURL + 'downloads/sqlscripts/';
				configurationObj.HttpServerInfo.httpServer = [];
				_.forEach(uiModel.URLs, function(uploadServerURL) {
					var obj = {};
					obj['httpServerURL'] = uploadServerURL;
					configurationObj.HttpServerInfo.httpServer.push(obj);
				});
				if (uiModel.URLs.length) {
					configurationObj.tieringActive = true;
				} else {
					configurationObj.tieringActive = false;
				}
			} else {
				configurationObj.commcellDiagUsage = uiModel.commcellDiagUsage;
			}
		};

		function initializeSelectedServices(serviceList, isPrivate) {
			var services = {};
			if (angular.isArray(serviceList)) {
				serviceList.forEach(function(entity) {
					if (entity.service && typeof entity.service.id === 'number') {
						services[entity.service.id] = entity.enabled == true;
						if (isPrivate && entity.service.id === CLOUD_SERVICES.CHARGE_BACK) {
							services.chargeBackDaily = (entity.flags & CHARGEBACK_FREQUENCY.DAILY) != 0;
							services.chargeBackWeekly = (entity.flags & CHARGEBACK_FREQUENCY.WEEKLY) != 0;
							services.chargeBackMonthly = (entity.flags & CHARGEBACK_FREQUENCY.MONTHLY) != 0;
							setDefaultChargeBackOption(services);
						}
					}
				});
			}
			return services;
		}

		function updateServiceList(serviceList, uiModel, isPrivate) {
			if (!isPrivate && !uiModel.services[CLOUD_SERVICES.ALLOW_REMOTE_TROUBLESHOOTING]) {
				uiModel.services[CLOUD_SERVICES.PROACTIVE_SUPPORT] = false;
			}
			var services = angular.isDefined(serviceList) ? serviceList : [];
			services.forEach(function(serviceEntity) {
				serviceEntity.enabled = uiModel.services[serviceEntity.service.id];
				if (isPrivate && serviceEntity.service.id === CLOUD_SERVICES.CHARGE_BACK) {
					serviceEntity.flags = 0;
					if (uiModel.services.chargeBackDaily) serviceEntity.flags |= CHARGEBACK_FREQUENCY.DAILY;
					if (uiModel.services.chargeBackWeekly) serviceEntity.flags |= CHARGEBACK_FREQUENCY.WEEKLY;
					if (uiModel.services.chargeBackMonthly) serviceEntity.flags |= CHARGEBACK_FREQUENCY.MONTHLY;
				}
			});
			return services;
		}

		function validateClientGroups(allClientGroups, clientGroups) {
			if (allClientGroups) {
				return true;
			}
			if (angular.isArray(clientGroups)) {
				var clientGroupsCount = clientGroups.length;
				for (var i = 0; i < clientGroupsCount; i++) {
					if (clientGroups[i].selected == true) {
						return true;
					}
				}
			}
			return false;
		}

		function getSelectedClientGroups(allClientGroups, clientGroups) {
			var selectedClientGroups = [];
			if (allClientGroups) {
				selectedClientGroups.push({
					clientGroupId: -1,
					clientGroupName: ''
				});
			} else {
				if (angular.isArray(clientGroups)) {
					clientGroups.forEach(function(clientGroup) {
						if (clientGroup.selected == true) {
							selectedClientGroups.push({
								clientGroupId: clientGroup.clientGroupId,
								clientGroupName: clientGroup.clientGroupName
							});
						}
					});
				}
			}
			return selectedClientGroups;
		}

		function convertDateObjectToSeconds(dataCollectionTime) {
			var dataCollectionTimeInSeconds;
			var base_timestemp = 60;
			var time = new Date(dataCollectionTime);
			dataCollectionTimeInSeconds =
				time.getHours() * base_timestemp * base_timestemp + time.getMinutes() * base_timestemp;
			return dataCollectionTimeInSeconds;
		}

		function convertSecondsToDateObject(dataCollectionTime) {
			var base_timestemp = 3600;
			var defaultTimeStamp = 28800; //08:00 AM
			var activeTime = dataCollectionTime != -1 ? dataCollectionTime : defaultTimeStamp;
			var date = new Date();
			date.setHours(activeTime / base_timestemp, (activeTime % base_timestemp) / (base_timestemp / 60), 0, 0);
			return date;
		}

		function setDefaultChargeBackOption(services) {
			if (!services.chargeBackDaily && !services.chargeBackWeekly && !services.chargeBackMonthly) {
				services.chargeBackMonthly = true;
			}
		}

		return metricsReportingFactory;
	}
]);

app.controller('metricsReportingController', [
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	function(cvBreadcrumbsTabsFactory, cvLoc) {
		// Add breadcrumbs

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.system'),
			link: '#nav/settings'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
]);

app.controller('editMetricsReportingController', [
	'$scope',
	'$uibModalInstance',
	'$state',
	'cvUtil',
	'cvLoc',
	'inputParams',
	'metricsReportingService',
	'metricsReportingFactory',
	'clientGroupService',
	'CLOUD_SERVICES',
	'CHARGEBACK_FREQUENCY',
	'$timeout',
	function(
		$scope,
		$modalInstance,
		$state,
		cvUtil,
		cvLoc,
		inputParams,
		metricsReportingService,
		metricsReportingFactory,
		clientGroupService,
		CLOUD_SERVICES,
		CHARGEBACK_FREQUENCY,
		$timeout
	) {
		var configurationCopy;

		/**
		 * Input fields in editMetricsReporting.jsp refers to fields
		 * in this object: uiModel;
		 */
		$scope.uiModel = {
			commcellDiagUsage: false,
			downloadURL: '',
			uploadURL: '',
			services: {
				chargeBackDaily: false,
				chargeBackWeekly: false,
				chargeBackMonthly: false
			},
			clientGroups: [],
			allClientGroups: false,
			dataCollectionTime: new Date(),
			dataCollectionEnabled: false,
			uploadFrequency: 0,
			lastCollectionTime: 0,
			lastUploadTime: 0,
			nextUploadTime: 0,
			URLs: [],
			uploadURLs: ''
		};

		$scope.model = {
			localLang: cvUtil.getIStevenLocLabels(),
			serverMessage: {
				message: '',
				type: ''
			},
			isPrivate: false,
			serviceIds: CLOUD_SERVICES,
			showClientGroupSelectionError: false,
			workflowLink: '/webconsole/customreports/workflow.jsp?packageStatus=PROACTIVE_SUPPORT',
			accordionStatus: {
				generalTab: true,
				configurationTab: false,
				tieredTab: false,
				advancedTab: false
			}
		};

		if (inputParams && inputParams.configuration) {
			configurationCopy = inputParams.configuration;
			$scope.model.isPrivate = inputParams.isPrivate == true;
			$scope.uiModel = metricsReportingFactory.initializeUiModel(configurationCopy, $scope.model.isPrivate);
		}

		$scope.needsAttention = function(inputElement) {
			return inputElement.$touched && inputElement.$invalid && !inputElement.pristine;
		};

		$scope.isURLValid = function(url) {
			let pattern = new RegExp(/^((https?|http):\/\/)?[a-zA-Z0-9\.\-+]+(:\d+)?\/$/);
			return pattern.test(url);
		};

		$scope.isForwardingURLValid = function(url) {
			return url && (url.startsWith('http://') || url.startsWith('https://')) && url.endsWith('/webconsole/');
		};

		$scope.uiModel.uploadURLError = 0;
		$scope.uiModel.uploadURLinvalid = 0;
		$scope.addURL = function() {
			const URL = _.trim($scope.uiModel.uploadURLs);
			if (!URL) {
				return;
			} else if (_.indexOf($scope.uiModel.URLs, URL) >= 0) {
				$scope.uiModel.uploadURLError = 1;
				$timeout(function() {
					$scope.uiModel.uploadURLError = 0;
				}, 2000);
				return;
			} else if (!$scope.isForwardingURLValid(URL)) {
				$scope.uiModel.uploadURLinvalid = 1;
				$timeout(function() {
					$scope.uiModel.uploadURLinvalid = 0;
				}, 6000);
				return;
			}
			$scope.uiModel.URLs.push(URL);
			$scope.uiModel.uploadURLs = '';
		};

		$scope.removeURL = function(index) {
			$scope.uiModel.URLs.splice(index, 1);
		};

		$scope.resetChargeBackErrorMessage = function() {
			$scope.model.serverMessage = cvUtil.emptyMsg();
		};

		$scope.resetClientGroupErrorMessage = function() {
			$scope.model.showClientGroupSelectionError = false;
		};

		$scope.close = function() {
			$modalInstance.dismiss();
		};

		$scope.saveConfiguration = function() {
			if (metricsReportingFactory.isUserInputValid($scope.uiModel, $scope.model)) {
				metricsReportingFactory.updateConfigurationObject(configurationCopy, $scope.uiModel, $scope.model.isPrivate);

				if ($scope.model.isPrivate) {
					if (
						typeof $scope.uiModel.metricsServerURL == 'undefined' ||
						!$scope.isURLValid($scope.uiModel.metricsServerURL)
					) {
						return;
					}
					configurationCopy.commcellDiagUsage = true;
				}

				metricsReportingService
					.updateConfiguration({
						commcellSurveyConfiguration: configurationCopy,
						isPrivateCloud: $scope.model.isPrivate
					})
					.then(function(response) {
						if (response && response.data && response.data.errorCode == 0) {
							$modalInstance.close();
							$state.forceReload();
						} else {
							$scope.model.serverMessage = {
								message: response.data.errorMessage ? cvLoc('generic_error') : response.data.errorMessage,
								type: 'error'
							};
						}
					});
			}
		};

		metricsReportingFactory.getClientGroups().then(function() {
			var initialSelection = configurationCopy.clientGroupList;
			metricsReportingFactory.markSelectedClientGroups(initialSelection);
			$scope.uiModel.clientGroups = metricsReportingFactory.clientGroups;
			initialSelection.forEach(function(clientGroup) {
				if (clientGroup.clientGroupId === -1) {
					$scope.uiModel.allClientGroups = true;
					return;
				}
			});
		}, showErrorMessage);

		function showErrorMessage(errorMessage) {
			if (errorMessage) {
				if (angular.isString(errorMessage)) {
					$scope.model.serverMessage = cvUtil.errMsg(errorMessage);
				} else if (angular.isString(errorMessage.data)) {
					$scope.model.serverMessage = cvUtil.errMsg(errorMessage.data);
				} else {
					$scope.model.serverMessage = cvLoc('generic_error');
				}
			}
		}
	}
]);

export default app;
