import 'commonForAllAgents/js/controllers/installUpdate.ctrl.js';
import 'commonForAllAgents/js/controllers/downloadSoftware.ctrl.js';
import 'modules/settings/js/controllers/drBackup.ctrl.js';
import 'modules/settings/js/controllers/copySoftware.ctrl.js';
import 'modules/servers/js/services/servers.svc.js';
import 'commonForAllAgents/js/controllers/smartMAStateManagement.ctrl.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var settingsMod = cvModuleSettingsModule;

var controllers = {};
settingsMod.factory('MaintenanceFactory', [
	'$q',
	'settingsService',
	'metricsReportingService',
	function($q, settingsService, metricsReportingService) {
		var maintenanceFactory = {
			save: function(proxyInfo) {
				var deferred = $q.defer();
				settingsService
					.setHttpProxy(angular.copy(proxyInfo))
					.success(function(data) {
						//resolve proxyinfo data to tile
						deferred.resolve();
					})
					.error(function(e) {
						self.editPlanMessage = {
							message: e,
							type: 'error'
						};
						deferred.reject(e);
					});

				return deferred.promise;
			},
			load: function(proxyInfo) {
				var deferred = $q.defer();
				settingsService.getHttpProxy(
					function(data) {
						angular.forEach(data.config, function(value, key) {
							proxyInfo[key] = typeof value === Object ? angular.copy(value) : value;
						});
						deferred.resolve();
					},
					function(e) {
						self.serverMessage = e;
						deferred.reject(e);
					}
				);

				return deferred.promise;
			},

			loadInternetGatewayClients: function() {
				var deferred = $q.defer();
				settingsService.getInternetGatewayClients(
					function(data) {
						maintenanceFactory.clientsList = data;
						deferred.resolve();
					},
					function(e) {
						self.serverMessage = e;
						deferred.reject(e);
					}
				);

				return deferred.promise;
			},

			getPrivateMetricsConfig: function() {
				var deferred = $q.defer();
				if (maintenanceFactory.privateMetricsConfiguration) {
					deferred.resolve(maintenanceFactory.privateMetricsConfiguration);
				} else {
					metricsReportingService.getPrivateMetricsConfiguration().then(function(response) {
						if (response && typeof response.data != 'undefined') {
							maintenanceFactory.privateMetricsConfiguration = response.data;
						}
						deferred.resolve(maintenanceFactory.privateMetricsConfiguration);
					});
				}

				return deferred.promise;
			}
		};
		maintenanceFactory.privateMetricsConfiguration = null;
		maintenanceFactory.clientsList = [];
		return maintenanceFactory;
	}
]);
/**
 * A controller for handling the functionality on the internetProxy.jsp page.
 */
controllers.internetProxyController = [
	'$uibModal',
	'MaintenanceFactory',
	'cvUtil',
	'cvLoc',
	'cvBreadcrumbsTabsFactory',
	'MAINTANENCE_ICONS',
	function($modal, maintenanceFactory, cvUtil, cvLoc, cvBreadcrumbsTabsFactory, MAINTANENCE_ICONS) {
		function InternetProxy() {
			var self = this;
			self.data = {
				proxyType: null,
				useHttpProxy: false,
				useProxyAuthentication: false,
				proxyServer: '',
				proxyPort: 1025,
				set preProxyPort(value) {
					self.data.proxyPort = self.data.useHttpProxy ? value : 1025;
				},
				get preProxyPort() {
					return self.data.proxyPort;
				},
				proxyCredentials: {
					userName: '',
					password: '',
					confirmPassword: ''
				},
				softwareDownloadProtocolType: null,
				usePassiveFTPConnection: false,
				proxyTypeDisplayName: '',
				proxyClient: {
					clientId: 0
				}
			};
		}

		var self = this;
		self.httpProxySvg = MAINTANENCE_ICONS.HTTP_PROXY;
		self.internetOptionSvg = MAINTANENCE_ICONS.INTERNET_OPTIONS;

		//get HTTP Proxy info from server
		self.proxyInfo = new InternetProxy().data;
		self.loadData = function() {
			maintenanceFactory.load(self.proxyInfo).then(function() {
				self.proxyInfo.proxyTypeDisplayName = cvUtil.lookupEnumConstant(self.proxyInfo.proxyType);
				self.showResult = true;
			});
		};

		self.editInternetOptionsModal = function() {
			var modalInstance = $modal.open({
				templateUrl: 'modules/settings/partials/internetOptionsModal.jsp',
				backdrop: 'static',
				controllerAs: 'internetOptionsCtrl',
				controller: [
					'$uibModalInstance',
					'proxyInfo',
					'MaintenanceFactory',
					function($modalIntance, proxyInfo, maintenanceFactory) {
						var _this = this;
						_this.proxyInfo = new InternetProxy().data;
						angular.forEach(proxyInfo, function(value, key) {
							_this.proxyInfo[key] = typeof value == 'object' ? angular.copy(value) : value;
						});

						_this.clientsList = [];
						maintenanceFactory.loadInternetGatewayClients(_this.clientsList).then(function() {
							_this.clientsList = maintenanceFactory.clientsList;
						});
						_this.checkInvalidClientSelection = function() {
							if (_this.proxyInfo.proxyType == 'useClient' && _this.proxyInfo.proxyClient.clientId < 2) {
								return true;
							}
							return false;
						};

						_this.isMetricsReportPackageInstalled = false;
						_this.isPrivateMetricsEnabled = false;
						maintenanceFactory.getPrivateMetricsConfig().then(function(data) {
							if (data) {
								if (typeof data.metricsReportPackageInstalled != 'undefined') {
									_this.isMetricsReportPackageInstalled = data.metricsReportPackageInstalled;
								}
								if (typeof data.commcellDiagUsage != 'undefined') {
									_this.isPrivateMetricsEnabled = data.commcellDiagUsage;
								}
							}
						});

						_this.cancel = function() {
							$modalIntance.dismiss();
						};

						_this.setProxySettings = function() {
							maintenanceFactory.save(_this.proxyInfo).then(function() {
								angular.extend(proxyInfo, _this.proxyInfo);
								proxyInfo.proxyTypeDisplayName = cvUtil.lookupEnumConstant(proxyInfo.proxyType);
								$modalIntance.close();
							});
						};
						_this.shouldMetricsServerOptionBeDisabled = function() {
							return _this.isMetricsReportPackageInstalled || !_this.isPrivateMetricsEnabled;
						};
						_this.getReasonForDisablingMetricsServerOption = function() {
							if (!_this.shouldMetricsServerOptionBeDisabled()) {
								return '';
							} else {
								if (_this.isMetricsReportPackageInstalled) {
									return cvLoc('info.metricsPackageInstalledInSameMachine');
								} else if (!_this.isPrivateMetricsEnabled) {
									return cvLoc('info.privateMetricsDisabled');
								}
							}
							return '';
						};
					}
				],
				resolve: {
					proxyInfo: function() {
						return self.proxyInfo;
					}
				}
			});
		};
		//if settings is clicked, or switch button is clicked from off to on,
		self.editHTTPProxyModal = function(type, edit) {
			if (edit && self.proxyInfo[type]) {
				self.proxyInfo[type] = false;
				if (type === 'useHttpProxy') {
					//self.proxyInfo = new InternetProxy().data;
					self.proxyInfo.proxyServer = '';
					self.proxyInfo.proxyPort = 1025;
				} else if (type === 'useProxyAuthentication') {
					//initialize proxyCredentials
					angular.forEach(self.proxyInfo.proxyCredentials, function(value, key) {
						self.proxyInfo.proxyCredentials[key] = '';
					});
				}
				maintenanceFactory.save(self.proxyInfo);
				return false;
			}

			var modalInstance = $modal.open({
				templateUrl: 'modules/settings/partials/proxySettingsModal.jsp',
				backdrop: 'static',
				controllerAs: 'modalCtrl',
				controller: [
					'$uibModalInstance',
					'proxyInfo',
					function($modalIntance, proxyInfo) {
						var _this = this;
						_this.type = type;
						_this.proxyInfo = new InternetProxy().data;
						angular.forEach(proxyInfo, function(value, key) {
							_this.proxyInfo[key] = typeof value == 'object' ? angular.copy(value) : value;
						});
						_this.proxyInfo[type] = true;
						_this.setProxySettings = function() {
							maintenanceFactory.save(_this.proxyInfo).then(function() {
								angular.extend(proxyInfo, _this.proxyInfo);
								$modalIntance.close();
							});
						};
						_this.cancel = function() {
							$modalIntance.dismiss();
						};
					}
				],
				resolve: {
					proxyInfo: function() {
						return self.proxyInfo;
					}
				}
			});
		};

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.system'),
			link: '#nav/settings'
		});

		cvBreadcrumbsTabsFactory.clearBc();
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
];

/**
 * A controller for handling the functionality on the internetProxy.jsp page.
 */
controllers.WebDomainsController = [
	'$uibModal',
	'serverService',
	'cvUtil',
	'cvLoc',
	'MAINTANENCE_ICONS',
	function($modal, serverService, cvUtil, cvLoc, MAINTANENCE_ICONS) {
		var self = this;
		self.domainObj = {};
		self.domainObj.domainList = [];
		self.webDomiansSvg = MAINTANENCE_ICONS.WEB_DOMAINS;
		//get HTTP Proxy info from server
		self.loadData = function() {
			//service call
			serverService
				.getGlobalParam('webDomainsWhiteList', true)
				.success(function(resp) {
					if (angular.isDefined(resp) && resp !== 'null' && resp !== '') {
						self.domainObj.domainList = resp.split(',');
					}
					self.showWebDomains = true;
				})
				.error(function(err) {
					self.serverMessage = err
						? cvUtil.errMsg(err)
						: cvUtil.errMsg('Could not retreive the domains list. Please contact your administrator.');
					self.showWebDomains = true;
				});
		};

		self.editDomainList = function() {
			var modalInstance = $modal.open({
				templateUrl: 'modules/settings/partials/editWebDomainsListModal.jsp',
				backdrop: 'static',
				controllerAs: 'domainListCtrl',
				controller: [
					'$uibModalInstance',
					'domainObj',
					'cvUtil',
					'cvLoc',
					function($modalIntance, domainObj, cvUtil, cvLoc) {
						var _this = this;
						_this.domainList = domainObj.domainList.slice();

						_this.add = function(domainName, $event) {
							if (!angular.isDefined($event) || $event.charCode === 13) {
								if (
									angular.isDefined(domainName) &&
									domainName.trim() !== '' &&
									_this.domainList.indexOf(domainName) === -1
								) {
									_this.domainList.unshift(domainName);
								}
								_this.domainName = '';
							}
						};

						_this.deleteDomain = function(domainName) {
							_this.serverMessage = cvUtil.emptyMsg();
							_this.domainList.splice(_this.domainList.indexOf(domainName), 1);
						};

						_this.cancel = function() {
							$modalIntance.dismiss();
						};

						_this.save = function() {
							serverService
								.saveWebDomainsList(_this.domainList.join(','))
								.success(function(data) {
									if (data.result == 'success') {
										domainObj.domainList = data.list.split(',');
										if (domainObj.domainList == '') {
											domainObj.domainList = [];
										}
										$modalIntance.dismiss();
									} else if (data.result == 'failed') {
										_this.serverMessage = cvUtil.errMsg(cvLoc('error.invalidDomain') + data.list);
									} else {
										// should not reach here
										_this.serverMessage = cvUtil.errMsg(cvLoc('error.domainSaveError'));
									}
								})
								.error(function(err) {
									_this.serverMessage = err ? cvUtil.errMsg(err) : cvUtil.errMsg(cvLoc('error.domainSaveError'));
								});
						};
					}
				],
				resolve: {
					domainObj: function() {
						return self.domainObj;
					}
				}
			});
		};
	}
];

settingsMod.controller(controllers);

export default settingsMod;
