import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'storage/js/services/storage.svc.js';
import 'modules/settings/js/factories/commcellUtils.factory.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var encodePwd = pwd => {
	if (pwd && pwd !== '') {
		return Base64.encode(pwd);
	}
	return undefined;
};

var settingsMod = cvModuleSettingsModule;
var controllers = {};
/**
 * A controller for handling the functionality on the internetProxy.jsp page.
 */
settingsMod.constant('TIME', {
	HOUR: 3600,
	MIN: 60
});

settingsMod.constant('DEFAULT_PATTERN', {
	EVERY: 28800,
	UNTIL: 86340
});
controllers.drBackupController = [
	'commcellUtils',
	'cvLoc',
	'MAINTANENCE_ICONS',
	function(commcellUtils, cvLoc, MAINTANENCE_ICONS) {
		var self = this;
		self.availableProperties = _.isEmpty(self.exportSettings);
		self.errorFunc = function(e) {
			self.exportSettings = {};
			self.serverMessage = e;
		};
		self.drBackupSvg = MAINTANENCE_ICONS.DR_BACKUP;
		self.loadData = async function() {
			const data = await commcellUtils.loadDrBackupInfo();

			if (data) {
				if (data.backupLoadError) {
					self.errorFunc(data.msg);
					return;
				}

				self.showEdit = true;
				self.exportSettings = data;

				if (data.libraryLoadError) {
					self.errorFunc(cvLoc('error.getAllLibraries'));
					return;
				}

				//export Settings
				if (self.exportSettings.UseLocalDrive) {
					self.exportSettings.userPassword = {};
				}
			} else {
				self.errorFunc(cvLoc('connect.failed.message'));
				return;
			}
		};

		self.openRunJob = function() {
			commcellUtils.openDRRunJob();
		};

		self.editDRBackup = async function() {
			var modalInstance = await commcellUtils.editDRBackup(function() {
				return self.exportSettings;
			});

			modalInstance.result.then(function(obj) {
				const pattern = angular.copy(self.exportSettings['pattern']);
				self.exportSettings = angular.extend({}, self.exportSettings, obj.drBackup);
				self.exportSettings['pattern'] = angular.extend({}, pattern, obj.pattern);
			});
		};
	}
];

controllers.editDRBackupModalController = [
	'$uibModal',
	'$uibModalInstance',
	'settingsService',
	'storageService',
	'REGEX',
	'drBackInfo',
	'cvLoc',
	'cvUtil',
	'TIME',
	'DEFAULT_PATTERN',
	function(
		$modal,
		$modalIntance,
		settingsService,
		storageService,
		REGEX,
		drBackInfo,
		cvLoc,
		cvUtil,
		TIME,
		DEFAULT_PATTERN
	) {
		//initialize dr backup info
		var self = this;
		self.clickBrowse = true;
		self.exportSettings = angular.copy(drBackInfo);
		self.exportSettings.backupFolderType = self.exportSettings.UseNetworkShare ? 'network' : 'local';
		self.destLocation = {
			local: self.exportSettings.UseNetworkShare ? '' : self.exportSettings.DRDumpLocation,
			network: self.exportSettings.UseNetworkShare ? self.exportSettings.DRDumpLocation : ''
		};

		self.pathInputLabels = {
			type: 'label.backupMetadataFolderType',
			path: 'label.backupMetadatPath'
		};

		self.credentialsName = ['userName', 'password', 'confirmPassword'];
		self.dummyCredentials = 'drBackupCvCloudEnabled';
		self.dummyCloudCredentials = {};

		_.forOwn(self.credentialsName, (val, key) => {
			self.dummyCloudCredentials[val] = self.dummyCredentials;
		});

		if (Array.isArray(self.exportSettings.cloudLibList) && self.exportSettings.cloudLibList.length) {
			for (var j = 0; j < self.exportSettings.cloudLibList.length; j++) {
				if (self.exportSettings.cloudLibList[j].library.libraryId === self.exportSettings.cloudLibrary.libraryId) {
					self.exportSettings.cloudLibrary = self.exportSettings.cloudLibList[j].library;
					break;
				}
			}
		}

		self.exportSettings.uploadBackupMetadataToCloud += '';
		self.exportSettings.uploadBackupMetadataToCloudLib += '';

		self.changeToggleState = function(obj, label, form) {
			self[obj][label] = self[obj][label] == 'true' ? 'false' : 'true';
			form.$dirty = true;
		};

		self.changeFromTimestamp = function(label, obj) {
			if (label == 'freq_subday_interval') {
				var activeTime = {
					min: (obj[label] % TIME.HOUR) / TIME.MIN,
					hour: Math.floor(obj[label] / TIME.HOUR)
				};
			} else {
				var activeTime = new Date();
				activeTime.setHours(Math.floor(obj[label] / TIME.HOUR));
				activeTime.setMinutes((obj[label] % TIME.HOUR) / TIME.MIN);
			}
			obj[label] = activeTime;
		};

		self.changeToTimestamp = function(label, obj, isRepeatEvery) {
			if (!isRepeatEvery || isRepeatEvery == 'false') {
				obj[label] = 0;
				return;
			}

			obj[label] =
				label == 'freq_subday_interval'
					? obj[label].hour * TIME.HOUR + obj[label].min * TIME.MIN
					: obj[label].getHours() * TIME.HOUR + obj[label].getMinutes() * TIME.MIN;
		};

		//schedule Settings
		if (self.exportSettings.pattern.active_end_time > 0 && self.exportSettings.pattern.freq_subday_interval > 0) {
			self.exportSettings.isRepeatEvery = 'true';
		} else {
			self.exportSettings.isRepeatEvery = 'false';
			self.exportSettings.pattern.active_end_time = DEFAULT_PATTERN.UNTIL;
			self.exportSettings.pattern.freq_subday_interval = DEFAULT_PATTERN.EVERY;
		}
		self.changeFromTimestamp('active_start_time', self.exportSettings.pattern);
		self.changeFromTimestamp('active_end_time', self.exportSettings.pattern);
		self.changeFromTimestamp('freq_subday_interval', self.exportSettings.pattern);

		self.browse = function() {
			//To load browse modal, get mediaAgent id
			self.clickBrowse = false;
			storageService
				.getMediaAgentList('NONE')
				.success(function(data) {
					self.mediaAgentId = data.length <= 0 ? 2 : data[0].mediaAgentId;
					var modalInstance = $modal
						.open({
							templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
							controller: 'mbController',
							resolve: {
								browseParams: function() {
									return {
										foldersOnly: true,
										clientId: self.mediaAgentId
									};
								}
							}
						})
						.result.then(function(result) {
							self.destLocation.local = result.path;
						});
				})
				.error(function(data, status, header, config) {
					self.serverMessage = cvUtil.errMsg(data);
					self.clickBrowse = true;

					return false;
				})
				.then(function() {
					self.clickBrowse = true;
				});
		};

		self.cancel = function() {
			$modalIntance.dismiss();
		};

		const validateCredentials = (checkAll, cred1, cred2) => {
			return checkAll || cred1.userName !== cred2.userName ? true : cred1.password !== cred2.password;
		};

		const checkConfirmPassword = cred => {
			return cred.password !== cred.confirmPassword;
		};

		self.saveExportSettings = function(form1, form2) {
			self.serverMessage = cvUtil.emptyMsg();

			let userPassword = null;
			let cloudUserPassword = null;
			let pattern = null;
			let newDRbackinfo = null;

			if (!form1.$dirty && !form2.$dirty) {
				$modalIntance.dismiss('No change');
				return;
			}

			if (form1.$dirty) {
				form1.$submitted = true;

				if (!_.isEmpty(form1.$error)) {
					return -1;
				}

				//manage DR backup info
				newDRbackinfo = {
					DRNumFulls: self.exportSettings.DRNumFulls
				};

				if (
					self.exportSettings.uploadBackupMetadataToCloud !== _.toString(drBackInfo.uploadBackupMetadataToCloud) ||
					self.exportSettings.uploadBackupMetadataToCloud === 'true'
				) {
					if (self.exportSettings.uploadBackupMetadataToCloud === 'true') {
						if (
							self.exportSettings.uploadBackupMetadataToCloud !== _.toString(drBackInfo.uploadBackupMetadataToCloud)
						) {
							newDRbackinfo['uploadBackupMetadataToCloud'] = true;
							cloudUserPassword = _.cloneDeep(self.dummyCloudCredentials);
						}
					} else {
						newDRbackinfo['uploadBackupMetadataToCloud'] = false;
					}
				}

				if (
					self.exportSettings.uploadBackupMetadataToCloudLib !==
						_.toString(drBackInfo.uploadBackupMetadataToCloudLib) ||
					self.exportSettings.uploadBackupMetadataToCloudLib === 'true'
				) {
					if (self.exportSettings.uploadBackupMetadataToCloudLib === 'true') {
						if (
							typeof self.exportSettings.cloudLibrary.libraryId !== 'undefined' &&
							self.exportSettings.cloudLibrary.libraryId !== 0 &&
							Array.isArray(self.exportSettings.cloudLibList) &&
							self.exportSettings.cloudLibList.length > 0 &&
							self.exportSettings.cloudLibList.some(value => {
								return value.library.libraryId == self.exportSettings.cloudLibrary.libraryId;
							})
						) {
							newDRbackinfo['uploadBackupMetadataToCloudLib'] = true;
							newDRbackinfo['cloudLibrary'] = self.exportSettings.cloudLibrary;
						}

						if (
							typeof self.exportSettings.cloudLibrary.libraryId === 'undefined' ||
							self.exportSettings.cloudLibrary.libraryId === 0 ||
							(Array.isArray(self.exportSettings.cloudLibList) && self.exportSettings.cloudLibList.length === 0) ||
							(Array.isArray(self.exportSettings.cloudLibList) &&
								self.exportSettings.cloudLibList.length > 0 &&
								!self.exportSettings.cloudLibList.some(value => {
									return value.library.libraryId == self.exportSettings.cloudLibrary.libraryId;
								}))
						) {
							self.serverMessage = cvUtil.errMsg(cvLoc('error.disableCloudLib'));
							return -1;
						}
					} else {
						newDRbackinfo['uploadBackupMetadataToCloudLib'] = false;
						newDRbackinfo['cloudLibrary'] = self.exportSettings.cloudLibrary;
					}
				}

				if (self.exportSettings.backupFolderType === 'network') {
					if (
						validateCredentials(
							drBackInfo.DRDumpLocation != self.destLocation['network'],
							drBackInfo.userPassword,
							self.exportSettings.userPassword
						)
					) {
						newDRbackinfo['isUserAccountEnabled'] = newDRbackinfo['UseNetworkShare'] = true;
						newDRbackinfo['UseLocalDrive'] = false;
						newDRbackinfo['DRDumpLocation'] = self.destLocation['network'];
						userPassword = angular.copy(self.exportSettings.userPassword);
					}
				} else {
					if (drBackInfo.DRDumpLocation !== self.destLocation['local']) {
						newDRbackinfo['isUserAccountEnabled'] = newDRbackinfo['UseNetworkShare'] = false;
						newDRbackinfo['UseLocalDrive'] = true;
						newDRbackinfo['DRDumpLocation'] = self.destLocation['local'];
					}
				}
			}

			if (form2.$dirty) {
				form2.$submitted = true;
				pattern = angular.copy(self.exportSettings.pattern);

				if (
					self.exportSettings.isRepeatEvery == 'true' &&
					pattern['active_start_time'].getTime() >= pattern['active_end_time']
				) {
					self.serverMessage = cvUtil.errMsg(cvLoc('error.drbackupSchedule'));
					return;
				}
				self.changeToTimestamp('active_start_time', pattern, true);
				self.changeToTimestamp('active_end_time', pattern, self.exportSettings.isRepeatEvery);
				self.changeToTimestamp('freq_subday_interval', pattern, self.exportSettings.isRepeatEvery);
			}

			//send drbackup info to server
			settingsService
				.setDrbackup(newDRbackinfo, userPassword, cloudUserPassword, pattern)
				.success(function(data) {
					if (newDRbackinfo != null) {
						if (newDRbackinfo.isUserAccountEnabled) {
							newDRbackinfo['userPassword'] = { userName: userPassword.userName };
						}

						if (newDRbackinfo.uploadBackupMetadataToCloud) {
							newDRbackinfo['cloudCredentials'] = { userName: cloudUserPassword.userName };
						}
					}

					$modalIntance.close({ drBackup: newDRbackinfo, pattern: pattern });
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		};
	}
];

controllers.disasterDRBackupModalController = [
	'$location',
	'$uibModalInstance',
	'$uibModalStack',
	'cvToaster',
	'cvLoc',
	'settingsService',
	function($location, $modalIntance, $modalStack, cvToaster, cvLoc, settingsService) {
		var self = this;

		//default settings for drBackupOption
		self.drBackup = {
			type: 'FULL',
			compression: true
		};
		self.cancel = function() {
			$modalIntance.dismiss();
		};
		self.runJob = function() {
			//send a back-up setting info to get a job for the back-up
			settingsService
				.getDisasterDrBackup(self.drBackup.type, self.drBackup.compression)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						message:
							'<a href="#jobs/' +
							data.jobIds[0] +
							'">' +
							cvLoc('notification.backup.started') +
							' ' +
							cvLoc('notification.backup.job') +
							' ' +
							data.jobIds[0] +
							'<br/>' +
							cvLoc('notification.jobDetails') +
							'</a>'
					});
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						message: e
					});
				})
				.then(function() {
					$modalIntance.close();
				});
		};
	}
];

settingsMod.controller(controllers);

export default settingsMod;
