import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'modules/servers/js/services/servers.svc.js';
import 'ediscovery/common/js/services/ediscovery.svc.js';
import 'modules/settings/js/services/settings.svc.js';
import { Constants } from 'ediscovery/casemanager/js/controllers/caseConstants.js';
import { commonAllAgentsModule } from 'common/js/modules';
class copySoftwareModalController {
	constructor(
		modalInstance,
		$uibModal,
		serverService,
		cvToaster,
		cvLoc,
		EntityTypes,
		cvUtil,
		ediscoveryService,
		settingsService,
		REGEX,
		cachedModel
	) {
		this.modalInstance = modalInstance;
		this.modal = $uibModal;
		this.serverService = serverService;
		this.cvToaster = cvToaster;
		this.cvLoc = cvLoc;
		this.EntityTypes = EntityTypes;
		this.cvUtil = cvUtil;
		this.ediscoveryService = ediscoveryService;
		this.settingsService = settingsService;
		this.REGEX = REGEX;
		this.cachedModel = cachedModel;
		this.init();
	}

	init() {
		this.clientId = 2;
		this.inputAlertFlags = {};
		this.settingsService
			.getCommserveDetails()
			.then(result => {
				this.clientId = _.get(result, 'data.commcell.commCellId', this.clientId);
			})
			.catch(error => {
				this.cvToaster.showErrorMessageWrapper(error);
			});
		this.topNode = {
			label: this.cvLoc('label.clients'),
			_type_: this.EntityTypes.ALL_CLIENTS,
			ItemId: 'root',
			ItemName: this.cvLoc('label.clients')
		};
		this.model = {
			impersonateUser: _.get(this.cachedModel, 'impersonateUser', true),
			syncUpdateCaches: _.get(this.cachedModel, 'syncUpdateCaches', true),
			networkLocation: _.get(this.cachedModel, 'networkLocation', false),
			updateCachePath: _.get(this.cachedModel, 'updateCachePath', ''),
			remoteCaches: _.get(this.cachedModel, 'remoteCaches', []),
			credentials: {}
		};
		this.cvParams = {
			mode: 'edit',
			topNodes: [this.topNode],
			requestChildren: this.requestChildren.bind(this),
			processChildren: this.processChildren.bind(this),
			multiSelect: true,
			editParams: {
				inputSelected: [this.topNode],
				result: {}
			}
		};
		this.localLang = this.cvUtil.getIStevenLocLabels();
	}

	processChildren(children) {
		return children;
	}

	requestChildren(node) {
		if (node._type_ == this.EntityTypes.ALL_CLIENTS) {
			let self = this;
			return new Promise((res, rej) => {
				self.serverService
					.getRemoteCache()
					.then(result => {
						let uaInfo = _.get(result, 'data.uaInfo');
						if (uaInfo && uaInfo.length) {
							self.model.remoteCaches = _.map(uaInfo, x => {
								return {
									_type_: self.EntityTypes.CLIENT_ENTITY,
									ItemName: _.get(x, 'uaName.name'),
									clientName: _.get(x, 'uaName.name'),
									clientId: _.get(x, 'uaName.id'),
									ItemId: _.get(x, 'uaName.id'),
									noChild: true
								};
							});
							res(self.model.remoteCaches);
						} else {
							rej(null);
						}
					})
					.catch(error => {
						self.cvToaster.showErrorMessageWrapper(error);
						rej(error);
					});
			});
		}
	}

	browse() {
		let clientId = this.clientId;
		let modalInstance = this.modal.open({
			templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
			controller: 'mbController',
			resolve: {
				browseParams: function() {
					return {
						clientId: clientId,
						foldersOnly: true
					};
				}
			}
		});
		modalInstance.result.then(result => {
			this.model.updateCachePath = result.path;
		});
	}

	cancel() {
		this.modalInstance.dismiss();
	}

	validate() {
		let valid = true;
		valid = !(this.inputAlertFlags.updateCachePath = !this.model.updateCachePath) && valid;
		if (this.model.updateCachePath) {
			if (this.model.networkLocation) {
				valid = this.REGEX.WINDOWS_NETWORK_PATH.test(this.model.updateCachePath) && valid;
				this.inputAlertFlags.updateCachePath = !valid;
			} else {
				valid =
					(this.REGEX.UNIX_PATH.test(this.model.updateCachePath) ||
						this.REGEX.WINDOWS_LOCAL_PATH.test(this.model.updateCachePath)) &&
					valid;
				this.inputAlertFlags.updateCachePath = !valid;
			}
		}
		if (this.model.impersonateUser) {
			valid = this.model.credentials.username && valid;
			valid = this.model.credentials.password && valid;
		}
		return valid;
	}

	createTaskReq() {
		let request = {
			taskInfo: {
				task: {
					taskType: Constants.IMMEDIATE //IMMEDIATE
				},
				subTasks: [
					{
						subTask: {
							operationType: Constants.DOWNLOAD_UPDATES, //DOWNLOAD_UPDATES
							subTaskType: Constants.ADMIN //ADMIN
						},
						options: {
							adminOpts: {
								updateOption: {
									copySoftwareAndUpdates: true,
									copyUpdates: true,
									invokeLevel: '1',
									overwriteNewerContent: false,
									syncUpdateCaches: this.model.syncUpdateCaches,
									clientAndClientGroups: [],
									downloadUpdatesJobOptions: {
										downloadSoftware: true,
										updateCachePath: this.model.updateCachePath
									}
								}
							}
						}
					}
				]
			}
		};
		if (this.model.networkLocation && this.model.impersonateUser) {
			_.set(request, 'taskInfo.subTasks[0].options.adminOpts.updateOption.downloadUpdatesJobOptions.clientAuth', {
				password: Base64.encode(this.model.credentials.password),
				userName: this.model.credentials.username
			});
		}
		if (this.model.syncUpdateCaches) {
			let excluded = _.map(_.get(this.cvParams, 'editParams.result.excluded'), item => {
				return {
					_type_: item._type_,
					clientId: item.clientId,
					clientName: item.clientName,
					flags: {
						exclude: true
					}
				};
			});
			let included = _.map(_.get(this.cvParams, 'editParams.result.selected'), item => {
				return {
					_type_: item._type_,
					clientId: item.clientId,
					clientName: item.clientName
				};
			});
			_.set(
				request,
				'taskInfo.subTasks[0].options.adminOpts.updateOption.clientAndClientGroups',
				_.compact(_.concat(included, excluded))
			);
		}
		return request;
	}

	setCachedDetails() {
		let toCache = _.omit(this.model, ['credentials', 'remoteCaches']);
		return this.settingsService.setGlobalParam('copySoftwareCache', toCache);
	}

	networkChanged() {
		if (!this.model.updateCachePath || this.model.updateCachePath == '\\\\') {
			let updateCache = document.getElementById('updateCachePath');
			updateCache = angular.element(updateCache);
			updateCache.focus();
			if (this.model.networkLocation) {
				this.model.updateCachePath = '\\\\';
			} else {
				this.model.updateCachePath = '';
			}
		}
	}

	ok() {
		if (this.validate()) {
			let request = this.createTaskReq();
			this.ediscoveryService
				.createTaskJs(angular.toJson(request))
				.then(result => {
					const { data } = result;
					if (data.taskId !== -1 && data.jobIds && data.jobIds.length > 0) {
						const jobId = data.jobIds[0];
						const jobType = 'copySoftware';
						const jobMsg = `${this.cvLoc(`notification.${jobType}.started`)}  ${jobId}`;
						const viewMsg = this.cvLoc('notification.jobDetails');
						this.cvToaster.showInfoMessage({
							ttl: '10000',
							message: `${jobMsg} <br><a href=#/jobs/${jobId}>${viewMsg}</a>`
						});
						this.setCachedDetails()
							.then(() => {
								this.modalInstance.close();
							})
							.catch(() => {
								this.modalInstance.close();
							});
					} else {
						this.cvToaster.showErrorMessage({
							ttl: '10000',
							message: this.cvLoc('error.casemanager.jobError')
						});
					}
				})
				.catch(error => {
					this.serverMessage = this.cvUtil.errMsgWrapper(error);
					this.cvToaster.showErrorMessageWrapper(error);
				});
		}
	}
}
copySoftwareModalController.$inject = [
	'$uibModalInstance',
	'$uibModal',
	'serverService',
	'cvToaster',
	'cvLoc',
	'EntityTypes',
	'cvUtil',
	'ediscoveryService',
	'settingsService',
	'REGEX',
	'cachedModel'
];
commonAllAgentsModule.controller('copySoftwareModalController', copySoftwareModalController);
export default commonAllAgentsModule;
