import 'modules/settings/js/factories/copySoftware.factory.js';
import 'jobs/js/services/jobs.svc.js';
import 'modules/settings/js/services/settings.svc.js';
import { Constants } from 'ediscovery/casemanager/js/controllers/caseConstants.js';
import { commonAllAgentsModule } from 'common/js/modules';
var self;
class copySoftwareController {
	constructor(copySoftwareFactory, jobService, cvToaster, settingsService, cvLoc) {
		this.copySoftwareFactory = copySoftwareFactory;
		this.jobService = jobService;
		this.cvToaster = cvToaster;
		this.settingsService = settingsService;
		this.cvLoc = cvLoc;
		this.init();
		self = this;
	}

	init() {
		this.loader = false;
		this.showCopySoftware = cvConfig.showCopySoftware;
		this.cachedModel = {};
	}

	getCachedDetails() {
		return self.settingsService.getGlobalParam('copySoftwareCache').then(result => {
			self.cachedModel = JSON.parse(_.get(result, 'data.globalParamsResultList[0].value', '{}'));
			return result;
		});
	}

	getExistingJobs() {
		return self.jobService
			.getJobs(
				angular.toJson({
					jobFilter: {
						jobTypeList: [Constants.PATCHDOWNLOAD]
					}
				})
			)
			.then(result => {
				self.existingJob = _.get(result, 'data.jobs[0].jobSummary');
				return result;
			});
	}

	openCopySoftwareDialog() {
		this.modal = this.copySoftwareFactory.openCopySoftwareDialog(this.cachedModel);
		this.modal.result.then(function() {
			self.load();
		});
	}

	load() {
		Promise.all([self.getExistingJobs(), self.getCachedDetails()])
			.then(results => {
				self.loader = true;
			})
			.catch(error => {
				self.loader = true;
				self.cvToaster.showErrorMessageWrapper(error);
			});
	}
}
copySoftwareController.$inject = ['copySoftwareFactory', 'jobService', 'cvToaster', 'settingsService', 'cvLoc'];
commonAllAgentsModule.controller('copySoftwareController', copySoftwareController);
export default commonAllAgentsModule;
