import 'adminConsole/js/directives/cv-activity-control-component.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'vsa/js/directives/cv-generate-auth-code-directive.js';
import 'commonForAllAgents/js/controllers/downloadSoftware.ctrl.js';
import 'modules/servers/js/services/servers.svc.js';
import 'modules/settings/js/directives/cv-tfa-directive.js';
import 'vsa/js/services/subscriptions.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'adminConsole/js/controllers/clientGroups.ctrl.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'adminConsole/js/directives/cv-encryption-setting-directives.js';
import 'adminConsole/js/directives/cv-privacy-setting-directives.js';
import 'adminConsole/js/controllers/clients.ctrl.js';
import 'adminConsole/js/directives/cv-sla-options-directives.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var mod = cvModuleSettingsModule;
/**
 * A controller for handling the functionality on the commCell.jsp page.
 */
mod.controller('commCellController', [
	'$scope',
	'$uibModal',
	'cvUtil',
	'cvToaster',
	'securityFactory',
	'activityControlFactory',
	'clientGroupsFactory',
	'settingsService',
	'ENTITY_TYPES',
	'cvLoc',
	'profileService',
	'subscriptionService',
	'serverService',
	'downloadSoftwareFactory',
	'cvMultiCommcell',
	'$location',
	'userPrefService',
	'$window',
	'clientFactory',
	'cvActionsEventFactory',
	'sendLogsFactory',
	'commcellFactory',
	function(
		$scope,
		$modal,
		cvUtil,
		cvToaster,
		securityFactory,
		activityControlFactory,
		clientGroupsFactory,
		settingsService,
		ENTITY_TYPES,
		cvLoc,
		profileService,
		subscriptionService,
		serverService,
		downloadSoftwareFactory,
		cvMultiCommcell,
		$location,
		userPrefService,
		$window,
		clientFactory,
		cvActionsEventFactory,
		sendLogsFactory,
		commcellFactory
	) {
		$scope.commcellName = cv.commcellName;
		$scope.isTenantAdmin = cv.isTenantAdmin;
		$scope.isAdmin = cv.isAdmin;

		$scope.cnParam = $location.search();
		$scope.isSingleComcellSelected = false;
		if ($scope.cnParam.hasOwnProperty('_cn')) {
			$scope.isSingleComcellSelected = true;
			$scope.commcellName = $scope.cnParam._cn;
		}
		$scope.hasSendLogPermission = sendLogsFactory.hasSendLogPermission;
		$scope.showManageIdleClient = cvConfig.showRetireOfflineDevices;
		// get comcell download link
		serverService.getGlobalParam('CommcellConsoleUrl').success(function(link) {
			$scope.commcellConsoleLink = link;
			$scope.showCommcellLink =
				cv.additionalSettings &&
				cv.additionalSettings.AdminConsole &&
				cv.additionalSettings.AdminConsole.showCommcellLink
					? cv.additionalSettings.AdminConsole.showCommcellLink
					: false;
		});

		settingsService
			.getCommserveDetails()
			.success(function(versionDetails) {
				$scope.versionDetails = versionDetails;
			})
			.error(function(err) {
				cvToaster.showErrorMessage({
					message: err,
					ttl: '5000'
				});
			});

		// start with false as default value
		$scope.hasActivityManagement = false;
		$scope.entityType = ENTITY_TYPES.COMMCELL_ENTITY;
		$scope.genericEntity = {
			commCellId: 2
		};
		$scope.acParams = {
			entityType: $scope.entityType,
			genericEntity: $scope.genericEntity,
			activityControlOptions: activityControlFactory.createActivityControlOptionsObject(),
			optionsLoaded: false
		};
		$scope.associationsLoaded = false;
		$scope.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		$scope.activityControlOptionsLoaded = false;
		$scope.activityControlOptionsObject = activityControlFactory.createActivityControlOptionsObject();
		if (cv.sessionContext.viewOptions && cv.sessionContext.viewOptions.hasActivityManagement === true) {
			$scope.hasActivityManagement = true;
			clientGroupsFactory.getCommcellActivityControlOptions().then(function(data) {
				var activityControlOptionsFromServer = clientGroupsFactory.commcellActivityControlOptions;
				$scope.acParams.activityControlOptions = activityControlFactory.getActivityControlOptions(
					$scope.acParams.entityType,
					activityControlOptionsFromServer
				);
				$scope.acParams.optionsLoaded = true;
			});
		}
		securityFactory.getSecurityAssociation('COMMCELL_ENTITY', 2).success(function(data) {
			// TODO: commcell-id to be generic
			//entityType,genericEntity and formattedSecurityAssociations are required by security directive.
			$scope.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(
				data.securityAssociations
			);
			$scope.associationsLoaded = true;
		});
		$scope.emailSettings = null;
		// Get the data relating to the user's email settings
		settingsService
			.getEmail(
				function(data) {
					var port = 25;
					// need check this deep as some cases have data of sendername or address
					if (data && data.emailSettings && data.emailSettings.smtpInfo && data.emailSettings.smtpInfo.smtpServer) {
						$scope.configureEmailMessage = cvUtil.infoMsgLoc('info.emailConfigured');
					}
					if (data.emailSettings.smtpInfo.smtpPort != undefined) {
						port = data.emailSettings.smtpInfo.smtpPort;
					}
					$scope.emailSettings = {
						smtpServer: data.emailSettings.smtpInfo.smtpServer,
						smtpPort: port,
						senderEmail: data.emailSettings.smtpInfo.senderInfo.senderAddress,
						senderName: data.emailSettings.smtpInfo.senderInfo.senderName
					};
					if ($scope.emailSettings.senderEmail == '' && cvApp.acApp == 'ADMIN_CONSOLE' && cvApp.oemId == 16) {
						$scope.emailSettings.senderEmail = 'one@commvault.com';
					}
					if ($scope.emailSettings.senderName == '' && cvApp.acApp == 'ADMIN_CONSOLE' && cvApp.oemId == 16) {
						$scope.emailSettings.senderName = 'Commvault One';
					}
				},
				function(e) {
					$scope.emailSettings = {
						smtpServer: '',
						smtpPort: 25,
						senderEmail: '',
						senderName: ''
					};
				}
			)
			.finally(function() {
				$scope.emailSettingsLoaded = true;
			});

		settingsService
			.getPasswordEncryptionConfig()
			.success(function(data) {
				$scope.keyManagementServer = data.keyProviderName;
			})
			.error(function(err) {
				cvToaster.showErrorMessage({
					message: err,
					ttl: '5000'
				});
			});

		$scope.globalCCTblGridOptions = {
			hasTitle: false,
			tableName: 'globalCCTable',
			hideToolbar: true,
			enableFiltering: false,
			hasViews: false,
			enableColumnMenu: false,
			enableColumnResizing: true,
			enablePaging: true,
			pageSize: 10,
			gridEmptyMessage: cvLoc('label.noGlobalCommandCenters'),
			columns: {
				'webconsoleClient.displayName': {
					title: cvLoc('label.commandCenter'),
					type: 'string',
					cellTemplate: `<span class="crop">#=webconsoleClient.displayName#</span>`
				},
				'webconsoleClient.hostName': {
					title: cvLoc('label.hostName'),
					type: 'string',
					cellTemplate: `<span class="crop">#=webconsoleClient.hostName#</span>`
				}
			},
			url: getGlobalCCList,
			beforeGridInitialize: ({ grid }) => {
				$scope.globalCCGrid = grid;
			}
		};

		let globalCCList = [];
		$scope.globalCCListSupported = [];

		function getGlobalCCList(options) {
			settingsService
				.getGlobalCCConfig()
				.success(function(data) {
					if (data && data.webconsoles && data.webconsoles.length > 0) {
						globalCCList = data.webconsoles;
						$scope.globalCCListSupported = data.webconsoles.filter(function(wc) {
							return wc.isSupported;
						});
						options.success($scope.globalCCListSupported);
					}
				})
				.error(function(err) {
					options.error(err);
				});
		}

		$scope.openConfigureGlobalCCModal = function() {
			let globalCCModal = commcellFactory.openConfigureGlobalCCModal(globalCCList);
			globalCCModal.result.then(
				function(data) {
					globalCCList = data;
					$scope.globalCCListSupported = data.filter(function(wc) {
						return wc.isSupported;
					});

					$scope.globalCCGrid.refreshData();
				},
				function(err) {}
			);
		};

		var modal = null;
		// Opens the modal for configuring the current user's email settings.
		$scope.openConfigureEmailModal = function() {
			modal = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/configureEmail.jsp',
				scope: $scope,
				backdrop: 'static'
			});
		};
		$scope.dismissModal = function() {
			modal.dismiss();
		};
		$scope.$on('emailAdded', function(event, emailSettings) {
			modal.close();
			$scope.emailSettings = emailSettings;
		});
		$scope.organizationInfo = {
			defaultPlans: []
		};
		$scope.openDownloadSoftwareDialog = function(clientId, clientName) {
			var downloadSoftwareParams = {
				clientId: clientId,
				clientName: clientName
			};
			downloadSoftwareFactory.openDownloadSoftwareDialog(downloadSoftwareParams);
		};
		$scope.openConfigurePasswordEncryptionModal = function() {
			modal = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/configurePasswordEncryptionConfig.jsp',
				scope: $scope,
				backdrop: 'static',
				controller: 'configurePasswordEncryptionController'
			});
			modal.result.then(
				function(keyManagementServer) {
					$scope.keyManagementServer = keyManagementServer;
				},
				function(e) {}
			);

			return modal.result;
		};

		$scope.enableDisableUserCentricOption = function() {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					subscriptionService
						.updateCommcellFields({
							id: 0,
							preferenceMachineCentricClient: !$scope.subscriptionData.preferenceMachineCentricClient
						})
						.success(function() {
							$scope.subscriptionData.preferenceMachineCentricClient = !$scope.subscriptionData
								.preferenceMachineCentricClient;
							var action = $scope.subscriptionData.preferenceMachineCentricClient ? 'enable' : 'disable';
							$scope.userCentric = action == 'enable' ? 'enabled-activity' : 'disabled-activity';
						})
						.error(function(err) {
							cvToaster.showErrorMessage({
								ttl: '5000', //5 sec
								message: cvLoc('label.toggleServerError')
							});
						});
				}
			};
			// Uncomment if-else block when warning message is approved
			//if($scope.organizationInfo.preferenceMachineCentricClient) {
			callBackFunctions.yesFunction();
			//}
			//else {
			//	$dialogs.confirm(cvLoc('label.confirmEnableUserCentricBackupTitle'), cvLoc('label.confirmEnableUserCentricBackupText') , callBackFunctions);
			//}
		};

		$scope.enableDisableUPNOption = function() {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					subscriptionService
						.updateCommcellFields({
							id: 0,
							useUPNForEmail: !$scope.subscriptionData.useUPNForEmail
						})
						.success(function() {
							$scope.subscriptionData.useUPNForEmail = !$scope.subscriptionData.useUPNForEmail;
							$scope.useUPN = $scope.subscriptionData.useUPNForEmail ? 'enabled-activity' : 'disabled-activity';
						})
						.error(function(err) {
							cvToaster.showErrorMessage({
								ttl: '5000', //5 sec
								message: cvLoc('label.toggleServerError')
							});
						});
				}
			};
			// Uncomment if-else block when warning message is approved
			//if($scope.organizationInfo.useUPNForEmail) {
			callBackFunctions.yesFunction();
			//}
			//else {
			//	$dialogs.confirm(cvLoc('label.warningTitle'), cvLoc('label.confirmUPNText') , callBackFunctions);
			//}
		};

		$scope.showHideActivateWithDefaultPlan = function() {
			var params = { id: 0, alwaysActivateWithDefaultPlan: !$scope.subscriptionData.alwaysActivateWithDefaultPlan };
			subscriptionService
				.updateCompanyInfo(params)
				.success(function(data) {
					$scope.subscriptionData.alwaysActivateWithDefaultPlan = !$scope.subscriptionData
						.alwaysActivateWithDefaultPlan;
					$scope.alwaysActivateWithDefaultPlanToggle = $scope.subscriptionData.alwaysActivateWithDefaultPlan
						? 'enabled-activity'
						: 'disabled-activity';
				})
				.error(function(failureReason) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: failureReason
					});
				});
		};

		//retrieve default plans from api
		subscriptionService
			.getSubscription()
			.success(function(data) {
				var organizationInfo = data.organizationInfo;
				$scope.showUserCentric =
					cv.additionalSettings &&
					cv.additionalSettings.AdminConsole &&
					cv.additionalSettings.AdminConsole.showSharedLaptopUsage;
				$scope.showTFA =
					cv.additionalSettings &&
					cv.additionalSettings.AdminConsole &&
					cv.additionalSettings.AdminConsole.showTwoFactorAuthentication === false
						? false
						: true;

				$scope.subscriptionData = {
					advancedPrivacySettings: organizationInfo.organizationProperties.advancedPrivacySettings,
					companyAuthCode: organizationInfo.organizationProperties.authCode,
					enableAuthCode: organizationInfo.organizationProperties.enableAuthCodeGen,
					id: cv.orgId,
					alwaysActivateWithDefaultPlan: organizationInfo.organizationProperties.alwaysActivateWithDefaultPlan,
					encryptionInfo: organizationInfo.organizationProperties.encryptionInfo
				};
				$scope.alwaysActivateWithDefaultPlanToggle = $scope.subscriptionData.alwaysActivateWithDefaultPlan
					? 'enabled-activity'
					: 'disabled-activity';
				subscriptionService
					.getCommcellFields()
					.success(function(data) {
						var generalInfo = data.commCellInfo.generalInfo;
						$scope.subscriptionData.preferenceMachineCentricClient = !!generalInfo.enableSharedLaptopUsage;
						$scope.userCentric = $scope.subscriptionData.preferenceMachineCentricClient
							? 'enabled-activity'
							: 'disabled-activity';
						$scope.subscriptionData.useUPNForEmail = !!generalInfo.useUPNForEmail;
						$scope.useUPN = $scope.subscriptionData.useUPNForEmail ? 'enabled-activity' : 'disabled-activity';
						$scope.subscriptionData.privacy = { enableDataSecurity: !!generalInfo.enablePrivacy };
						$scope.subscriptionData.enableTwoFactorAuthentication = !!generalInfo.enableTwoFactorAuthentication;
						$scope.subscriptionData.allowUsersToEnablePasskey = !!generalInfo.allowUsersToEnablePasskey;
						$scope.enableTwoFactorAuth = $scope.subscriptionData.enableTwoFactorAuthentication
							? 'enabled-activity'
							: 'disabled-activity';
						$scope.autoRetireDevices = generalInfo.autoRetireDevices;
						$scope.commcellId = 0;
						$scope.viewLogs = () =>
							cvActionsEventFactory._viewLogs(
								_.get(data, 'commCellInfo.commCellEntity.commCellId'),
								$scope.commcellName
							);
						$scope.commcellFieldsLoaded = true;
					})
					.error(function(error) {
						//Modify to toaster error
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: JSON.stringify(error)
						});
					});
				if (organizationInfo.organizationProperties && organizationInfo.organizationProperties.defaultPlans) {
					organizationInfo.organizationProperties.defaultPlans.map(function(plan) {
						// set plan type for help text
						if (plan.subtype === 'Server') {
							plan.type = cvLoc('label.serverPlan');
						} else if (plan.subtype === 'Laptop') {
							plan.type = cvLoc('label.laptopPlan');
						} else if (plan.subtype === 'FSServer') {
							plan.type = cvLoc('label.fsPlan');
						} else if (plan.subtype === 'Database') {
							plan.type = cvLoc('label.dbPlan');
						}
						// snap plan can't be default plan
						if (plan.subtype != 'Snap') {
							$scope.organizationInfo.defaultPlans.push(plan);
						}
					});
				}
			})
			.error(function(e) {
				$scope.subscriptionsLoadedError = true;
			});

		//include all type plans
		$scope.allPlans = {};
		$scope.allPlans.laptopPlans = [];
		$scope.allPlans.serverPlans = [];
		$scope.allPlans.fsPlans = [];
		$scope.allPlans.dbPlans = [];
		$scope.showEdit = false;
		//get plans to handle show/hide edit and will resolve in the edit default plan modal
		profileService.getProfiles('all', true, 'all').success(function(data) {
			// filter incomplete plans
			if (data.length) {
				data = data.filter(function(plan) {
					return plan.planSummary.planStatusFlag !== 'Incomplete';
				});
			}
			if (data.length > 0) {
				for (var i = 0; i < data.length; i++) {
					if (data[i].planSummary.subtype === 'Laptop') {
						$scope.allPlans.laptopPlans.push(data[i]);
					}
					if (data[i].planSummary.subtype === 'Server') {
						$scope.allPlans.serverPlans.push(data[i]);
					}
					if (data[i].planSummary.subtype === 'FSServer') {
						$scope.allPlans.fsPlans.push(data[i]);
					}
					if (data[i].planSummary.subtype === 'Database') {
						$scope.allPlans.dbPlans.push(data[i]);
					}
				}
				//show Edit button
				for (var i in $scope.allPlans) {
					if ($scope.allPlans[i].length > 0) {
						$scope.showEdit = true;
						break;
					}
				}
			}
		});
		$scope.editDefaultPlanModal = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/mspDefaultPlans.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					'cvLoc',
					'cvUtil',
					'profileService',
					'$state',
					'allPlans',
					'organizationInfo',
					'subscriptionData',
					function(
						$scope,
						$modalInstance,
						cvLoc,
						cvUtil,
						profileService,
						$state,
						allPlans,
						organizationInfo,
						subscriptionData
					) {
						//plans drop down list
						$scope.laptopPlans = allPlans.laptopPlans;
						$scope.serverPlans = allPlans.serverPlans;
						$scope.fsPlans = allPlans.fsPlans;
						$scope.dbPlans = allPlans.dbPlans;
						$scope.model = {};
						var defaultServerPlan, defaultLaptopPlan, defaultFsPlan, defaultDbPlan;
						if (organizationInfo.defaultPlans.length > 0) {
							organizationInfo.defaultPlans.map(function(plan) {
								if (plan && plan.subtype === 'Server') {
									defaultServerPlan = plan;
								} else if (plan && plan.subtype === 'Laptop') {
									defaultLaptopPlan = plan;
								} else if (plan && plan.subtype === 'FSServer') {
									defaultFsPlan = plan;
								} else if (plan && plan.subtype === 'Database') {
									defaultDbPlan = plan;
								}
							});
						}
						//default laptop plan
						$scope.laptopPlans.map(function(laptop) {
							if (defaultLaptopPlan && defaultLaptopPlan.plan.planId === laptop.planSummary.plan.planId) {
								$scope.model.defaultLaptop = laptop;
							}
						});
						//default server plan
						$scope.serverPlans.map(function(server) {
							if (defaultServerPlan && defaultServerPlan.plan.planId === server.planSummary.plan.planId) {
								$scope.model.defaultServer = server;
							}
						});
						//default fs plan
						$scope.fsPlans.map(function(fs) {
							if (defaultFsPlan && defaultFsPlan.plan.planId === fs.planSummary.plan.planId) {
								$scope.model.defaultFs = fs;
							}
						});
						//default database plan
						$scope.dbPlans.map(function(db) {
							if (defaultDbPlan && defaultDbPlan.plan.planId === db.planSummary.plan.planId) {
								$scope.model.defaultDb = db;
							}
						});

						$scope.alwaysActivateWithDefaultPlan = !!subscriptionData.alwaysActivateWithDefaultPlan;
						$scope.alwaysActivateWithDefaultPlanToggle = $scope.alwaysActivateWithDefaultPlan
							? 'enabled-activity'
							: 'disabled-activity';

						$scope.showAlwaysActivateLaptop =
							cv.additionalSettings &&
							cv.additionalSettings.AdminConsole &&
							cv.additionalSettings.AdminConsole.showAlwaysActivateLaptop === false
								? false
								: true;
						$scope.toggleActivateWithDefaultPlan = function() {
							$scope.alwaysActivateWithDefaultPlan = !$scope.alwaysActivateWithDefaultPlan;
							$scope.alwaysActivateWithDefaultPlanToggle = $scope.alwaysActivateWithDefaultPlan
								? 'enabled-activity'
								: 'disabled-activity';
						};

						$scope.saveDefaultPlan = function() {
							$scope.editPlanMessage = cvUtil.emptyMsg();
							var objToSend = { id: 0 };
							// 0 means remove that default plan
							objToSend.laptopPlan = $scope.model.defaultLaptop
								? $scope.model.defaultLaptop.planSummary.plan.planId
								: 0;
							objToSend.serverPlan = $scope.model.defaultServer
								? $scope.model.defaultServer.planSummary.plan.planId
								: 0;
							objToSend.fsServerPlan = $scope.model.defaultFs ? $scope.model.defaultFs.planSummary.plan.planId : 0;
							objToSend.dbPlan = $scope.model.defaultDb ? $scope.model.defaultDb.planSummary.plan.planId : 0;
							if (objToSend.laptopPlan) objToSend.alwaysActivateWithDefaultPlan = $scope.alwaysActivateWithDefaultPlan;
							else objToSend.alwaysActivateWithDefaultPlan = false;
							subscriptionService
								.updateCompanyInfo(objToSend)
								.success(function(data) {
									//resolve modal data
									organizationInfo.defaultPlans = [];
									if (objToSend.laptopPlan) {
										organizationInfo.defaultPlans.push({
											plan: $scope.model.defaultLaptop.planSummary.plan,
											subtype: $scope.model.defaultLaptop.planSummary.subtype,
											type: cvLoc('label.laptopPlan')
										});
									}
									if (objToSend.serverPlan) {
										organizationInfo.defaultPlans.push({
											plan: $scope.model.defaultServer.planSummary.plan,
											subtype: $scope.model.defaultServer.planSummary.subtype,
											type: cvLoc('label.serverPlan')
										});
									}
									if (objToSend.fsServerPlan) {
										organizationInfo.defaultPlans.push({
											plan: $scope.model.defaultFs.planSummary.plan,
											subtype: $scope.model.defaultFs.planSummary.subtype,
											type: cvLoc('label.fsPlan')
										});
									}
									if (objToSend.dbPlan) {
										organizationInfo.defaultPlans.push({
											plan: $scope.model.defaultDb.planSummary.plan,
											subtype: $scope.model.defaultDb.planSummary.subtype,
											type: cvLoc('label.dbPlan')
										});
									}
									_.set(subscriptionData, 'alwaysActivateWithDefaultPlan', objToSend.alwaysActivateWithDefaultPlan);
									/* Call commcell activate with default plan property*/

									$modalInstance.close();
								})
								.error(function(e) {
									$scope.editPlanMessage = {
										message: e,
										type: 'error'
									};
								});
						};

						$scope.cancel = function() {
							$modalInstance.dismiss();
						};
					}
				],
				resolve: {
					mspDefaultPlan: function() {
						return $scope.mspDefaultPlan;
					},
					allPlans: function() {
						return $scope.allPlans;
					},
					organizationInfo: function() {
						return $scope.organizationInfo;
					},
					subscriptionData: function() {
						return $scope.subscriptionData;
					}
				}
			});
		};

		/**
		 * Make the current environment as a managed service provider.
		 *
		 * $scope.showMSP = cvApp.showMSP; $scope.mspDocumentationLink = cvConfig.helpLink + '?p=87419.htm';
		 *
		 * $scope.makeMsp = function() { $scope.mspToggleClicked = true; if (!cvApp.showMSP) {
		 * serverService.setIsMSPCommcell(true).success(function() {
		 * userPrefService.setBooleanUserPref('mspConfigured', true); $window.location.reload(); })
		 * .error(function(data, status){ $scope.mspToggleClicked = false; }); } };
		 */
	}
]);

mod.factory('commcellFactory', [
	'$uibModal',
	function commcellFactory($modal) {
		let factory = {};
		factory.openConfigureGlobalCCModal = function(inputGlobalCCList) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/configureGlobalCommandCenter.jsp',
				backdrop: 'static',
				controller: 'configureGlobalCCController',
				resolve: {
					globalCCConfigParams: function() {
						return {
							globalCCList: inputGlobalCCList
						};
					}
				}
			});
		};
		return factory;
	}
]);

export default mod;
