import 'users/js/services/roles.svc.js';

import { cvModuleSettingsModule } from 'common/js/modules';

var app = cvModuleSettingsModule;

app.directive('cvOwnerPermissions', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/settings/partials/ownerPermissionsTemplate.jsp',
			controller: 'ownerPermissionsController'
		};
	}
]);

app.factory('ownerPermissionsFactory', [
	'$uibModal',
	'$log',
	'cvLoc',
	'TREE_NODE_STATE',
	'ivhTreeviewMgr',
	'accessControlService',
	'rolesService',
	function ownerPermissionsFactory(
		$modal,
		$log,
		cvLoc,
		TREE_NODE_STATE,
		ivhTreeviewMgr,
		accessControlService,
		rolesService
	) {
		ownerPermissionsFactory.ownerPermissions = [];
		ownerPermissionsFactory.categoryPermissionsTree = [];

		var getSelectedNodes = function(ivhTree) {
			var selected = [];
			if (ivhTree && ivhTree.length > 0) {
				ivhTree.forEach(function(node) {
					if (node.selected || node.__ivhTreeviewIndeterminate) {
						if (node.selected && !node.__ivhTreeviewIndeterminate) {
							selected.push(node);
						} else {
							Array.prototype.push.apply(selected, getSelectedNodes(node.children));
						}
					}
				});
			}
			return selected;
		};

		ownerPermissionsFactory.getOwnerPermissions = function() {
			ownerPermissionsFactory.ownerPermissions.length = 0;
			return accessControlService.getOwnerPermissions().success(function(ownerPermissions) {
				ownerPermissionsFactory.ownerPermissions = ownerPermissions;
			});
		};

		ownerPermissionsFactory.updateOwnerPermissions = function() {
			var tree = ownerPermissionsFactory.categoryPermissionsTree;
			var selectedPermissions = getSelectedNodes(tree).map(function(treeNode) {
				var categoryPermission = treeNode.categoryPermissionEntity;
				if (
					!('permissionId' in treeNode.categoryPermissionEntity) &&
					!('categoryId' in treeNode.categoryPermissionEntity)
				) {
					categoryPermission.categoryId = -1; //to represent all categories are selected
				}
				return categoryPermission;
			});
			return accessControlService.updateOwnerPermissions({
				categoriesPermissionList: angular.toJson(selectedPermissions)
			});
		};

		ownerPermissionsFactory.loadCategoryPermissionsTree = function() {
			return accessControlService
				.getCategoryPermissionsTree()
				.success(function(categoryPermissionsTree) {
					ivhTreeviewMgr.validate(categoryPermissionsTree, false);
					ownerPermissionsFactory.categoryPermissionsTree = categoryPermissionsTree;
				})
				.error(function(errorMessage) {
					$log.error('Unable to fetch categories and permissions list' + errorMessage);
				});
		};

		ownerPermissionsFactory.filterTree = function(ivhTreeNode, model) {
			if (model.isShowOnlySelected) {
				if (ivhTreeNode.id === 0) {
					//id = 0 represents the root node "All permissions"
					//root should always be visible
					return true;
				}
				return (
					(ivhTreeNode.selected || ivhTreeNode.__ivhTreeviewIndeterminate) &&
					(model.searchField
						? filterTreeBySearchInput(model.categoryPermissionsTree, ivhTreeNode, model.searchField)
						: true)
				);
			} else {
				return model.searchField
					? filterTreeBySearchInput(model.categoryPermissionsTree, ivhTreeNode, model.searchField)
					: true;
			}
		};

		function hasChildNodesMatched(childNodes, searchInput) {
			if (angular.isArray(childNodes)) {
				for (var i = 0, length = childNodes.length; i < length; i++) {
					if (hasNodeMatched(childNodes[i], searchInput) || hasChildNodesMatched(childNodes[i].children, searchInput))
						return true;
				}
			}
			return false;
		}

		function filterTreeBySearchInput(ivhTree, ivhTreeNode, searchInput) {
			if (searchInput && angular.isString(searchInput)) {
				if (ivhTreeNode.id != 0)
					if (hasChildNodesMatched(ivhTreeNode.children, searchInput)) {
						ivhTreeviewMgr.expand(ivhTree, ivhTreeNode);
					} else ivhTreeNode.__ivhTreeviewExpanded = false;
				return hasNodeMatched(ivhTreeNode, searchInput);
			}
			return false;
		}

		function hasNodeMatched(treeNode, searchInput) {
			return treeNode && treeNode.label.toLowerCase().indexOf(searchInput.toLowerCase()) !== -1;
		}

		return ownerPermissionsFactory;
	}
]);

app.controller('accessControlController', [
	'$scope',
	'$uibModal',
	'$state',
	'cvLoc',
	'cvUtil',
	'cvToaster',
	'ADDITIONAL_SETTING_CATEGORY',
	'subscriptionService',
	function($scope, $modal, $state, cvLoc, cvUtil, cvToaster, ADDITIONAL_SETTING_CATEGORY, subscriptionService) {
		// Remove additional setting after feature is released
		$scope.showLaptopAssignmentFeature = cvUtil.getAdditionalSettingValue(
			'showLaptopAssignmentFeature',
			ADDITIONAL_SETTING_CATEGORY.ADMINCONSOLE,
			true
		);

		subscriptionService
			.getCommcellFields()
			.success(function(data) {
				var generalInfo = data.commCellInfo.generalInfo;
				$scope.commcellGeneralInfo = {
					id: 0,
					autoClientOwnerAssignmentType: generalInfo.autoClientOwnerAssignmentType,
					autoClientOwnerAssignmentValue: generalInfo.autoClientOwnerAssignmentValue
				};

				$scope.commcellInfoLoaded = true;
			})
			.error(function(error) {
				cvToaster.showErrorMessage({
					ttl: '5000', //5 sec
					message: error
				});
			});
	}
]);

app.controller('ownerPermissionsController', [
	'$scope',
	'$uibModal',
	'$q',
	'$state',
	'cvLoc',
	'cvUtil',
	'cvToaster',
	'ownerPermissionsFactory',
	'cvBreadcrumbsTabsFactory',
	'subscriptionService',
	function(
		$scope,
		$modal,
		$q,
		$state,
		cvLoc,
		cvUtil,
		cvToaster,
		ownerPermissionsFactory,
		cvBreadcrumbsTabsFactory,
		subscriptionService
	) {
		var requestsToProcess = {
			ownerPermissionsResp: ownerPermissionsFactory.getOwnerPermissions()
		};

		$scope.uiModel = {
			ownerPermissions: undefined,
			serverMessage: {}
		};

		$q.all(requestsToProcess).then(
			function(responses) {
				if (responses.ownerPermissionsResp) {
					$scope.uiModel.ownerPermissions = ownerPermissionsFactory.ownerPermissions;
				}
			},
			function(errorMessage) {
				if (errorMessage) {
					if (angular.isString(errorMessage)) {
						$scope.uiModel.serverMessage = cvUtil.errMsg(errorMessage);
					} else if (angular.isString(errorMessage.data)) {
						$scope.uiModel.serverMessage = cvUtil.errMsg(errorMessage.data);
					} else {
						$scope.uiModel.serverMessage = cvLoc('generic_error');
					}
				}
			}
		);

		$scope.hasOwnerPermissionsConfigured = function() {
			return $scope.uiModel.ownerPermissions && $scope.uiModel.ownerPermissions.length > 0;
		};

		$scope.editOwnerPermissions = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/editOwnerPermissions.jsp',
				controller: 'editOwnerPermissionsController',
				backdrop: 'static'
			});

			modalInstance.result.then(function() {
				$state.forceReload();
				cvToaster.showSuccessMessage({
					ttl: '5000', //5 sec
					message: cvLoc('label.ownerPermissionsUpdated')
				});
			});
		};

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.system'),
			link: '#nav/settings'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
]);

app.controller('editOwnerPermissionsController', [
	'$scope',
	'$uibModalInstance',
	'cvUtil',
	'cvLoc',
	'ivhTreeviewMgr',
	'ownerPermissionsFactory',
	function($scope, $modalInstance, cvUtil, cvLoc, ivhTreeviewMgr, ownerPermissionsFactory) {
		$scope.model = {
			isShowOnlySelected: false,
			categoryPermissionsTree: [],
			serverMessage: cvUtil.infoMsg(cvLoc('Loading')),
			searchField: ''
		};

		ownerPermissionsFactory.loadCategoryPermissionsTree().then(
			function() {
				$scope.model.categoryPermissionsTree = ownerPermissionsFactory.categoryPermissionsTree;
				$scope.model.serverMessage = cvUtil.emptyMsg();
			},
			function(errorMessage) {
				if (errorMessage) {
					if (angular.isString(errorMessage)) {
						$scope.model.serverMessage = cvUtil.errMsg(errorMessage);
					} else if (angular.isString(errorMessage.data)) {
						$scope.model.serverMessage = cvUtil.errMsg(errorMessage.data);
					} else {
						$scope.model.serverMessage = cvLoc('generic_error');
					}
				}
			}
		);

		$scope.filterTree = function(ivhTreeNode) {
			return ownerPermissionsFactory.filterTree(ivhTreeNode, $scope.model);
		};

		$scope.close = function() {
			$modalInstance.dismiss();
		};

		$scope.saveOwnerPermissions = function() {
			ownerPermissionsFactory.updateOwnerPermissions().then(
				function() {
					$modalInstance.close();
				},
				function(errorMessage) {
					if (angular.isString(errorMessage)) {
						$scope.model.serverMessage = cvUtil.errMsg(errorMessage);
					} else if (errorMessage.data && angular.isString(errorMessage.data)) {
						$scope.model.serverMessage = cvUtil.errMsg(errorMessage.data);
					}
				}
			);
		};
	}
]);

export default app;
