<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
    <div class="form-group">
        <script nonce="${sessionScope.cspNonce}">
            <cv:cvMessages bundle="localization.security"></cv:cvMessages>
            <cv:cvMessages bundle="localization.collections"></cv:cvMessages>
        </script>
        <div class="setup-title">
            <h1 class="full-width"><cv:msg key="label.addLocation" bundle="security" /></h1>
        </div>
        <div class="setup-content margin-right-15">
            <form name="locationForm" novalidate data-cv-submit="save()" autocomplete="off">
                <div data-ng-class="{'hidden': clientValues.length <= 0 }" class="form-group row margin-0 padding-top-10">
                    <div class="col-xs-12 col-md-5 col-lg-5">
                        <label for="clientValues">
                            <cv:msg key="label.client" bundle="security" />
                        </label>
                    </div>
                    <div class="col-xs-12 col-md-7 col-lg-7">
                        <isteven-multi-select
                            input-model="clientValues"
                            id="clientValues"
                            output-model="selectedClient"
                            button-label="clientName" item-label="clientName"
                            on-close="saveSelected()"
                            helper-elements="none" hide-search-button="true" tick-property="selected" class="isteven-multi-select user-group-select"
                            selection-mode="single" >
                        </isteven-multi-select>
                        <span class="error float-left margin-0" data-ng-if="data.client.hasError">
                            <cv:msg key="error.client" bundle="security" />
                        </span>
                    </div>
                </div>
                <div class="form-group row margin-0 padding-top-10">
                    <div class="col-xs-12 col-md-5 col-lg-5">
                        <label for="mountPath1">
                            <cv:msg key="label.path" bundle="security" />
                        </label>
                    </div>
                    <div class="col-xs-12 col-md-7 col-lg-7 text-align-left">
                        <div class="input-group">
                            <input class="hidden" type="file" id="IDServerPath" name="IDServerPath" maxlength="100" />
                            <input placeholder="" data-ng-change="changeText()" type="text" required
                                data-ng-model="serverPath"
                                maxlength="100"
                                name="mountPath1"
                                id="mountPath1"
                                data-ng-class="{'has-error': cv.locationForm.needsAttention(locationForm.mountPath1)}"
                                data-ng-pattern='pathPattern' />
                            <span class="input-group-btn">
                                <button type="button" id="outputCertificate" class="btn btn-default" data-ng-click="browse()">
                                    <cv:msg key="action.browse" bundle="collections" />
                                </button>
                            </span>
                        </div>
                        <div class="margin-left-10">
                            <div class="row">
                                <span class="error float-left margin-0 padding-left-10" data-ng-show="locationForm.mountPath1.$error.pattern && cv.locationForm.needsAttention(locationForm.mountPath1)">
                                    <cv:msg key="error.location.invalid" bundle="storage" />
                                    <br>
                                </span>
                            </div>
                            <div class="row">
                                <span class="error float-left margin-0 padding-left-10" data-ng-if="data.path.hasError">
                                    <cv:msg key="error.path" bundle="security" />
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="button-container">
                    <button id="modalExportLocation_button_#7510" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="close()"> 
                        <cv:msg key="Cancel" />
                    </button>
                    <button id="modalExportLocation_button_#9756" type="submit" class="btn btn-primary cvBusyOnAjax"> 
                        <cv:msg key="Save" />
                    </button>
                </div>
            </form>
        </div>
    </div>