import { acAppSecurityModule } from 'common/js/modules';
var securityPassMod = acAppSecurityModule;
import 'modules/security/js/keyManagement.ctrl.js';
// Modal
securityPassMod.factory('updatePasswordFactory', function() {
	var factory = {};
	factory.updatePassphraseCredential = function($scope, $rootScope, $modal, cvLoc, values, useSaveLabel) {
		var self = this;
		useSaveLabel = useSaveLabel ? useSaveLabel : false;
		$rootScope.dataDetails = values;
		var template = 'modules/security/partials/updatePassphrase.jsp';
		var modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + template,
			backdrop: 'static',
			windowClass: 'small-size' || '',
			controller: [
				'$log',
				'cvLoc',
				'cvUtil',
				'$scope',
				'$rootScope',
				'keyManagementService',
				'$uibModalInstance',
				function($log, cvLoc, cvUtil, $scope, $rootScope, keyManagementService, $uibModalInstance) {
					$scope.validateValue = function() {
						let flag = this.value ? true : false;
						this.hasError = !flag;
						return flag;
					};
					$scope.data = {
						oldPassphrase: {
							value: '',
							validate: $scope.validateValue
						},
						newPassphrase: {
							value: '',
							validate: $scope.validateValue
						},
						confirmPassphrase: {
							value: '',
							validate: $scope.validateValue
						}
					};

					($scope.titlePassphrase = cvLoc('title.providePassphrase')), ($scope.errorClient = false);
					$scope.errorMaxClient = false;
					$scope.editPassphrasePassword = $rootScope.dataDetails;
					$scope.validateForm = function() {
						$scope.data.oldPassphrase.validate();
						if ($scope.editPassphrasePassword) {
							$scope.data.newPassphrase.validate();
							$scope.data.confirmPassphrase.validate();
						}
						if (
							!$scope.data.oldPassphrase.hasError &&
							!$scope.data.newPassphrase.hasError &&
							!$scope.data.confirmPassphrase.hasError
						) {
							$scope.data.formHasError = false;
						} else {
							$scope.data.formHasError = true;
						}
						return !$scope.data.formHasError;
					};
					$scope.verifyPassphrase = function() {
						if ($scope.editPassphrasePassword) {
							if ($scope.data.newPassphrase.value === $scope.data.confirmPassphrase.value) {
								return true;
							} else {
								$scope.serverErrorMessage = cvLoc('error.differentPassphraseData');
								$log.error(cvLoc('error.differentPassphraseData'));
								return false;
							}
						}
						return true;
					};
					$scope.isPassphraseChanged = false;
					$scope.changedPassphrase = function() {
						if ($scope.data.oldPassphrase.value === $scope.data.newPassphrase.value) {
							$scope.isPassphraseChanged = false;
						} else {
							$scope.isPassphraseChanged = true;
						}
					};

					$scope.sendReq = function(payload) {
						let password = {
							oldPassphrase: btoa($scope.data.oldPassphrase.value),
							passphrase: btoa($scope.data.oldPassphrase.value)
						};
						if (!$scope.editPassphrasePassword) {
							$scope.password = password;
							$uibModalInstance.close(password);
						} else {
							let payload = {
								keyProvider: {
									provider: {
										keyProviderName: $rootScope.dataDetails.provider.keyProviderName,
										keyProviderId: $rootScope.dataDetails.provider.keyProviderId
									},
									properties: {}
								}
							};
							payload.oldPassphrase = btoa($scope.data.oldPassphrase.value);
							payload.keyProvider.properties.passphrase = btoa($scope.data.newPassphrase.value);
							payload.rotatePassphrase = true;

							payload = JSON.stringify(payload);
							keyManagementService
								.updatePassphrase(payload)
								.success(data => {
									if (data.errorCode === 0) {
										$log.debug(cvLoc('log.succesUpdatePassphrase'));
										$uibModalInstance.dismiss('clear');
									} else {
										$log.error(cvLoc('error.toUpdatePassphrase'));
										$scope.serverErrorMessage = data.errorMessage;
									}
								})
								.error(function(data) {
									$scope.serverErrorMessage = data.errorMessage;
									$log.error(cvLoc('error.toUpdatePassphrase'));
								});
						}
					};
					$scope.cancel = function() {
						$uibModalInstance.dismiss('clear');
					};

					$scope.saveNewPassphrase = function() {
						if ($scope.validateForm() && $scope.verifyPassphrase()) {
							if (!$scope.editPassphrasePassword) {
								$scope.sendReq();
							} else {
								var funcs = {
									yesFunction: $scope.sendReq,
									noFunction: $scope.cancel
								};
								factory.changePassModal(
									$modal,
									cvLoc('title.confirmationTitle'),
									cvLoc('label.passphraseMessageChange'),
									funcs,
									cvLoc('label.confirmText'),
									{ useSaveLabel }
								);
							}
						}
					};
				}
			]
		});
		return modalInstance;
	};

	factory.changePassModal = function($modal, title, message, callBackFuncs, confirmMsg, payload) {
		var _modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + 'adminConsole/partials/deleteConfirmModal.jsp',
			background: 'static',
			windowClass: 'confirm-dialog',
			ariaLabelledBy: 'deleteConfirmModal',
			controllerAs: 'dcmCtrl',
			controller: [
				'$uibModalInstance',
				'cvLoc',
				function($uibModalInstance, cvLoc) {
					var self = this;
					self.title = title;
					self.msg = message;
					self.option = {};
					self.option.useConfirm = true;
					self.confirmMsg = confirmMsg || cvLoc('action.ok');
					self.confirmLabel = cvLoc('label.typeToConfirm', '<b>' + self.confirmMsg + '</b>');
					self.userConfirm = '';
					self.useSaveLabel = payload.useSaveLabel;
					self.save = function() {
						var str = self.userConfirm.toUpperCase();
						var confirmStr = self.confirmMsg.toUpperCase();
						if (str === confirmStr) {
							$uibModalInstance.close();
						} else {
							self.errorMsg = {
								msg: cvLoc('error.deleteConfirm'),
								type: 'error'
							};
						}
					};

					self.close = function() {
						$uibModalInstance.dismiss();
					};
				}
			]
		});

		_modalInstance.result.then(
			function(data) {
				callBackFuncs.yesFunction(payload);
			},
			function() {
				callBackFuncs.noFunction();
			}
		);
	};

	return factory;
});
export default securityPassMod;
