export const getColumnTemplate = function(angularLibs) {
	const columnList = [getKeyProviderName(angularLibs.cvLoc), getProviderName(angularLibs.cvLoc)];

	const columns = {};

	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});

	return columns;
};

export const getKeyProviderName = cvLoc => {
	return {
		'provider.keyProviderName': {
			title: cvLoc('label.Name'),
			template:
				'<span class="crop" cv-toggle="toolTip" cv-toggle-content="#:provider.keyProviderName#"><a href="\\#/keyManagementDetails?keyId=#:provider.keyProviderId#&type=#:keyProviderType#&name=#:provider.keyProviderName#">#:provider.keyProviderName#</a></span>',
			width: '45%'
		}
	};
};

export const getProviderName = cvLoc => {
	return {
		'provider.keyProviderType': {
			title: cvLoc('label.type'),
			template: `#if (keyProviderType === 1) {#
            <div>Built-in</div>
        #} else if (keyProviderType === 2) {#
            <div>KMIP</div>
        #} else if(keyProviderType === 3) {#
            <div>AWS KMS</div>
        #} else if (keyProviderType === 4) {#
            <div>AZURE KEY VAULT KMS</div>
        #} else if (keyProviderType === 5) {#
            <div>SAFENET</div>
        #} else if (keyProviderType === 6) {#
            <div>PASSPHRASE</div>
        #}#`,
			width: '55%'
		}
	};
};
