import { acAppSecurityModule } from 'common/js/modules';
import 'modules/security/js/services/keyManagement.svc.js';
import 'modules/security/js/keyManagement.ctrl.js';

import * as keyManagementTemplate from 'keyManagementList.template.js';

var securityMod = acAppSecurityModule;

export class KeyManagementListController {
	constructor(
		keyManagementFactory,
		keyManagementService,
		$stateParams,
		cvLoc,
		$log,
		cvUtil,
		$scope,
		cvBreadcrumbsTabsFactory,
		$location,
		$dialogs,
		$state,
		$uibModal,
		$rootScope,
		cvToaster,
		cvPermissionFactory,
		$compile,
		ENTITY_TYPES
	) {
		this.keyManagementFactory = keyManagementFactory;
		this.keyManagementService = keyManagementService;
		this.$stateParams = $stateParams;
		this.cvLoc = cvLoc;
		this.$log = $log;
		this.cvUtil = cvUtil;
		this.$scope = $scope;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.$location = $location;
		this.$dialogs = $dialogs;
		this.$state = $state;
		this.$uibModal = $uibModal;
		this.$rootScope = $rootScope;
		this.cvToaster = cvToaster;
		this.cvPermissionFactory = cvPermissionFactory;
		this.$compile = $compile;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this._setupGridOptions();
	}

	addAwsKmsp(params) {
		let self = this;
		self.keyManagementFactory.addAWS(self.$scope, self.$rootScope, self.$uibModal, self.cvLoc, null);
	}

	addKmip(params) {
		let self = this;
		self.keyManagementFactory.addKMIP(self.$scope, self.$rootScope, self.$uibModal, self.cvLoc, null);
	}

	addPassphrase(params) {
		let self = this;
		var data = { typeToShow: 'all' };
		self.keyManagementFactory.addPassphrase(self.$scope, self.$rootScope, self.$uibModal, self.cvLoc, data);
	}

	addAzureKeyVault(params) {
		let self = this;
		self.keyManagementFactory.addAzure(self.$scope, self.$rootScope, self.$uibModal, self.cvLoc, null);
	}

	// actions
	deleteServer(value) {
		let self = this;
		var callBackFunctions = {
			noFunction: () => {},
			yesFunction: () => {
				self.$state.forceReload();
				self.keyManagementService
					.deleteKeyManagementServer(value.provider.keyProviderId)
					.success(data => {
						if (data.errorCode === 0) {
							self.$log.debug(self.cvLoc('log.succesDeleteKeyServer'));
						} else {
							self.$log.error(self.cvLoc('error.deleteKeyServer'));
						}
					})
					.error(data => {
						self.$dialogs.error(self.cvLoc('label.error'), self.cvUtil.errMsg(data).message);
						self.$log.error(self.cvLoc('error.deleteKeyServer'));
					});
			}
		};

		self.$dialogs.confirm(
			self.cvLoc('label.confirmDelete'),
			self.cvLoc('label.confirmationKeyManagement', '<b>' + value.provider.keyProviderName + '</b>'),
			callBackFunctions
		);
	}

	editServer(entity) {
		let payload = {
			id: entity.provider.keyProviderId
		};
		this.keyManagementService
			.getKeyDetails(payload)
			.success(data => {
				this.$scope.dataDetails = data.keyProviders[0];
				if (this.$scope.dataDetails.properties.passphraseClient) {
					this.$scope.dataDetails.table = this.$scope.dataDetails.properties.passphraseClient;
				} else {
					this.$scope.dataDetails.table = [];
				}
				switch (entity.keyProviderType) {
					case 2:
						this.keyManagementFactory.addKMIP(
							this.$scope,
							this.$rootScope,
							this.$modal,
							this.cvLoc,
							this.$scope.dataDetails
						);
						break;
					case 3:
						this.keyManagementFactory.addAWS(
							this.$scope,
							this.$rootScope,
							this.$modal,
							this.cvLoc,
							this.$scope.dataDetails
						);
						break;
					case 6:
						this.$scope.dataDetails.typeToShow = 'general';
						this.keyManagementFactory.addPassphrase(
							this.$scope,
							this.$rootScope,
							this.$modal,
							this.cvLoc,
							this.$scope.dataDetails
						);
						break;
					default:
						break;
				}
			})
			.error(e => {
				this.$scope.addServerMessage = this.cvUtil.errMsg(e);
			});
	}

	_setupGridOptions() {
		this.kendoGridOptions = {};
		this.$scope.kendoGridOptions = this.kendoGridOptions;
		this.kendoGridOptions.usePageToolbar = true;
		this.kendoGridOptions.gridTitle = this.cvLoc('title.keyManagement');
		this.kendoGridOptions.gridEmptyMessage = this.cvLoc('title.noStorageServers');
		this.kendoGridOptions.gridToolbarMenu = [
			{
				id: 'add',
				label: this.cvLoc('label.add'),
				subOptions: [
					{
						id: 'AddAwsKmsp',
						disableOnDeselect: false,
						label: this.cvLoc('label.awsKmsp'),
						onSelect: this.addAwsKmsp.bind(this)
					},
					{
						id: 'AddKmip',
						disableOnDeselect: false,
						label: this.cvLoc('label.kmip'),
						onSelect: this.addKmip.bind(this)
					},
					{
						id: 'AddPassPhrase',
						disableOnDeselect: false,
						label: this.cvLoc('label.passphrase'),
						onSelect: this.addPassphrase.bind(this)
					},
					{
						id: 'AddAzureKeyVault',
						disableOnDeselect: false,
						label: this.cvLoc('label.azureKeyVault'),
						onSelect: this.addAzureKeyVault.bind(this)
					}
				]
			}
		];

		this.kendoGridOptions.actionMenu = [
			{
				id: 'DELETE',
				label: this.cvLoc('action.delete'),
				onSelect: event => {
					this.deleteServer(event.rowValue);
				},
				contextMenuOnly: true
			}
		];

		// Setup column definitions
		this.kendoGridOptions.columns = this._initColumnDefs();

		// // Setup events data to kendoGrid.
		this.kendoGridOptions.url = this._fetchData.bind(this);

		this.kendoGridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
	}

	_initColumnDefs() {
		return keyManagementTemplate.getColumnTemplate({
			cvLoc: this.cvLoc
		});
	}

	_fetchData(data) {
		let self = this;

		let payload = {
			propertyLevel: 1,
			providerType: 'tipo'
		};
		payload = JSON.stringify(payload);

		return this.keyManagementService
			.getAllServers(payload)
			.success(servers => {
				if (servers.errorCode !== 0 && servers.keyProviders) {
					this.$scope.keyManagementservers = servers.keyProviders.length > 0 ? servers.keyProviders : [];
					this.$scope.keyManagementservers = servers.keyProviders.filter(item => {
						return item.provider.keyProviderId !== 1;
					});
				} else {
					this.$log.error(servers.errorMessage);
					this.cvToaster.showErrorMessageWrapper(servers.errorMessage);
				}

				data.success(this.$scope.keyManagementservers);
			})
			.error(e => {
				this.$scope.addServerMessage = this.cvUtil.errMsg(e);
			});
	}
}

KeyManagementListController.$inject = [
	'keyManagementFactory',
	'keyManagementService',
	'$stateParams',
	'cvLoc',
	'$log',
	'cvUtil',
	'$scope',
	'cvBreadcrumbsTabsFactory',
	'$location',
	'$dialogs',
	'$state',
	'$uibModal',
	'$rootScope',
	'cvToaster',
	'cvPermissionFactory',
	'$compile',
	'ENTITY_TYPES'
];

securityMod.controller('keyManagementListController', KeyManagementListController);

export default securityMod;
