import 'commonForAllAgents/js/controllers/pushInstallSoftware.ctrl.js';
import 'modules/security/js/services/keyManagement.svc.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'adminConsole/js/services/clientGroups.svc.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'modules/security/js/updatePassphrase.ctrl.js';

import 'modules/security/js/keyManagementList.ctrl.js';

import { acAppSecurityModule } from 'common/js/modules';

var securityMod = acAppSecurityModule;
var keyManagementControllers = {};

// Modal
securityMod.factory('keyManagementFactory', function() {
	var factory = {
		addAWS: null
	};

	factory.encryptionTypeList = function(cvLoc) {
		const data = {
			'2': cvLoc('label.blowFish'),
			'3': cvLoc('label.aes'),
			'4': cvLoc('label.serpent'),
			'5': cvLoc('label.twoFish'),
			'6': cvLoc('label.des'),
			'7': cvLoc('label.gost'),
			'1001': cvLoc('label.rsa'),
			'1002': cvLoc('label.rsahsm')
		};

		return data;
	};

	factory.addAWS = function($scope, $rootScope, $modal, cvLoc, values) {
		$rootScope.values = values;
		var self = this;
		var template = 'modules/security/partials/modalAws.jsp';
		$modal.open({
			templateUrl: appUtil.appRoot + template,
			backdrop: 'static',
			controller: [
				'keyManagementService',
				'$dialogs',
				'$uibModalInstance',
				'$rootScope',
				'$log',
				'action',
				'$state',
				'cvLoc',
				'cvUtil',
				'$scope',
				'cvTableOptions',
				'$location',
				'$stateParams',
				function(
					keyManagementService,
					$dialogs,
					$modalInstance,
					$rootScope,
					$log,
					action,
					$state,
					cvLoc,
					cvUtil,
					$scope,
					cvTableOptions,
					$location,
					$stateParams
				) {
					$scope.errorSecret = false;
					$scope.serverErrorMessage = null;
					$scope.disabled = false;

					$scope.regions = [];

					$scope.isEditing = false;

					//START: Formulary Logic
					$scope.validateValue = function() {
						let flag = this.value ? true : false;
						this.hasError = !flag;
						return flag;
					};

					$scope.validateForm = function() {
						$scope.data.name.validate();
						$scope.data.regionName.validate();
						$scope.data.regionCode.validate();
						$scope.data.accessKey.validate();
						if (!$scope.isEditing) {
							$scope.data.secretAccess.validate();
						}

						if (
							!$scope.data.name.hasError &&
							!$scope.data.regionName.hasError &&
							!$scope.data.accessKey.hasError &&
							!$scope.data.regionCode.hasError &&
							(!$scope.data.secretAccess.hasError || $scope.isEditing)
						) {
							$scope.data.formHasError = false;
						} else {
							$scope.data.formHasError = true;
						}
						return !$scope.data.formHasError;
					};

					$scope.data = {
						name: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						encryptionType: {
							value: 3
						},
						keyProviderType: {
							value: 3
						},
						regionName: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						regionCode: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						accessKey: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						secretAccess: {
							value: null,
							hasError: false,
							validate: $scope.validateValue
						},
						validateForm: $scope.validateForm,
						formHasError: false
					};
					//END: Formulary Logic
					if ($rootScope.values) {
						// Is editing
						$scope.titleAWS = cvLoc('title.editAWS');
						$scope.isEditing = true;
						$scope.idServer = $rootScope.values.provider.keyProviderId;
						$scope.data.name.value = $rootScope.values.provider.keyProviderName;
						$scope.data.id = $rootScope.values.provider.keyProviderId;
						$scope.oldProviderName = $scope.data.name.value;
						$scope.data.regionName.value = $rootScope.values.properties.regionName;
						$scope.data.regionCode.value = $rootScope.values.properties.regionCode;
						let password = $rootScope.values.properties.userAccount.password;
						$scope.disabled = true;

						try {
							password = password.replace('', '');
							$scope.data.accessKey.value = atob(password);
						} catch (error) {
							$scope.data.accessKey.value = $rootScope.values.properties.userAccount.userName;
						}
					} else {
						$scope.disabled = false;
						$scope.titleAWS = cvLoc('title.addAWS');
						keyManagementService
							.getRegions({ vendor: 4 })
							.success(data => {
								if (data.hasOwnProperty('regions')) {
									$scope.regions = data.regions;

									$scope.regions = data.regions.map(elem => {
										const obj = {
											...elem,
											selected: false
										};
										return obj;
									});
								} else {
									$scope.serverErrorMessage = data.response.errorMessage;
									$log.error(cvLoc('error.toGetRegions'));
								}
							})
							.error(function(data) {
								$scope.serverErrorMessage = data.errorMessage;
								$log.error(cvLoc('error.toGetRegions'));
							});
					}

					$scope.isProviderNameChanged = false;
					$scope.changedName = function() {
						if ($scope.oldProviderName === $scope.data.name.value) {
							$scope.isProviderNameChanged = false;
						} else {
							$scope.isProviderNameChanged = true;
						}
					};

					$scope.changedRegionItem = function(params) {
						$scope.data.regionName.value = $scope.selectedRegion[0].regionName;
						$scope.data.regionCode.value = $scope.selectedRegion[0].regionCode;
					};

					// Save button
					$scope.save = function() {
						$scope.errorSecret = false;
						if ($scope.data.validateForm()) {
							$scope.serverErrorMessage = null;
							let payload = {
								keyProvider: {
									encryptionType: $scope.data.encryptionType.value,
									keyProviderType: $scope.data.keyProviderType.value,
									provider: {
										keyProviderName: $scope.data.name.value,
										keyProviderId: $scope.data.id
									},
									properties: {
										regionName: $scope.data.regionName.value,
										regionCode: $scope.data.regionCode.value,
										userAccount: {
											userName: $scope.data.accessKey.value
										}
									}
								}
							};

							if ($scope.isProviderNameChanged && $scope.isEditing) {
								payload.newKeyProviderName = $scope.data.name.value;
								payload.keyProvider.provider.keyProviderName = $scope.oldProviderName;
							}

							if ($scope.isEditing) {
								const secret = $scope.data.secretAccess.value;
								if (secret !== null && secret !== '') {
									payload.keyProvider.properties.password = btoa(secret);
								}
								payload = JSON.stringify(payload);
								keyManagementService
									.updateAWS(payload)
									.success(data => {
										if (data.errorCode === 0) {
											$log.debug(cvLoc('log.succesUpdateAWS'));
											$modalInstance.dismiss('clear');
											if ($scope.isProviderNameChanged) {
												const keyId = $stateParams['keyId'];
												const keyType = $stateParams['type'];
												const keyName = $scope.data.name.value;
												$location.url(`/keyManagementDetails?keyId=${keyId}&type=${keyType}&name=${keyName}`);
											} else {
												$state.forceReload();
											}
										} else {
											$log.error(cvLoc('error.toUpdateAWS'));
											$scope.serverErrorMessage = data.errorMessage;
										}
									})
									.error(function(data) {
										$scope.serverErrorMessage = data.errorMessage;
										$log.error(cvLoc('error.toUpdateAWS'));
									});
							} else {
								const secret = $scope.data.secretAccess.value;
								payload.keyProvider.properties.password = btoa(secret);
								payload = JSON.stringify(payload);
								keyManagementService
									.createAWS(payload)
									.success(data => {
										if (data.errorCode === 0) {
											$log.debug(cvLoc('log.succesCreateAWS'));
											$modalInstance.dismiss('clear');
											$state.forceReload();
										} else {
											$log.error(cvLoc('error.toCreateAWS'));
											$scope.serverErrorMessage = data.errorMessage;
										}
									})
									.error(function(data) {
										$scope.serverErrorMessage = data.errorMessage;
										$log.error(cvLoc('error.toCreateAWS'));
									});
							}
						}
					};

					$scope.close = function() {
						$modalInstance.dismiss('clear');
					};
				}
			],
			resolve: {
				arrayInfo: function() {
					return self.entity;
				},
				action: function() {
					return $scope.action;
				}
			}
		});
	};

	factory.addKMIP = function($scope, $rootScope, $modal, cvLoc, values) {
		$rootScope.values = values;
		var self = this;
		var template = 'modules/security/partials/modalKmip.jsp';
		$modal.open({
			templateUrl: appUtil.appRoot + template,
			backdrop: 'static',
			controller: [
				'$stateParams',
				'keyManagementService',
				'$dialogs',
				'$uibModalInstance',
				'$rootScope',
				'$log',
				'$state',
				'cvLoc',
				'cvUtil',
				'$scope',
				'$location',
				function(
					$stateParams,
					keyManagementService,
					$dialogs,
					$modalInstance,
					$rootScope,
					$log,
					$state,
					cvLoc,
					cvUtil,
					$scope,
					$location
				) {
					$scope.keylengthValues = [
						{ value: 128, name: '128' },
						{ value: 256, name: '256' }
					];

					// $scope.pathPattern = /^([a-zA-Z]\:|\\\\[^\/\\:*?"<>|]+\\[^\/\\:*?"<>|]+)(\\[^\/\\:*?"<>|]+)+(\.[^\/\\:*?"<>|]+)$/;
					$scope.pathPattern = /(?=.*\S.*)(?=^([a-zA-Z]\:|\\\\[^\/\\:*?“<>|]+\\[^\/\\:*?“<>|]+)(\\[^\/\\:*?“<>|]+)+(\.[^\/\\:*?“<>|]+)$)/;
					$scope.serverErrorMessage = null;

					//START: Formulary Logic
					$scope.validateValue = function() {
						let flag = this.value ? true : false;
						this.hasError = !flag;
						return flag;
					};

					$scope.validatePath = function() {
						let flag = /^([a-zA-Z]\:|\\\\[^\/\\:*?"<>|]+\\[^\/\\:*?"<>|]+)(\\[^\/\\:*?"<>|]+)/.test(this.value);
						this.hasError = !flag;
						return flag;
					};

					// functions

					$scope.isEditing = false;

					/* Start of uploading File */
					$scope.browseLocalPath = function(inputName, pathName, idpMetadata) {
						document.getElementById(inputName).onchange = function() {
							$scope[pathName] = this.value;
						};
						var showPath = document.getElementById(pathName),
							element = document.getElementById(inputName);
						element.click();
					};

					$scope.changedCipher = function(value) {
						switch (value) {
							case '7':
								$scope.data.keyLength.value = null;
								$scope.keylengthValues = [{ value: 192, name: '192' }];
								break;
							case '6':
								$scope.data.keyLength.value = null;
								$scope.keylengthValues = [{ value: 256, name: '256' }];
								break;

							default:
								$scope.keylengthValues = [
									{ value: 128, name: '128' },
									{ value: 192, name: '192' },
									{ value: 256, name: '256' }
								];
								break;
						}
					};

					$scope.browseCertificates = function(type) {
						if (!true) {
							$scope.serverMessage = cvUtil.errMsgLoc('error.mediaAgent');
							return;
						} else {
							$scope.serverMessage = cvUtil.emptyMsg();
						}

						var modalInstance = $modal.open({
							templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
							controller: 'mbController',
							resolve: {
								browseParams: function browseParams() {
									return {
										foldersOnly: false,
										clientId: 2 // Commcell also force this id
									};
								}
							}
						});
						modalInstance.result.then(
							function(result) {
								switch (type) {
									case 'certificate':
										$scope.data.certificate.value = result.path;
										break;
									case 'certificate_key':
										$scope.data.certificateKey.value = result.path;
										break;
									case 'certificate_ca':
										$scope.data.caCertificate.value = result.path;
										break;
									default:
										break;
								}
							},
							function() {
								$log.info('Cancel clicked: ');
							}
						);
					};

					$scope.validateForm = function() {
						$scope.data.name.validate();
						$scope.data.cipher.validate();
						$scope.data.keyLength.validate();
						$scope.data.server.validate();
						$scope.data.port.validate();
						if (!$scope.isEditing) {
							$scope.data.passphrase.validate();
						}
						$scope.data.certificateKey.validate();
						$scope.data.certificate.validate();
						$scope.data.caCertificate.validate();

						// $scope.data.certificateKey.validate();
						// $scope.data.certificate.validate();
						// $scope.data.caCertificate.validate();

						if (
							!$scope.data.name.hasError &&
							!$scope.data.cipher.hasError &&
							!$scope.data.keyLength.hasError &&
							!$scope.data.server.hasError &&
							!$scope.data.port.hasError &&
							(!$scope.data.passphrase.hasError || $scope.isEditing) &&
							!$scope.data.certificateKey.hasError &&
							!$scope.data.certificate.hasError &&
							!$scope.data.caCertificate.hasError
						) {
							$scope.data.formHasError = false;
						} else {
							$scope.data.formHasError = true;
						}
						return !$scope.data.formHasError;
					};

					$scope.data = {
						name: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						cipher: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						keyLength: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						server: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						port: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						passphrase: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						certificateKey: {
							value: null,
							validate: $scope.validatePath,
							hasError: false
						},
						certificate: {
							value: null,
							validate: $scope.validatePath,
							hasError: false
						},
						caCertificate: {
							value: null,
							validate: $scope.validatePath,
							hasError: false
						},
						validateForm: $scope.validateForm,
						formHasError: false
					};
					//END: Formulary Logic

					$scope.data.cipher.value = '3';

					if ($rootScope.values) {
						// Is editing
						$scope.titleKMIP = cvLoc('title.editKMIP');
						$scope.isEditing = true;
						$scope.idServer = $rootScope.values.provider.keyProviderId;
						$scope.data.name.value = $rootScope.values.provider.keyProviderName;
						$scope.data.id = $rootScope.values.provider.keyProviderId;
						$scope.oldProviderName = $scope.data.name.value;
						$scope.data.cipher.value = $rootScope.values.encryptionType + '';
						$scope.data.server.value = $rootScope.values.properties.host;
						$scope.data.keyLength.value = $rootScope.values.encryptionKeyLength + '';
						$scope.data.port.value = $rootScope.values.properties.port;
						$scope.data.certificateKey.value = $rootScope.values.properties.keyFilePath;
						$scope.data.certificate.value = $rootScope.values.properties.certFilePath;
						$scope.data.caCertificate.value = $rootScope.values.properties.caCertFilePath;
					} else {
						$scope.titleKMIP = cvLoc('title.addKMIP');
					}

					$scope.isProviderNameChanged = false;
					$scope.changedName = function() {
						if ($scope.oldProviderName === $scope.data.name.value) {
							$scope.isProviderNameChanged = false;
						} else {
							$scope.isProviderNameChanged = true;
						}
					};

					// Save button
					$scope.save = function() {
						$scope.errorSecret = false;
						if ($scope.data.validateForm()) {
							$scope.serverErrorMessage = null;
							let payload = {
								keyProvider: {
									encryptionKeyLength: Number($scope.data.keyLength.value),
									encryptionType: Number($scope.data.cipher.value),
									keyProviderType: 2,
									provider: {
										keyProviderName: $scope.data.name.value,
										keyProviderId: $scope.data.id
									},
									properties: {
										certFilePath: $scope.data.certificate.value,
										keyFilePath: $scope.data.certificateKey.value,
										caCertFilePath: $scope.data.caCertificate.value,
										port: Number($scope.data.port.value),
										host: $scope.data.server.value
									}
								}
							};
							if ($scope.isEditing) {
								if ($scope.isProviderNameChanged && $scope.isEditing) {
									payload.newKeyProviderName = $scope.data.name.value;
									payload.keyProvider.provider.keyProviderName = $scope.oldProviderName;
								}
								payload.id = $scope.idServer;

								const secret = $scope.data.passphrase.value;
								if (secret !== null && secret !== '') {
									payload.keyProvider.properties.sslPassPhrase = btoa(secret);
								}

								payload = JSON.stringify(payload);
								keyManagementService
									.updateKMIP(payload)
									.success(data => {
										if (data.errorCode === 0) {
											$log.debug(cvLoc('log.succesUpdateKMIP'));
											$modalInstance.dismiss('clear');
											if ($scope.isProviderNameChanged) {
												const keyId = $stateParams['keyId'];
												const keyType = $stateParams['type'];
												const keyName = $scope.data.name.value;
												$location.url(`/keyManagementDetails?keyId=${keyId}&type=${keyType}&name=${keyName}`);
											} else {
												$state.forceReload();
											}
										} else {
											$log.error(cvLoc('error.toUpdateKMIP'));
											$scope.serverErrorMessage = data.errorMessage;
										}
									})
									.error(function(data) {
										$log.debug(cvLoc('label.error'));
										$scope.serverErrorMessage = data.errorMessage;
										$log.error(cvLoc('error.toUpdateKMIP'));
									});
							} else {
								const secret = $scope.data.passphrase.value;
								payload.keyProvider.properties.sslPassPhrase = btoa(secret);
								payload = JSON.stringify(payload);
								keyManagementService
									.createKMIP(payload)
									.success(data => {
										if (data.errorCode === 0) {
											$log.debug(cvLoc('log.succesCreateKMIP'));
											$modalInstance.dismiss('clear');
											$state.forceReload();
										} else {
											$log.error(cvLoc('error.toCreateKMIP'));
											$scope.serverErrorMessage = data.errorMessage;
										}
									})
									.error(function(data) {
										$log.debug(cvLoc('label.error'));
										$scope.serverErrorMessage = data.errorMessage;
										$log.error(cvLoc('error.toCreateKMIP'));
									});
							}
						}
					};

					$scope.close = function() {
						$modalInstance.dismiss('clear');
					};
				}
			],
			resolve: {
				arrayInfo: function() {
					return self.entity;
				},
				action: function() {
					return $scope.action;
				}
			}
		});
	};

	factory.addLocation = function($scope, $rootScope, $modal, cvLoc, action) {
		var self = this;
		$rootScope.values = action;
		var template = 'modules/security/partials/modalExportLocation.jsp';
		$modal.open({
			templateUrl: appUtil.appRoot + template,
			backdrop: 'static',
			controller: [
				'$q',
				'sharedData',
				'mbService',
				'clientGroupService',
				'keyManagementService',
				'$dialogs',
				'$uibModalInstance',
				'$rootScope',
				'$log',
				'action',
				'$state',
				'cvLoc',
				'cvUtil',
				'$scope',
				'cvTableOptions',
				function(
					$q,
					sharedData,
					mbService,
					clientGroupService,
					keyManagementService,
					$dialogs,
					$modalInstance,
					$rootScope,
					$log,
					action,
					$state,
					cvLoc,
					cvUtil,
					$scope,
					cvTableOptions
				) {
					//let isUnixClient = false;
					$scope.serverPath = null;
					$scope.selectedClient = null;
					$scope.clientValues = [];

					$scope.winPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
					$scope.linuxPathPattern = /^(\/[^<>:"/\\|?*]+)+\/?$/;
					$scope.pathPattern = null;
					/* Start of uploading File */
					$scope.browseLocalPath = function(inputName, pathName, idpMetadata) {
						document.getElementById(inputName).onchange = function() {
							$scope[pathName] = this.value;
							$scope.data.path.value = this.value;
						};
						var showPath = document.getElementById(pathName),
							element = document.getElementById(inputName);
						element.click();
					};

					//START: Formulary Logic
					$scope.validateValue = function() {
						let flag = this.value ? true : false;
						this.hasError = !flag;
						return flag;
					};

					$scope.changeText = function() {
						if ($scope.serverPath) {
							$scope.data.path.value = $scope.serverPath;
						}
					};

					$scope.validateForm = function() {
						$scope.data.client.validate();
						$scope.data.path.validate();

						if (!$scope.data.client.hasError && !$scope.data.path.hasError) {
							$scope.data.formHasError = false;
						} else {
							$scope.data.formHasError = true;
						}
						return !$scope.data.formHasError;
					};

					$scope.updatePath = function() {
						$scope.serverPath = sharedData.filePath;
						$scope.data.path.value = sharedData.filePath;
					};
					sharedData.updatePath = $scope.updatePath;

					$scope.browse = function() {
						if (!true) {
							$scope.serverMessage = cvUtil.errMsgLoc('error.mediaAgent');
							return;
						} else {
							$scope.serverMessage = cvUtil.emptyMsg();
						}
						if ($scope.data.clientId.value > 0) {
							var modalInstance = $modal.open({
								templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
								controller: 'mbController',
								resolve: {
									browseParams: function browseParams() {
										return {
											foldersOnly: true,
											clientId: $scope.data.clientId.value
										};
									}
								}
							});
							modalInstance.result.then(
								function(result) {
									sharedData.filePath = result.path;
									sharedData.updatePath();
								},
								function() {
									$log.info('Cancel clicked: ');
								}
							);
						}
					};

					$scope.saveSelected = function() {
						if ($scope.selectedClient[0]) {
							$scope.data.client.value = $scope.selectedClient[0].clientName;
							$scope.data.clientId.value = $scope.selectedClient[0].clientId;
							$scope.data.client.hasError = false;
							mbService.getOSType($scope.selectedClient[0].clientId).then(function successCallBack(response) {
								$scope.pathPattern =
									response.data.toLowerCase() == 'unix' ? $scope.linuxPathPattern : $scope.winPathPattern;
							});
						}
					};

					$scope.data = {
						client: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						clientId: {
							value: null,
							hasError: false
						},
						path: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						validateForm: $scope.validateForm,
						formHasError: false
					};
					//END: Formulary Logic
					// Initialize controller
					$scope.filter = {
						pagingOptions: { page: 1 },
						sortOptions: { fields: 'clientProperties.client.clientEntity.displayName', directions: 'ASC' },
						filters: {}
					};
					//FORM
					$scope.isEditing = false;
					$scope.isTouched = false;
					if ($rootScope.values) {
						$scope.isEditing = true;
						$scope.data.client.value = $rootScope.values.client.clientName;
						$scope.data.clientId.value = $rootScope.values.client.clientId;
						$scope.originalId = $scope.data.clientId.value;
						$scope.data.path.value = $rootScope.values.filePath.path;
						$scope.serverPath = $scope.data.path.value;
					}
					//FORM
					const promisesList = [clientGroupService.getAllClientsList($scope.filter, undefined, 0, true, null, true)];

					if ($scope.isEditing) {
						promisesList.push(mbService.getOSType($scope.data.clientId.value));
					}

					$q.all(promisesList)
						.then(([clientPropertiesData, osTypeData = null]) => {
							if (osTypeData !== null) {
								$scope.pathPattern =
									osTypeData.data.toLowerCase() === 'unix' ? $scope.linuxPathPattern : $scope.winPathPattern;
							}

							$scope.clientValues = clientPropertiesData.data.clientProperties.map(elem => {
								if ($scope.data.clientId.value === elem.client.clientEntity.clientId) {
									const obj = {
										...elem.client.clientEntity,
										selected: true
									};
									return obj;
								} else {
									const obj = {
										...elem.client.clientEntity,
										selected: false
									};
									return obj;
								}
							});
						})
						.catch(() => {
							$scope.serverMessage = cvUtil.emptyMsg();
							cvToaster.showErrorMessage({
								ttl: '5000', //5 sec
								message: cvLoc('error.errorLoadingServersForGroup')
							});
						});
					// END: Initialize controller

					$scope.changedValue = function(params) {
						$scope.isTouched = true;
					};

					sharedData.data.clientList = [];
					// Save button
					$scope.save = function() {
						if ($scope.validateForm()) {
							if ($scope.isEditing) {
								sharedData.data.clientList.push({
									clientId: $scope.data.clientId.value,
									clientName: $scope.data.client.value,
									path: $scope.data.path.value
								});
								$scope.originalId = $scope.originalId !== $scope.data.clientId.value ? $scope.originalId : null;
								sharedData.data.replaceValues($scope.originalId, $rootScope.values.$$hashKey);
								$modalInstance.dismiss('clear');
							} else {
								sharedData.data.clientList.push({
									clientId: $scope.data.clientId.value,
									clientName: $scope.data.client.value,
									path: $scope.data.path.value
								});
								sharedData.data.refreshTable();
								$modalInstance.dismiss('clear');
							}
						}
					};

					$scope.close = function() {
						$modalInstance.dismiss('clear');
					};
				}
			],
			resolve: {
				arrayInfo: function() {
					return self.entity;
				},
				action: function() {
					return $scope.action;
				}
			}
		});
	};

	factory.addPassphrase = function($scope, $rootScope, $modal, cvLoc, values) {
		$rootScope.values = values;
		var self = this;
		var template = 'modules/security/partials/modalPassphrase.jsp';
		$modal.open({
			templateUrl: appUtil.appRoot + template,
			backdrop: 'static',
			controller: [
				'$stateParams',
				'sharedData',
				'keyManagementService',
				'$dialogs',
				'$uibModalInstance',
				'$rootScope',
				'$log',
				'action',
				'$state',
				'cvLoc',
				'cvUtil',
				'$scope',
				'cvTableOptions',
				'securityFactory',
				'$location',
				'keyManagementFactory',
				'updatePasswordFactory',
				function(
					$stateParams,
					sharedData,
					keyManagementService,
					$dialogs,
					$modalInstance,
					$rootScope,
					$log,
					action,
					$state,
					cvLoc,
					cvUtil,
					$scope,
					cvTableOptions,
					securityFactory,
					$location,
					keyManagementFactory,
					updatePasswordFactory
				) {
					$scope.keylengthValues = [
						{ value: 128, name: '128' },
						{ value: 256, name: '256' }
					];
					$scope.pathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
					$scope.modalTable = [];

					switch ($rootScope.values.typeToShow) {
						case 'location':
							$scope.typeToShow = 'location';
							break;

						case 'general':
							$scope.typeToShow = 'general';
							break;

						case 'all':
							$scope.typeToShow = 'all';
							break;

						default:
							$scope.typeToShow = false;
							break;
					}

					$scope.isEditing = false;

					//START: Formulary Logic
					$scope.validateValue = function() {
						let flag = this.value ? true : false;
						this.hasError = !flag;
						return flag;
					};

					$scope.errorClient = false;
					$scope.errorMaxClient = false;

					$scope.validateForm = function() {
						$scope.data.name.validate();
						$scope.data.encruption.validate();

						if (!$scope.isEditing) {
							$scope.data.passphrase.validate();
						}

						if (
							(!$scope.data.name.hasError && !$scope.data.encruption.hasError && !$scope.data.passphrase.hasError) ||
							$scope.typeToShow === 'location'
						) {
							$scope.data.formHasError = false;
						} else {
							$scope.data.formHasError = true;
						}
						return !$scope.data.formHasError;
					};

					$scope.data = {
						name: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						encruption: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						passphrase: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						encryptionType: {
							value: null,
							hasError: false
						},
						validateForm: $scope.validateForm,
						formHasError: false
					};
					//END: Formulary Logic
					$scope.typeCipher = keyManagementFactory.encryptionTypeList(cvLoc);
					if ($rootScope.values && $scope.typeToShow !== 'all') {
						// Is editing
						$scope.titlePassphrase = cvLoc('title.editPassphrase');
						$scope.isEditing = true;
						$scope.idServer = $rootScope.values.provider.keyProviderId;
						$scope.data.name.value = $rootScope.values.provider.keyProviderName;
						$scope.data.id = $rootScope.values.provider.keyProviderId;
						$scope.oldProviderName = $scope.data.name.value;
						$scope.oldPassphrase = $rootScope.values.properties.passphrase;
						$scope.data.encruption.value = $rootScope.values.encryptionKeyLength + '';
						$scope.data.passphrase.value = $rootScope.values.properties.passphrase;
						$scope.data.encryptionType.value = $rootScope.values.encryptionType;
						if ($rootScope.table) {
							sharedData.data.clientList = $rootScope.values.properties.passphraseClient;
							$scope.modalTable = $rootScope.values.properties.passphraseClient.map(elem => {
								return Object.assign({}, elem);
							});
						} else {
							sharedData.data.clientList = $rootScope.values.properties.passphraseClient;
							$scope.modalTable = $rootScope.values.properties.passphraseClient.map(elem => {
								return Object.assign({}, elem);
							});
						}
					} else {
						$scope.titlePassphrase = cvLoc('title.addPassphrase');
						$scope.genericEntity = {
							entityId: parseInt($scope.idServer) || null
						};
						sharedData.data.clientList = [];
						$scope.modalTable = [];
					}

					$scope.isProviderNameChanged = false;
					$scope.changedName = function() {
						if ($scope.oldProviderName === $scope.data.name.value) {
							$scope.isProviderNameChanged = false;
						} else {
							$scope.isProviderNameChanged = true;
						}
					};

					$scope.isPassphraseChanged = false;
					$scope.changedPassphrase = function() {
						if ($scope.oldPassphrase === btoa($scope.data.passphrase.value)) {
							$scope.isPassphraseChanged = false;
						} else {
							$scope.isPassphraseChanged = true;
						}
					};

					// functions
					$scope.addLocation = function() {
						$scope.errorMaxClient = false;
						if ($scope.modalTable.length >= 3) {
							$scope.errorMaxClient = true;
						} else {
							factory.addLocation($scope, $rootScope, $modal, cvLoc, null);
						}
					};

					$scope.editLocation = function(entity, posc) {
						entity.posc = posc;
						factory.addLocation($scope, $rootScope, $modal, cvLoc, entity);
					};

					$scope.deleteLocation = function(entity) {
						var callBackFunctions = {
							noFunction: function() {},
							yesFunction: function() {
								if ($scope.modalTable.length > 2) {
									for (var i = 0; i < $scope.modalTable.length; i++) {
										if ($scope.modalTable[i]) {
											if ($scope.modalTable[i].$$hashKey === entity.$$hashKey) {
												$scope.modalTable.splice(i, 1);
												if ($scope.modalTable.length >= 3) {
													$scope.errorMaxClient = true;
												} else $scope.errorMaxClient = false;
												break;
											}
										}
									}
								} else {
									$dialogs.error(cvLoc('label.error'), cvLoc('error.minimunlocation'));
								}
							}
						};
						$dialogs.confirm(
							cvLoc('label.confirmDelete'),
							cvLoc('label.confirmationKeyManagement', '<b>' + entity.client.clientName + '</b>'),
							callBackFunctions
						);
					};

					// For the Table
					var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
					angular.extend(globalGridOptions, {
						data: 'modalTable',
						showGridFooter: true,
						enableGridMenu: false,
						columnDefs: [
							{
								field: 'client.clientName',
								sort: {
									direction: 'asc',
									priority: 0
								},
								displayName: cvLoc('label.client'),
								enableHiding: false,
								cellTemplate: '<a>{{row.entity.client.clientName}}</a>',
								width: '30%'
							},
							{
								field: 'filePath.path',
								displayName: cvLoc('label.path'),
								enableHiding: false,
								cellTemplate: '<span>{{row.entity.filePath.path}}</span>',
								width: '30%'
							},
							{
								name: 'action',
								displayName: cvLoc('label.actions'),
								enableHiding: false,
								enableFiltering: false,
								enableSorting: false,
								cellTemplate:
									'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.editLocation(row.entity, rowRenderIndex)">' +
									cvLoc('label.edit') +
									'</a></li><li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteLocation(row.entity)">' +
									cvLoc('label.deleteLocation') +
									'</a></li> </ul></div>',
								width: '20%'
							}
						]
					});

					$scope.keyManagementGridOptions = {
						cvPageLinks: [
							{
								label: cvLoc('label.add'),
								onclick: $scope.addLocation
							}
						],
						cvGridTitle: cvLoc('title.exportLocation'),
						cvTableName: '',
						cvIsSearchable: false,
						cvIsPageTitle: false,
						cvSearchFields: ['provider.keyProviderName'],
						cvServerMessage: '',
						cvAppScope: $scope,
						gridOptions: globalGridOptions
					};

					$scope.refreshTable = function() {
						var newClient = {
							client: {
								clientId: sharedData.data.clientList[0].clientId,
								clientName: sharedData.data.clientList[0].clientName
							},
							filePath: {
								path: sharedData.data.clientList[0].path
							}
						};
						$scope.modalTable.push(newClient);
					};
					sharedData.data.refreshTable = $scope.refreshTable;

					$scope.replaceValues = function(oldId, hash) {
						var replacedValue = {
							client: {
								clientId: sharedData.data.clientList[0].clientId,
								clientName: sharedData.data.clientList[0].clientName
							},
							filePath: {
								path: sharedData.data.clientList[0].path
							}
						};
						for (var i = 0; i < $scope.modalTable.length; i++) {
							if ($scope.modalTable[i].$$hashKey === hash) {
								$scope.modalTable[i] = replacedValue;
							}
						}
					};
					sharedData.data.replaceValues = $scope.replaceValues;

					$scope.updatePassphrase = function(payload) {
						payload = JSON.stringify(payload);
						keyManagementService
							.updatePassphrase(payload)
							.success(data => {
								if (data.errorCode === 0) {
									$log.debug(cvLoc('log.succesUpdatePassphrase'));
									$modalInstance.dismiss('clear');
									if ($scope.isProviderNameChanged) {
										const keyId = $stateParams['keyId'];
										const keyType = $stateParams['type'];
										const keyName = $scope.data.name.value;
										$location.url(`/keyManagementDetails?keyId=${keyId}&type=${keyType}&name=${keyName}`);
									} else {
										$state.forceReload();
									}
								} else {
									$log.error(cvLoc('error.toUpdatePassphrase'));
									$scope.serverErrorMessage = data.errorMessage;
								}
							})
							.error(function(data) {
								$scope.serverErrorMessage = data.errorMessage;
								$log.error(cvLoc('error.toUpdatePassphrase'));
							});
					};

					$scope.updatePasswordPassphrase = function(payload) {
						var modalInstance = updatePasswordFactory.updatePassphraseCredential($scope, $rootScope, $modal, cvLoc);
						modalInstance.result.then(function(data) {
							payload.oldPassphrase = data.oldPassphrase;
							payload.keyProvider.properties.passphrase = data.passphrase;
							payload.rotatePassphrase = true;
							$scope.updatePassphrase(payload);
						});
					};

					$scope.cancel = function() {
						console.log('canceled');
					};

					$scope.createPassphrase = function(payload) {
						payload.keyProvider.properties.passphrase = btoa($scope.data.passphrase.value);
						payload = JSON.stringify(payload);
						keyManagementService
							.createPassphrase(payload)
							.success(data => {
								if (data.errorCode === 0) {
									$log.debug(cvLoc('log.succesCreatePassphrase'));
									$modalInstance.dismiss('clear');
									$state.forceReload();
								} else {
									$log.error(cvLoc('error.toCreatePassphrase'));
									$scope.serverErrorMessage = data.errorMessage;
								}
							})
							.error(function(data) {
								$scope.serverErrorMessage = data.errorMessage;
								$log.error(cvLoc('error.toCreatePassphrase'));
							});
					};
					// Save button
					$scope.save = function() {
						$scope.errorClient = false;
						var cleanedArray = $scope.modalTable.filter(n => n);
						if ($scope.data.validateForm() && (cleanedArray.length >= 2 || $scope.typeToShow === 'general')) {
							$scope.errorMaxClient = false;
							$scope.serverErrorMessage = null;
							let payload = {
								keyProvider: {
									encryptionKeyLength: Number($scope.data.encruption.value),
									encryptionType: 3,
									keyProviderType: 6,
									provider: {
										keyProviderName: $scope.data.name.value,
										keyProviderId: $scope.data.id
									},
									properties: {
										// passphrase: btoa($scope.data.passphrase.value),
										passphraseClient: cleanedArray
									}
								}
							};
							if ($scope.validateForm()) {
								if ($scope.isProviderNameChanged && $scope.isEditing) {
									payload.newKeyProviderName = $scope.data.name.value;
									payload.keyProvider.provider.keyProviderName = $scope.oldProviderName;
								}

								if ($scope.isEditing) {
									if ($scope.typeToShow === 'location') $scope.updatePasswordPassphrase(payload);
									else $scope.updatePassphrase(payload);
								} else {
									var funcs = {
										yesFunction: $scope.createPassphrase,
										noFunction: $scope.cancel
									};
									payload.useSaveLabel = true;
									updatePasswordFactory.changePassModal(
										$modal,
										cvLoc('title.confirmationTitle'),
										cvLoc('label.passphraseMessageChange'),
										funcs,
										cvLoc('label.confirmText'),
										payload
									);
								}
							}
						} else {
							if (cleanedArray.length < 2) {
								$scope.errorClient = true;
							}
						}
					};

					$scope.close = function() {
						$modalInstance.dismiss('clear');
					};
				}
			],
			resolve: {
				arrayInfo: function() {
					return self.entity;
				},
				action: function() {
					return $scope.action;
				}
			}
		});
	};

	factory.addAzure = function($scope, $rootScope, $modal, cvLoc, values) {
		$rootScope.values = values;
		var self = this;
		var template = 'modules/security/partials/modalAzure.jsp';
		$modal.open({
			templateUrl: appUtil.appRoot + template,
			backdrop: 'static',
			controller: [
				'sharedData',
				'keyManagementService',
				'$dialogs',
				'$uibModalInstance',
				'$rootScope',
				'$log',
				'action',
				'$state',
				'cvLoc',
				'cvUtil',
				'$scope',
				'cvTableOptions',
				'securityFactory',
				'keyManagementFactory',
				'CREDENTIAL_TYPE_ENVIRONMENT',
				'credentialManagerService',
				function(
					sharedData,
					keyManagementService,
					$dialogs,
					$modalInstance,
					$rootScope,
					$log,
					action,
					$state,
					cvLoc,
					cvUtil,
					$scope,
					cvTableOptions,
					securityFactory,
					keyManagementFactory,
					CREDENTIAL_TYPE_ENVIRONMENT,
					credentialManagerService
				) {
					$scope.keylengthValues = [
						{ value: 2048, name: '2048' },
						{ value: 3072, name: '3072' }
					];

					$scope.encryptionType = [
						{ value: 1001, name: 'RSA' },
						{ value: 1002, name: 'RSA-HSM' }
					];

					const sharedCertificate = 1;
					const dummyPwd = '123456789';

					$scope.populateEnvironment = () => {
						$scope.environment = [];
						angular.forEach(CREDENTIAL_TYPE_ENVIRONMENT, function(value, key) {
							$scope.environment.push({
								id: key,
								name: value
							});
						});
					};

					$scope.populateEnvironment();

					$scope.changeEnvironment = function() {
						$scope.data.authenticationEndpoint.value = credentialManagerService.getAuthenticationEndpoint(
							$scope.data.environment.value[0]
						);
						$scope.data.keyVaultEndpoint.value = credentialManagerService.getKeyVaultEndpoint(
							$scope.data.environment.value[0]
						);
					};

					$scope.getEnvironment = function(type) {
						let environment = [];
						angular.forEach(CREDENTIAL_TYPE_ENVIRONMENT, function(value, key) {
							if (value === type) {
								environment.push({
									id: key,
									name: value
								});
							}
						});
						return environment;
					};

					//START: Formulary Logic
					$scope.validateValue = function() {
						let flag = this.value ? true : false;
						this.hasError = !flag;
						return flag;
					};

					$scope.validateEnvironment = function() {
						let flag = this.value && this.value.length > 0 ? true : false;
						this.hasError = !flag;
						return flag;
					};

					$scope.errorClient = false;

					$scope.validateForm = function() {
						$scope.data.name.validate();
						$scope.data.keylength.validate();
						$scope.data.encryptionType.validate();
						$scope.data.keyVaultName.validate();
						$scope.data.tenantId.validate();
						$scope.data.applicationId.validate();
						$scope.data.certificate.validate();
						$scope.data.certificateThumbprint.validate();
						$scope.data.environment.validate();
						$scope.data.keyVaultEndpoint.validate();
						$scope.data.authenticationEndpoint.validate();

						if (
							!$scope.data.name.hasError &&
							!$scope.data.keylength.hasError &&
							!$scope.data.encryptionType.hasError &&
							!$scope.data.keylength.hasError &&
							!$scope.data.keyVaultName.hasError &&
							!$scope.data.tenantId.hasError &&
							!$scope.data.applicationId.hasError &&
							!$scope.data.certificate.hasError &&
							!$scope.data.certificateThumbprint.hasError &&
							!$scope.data.environment.hasError &&
							!$scope.data.keyVaultEndpoint.hasError &&
							!$scope.data.authenticationEndpoint.hasError
						) {
							$scope.data.formHasError = false;
						} else {
							$scope.data.formHasError = true;
						}
						return !$scope.data.formHasError;
					};

					$scope.showEndpoint = false;

					$scope.showEndpoints = () => {
						$scope.showEndpoint = !$scope.showEndpoint;
					};

					$scope.data = {
						name: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						keylength: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						encryptionType: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						keyVaultName: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						tenantId: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						applicationId: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						certificate: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						certificatePassword: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						certificateThumbprint: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						environment: {
							value: null,
							validate: $scope.validateEnvironment,
							hasError: false
						},
						authenticationEndpoint: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						keyVaultEndpoint: {
							value: null,
							validate: $scope.validateValue,
							hasError: false
						},
						validateForm: $scope.validateForm,
						formHasError: false
					};
					//END: Formulary Logic

					if ($rootScope.values) {
						// Is editing
						$scope.titleAzure = cvLoc('title.editAzure');
						$scope.isEditing = true;
						$scope.data.name.value = $rootScope.values.provider.keyProviderName;
						$scope.data.keylength.value = $rootScope.values.encryptionKeyLength + '';
						$scope.data.encryptionType.value = $rootScope.values.encryptionType + '';
						$scope.data.keyVaultName.value = $rootScope.values.properties.keyVaultCredential.resourceName;
						$scope.data.tenantId.value = $rootScope.values.properties.keyVaultCredential.tenantId;
						$scope.data.applicationId.value = $rootScope.values.properties.keyVaultCredential.applicationId;
						$scope.data.certificate.value = $rootScope.values.properties.keyVaultCredential.certificate;
						$scope.data.certificatePassword.value = dummyPwd;
						$scope.data.certificateThumbprint.value =
							$rootScope.values.properties.keyVaultCredential.certificateThumbprint;
						$scope.serverId = $rootScope.values.provider.keyProviderId || undefined;
						var selectedEnvironment = $rootScope.values.properties.keyVaultCredential.environment;
						$scope.environment.forEach(environment => {
							if (typeof selectedEnvironment != 'undefined' && selectedEnvironment == environment.name) {
								environment.selected = true;
							}
						});

						$scope.data.environment.value = $scope.getEnvironment(selectedEnvironment);
						$scope.changeEnvironment();
					} else {
						$scope.titleAzure = cvLoc('title.addAzure');
					}

					//certifiacte browse
					$scope.browseCertificates = function() {
						if (!true) {
							$scope.serverMessage = cvUtil.errMsgLoc('error.mediaAgent');
							return;
						} else {
							$scope.serverMessage = cvUtil.emptyMsg();
						}

						var modalInstance = $modal.open({
							templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
							controller: 'mbController',
							resolve: {
								browseParams: function browseParams() {
									return {
										foldersOnly: false,
										clientId: 2 // Commcell also force this id
									};
								}
							}
						});
						modalInstance.result.then(
							function(result) {
								$scope.data.certificate.value = result.path;
							},
							function() {
								$log.info('Cancel clicked: ');
							}
						);
					};

					// Save button
					$scope.save = function() {
						if ($scope.data.validateForm()) {
							$scope.serverErrorMessage = null;
							let payload = {
								keyProvider: {
									encryptionKeyLength: Number($scope.data.keylength.value),
									encryptionType: Number($scope.data.encryptionType.value),
									keyProviderType: 4,
									provider: {
										keyProviderId: $scope.serverId,
										keyProviderName: $scope.data.name.value
									},
									properties: {
										keyVaultCredential: {
											authType: sharedCertificate,
											applicationId: $scope.data.applicationId.value,
											tenantId: $scope.data.tenantId.value,
											certificate: $scope.data.certificate.value,
											certificateThumbprint: $scope.data.certificateThumbprint.value,
											environment: $scope.data.environment.value[0].name,
											resourceName: $scope.data.keyVaultName.value,
											endpoints: {
												activeDirectoryEndpoint: $scope.data.authenticationEndpoint.value,
												keyVaultEndpoint: $scope.data.keyVaultEndpoint.value
											}
										}
									}
								}
							};
							if ($scope.isEditing) {
								const secret = $scope.data.certificatePassword.value;
								if (secret !== null && secret !== '' && secret !== dummyPwd) {
									payload.keyProvider.properties.sslPassPhrase = btoa(secret);
								}
								payload = JSON.stringify(payload);
								keyManagementService
									.updateAzure(payload)
									.success(data => {
										if (data.errorCode === 0) {
											$log.debug(cvLoc('log.succesUpdateAzure'));
											$modalInstance.dismiss('clear');
											$state.forceReload();
										} else {
											$log.error(cvLoc('error.toUpdateAzure'));
											$scope.serverErrorMessage = data.errorMessage;
										}
									})
									.error(function(data) {
										$scope.serverErrorMessage = data.errorMessage;
										$log.error(cvLoc('error.toUpdateAzure'));
									});
							} else {
								const secret = $scope.data.certificatePassword.value;
								payload.keyProvider.properties.sslPassPhrase = btoa(secret);
								payload = JSON.stringify(payload);
								keyManagementService
									.createAzure(payload)
									.success(data => {
										if (data.errorCode === 0) {
											$log.debug(cvLoc('log.succesUpdateAzure'));
											$modalInstance.dismiss('clear');
											$state.forceReload();
										} else {
											$log.error(cvLoc('error.toUpdateAzure'));
											$scope.serverErrorMessage = data.errorMessage;
										}
									})
									.error(function(data) {
										$scope.serverErrorMessage = data.errorMessage;
										$log.error(cvLoc('error.toUpdateAzure'));
									});
							}
						}
					};

					$scope.close = function() {
						$modalInstance.dismiss('clear');
					};
				}
			],
			resolve: {
				arrayInfo: function() {
					return self.entity;
				},
				action: function() {
					return $scope.action;
				}
			}
		});
	};

	return factory;
});

keyManagementControllers.keyManagementController = [
	'keyManagementFactory',
	'keyManagementService',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$log',
	'cvUtil',
	'$scope',
	'cvBreadcrumbsTabsFactory',
	'$location',
	'$dialogs',
	'$state',
	'$uibModal',
	'$rootScope',
	'cvToaster',
	function(
		keyManagementFactory,
		keyManagementService,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$log,
		cvUtil,
		$scope,
		cvBreadcrumbsTabsFactory,
		$location,
		$dialogs,
		$state,
		$modal,
		$rootScope,
		cvToaster
	) {
		// Declarations
		//$scope.keyManagementData = [];
		let _setupBreadCrumbs = () => {
			let breadCrumbs = [];

			breadCrumbs.push({
				title: cvLoc('label.nav.security'),
				link: '#nav/musers'
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		_setupBreadCrumbs();

		// functions
		$scope.addAwsKmsp = function(params) {
			keyManagementFactory.addAWS($scope, $rootScope, $modal, cvLoc, null);
		};

		$scope.addKmip = function(params) {
			keyManagementFactory.addKMIP($scope, $rootScope, $modal, cvLoc, null);
		};

		$scope.addPassphrase = function(params) {
			var data = { typeToShow: 'all' };
			keyManagementFactory.addPassphrase($scope, $rootScope, $modal, cvLoc, data);
		};

		// actions
		$scope.deleteServer = function(entity) {
			var callBackFunctions = {
				noFunction: () => {},
				yesFunction: () => {
					$state.forceReload();
					keyManagementService
						.deleteKeyManagementServer(entity.provider.keyProviderId)
						.success(data => {
							if (data.errorCode === 0) {
								$log.debug(cvLoc('log.succesDeleteKeyServer'));
								$state.forceReload();
							} else {
								$log.error(cvLoc('error.deleteKeyServer'));
								$dialogs.error(cvLoc('label.error'), data.errorMessage);
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error(cvLoc('error.deleteKeyServer'));
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmationKeyManagement', '<b>' + entity.provider.keyProviderName + '</b>'),
				callBackFunctions
			);
		};

		$scope.editServer = function(entity) {
			let payload = {
				id: entity.provider.keyProviderId
			};
			keyManagementService
				.getKeyDetails(payload)
				.success(function(data) {
					$scope.dataDetails = data.keyProviders[0];
					if ($scope.dataDetails.properties.passphraseClient) {
						$scope.dataDetails.table = $scope.dataDetails.properties.passphraseClient;
					} else {
						$scope.dataDetails.table = [];
					}
					switch (entity.keyProviderType) {
						case 2:
							keyManagementFactory.addKMIP($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
							break;
						case 3:
							keyManagementFactory.addAWS($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
							break;
						case 6:
							$scope.dataDetails.typeToShow = 'general';
							keyManagementFactory.addPassphrase($scope, $rootScope, $modal, cvLoc, $scope.dataDetails);
							break;

						default:
							break;
					}
				})
				.error(function(e) {
					// $dialogs.error(cvLoc('label.error'), e.errorMessage);
					$scope.addServerMessage = cvUtil.errMsg(e);
				});
		};

		// For the Table
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(globalGridOptions, {
			data: 'keyManagementData',
			showGridFooter: true,
			enableGridMenu: false,
			columnDefs: [
				{
					field: 'provider.keyProviderName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('label.Name'),
					enableHiding: false,
					cellTemplate:
						'<a href="#keyManagementDetails?keyId={{row.entity.provider.keyProviderId}}&type={{row.entity.keyProviderType}}&name={{row.entity.provider.keyProviderName}}">{{row.entity.provider.keyProviderName}}</a>',
					width: '30%'
				},
				{
					field: 'provider.keyProviderName',
					displayName: cvLoc('label.type'),
					enableHiding: false,
					cellTemplate:
						'<div data-ng-if="row.entity.keyProviderType === 1">Built-in</div><div data-ng-if="row.entity.keyProviderType === 2">KMIP</div><div data-ng-if="row.entity.keyProviderType === 3">AWS KMS</div><div data-ng-if="row.entity.keyProviderType === 4">AZURE KEY VAULT KMS</div><div data-ng-if="row.entity.keyProviderType === 5">SAFENET</div><div data-ng-if="row.entity.keyProviderType === 6">PASSPHRASE</div>',
					width: '30%'
				},
				{
					name: 'action',
					displayName: cvLoc('label.actions'),
					enableHiding: false,
					enableFiltering: false,
					enableSorting: false,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteServer(row.entity)">' +
						cvLoc('label.deleteServer') +
						'</a></li> </ul></div>',
					width: '20%'
				}
			]
		});

		$scope.keyManagementGridOptions = {
			cvPageLinks: [
				{
					label: cvLoc('label.add'),
					subLinks: [
						{
							label: cvLoc('label.awsKmsp'),
							onclick: $scope.addAwsKmsp
						},
						{
							label: cvLoc('label.kmip'),
							onclick: $scope.addKmip
						},
						{
							label: cvLoc('label.passphrase'),
							onclick: $scope.addPassphrase
						}
					]
				}
			],
			cvGridTitle: cvLoc('title.keyManagement'),
			cvTableName: '',
			cvIsSearchable: true,
			cvSearchFields: ['provider.keyProviderName'],
			cvServerMessage: '',
			cvAppScope: $scope,
			gridOptions: globalGridOptions,
			cvOnGridEmpty: {
				message: cvLoc('title.noStorageServers'),
				links: [
					{
						label: 'Add ' + cvLoc('label.awsKmsp'),
						onclick: $scope.addAwsKmsp
					}
				]
			}
		};

		// Service
		let payload = {
			propertyLevel: 1,
			providerType: 'tipo'
		};
		payload = JSON.stringify(payload);
		keyManagementService
			.getAllServers(payload)
			.success(function(data) {
				if (data.errorCode !== 0 && data.keyProviders) {
					$scope.keyManagementData = data.keyProviders.length > 0 ? data.keyProviders : [];
					$scope.keyManagementData = data.keyProviders.filter(item => {
						return item.provider.keyProviderId !== 1;
					});
				} else {
					$log.error(data.errorMessage);
					cvToaster.showErrorMessageWrapper(data.errorMessage);
				}
			})
			.error(function(e) {
				$dialogs.error(cvLoc('label.error'), e.errorMessage);
				$scope.addServerMessage = cvUtil.errMsg(e);
			});

		// Modals
	}
];

securityMod.controller(keyManagementControllers);

export default securityMod;
