<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<cv-tile-component loader="getSchedulePolicyRequest" data-title='{{scheduleTitle}}'
		data-override-text="overrideText" min-height="true" sla="sla" help-text="{{helpText}}">
	<span data-ng-if="serverMessage.type=='error'">
		<p class="info-place-holder padding-bottom-0"><span class="error">{{serverMessage.message}}</span></p>
	</span>
	<span data-ng-if="serverMessage.type!='error'" ng-show="schedulesLoaded && !scheduleIdentifierList.length">
		<p class="info-place-holder padding-bottom-0"><cv:msg key="info.nobackupScheduled" bundle="collections"/></p>
	</span>
	<ul class="schedules-list list-style__row group" data-ng-repeat="scheduleIdent in scheduleIdentifierList">
		<li data-ng-if="isScheduleEditable">
			<a data-ng-click="editSchedule(scheduleIdent)" data-ng-class="{'sla-schedule': scheduleIdent.flags === slaFlag, 'rpo-full-backup-schedule' : scheduleIdent.flags === fullBackupRPOFlag}" data-ng-bind="getScheduleName(scheduleIdent)">
			</a><span data-ng-if="scheduleIdent.flags === slaFlag" class='parenthetical-text'>- <span data-ng-if="databasePlan"><cv:msg key="label.slaSchedule" bundle="profiles"/></span><span data-ng-if="!databasePlan"><cv:msg key="label.rpoSchedule" bundle="profiles"/></span></span><span data-ng-if="scheduleIdent.flags === fullBackupRPOFlag" class='parenthetical-text'>- <cv:msg key="label.rpoFullSchedule" bundle="profiles" /></span>
			<a data-ng-if="isScheduleDeleteAllowed(scheduleIdent)" class="delete-row" data-ng-click="deleteSchedule(scheduleIdent)" class="float-right" title="Delete {{scheduleIdent.name}}">&times;</a>
		</li>
		<li data-ng-bind="getScheduleName(scheduleIdent)" data-ng-if="!isScheduleEditable" />
	</ul>
	<div class="page-details-box-links" data-ng-if="showEdit">
		<a href="" data-ng-if="getSchedulePolicyRequest && isScheduleEditable && !policyId" data-ng-click="addSchedule()"><cv:msg key="label.addSchedule" bundle="schedule" /></a>
	</div>
</cv-tile-component>