<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.exceptions" bundle="schedule" /></h1>
</div>
<div class="setup-content">
	<div class="{{addExceptionsMessage.type}} serverMessage">{{addExceptionsMessage.message}}</div>
	<form cv-hide-api name="addExceptionsForm" id="addExceptionsForm" class="bootstrap-wrapper form-horizontal modal-margin" novalidate cv-submit="submitExceptions()" autocomplete="off">
		<!-- // start radio button choices // -->
		<div class="form-group" data-ng-init="dayType='dayInMonth'">
			<label class="col-xs-12 col-md-4 col-lg-4" for="dayInMonth"><cv:msg key="label.repeatExceptions" bundle="schedule" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<label for="dayInMonth"><input id="dayInMonth" type="radio" name="repeat-exceptions" value="dayInMonth" data-ng-model="dayType" /> <cv:msg key="label.onDate" bundle="schedule" /></label>
			</div>
			<div class="col-xs-12 col-md-8 col-lg-8 col-lg-offset-4">
				<label for="weekInMonth"><input id="weekInMonth" type="radio" name="repeat-exceptions" value="weekInMonth" data-ng-model="dayType" /> <cv:msg key="label.onThe" bundle="schedule" /></label>
			</div>
		</div>
		<!-- // end radio button choices // -->
		<!-- // part 1 start // -->
		<div class="form-group" data-ng-if="dayType=='dayInMonth'">
			<label class="col-xs-12 col-md-4 col-lg-4" for="isteven-multi-select1"><cv:msg key="label.selectDates" bundle="schedule" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
				<isteven-multi-select
	   				  input-model="dayInMonth"
	   				  output-model="$parent.selectedDaysInMonth"
	  				  button-label="name"
	  				  item-label="name"
	   				  tick-property="ticked"
	   				  prevent-sort="true"
	   				  on-reset="reset()"
	   				  search-property="name"
	   				  is-disabled="dayType == 'weekInMonth'"
	   				  class="isteven-multi-select user-group-select"
	   				  id="isteven-multi-select1"
	   				  max-labels="5"
	   				  translation="localLang">
	   			</isteven-multi-select>
	   			<span class="input-group-btn">
	   			<button id="exceptionsModal_button_#5546" type="button" class="btn btn-default margin-left-5" data-ng-show="!showEdit || !dayInMonthList.length" data-ng-click="addException()"><cv:msg key="action.addNewSchedule" bundle="schedule" /></button> 
	   			<button id="exceptionsModal_button_#4190" type="button" class="btn btn-default margin-left-5" data-ng-show="showEdit && dayInMonthList.length" data-ng-click="editDayInMonthException()"><cv:msg key="action.edit" bundle="schedule" /></button> 
	   			</span>
	   			</div>
			</div>
		</div>
		<!-- // part 1 end // -->
		<!-- // part 2 start // -->
		<div class="form-group" data-ng-if="dayType=='weekInMonth'">
			<label class="col-xs-12 col-md-4 col-lg-4" for="isteven-multi-select2"><cv:msg key="label.selectWeekInMonth" bundle="schedule" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select id="exceptionsModal_isteven-multi-select_#0337" 
	   				  input-model="weekInMonth"
	   				  output-model="$parent.selectedWeeksInMonth"
	  				  button-label="label"
	  				  item-label="label"
	   				  tick-property="ticked"
	   				  prevent-sort="true"
	   				  is-disabled="dayType == 'dayInMonth'"
	   				  class="isteven-multi-select user-group-select"
	   				  directive-id="isteven-multi-select2"
	   				  max-labels="2" translation="localLang">
				</isteven-multi-select>
			</div>
		</div>
		<div class="form-group" data-ng-if="dayType=='weekInMonth'">
			<label class="col-xs-12 col-md-4 col-lg-4" for="isteven-multi-select3"><cv:msg key="label.selectDayInWeek" bundle="schedule" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
				<isteven-multi-select
	   				  input-model="dayInWeek"
	   				  output-model="$parent.selectedDaysInWeek"
	  				  button-label="label"
	  				  item-label="label"
	   				  tick-property="ticked"
	   				  prevent-sort="true"
	   				  is-disabled="dayType == 'dayInMonth'"
	   				  class="isteven-multi-select user-group-select"
	   				  id="isteven-multi-select3"
	   				  max-labels="2" translation="localLang">
				</isteven-multi-select>
	   			<span class="input-group-btn">
	   			<button id="exceptionsModal_button_#9370" type="button" class="btn btn-default margin-left-5" data-ng-show="!showEdit || !dayAndWeekList.length" data-ng-click="addException()"><cv:msg key="action.addNewSchedule" bundle="schedule" /></button> 
				<button id="exceptionsModal_button_#0741" type="button" class="btn btn-default margin-left-5" data-ng-show="showEdit && dayAndWeekList.length" data-ng-click="editExceptions()"><cv:msg key="action.edit" bundle="schedule" /></button> 
	   			</span>
	   			</div>
			</div>
		</div>
		<!-- // part 2 end // -->
		<div class="users-list limit-modal-height" >
			<ul class="schedules-list list-style__row group" data-ng-repeat="day in dayInMonthList track by $index">
				<li data-ng-if="dayInMonthList.length > 0"><a data-ng-click="editDayInMonth(day, $index)" class="schedule-ellipsis" title="On {{day.dayInMonth}}<cv:msg key="label.onDaysOfEachMonth" bundle="schedule" />"><cv:msg key="label.onDates" bundle="schedule" /> {{day.dayInMonth}} <cv:msg key="label.ofEachMonth" bundle="schedule" /></a>
				<span class="delete-row"><a href="javascript:void(0);" data-ng-click="removeDayInMonth(day, $index)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' />"><span class="k-icon k-i-close"></span></a></span></li>
			</ul>
			<ul class="schedules-list list-style__row group" data-ng-repeat="week in dayAndWeekList track by $index" title="<cv:msg key="label.onTheWeek" bundle="schedule" /> {{week.weekInMonthList}}: {{week.dayInWeekList}}">
				<li data-ng-if="dayAndWeekList.length > 0"><a data-ng-click="editWeekInMonth(week, $index)" class="schedule-ellipsis"><cv:msg key="label.onTheWeek" bundle="schedule" /> {{week.weekInMonthList}}:&nbsp;{{week.dayInWeekList}}</a>
				<span class="delete-row"><a href="javascript:void(0);" data-ng-click="removeWeekInMonth(week,$index)" title="<cv:msg key='label.removeContent' bundle='collectionsJs' />"><span class="k-icon k-i-close"></span></a></span></li>
			</ul>
		</div>
		<div class="button-container">
			<button id="exceptionsModal_button_#0919" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles" /></button> 
			<button id="exceptionsModal_button_#3497" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles" /></button> 
		</div>
	</form>
</div>
