import 'vsa/js/controllers/collections.ctrl.js';
import 'dlo/js/services/profile.svc.js';
import 'vsa/js/services/schedules.svc.js';

import { cvModuleScheduleModule } from 'common/js/modules';

var scheduleMod = cvModuleScheduleModule;
scheduleMod.constant('DaysOfWeek', {
	FRIDAY: 'FRIDAY'
});

scheduleMod.constant('FreqTypes', {
	WEEKLY: 'WEEKLY'
});

scheduleMod.factory('scheduleUIFactory', [
	'cvLoc',
	'$uibModal',
	'$location',
	'cvToaster',
	'$dialogs',
	'cvUtil',
	'SCHEDULE_PROPERTY',
	'$rootScope',
	'AppTypes',
	'DaysOfWeek',
	'FreqTypes',
	function(
		cvLoc,
		$modal,
		$location,
		cvToaster,
		$dialogs,
		cvUtil,
		SCHEDULE_PROPERTY,
		$rootScope,
		AppTypes,
		DaysOfWeek,
		FreqTypes
	) {
		var factory = {};
		var defaultEndTime = 86340;
		factory.addSchedule = function(
			schedule,
			showEdit,
			planSubType,
			dismissModal,
			planId,
			appType,
			attrs,
			rpo,
			emitOn,
			primaryRetentionDays,
			disablePrimaryRetentionDays
		) {
			if (schedule && schedule.model) {
				var model = schedule.model;
			}
			var modalInfo = {};

			// localization labels for muti-select options
			var daysOfWeek = [
				{
					name: cvLoc('label.day.mon'),
					value: 'MONDAY'
				},
				{
					name: cvLoc('label.day.tue'),
					value: 'TUESDAY'
				},
				{
					name: cvLoc('label.day.wed'),
					value: 'WEDNESDAY'
				},
				{
					name: cvLoc('label.day.thu'),
					value: 'THURSDAY'
				},
				{
					name: cvLoc('label.day.fri'),
					value: 'FRIDAY'
				},
				{
					name: cvLoc('label.day.sat'),
					value: 'SATURDAY'
				},
				{
					name: cvLoc('label.day.sun'),
					value: 'SUNDAY'
				}
			];

			var prefixDayList = [
				{
					label: cvLoc('label.first'),
					name: 'First',
					value: 1
				},
				{
					label: cvLoc('label.second'),
					name: 'Second',
					value: 2
				},
				{
					label: cvLoc('label.third'),
					name: 'Third',
					value: 3
				},
				{
					label: cvLoc('label.fourth'),
					name: 'Fourth',
					value: 4
				},
				{
					label: cvLoc('label.last'),
					name: 'Last',
					value: 5
				}
			];

			var days = [
				{
					label: cvLoc('label.day.sun'),
					name: 'Sunday',
					value: 1
				},
				{
					label: cvLoc('label.day.mon'),
					name: 'Monday',
					value: 2
				},
				{
					label: cvLoc('label.day.tue'),
					name: 'Tuesday',
					value: 3
				},
				{
					label: cvLoc('label.day.wed'),
					name: 'Wednesday',
					value: 4
				},
				{
					label: cvLoc('label.day.thu'),
					name: 'Thursday',
					value: 5
				},
				{
					label: cvLoc('label.day.fri'),
					name: 'Friday',
					value: 6
				},
				{
					label: cvLoc('label.day.sat'),
					name: 'Saturday',
					value: 7
				},
				{
					label: cvLoc('label.day'),
					name: 'Days',
					value: 8
				},
				{
					label: cvLoc('label.weekday'),
					name: 'Weekday',
					value: 9
				},
				{
					label: cvLoc('label.weekend'),
					name: 'Weekend Day',
					value: 10
				}
			];

			//default time for adding a new schedule
			var setDefaultTime = function() {
				var d = new Date();
				d.setHours(21);
				d.setMinutes(0);
				return d;
			};

			var isIncrementalSupported = function() {
				if (appType && appType == AppTypes.SQL_SERVER) {
					return false;
				}
				return true;
			};

			var isSyntheticFullSupported = function() {
				if (planSubType == 'Database' || (appType && (appType == AppTypes.SQL_SERVER || appType == AppTypes.NAS))) {
					return false;
				}
				return true;
			};

			var isDifferentialSupported = function() {
				if (planSubType == 'Database' || (appType && (appType == AppTypes.SQL_SERVER || appType == AppTypes.NAS))) {
					return true;
				}
				return false;
			};

			var isTransactionLogSupported = function() {
				if (appType && appType == AppTypes.SQL_SERVER) {
					return true;
				}
				return false;
			};

			var isCleanupSupported = function() {
				if (planSubType == 'Server') {
					return true;
				}
				return false;
			};

			var isContinuousRPOSupported = function() {
				if (
					planSubType &&
					(planSubType === 'Server' ||
						planSubType === 'FSServer' ||
						planSubType === 'Snap' ||
						planSubType === 'VSAServer' ||
						planSubType === 'VSAReplication')
				) {
					return true;
				}
				return false;
			};
			// To hide 'One-Time' schedule option from 'Subclient details' page
			var isOneTimeScheduleSupported = function() {
				if (angular.isDefined(planSubType)) {
					if (attrs && attrs.isSystemCreated) {
						return false; // To hide 'One-Time' schedule option for 'System created policies'
					}
					return true;
				}
				return false;
			};

			var isAutomaticScheduleApplicable = function() {
				if (appType && appType == AppTypes.SQL_SERVER) {
					return false;
				}
				if (planSubType == 'Database' || planSubType == 'Archiving') {
					return false;
				}
				// Automatic schedules is not applicable for vmoperationtype
				if (attrs && attrs.vmOperationType) {
					return false;
				}

				// Automatic schedules is not applicable for vmInfoList
				if (attrs && attrs.vmInfoList) {
					return false;
				}

				if (attrs && attrs.operationType && attrs.operationType === 'DRORCHESTRATION') {
					return false;
				}

				if (attrs && attrs.hideAutomaticSchedules) {
					return false;
				}

				return true;
			};

			if (model) {
				// EDIT schedule operation
				modalInfo = JSON.parse(angular.toJson(model)); // copy object
				modalInfo.opType = 'EDIT';
				// set default value
				modalInfo.days = days;
				modalInfo.prefixDayList = prefixDayList;
				if (modalInfo.freqType == 'DAILY' || modalInfo.freqType == 'WEEKLY') {
					var d = new Date();
					d.setHours(modalInfo.dailyBackupHours);
					d.setMinutes(modalInfo.dailyBackupMinutes);
					modalInfo.scheduleTime = d;
					if (model.scheduleTime) {
						modalInfo.scheduleTime = model.scheduleTime;
					}
					if (model.repeat) {
						modalInfo.repeat = angular.copy(model.repeat);
						if (typeof model.repeat.time == 'number') {
							modalInfo.repeat.time = cvUtil.convertCvTimeToDate(model.repeat.time);
						}
					} else {
						modalInfo.repeat = {
							enabled: model.repeatEnabled,
							duration: model.repeatDuration,
							hrs: model.repeatHrs,
							mins: model.repeatMins,
							time: cvUtil.convertCvTimeToDate(model.repeatTime)
						};
					}
					modalInfo.dayOfMonth = 1;
					modalInfo.dayOfWeek = days[0];
					modalInfo.weekOfMonth = prefixDayList[0];

					modalInfo.repeatExpcetion = model.repeatException;
				} else if (modalInfo.freqType == 'AUTOMATIC_SCHEDULE') {
					modalInfo.minBackupIntervalHours = model.minBackupIntervalHours;
					modalInfo.minBackupIntervalMinutes = model.minBackupIntervalMinutes;
					modalInfo.maxBackupIntervalHours = model.maxBackupIntervalHours;
					modalInfo.maxBackupIntervalMinutes = model.maxBackupIntervalMinutes;
					modalInfo.autoSchedulePattern = model.autoSchedulePattern;
					if (modalInfo.backupLevel == 'SYNTHETIC_FULL') {
						modalInfo.daysBetweenSyntheticBackup = model.daysBetweenSyntheticBackup;
					} else {
						modalInfo.minSyncIntervalHours = model.minSyncIntervalHours;
						modalInfo.minSyncIntervalMinutes = model.minSyncIntervalMinutes;
						modalInfo.ignoreAtMaxInterval = model.ignoreAtMaxInterval;
						modalInfo.useOnlyWiredWork = model.useOnlyWiredWork;
						modalInfo.minNetworkBandwidth = model.minNetworkBandwidth;
						modalInfo.networkBandwidth = model.networkBandwidth;
						modalInfo.useSpecificNetwork = model.useSpecificNetwork;
						modalInfo.specificNetworkNumber = model.specificNetworkNumber;
						modalInfo.specificNetworkIp = model.specificNetworkIp;
						modalInfo.startOnlyOnAc = model.startOnlyOnAc;
						modalInfo.stopIfBatteryMode = model.stopIfBatteryMode;
						modalInfo.preventSleep = model.preventSleep;
						modalInfo.cpuBelowThresholdEnabled = model.cpuBelowThresholdEnabled;
						modalInfo.cpuBelowThreshold = model.cpuBelowThreshold;
						modalInfo.startOnlyfileBackUp = model.startOnlyfileBackUp;
						modalInfo.changeStopTask = function() {
							modalInfo.stopIfBatteryMode = false;
						};
					}
					modalInfo.scheduleTime = setDefaultTime();
					modalInfo.repeat = {
						enabled: false,
						duration: 1,
						hrs: 8,
						mins: 0,
						time: cvUtil.convertCvTimeToDate(defaultEndTime)
					};
					modalInfo.dayOfMonth = 1;
					modalInfo.dayOfWeek = days[0];
					modalInfo.weekOfMonth = prefixDayList[0];
				} else if (modalInfo.freqType == 'MONTHLY') {
					var d = new Date();
					d.setHours(modalInfo.dailyBackupHours);
					d.setMinutes(modalInfo.dailyBackupMinutes);
					modalInfo.scheduleTime = d;
					modalInfo.dayOfMonth = model.dayOfMonth;
					modalInfo.dayOfWeek = days[0];
					modalInfo.weekOfMonth = prefixDayList[0];
					if (model.repeat) {
						modalInfo.repeat = angular.copy(model.repeat);
						if (typeof model.repeat.time == 'number') {
							modalInfo.repeat.time = cvUtil.convertCvTimeToDate(model.repeat.time);
						}
					} else {
						modalInfo.repeat = {
							enabled: model.repeatEnabled,
							duration: model.repeatDuration,
							hrs: model.repeatHrs,
							mins: model.repeatMins,
							time: cvUtil.convertCvTimeToDate(model.repeatTime)
						};
					}
					modalInfo.repeatExpcetion = model.repeatException;
				} else if (modalInfo.freqType == 'MONTHLY_RELATIVE') {
					var d = new Date();
					d.setHours(modalInfo.dailyBackupHours);
					d.setMinutes(modalInfo.dailyBackupMinutes);
					modalInfo.scheduleTime = d;
					modalInfo.dayOfMonth = 1;
					modalInfo.dayOfWeek = days[model.dayOfWeek - 1];
					modalInfo.weekOfMonth = prefixDayList[model.weekOfMonth - 1];
					if (model.repeat) {
						modalInfo.repeat = angular.copy(model.repeat);
						if (typeof model.repeat.time == 'number') {
							modalInfo.repeat.time = cvUtil.convertCvTimeToDate(model.repeat.time);
						}
					} else {
						modalInfo.repeat = {
							enabled: model.repeatEnabled,
							duration: model.repeatDuration,
							hrs: model.repeatHrs,
							mins: model.repeatMins,
							time: cvUtil.convertCvTimeToDate(model.repeatTime)
						};
					}
					modalInfo.repeatExpcetion = model.repeatException;
				} else if (modalInfo.freqType == 'YEARLY') {
					var d = new Date();
					d.setHours(modalInfo.dailyBackupHours);
					d.setMinutes(modalInfo.dailyBackupMinutes);
					modalInfo.scheduleTime = d;
					modalInfo.dayOfMonth = model.dayOfMonth;
					modalInfo.dayOfWeek = days[0];
					modalInfo.weekOfMonth = prefixDayList[0];
					if (model.repeat) {
						modalInfo.repeat = angular.copy(model.repeat);
						if (typeof model.repeat.time == 'number') {
							modalInfo.repeat.time = cvUtil.convertCvTimeToDate(model.repeat.time);
						}
					} else {
						modalInfo.repeat = {
							enabled: model.repeatEnabled,
							duration: model.repeatDuration,
							hrs: model.repeatHrs,
							mins: model.repeatMins,
							time: cvUtil.convertCvTimeToDate(model.repeatTime)
						};
					}
					modalInfo.repeatExpcetion = model.repeatException;
					modalInfo.monthName = moment.months()[modalInfo.monthOfYear - 1];
				} else if (modalInfo.freqType == 'YEARLY_RELATIVE') {
					var d = new Date();
					d.setHours(modalInfo.dailyBackupHours);
					d.setMinutes(modalInfo.dailyBackupMinutes);
					modalInfo.scheduleTime = d;
					modalInfo.dayOfMonth = 1;
					modalInfo.dayOfWeek = days[model.dayOfWeek - 1];
					modalInfo.weekOfMonth = prefixDayList[model.weekOfMonth - 1];
					if (model.repeat) {
						modalInfo.repeat = angular.copy(model.repeat);
						if (typeof model.repeat.time == 'number') {
							modalInfo.repeat.time = cvUtil.convertCvTimeToDate(model.repeat.time);
						}
					} else {
						modalInfo.repeat = {
							enabled: model.repeatEnabled,
							duration: model.repeatDuration,
							hrs: model.repeatHrs,
							mins: model.repeatMins,
							time: cvUtil.convertCvTimeToDate(model.repeatTime)
						};
					}
					modalInfo.repeatExpcetion = model.repeatException;
					modalInfo.monthName = moment.months()[modalInfo.monthOfYear - 1];
				} else if (modalInfo.freqType == 'ONE_TIME') {
					var hrs = model.activeStartTime / 60 / 60,
						mins = (model.activeStartTime / 60) % 60,
						d = new Date();
					d.setHours(hrs);
					d.setMinutes(mins);
					modalInfo.scheduleTime = d;

					var d = new Date(0);
					d.setUTCSeconds(model.active_start_date);
					modalInfo.fromDate = d;
					// To handle 'repeat', if a 'one-time' schedule is edited and changed to Daily/Weekly/Monthly
					modalInfo.repeat = {
						enabled: false,
						duration: 1,
						hrs: 8,
						mins: 0,
						time: cvUtil.convertCvTimeToDate(defaultEndTime)
					};
					modalInfo.dayOfMonth = 1;
					modalInfo.dayOfWeek = days[0];
					modalInfo.weekOfMonth = prefixDayList[0];
				} else if (modalInfo.freqType == 'AFTER_JOB_COMPLETES') {
					//modalInfo is used to two way bind with modal datavalues
					if (model.repeat) {
						modalInfo.repeat = angular.copy(model.repeat);
						if (typeof model.repeat.time == 'number') {
							modalInfo.repeat.time = cvUtil.convertCvTimeToDate(model.repeat.time);
						}
					} else {
						modalInfo.repeat = {
							enabled: model.repeatEnabled,
							duration: model.repeatDuration,
							hrs: model.repeatHrs,
							mins: model.repeatMins,
							time: cvUtil.convertCvTimeToDate(model.repeatTime)
						};
					}
					modalInfo.flags = model.flags;
					// if (rpo && angular.isDefined(rpo)) {
					// 	model.freq_interval = rpo * 60;
					// }
					modalInfo.freq_interval = model.freq_interval;
				}
				if (model.daysToRun && model.daysToRun.length > 0) {
					for (var i = 0; i < model.daysToRun.length; i++) {
						if (model.daysToRun[i]) {
							daysOfWeek[i].ticked = true;
						}
					}
				}
				modalInfo.daysOfWeek = daysOfWeek;

				if (model.hideDelete) {
					modalInfo.hideDelete = true;
				}

				//				if (model.hideGranularRecovery) {
				//					modalInfo.hideGranularRecovery = true;
				//				}

				if (showEdit == undefined) {
					modalInfo.showEdit = true;
				} else {
					modalInfo.showEdit = showEdit;
				}
			} else {
				// New ADD operation
				modalInfo = {
					opType: 'ADD',
					name: '',
					daysOfWeek: daysOfWeek,
					backupLevel: 'INCREMENTAL',
					operationType: 'BACKUP',
					subTaskType: 'BACKUP',
					//'collectMetadata': false,
					flags: 0,
					minBackupIntervalHours: 36,
					minBackupIntervalMinutes: 0,
					maxBackupIntervalHours: 72,
					maxBackupIntervalMinutes: 0,
					freq_interval: 30, //this is for continous frequencyType
					scheduleTime: setDefaultTime(),
					showEdit: true,
					planSubType: planSubType,
					dayOfMonth: 1,
					weekOfMonth: prefixDayList[0],
					dayOfWeek: days[0],
					days: days,
					prefixDayList: prefixDayList,
					repeat: {
						enabled: false,
						duration: 1,
						hrs: 8,
						mins: 0,
						time: cvUtil.convertCvTimeToDate(defaultEndTime)
					},
					repeatException: []
				};

				if (appType && appType == AppTypes.SQL_SERVER) {
					modalInfo.backupLevel = 'FULL';
				}

				if (modalInfo.planSubType == AppTypes.VAULT_TRACKER) {
					modalInfo.backupLevel = AppTypes.VAULT_TRACKER;
					// Weekly
					const default_Time = new Date();
					default_Time.setHours(8);
					default_Time.setMinutes(0);
					modalInfo.scheduleTime = default_Time;
					// day of week: FRIDAY
					modalInfo.daysOfWeek = daysOfWeek.map(day =>
						day.value === DaysOfWeek.FRIDAY ? { ...day, ticked: true } : { ...day }
					);
				}

				//if auto schedule supported, make auto schedule as default
				if (isAutomaticScheduleApplicable()) {
					modalInfo.freqType = 'AUTOMATIC_SCHEDULE';
					modalInfo.daysBetweenSyntheticBackup = 30;
					modalInfo.minSyncIntervalHours = 0;
					modalInfo.minSyncIntervalMinutes = 2;
					modalInfo.ignoreAtMaxInterval = false;
					modalInfo.useOnlyWiredWork = false;
					modalInfo.minNetworkBandwidth = false;
					modalInfo.networkBandwidth = 128;
					modalInfo.useSpecificNetwork = false;
					modalInfo.specificNetworkIp = '0.0.0.0';
					modalInfo.specificNetworkNumber = 24;
					modalInfo.startOnlyOnAc = false;
					modalInfo.stopIfBatteryMode = false;
					modalInfo.preventSleep = false;
					modalInfo.cpuBelowThresholdEnabled = false;
					modalInfo.cpuBelowThreshold = 10;
					modalInfo.startOnlyfileBackUp = false;
					modalInfo.changeStopTask = function() {
						modalInfo.stopIfBatteryMode = false;
					};
				} else {
					modalInfo.freqType = 'DAILY';
				}

				if (
					schedule.source == 'createProfile' ||
					schedule.source == 'editProfile' ||
					schedule.source == 'dr' ||
					schedule.source == 'replication'
				) {
					modalInfo.id = Date.now();
				}
			}

			var tempUrl = 'modules/schedule/partials/addScheduleModal.jsp';
			if (modalInfo.flags === SCHEDULE_PROPERTY.SLA_FLAG && planSubType == 'Database') {
				tempUrl = 'modules/schedule/partials/addSlaScheduleModal.jsp';
			}
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + tempUrl,
				backdrop: 'static',
				controller: [
					'$scope',
					'$log',
					'$uibModalInstance',
					'cvLoc',
					'cvUtil',
					'model',
					'$rootScope',
					'dismissModal',
					'planId',
					'attrs',
					'SCHEDULE_PROPERTY',
					'rpo',
					'$state',
					'primaryRetentionDays',
					'disablePrimaryRetentionDays',
					'cvEntitySelectionTreeComponent',
					'AppTypes',
					function(
						$scope,
						$log,
						$modalInstance,
						cvLoc,
						cvUtil,
						model,
						$rootScope,
						dismissModal,
						planId,
						attrs,
						SCHEDULE_PROPERTY,
						rpo,
						$state,
						primaryRetentionDays,
						disablePrimaryRetentionDays,
						cvEntitySelectionTreeComponent,
						AppTypes
					) {
						$scope.isScheduleSettings = _.get(schedule, 'model.scheduleSettings');
						if (schedule.isInstallUpdateSchedule) {
							$scope.accordionStatus = {
								serversList: false
							};
							$scope.treeParams = {
								initialSelections: [],
								initialExclusions: [],
								result: {},
								mode: 'edit'
							};

							$scope.isInstallUpdateSchedule = schedule.isInstallUpdateSchedule;

							if (schedule.model && schedule.model.selectedServers) {
								$scope.treeParams = cvEntitySelectionTreeComponent.populateTreeParams(schedule.model.selectedServers);
							}

							if (schedule.model) {
								$scope.treeParams.isShowSelectedByDefault = true;
							}

							$scope.treeParams.enableInstallUpdate = true;

							$scope.treeParams.isNodeApplicable = function(node) {
								if (node.entity.entityTypeName == 'CLIENT_ENTITY') {
									node.noChild = true;
									node.childrenLoaded = true;
								}
								return true;
							};
						}

						$scope.nonBackupSchedule = attrs && attrs.policyId ? true : false; //Disable save button for secondary schedule
						$scope.disablePrimaryRetentionDays = disablePrimaryRetentionDays;
						$scope.specificNetworkMessage = `<div>${cvLoc('info.help.specificNetworkMessage')}</div>`;
						// The values from the attrs are used to modify the modalinfo object
						if (attrs) {
							if (attrs.hideBackupLevelOptions) {
								modalInfo.backupLevel = 'NONE';
							}

							if (attrs.operationType) {
								modalInfo.operationType = attrs.operationType;
							}

							if (attrs.subTaskType) {
								modalInfo.subTaskType = attrs.subTaskType;
							}

							if (attrs.vmOperationType) {
								modalInfo.vmOperationType = attrs.vmOperationType;
							}

							if (attrs.vmInfoList) {
								modalInfo.vmInfoList = attrs.vmInfoList;
							}

							dismissModal = attrs.dismissModal ? attrs.dismissModal : dismissModal || false;
							modalInfo.context = attrs.context;
							modalInfo.hideTimeInCommServeTimezone = attrs.hideTimeInCommServeTimezone || false;
						}

						// handle isteven mutiselect scroll bar in firefox
						var browser = window.navigator.userAgent;
						var browserName;
						if (browser.indexOf('Firefox') != -1) {
							browserName = 'Firefox';
						}
						function preventDefault(e) {
							e = e || window.event;
							if (e.preventDefault) {
								e.preventDefault();
							}
							e.returnValue = false;
						}

						function disableScroll() {
							window.onwheel = preventDefault; // modern standard
							window.onmousewheel = document.onmousewheel = preventDefault; // older browsers, IE
							window.onmousedown = preventDefault;
						}
						$scope.fOpen = function() {
							disableScroll();
							var marginTop = 2;
							var cbx = angular.element('.checkboxLayer');
							var p = cbx.parent();
							if (browserName != 'Firefox') {
								while (true) {
									if (p && p.length) {
										var scrollTop = p.prop('scrollTop');
										if (scrollTop) {
											marginTop -= scrollTop;
										}
										p = angular.element(p).parent();
									} else {
										break;
									}
								}
							}
							cbx.css('margin-top', marginTop + 'px');
						};
						$scope.fClose = function() {
							window.onmousewheel = document.onmousewheel = null;
							window.onwheel = null;
							window.onmousedown = null;
						};

						// get isteven localizations
						$scope.localLang = cvUtil.getIStevenLocLabels();
						$scope.model = model;
						$scope.model.isVaultTrackerPlan = $scope.model.planSubType === AppTypes.VAULT_TRACKER;

						if ($scope.model.isVaultTrackerPlan && $scope.model.opType !== 'EDIT') {
							model.freqType = FreqTypes.WEEKLY;
						}

						//check if it is SLA schedule
						if ($scope.model.flags === SCHEDULE_PROPERTY.SLA_FLAG) {
							$scope.isSlaSchedule = true;
							$scope.model.repeat.enabled = true;
							if (_.get($scope, 'model.planSubType') !== 'Laptop') {
								$scope.model.showEdit = false;
							} else {
								$scope.isLaptopPlan = true;
								$scope.isScheduleSettings = true;
								$scope.backupIntervalLimits = {
									maxHours: 168, // 167?
									maxMinutes: 59
								};
							}
							if ($scope.model.isLogSla || (model.freqType === 'AUTOMATIC_SCHEDULE' && planSubType === 'Database')) {
								// Log SLA will be automatic only
								$scope.islogSlaSchedule = true;
								if ($scope.model.slaTime) {
									model.repeat.hrs = $scope.model.slaTime.hrs;
									model.repeat.mins = $scope.model.slaTime.mins;

									$scope.model.maxBackupIntervalMinutes = $scope.model.slaTime.mins;
									$scope.model.maxBackupIntervalHours = $scope.model.slaTime.hrs;
								} else {
									model.repeat.hrs = $scope.model.maxBackupIntervalHours;
									model.repeat.mins = $scope.model.maxBackupIntervalMinutes;
								}
							} else if (rpo) {
								model.repeat.hrs = rpo;
								//convert rpo minutes to hours and minutes in automatic schedule
								if (model.freqType === 'AUTOMATIC_SCHEDULE') {
									if (planSubType === 'Laptop') {
										$scope.isMinBackupIntervalHoursReadOnly = true;
										$scope.model.minBackupIntervalMinutes = rpo % 60;
										$scope.model.minBackupIntervalHours = (rpo - $scope.model.minBackupIntervalMinutes) / 60;
									} else {
										$scope.model.maxBackupIntervalMinutes = rpo % 60;
										$scope.model.maxBackupIntervalHours = (rpo - $scope.model.maxBackupIntervalMinutes) / 60;
									}
								}
							}
						}

						//handle synthetic backup and automatical schedule
						if (primaryRetentionDays && planSubType != 'Snap') {
							$scope.model.daysBetweenSyntheticBackup = primaryRetentionDays > 90 ? 90 : primaryRetentionDays;
						}

						// hide backup level for AUX_COPY
						if ($scope.model.operationType == 'AUX_COPY') {
							$scope.model.backupLevel = 'NONE';
							//$scope.model.hideGranularRecovery = true;
							$scope.model.hideDelete = true;
							if ($scope.model.isSystemAutoCopy) {
								$scope.model.showEdit = false;
							}
						}

						if (model.isScheduleFromPolicy) {
							$scope.model.hideDelete = true;
						}

						$scope.ipPattern =
							'^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$';
						if (attrs && angular.isString(attrs.customTitle) && attrs.customTitle.length > 0) {
							$scope.title = attrs.customTitle;
						} else {
							if ($scope.model.opType == 'EDIT') {
								$scope.title = $scope.model.showEdit
									? cvLoc('label.editSchedule')
									: $scope.model.isSystemAutoCopy
									? cvLoc('header.viewSchedule')
									: cvLoc('header.scheduleDetails');
							} else {
								$scope.title = cvLoc('label.addSchedule');
							}
						}

						//					if (!model.hideGranularRecovery && (planSubType === 'VSAServer' || planSubType === 'VSAReplication' || planSubType === 'Snap')) {
						//						$scope.showGranularRecovery = true;
						//					}
						if (planSubType === 'Archiving') {
							model.backupLevel = 'NONE';
							$scope.model.hideDelete = false;
						}

						// set default time and disable past dates for 'One-Time' schedule
						$scope.model.scheduleTime = model.scheduleTime;
						$scope.model.fromDate = model.fromDate ? model.fromDate : new Date();
						$scope.model.options = {
							minDate: new Date(),
							showWeeks: false
						};

						$scope.isIncrementalSupported = isIncrementalSupported();
						$scope.isSyntheticFullSupported = isSyntheticFullSupported();
						$scope.isDifferentialSupported = isDifferentialSupported();
						$scope.isTransactionLogSupported = isTransactionLogSupported();
						$scope.isAutomaticScheduleApplicable = isAutomaticScheduleApplicable();
						$scope.isCleanupSupported = isCleanupSupported();
						$scope.isContinuousRPOSupported = isContinuousRPOSupported();
						$scope.isWorkflowSchedule = attrs && attrs.operationType === 'WORK_FLOW' ? true : false;
						$scope.isOneTimeScheduleSupported =
							isOneTimeScheduleSupported() ||
							$scope.model.planSubType === AppTypes.VAULT_TRACKER ||
							$scope.isWorkflowSchedule;

						if ($scope.isWorkflowSchedule && modalInfo.opType === 'ADD') {
							$scope.model.freqType = 'DAILY';
						}

						//frequent Array
						$scope.freqArr = [
							{ label: cvLoc('option.daily'), value: 'DAILY' },
							{ label: cvLoc('option.weekly'), value: 'WEEKLY' },
							{
								label: cvLoc('option.monthly'),
								value: $scope.model.freqType === 'MONMONTHLY_RELATIVE' ? $scope.model.freqType : 'MONTHLY'
							}
						];

						if (
							$scope.isAutomaticScheduleApplicable &&
							!$scope.model.isVaultTrackerPlan &&
							!$scope.isWorkflowSchedule
						) {
							$scope.freqArr.unshift({ label: cvLoc('option.automatic'), value: 'AUTOMATIC_SCHEDULE' });
						}

						if ($scope.isOneTimeScheduleSupported || $scope.isWorkflowSchedule === true) {
							$scope.freqArr.unshift({ label: cvLoc('option.oneTime'), value: 'ONE_TIME' });
						}

						if ($scope.isContinuousRPOSupported || $scope.isWorkflowSchedule === true) {
							$scope.freqArr.push({ label: cvLoc('option.continous'), value: 'AFTER_JOB_COMPLETES' });
						}

						$scope.freqArr.forEach(ele => {
							if ($scope.model.freqType === ele.value) {
								ele.selected = true;
							}
						});

						$scope.cancel = function() {
							$modalInstance.dismiss();
						};

						$scope.selectFreq = function(data) {
							$scope.model.freqType = data.value;
						};

						//SAVE schedule operation
						$scope.addSchedule = function() {
							$scope.addScheduleServerMessage = cvUtil.emptyMsg();
							var errorMessage = validateScheduleModel();
							if (errorMessage) {
								$scope.addScheduleServerMessage = errorMessage;
								return;
							}

							var objToSend = {};
							objToSend.name = $scope.model.name;
							objToSend.freqType = $scope.model.freqType;
							objToSend.autoConvertBackupLevel = $scope.model.autoConvertBackupLevel;
							objToSend.backupLevel = $scope.model.backupLevel;
							//objToSend.collectMetadata = $scope.model.collectMetadata;
							objToSend.opType = $scope.model.opType;
							objToSend.id = $scope.model.id;
							objToSend.taskId = $scope.model.taskId;
							objToSend.subtaskId = $scope.model.subtaskId;
							objToSend.planSubType = $scope.model.planSubType;
							objToSend.operationType = $scope.model.operationType;
							objToSend.subTaskType = $scope.model.subTaskType;
							objToSend.flags = $scope.model.flags;
							objToSend.vmOperationType = $scope.model.vmOperationType;
							objToSend.vmInfoList = $scope.model.vmInfoList;
							objToSend.drOrchestrationOption = $scope.model.drOrchestrationOption;
							objToSend.calendar = $scope.model.calendar;
							objToSend.timeZone = $scope.model.timeZone;
							objToSend.active_end_occurence = $scope.model.active_end_occurence;
							objToSend.active_end_date = $scope.model.active_end_date;
							objToSend.active_start_date = $scope.model.active_start_date;
							objToSend.active_start_time = $scope.model.activeStartTime;
							objToSend.activeStartTime = $scope.model.activeStartTime;

							// Setting time zone as client time zone for operation type backup
							// in add/modify schedules associated to plan modal
							if (!$scope.model.hideTimeInCommServeTimezone && objToSend.operationType === 'BACKUP') {
								objToSend.timeZone = { TimeZoneID: 1001 };
							}

							//convert repeat time pattern
							function sendingRepeat(model) {
								var hours = model.repeat.time.getHours();
								var mins = model.repeat.time.getMinutes();
								objToSend.repeatTime = hours * 60 * 60 + mins * 60;
								objToSend.repeatEnabled = model.repeat.enabled;
								objToSend.repeatDuration = model.repeat.duration;
								objToSend.repeatHrs = !_.isUndefined(model.repeat.hrs) ? model.repeat.hrs : 8;
								objToSend.repeatMins = !_.isUndefined(model.repeat.mins) ? model.repeat.mins : 0;
							}

							if ($scope.model.hideDelete) {
								objToSend.hideDelete = true;
							}
							if ($scope.model.freqType == 'AUTOMATIC_SCHEDULE') {
								objToSend.minBackupIntervalHours = $scope.model.minBackupIntervalHours;
								objToSend.minBackupIntervalMinutes = $scope.model.minBackupIntervalMinutes;
								objToSend.maxBackupIntervalHours = $scope.model.maxBackupIntervalHours;
								objToSend.maxBackupIntervalMinutes = $scope.model.maxBackupIntervalMinutes;
								//Add validation that rpo time can not be less than min. job interval in automatic schedule
								if (planSubType !== 'Laptop' && rpo) {
									var minJobIntervalMinutes =
										objToSend.minBackupIntervalHours * 60 + objToSend.minBackupIntervalMinutes;
									if (rpo < minJobIntervalMinutes) {
										$scope.addScheduleServerMessage = {
											message: cvLoc('error.rpoLessThanMinJob'),
											type: 'error'
										};
										return;
									}
								}
								if ($scope.model.isLogSla || (model.freqType === 'AUTOMATIC_SCHEDULE' && planSubType === 'Database')) {
									objToSend.isLogSla = $scope.model.isLogSla;
									objToSend.slaTime = $scope.model.slaTime;
									objToSend.automaticSchedulePattern = $scope.model.automaticSchedulePattern;
								} else if ($scope.model.backupLevel == 'SYNTHETIC_FULL') {
									objToSend.daysBetweenSyntheticBackup = $scope.model.daysBetweenSyntheticBackup;
								} else {
									objToSend.startOnlyOnAc = $scope.model.startOnlyOnAc;
									objToSend.stopIfBatteryMode = $scope.model.stopIfBatteryMode;
									objToSend.cpuBelowThresholdEnabled = $scope.model.cpuBelowThresholdEnabled;
									objToSend.minSyncIntervalHours = $scope.model.minSyncIntervalHours;
									objToSend.minSyncIntervalMinutes = $scope.model.minSyncIntervalMinutes;
									objToSend.ignoreAtMaxInterval = $scope.model.ignoreAtMaxInterval;
									objToSend.useOnlyWiredWork = $scope.model.useOnlyWiredWork;
									objToSend.minNetworkBandwidth = $scope.model.minNetworkBandwidth;
									objToSend.networkBandwidth = $scope.model.networkBandwidth;
									objToSend.useSpecificNetwork = $scope.model.useSpecificNetwork;
									objToSend.specificNetworkIp = $scope.model.specificNetworkIp;
									objToSend.specificNetworkNumber = $scope.model.specificNetworkNumber;
									objToSend.preventSleep = $scope.model.preventSleep;
									objToSend.cpuBelowThresholdEnabled = $scope.model.cpuBelowThresholdEnabled;
									objToSend.cpuBelowThreshold = $scope.model.cpuBelowThreshold;
									objToSend.startOnlyfileBackUp = $scope.model.startOnlyfileBackUp;
									objToSend.changeStopTask = function() {
										objToSend.stopIfBatteryMode = false;
									};
								}
							} else if ($scope.model.freqType == 'DAILY') {
								objToSend.dailyBackupHours = $scope.model.scheduleTime.getHours();
								objToSend.dailyBackupMinutes = $scope.model.scheduleTime.getMinutes();

								// calculate seconds after midnight
								objToSend.activeStartTime = objToSend.dailyBackupHours * 60 * 60 + objToSend.dailyBackupMinutes * 60;

								sendingRepeat($scope.model);
								objToSend.repeatException = $scope.model.repeatException;
							} else if ($scope.model.freqType == 'WEEKLY') {
								var daysOfWeekToSend = [];
								objToSend.daysToRun = [];
								for (var i = 0; i < $scope.model.daysOfWeek.length; i++) {
									if ($scope.model.daysOfWeek[i].ticked == true) {
										daysOfWeekToSend.push($scope.model.daysOfWeek[i].value);
										objToSend.daysToRun.push(true);
									} else {
										objToSend.daysToRun.push(false);
									}
								}
								if (daysOfWeekToSend.length == 0) {
									$scope.addScheduleServerMessage = {
										message: cvLoc('label.selectDay'),
										type: 'error'
									};
									return;
								}
								objToSend.dailyBackupHours = $scope.model.scheduleTime.getHours();
								objToSend.dailyBackupMinutes = $scope.model.scheduleTime.getMinutes();
								// calculate seconds after midnight
								objToSend.activeStartTime = objToSend.dailyBackupHours * 60 * 60 + objToSend.dailyBackupMinutes * 60;
								//objToSend.dayOfWeek = daysOfWeekToSend;
								sendingRepeat($scope.model);
								objToSend.repeatException = $scope.model.repeatException;
							} else if ($scope.model.freqType == 'MONTHLY') {
								objToSend.dayOfMonth = $scope.model.dayOfMonth;
								objToSend.dailyBackupHours = $scope.model.scheduleTime.getHours();
								objToSend.dailyBackupMinutes = $scope.model.scheduleTime.getMinutes();
								// calculate
								// seconds
								// after
								// midnight
								objToSend.activeStartTime = objToSend.dailyBackupHours * 60 * 60 + objToSend.dailyBackupMinutes * 60;
								sendingRepeat($scope.model);
								objToSend.repeatException = $scope.model.repeatException;
							} else if ($scope.model.freqType == 'MONTHLY_RELATIVE') {
								objToSend.weekOfMonth = $scope.model.weekOfMonth.value;
								objToSend.dayOfWeek = $scope.model.dayOfWeek.value;
								objToSend.dailyBackupHours = $scope.model.scheduleTime.getHours();
								objToSend.dailyBackupMinutes = $scope.model.scheduleTime.getMinutes();
								// calculate
								// seconds
								// after
								// midnight
								objToSend.activeStartTime = objToSend.dailyBackupHours * 60 * 60 + objToSend.dailyBackupMinutes * 60;
								sendingRepeat($scope.model);
								objToSend.repeatException = $scope.model.repeatException;
							} else if ($scope.model.freqType == 'AFTER_JOB_COMPLETES') {
								objToSend.activeStartTime = $scope.model.freq_interval * 60;
								objToSend.freq_interval = $scope.model.freq_interval;
							} else if ($scope.model.freqType == 'ONE_TIME') {
								if (!angular.isDefined($scope.model.fromDate) || !angular.isDefined($scope.model.scheduleTime)) {
									$scope.addScheduleServerMessage = {
										message: cvLoc('error.selectTime'),
										type: 'error'
									};
									return;
								}

								objToSend.active_start_date =
									moment($scope.model.fromDate).unix() - moment($scope.model.fromDate)._d.getTimezoneOffset() * 60; // added timezone offset
								objToSend.activeStartTime =
									$scope.model.scheduleTime.getHours() * 60 * 60 + $scope.model.scheduleTime.getMinutes() * 60;
							}

							if ($scope.isInstallUpdateSchedule) {
								objToSend.selectedServers = cvEntitySelectionTreeComponent.getAssociations($scope.treeParams);

								if (objToSend.opType == 'EDIT') {
									$scope.$emit('installUpdateScheduleEdited', objToSend);
								} else {
									$scope.$emit('installUpdateScheduleAdded', objToSend);
								}
							}

							if (emitOn) {
								$scope.$emit(emitOn, objToSend);
							} else if (objToSend.opType == 'EDIT') {
								//planId is for AC setup add schedule
								if (planId) {
									$scope.$emit('scheduleEdited', objToSend, planId);
								} else {
									if ($scope.nonBackupSchedule) {
										$scope.$emit('secondaryScheduleEdited', objToSend);
									} else {
										$scope.$emit('scheduleEdited', objToSend);
									}
								}
							} else {
								if (planId) {
									$scope.$emit('scheduleAdded', objToSend, planId);
								} else {
									$scope.$emit('scheduleAdded', objToSend);
								}
							}

							if (dismissModal) {
								$rootScope.$on('scheduleDataChanged', function() {
									$modalInstance.dismiss();
								});
							} else {
								if ($scope.isAPICall === true) {
									return;
								}

								$modalInstance.dismiss();
							}
							$rootScope.$on('editScheduleFailed', function(evt, err) {
								$scope.addScheduleServerMessage = cvUtil.errMsg(err);
							});
						};

						$rootScope.$on('exceptionsAdded', function(evt, exceptions) {
							$scope.exceptionsList = exceptions;
							$scope.repeatException = [];
							exceptions.dayInMonthList.map(function(day) {
								var daysObj = {
									days: [],
									exception: true
								};
								daysObj.days = day.dayInMonth;
								$scope.repeatException.push(daysObj);
							});

							exceptions.dayAndWeekList.map(function(week) {
								var obj = {
									onDays: [],
									onWeek: [],
									exception: true
								};
								obj.onDays = week.dayInWeekList;
								obj.onWeek = week.weekInMonthList;
								for (var i in obj.onDays) {
									if (obj.onDays[i] == 'WEEKDAY') {
										obj.onDays[i] = 'WEEKDAYS';
									}
									if (obj.onDays[i] == 'WEEKEND DAY') {
										obj.onDays[i] = 'WEEKEND_DAYS';
									}
								}
								$scope.repeatException.push(obj);
							});
							$scope.model.repeatException = $scope.repeatException;
						});

						$scope.deleteSchedule = function() {
							if ($scope.isInstallUpdateSchedule) {
								$scope.$emit('installUpdateScheduleDeleted', $scope.model.taskId);
							}
							var scheduleDeleted = 'scheduleDeleted';
							if ($scope.model.planSubType == 'Database' && $scope.model.scheduleType) {
								scheduleDeleted = scheduleDeleted + $scope.model.scheduleType;
							}
							$scope.$emit(scheduleDeleted, $scope.model);
							$modalInstance.dismiss();
						};

						$scope.openExceptionsModal = function() {
							$modal.open({
								templateUrl: appUtil.appRoot + 'modules/schedule/partials/exceptionsModal.jsp',
								windowClass: 'small-size',
								backdrop: 'static',
								controller: [
									'$scope',
									'$uibModalInstance',
									'prefixDayList',
									'days',
									'exceptionsList',
									'cvUtil',
									'repeatException',
									function($scope, $modalInstance, prefixDayList, days, exceptionsList, cvUtil, repeatException) {
										$scope.exceptionMessage = cvUtil.emptyMsg();
										//get isteven label localization
										$scope.localLang = cvUtil.getIStevenLocLabels();
										prefixDayList.map(function(data) {
											data.name = data.name.toUpperCase();
										});
										days.map(function(data) {
											data.name = data.name.toUpperCase();
										});
										$scope.dayInMonthList = [];
										$scope.dayAndWeekList = [];
										if (!repeatException) {
											repeatException = [];
										}
										repeatException.map(function(ex) {
											if (ex.days) {
												ex.dayInMonth = ex.days.join();
												$scope.dayInMonthList.push(ex);
											} else if (ex.onDays) {
												for (var i = 0; i < ex.onDays.length; i++) {
													if (ex.onDays[i] == 'WEEKDAYS') {
														ex.onDays[i] = 'WEEKDAY';
													}
													if (ex.onDays[i] == 'WEEKEND_DAYS') {
														ex.onDays[i] = 'WEEKEND DAY';
													}
												}
												ex.dayInWeekList = ex.onDays.join();
												ex.weekInMonthList = ex.onWeek.join();
												$scope.dayAndWeekList.push(ex);
											}
										});
										$scope.weekInMonth = prefixDayList;
										$scope.dayInWeek = days;
										$scope.dayInMonth = [];
										$scope.selectedDaysInMonth = [];
										$scope.selectedWeeksInMonth = [];
										$scope.selectedDaysInWeek = [];
										//$scope.dayInMonthList = exceptionsList ? exceptionsList.dayInMonthList : [];
										//$scope.dayAndWeekList = exceptionsList ? exceptionsList.dayAndWeekList : [];
										for (var i = 1; i < 32; i++) {
											var obj = {
												name: i
											};
											$scope.dayInMonth.push(obj);
										}

										//reset select options
										function resetDayInMonth() {
											$scope.dayInMonth.map(function(o) {
												o.ticked = false;
											});
										}
										function resetWeekInMonth() {
											$scope.weekInMonth.map(function(o) {
												o.ticked = false;
											});
											$scope.dayInWeek.map(function(o) {
												o.ticked = false;
											});
										}

										//find date when click exception to edit
										function findDate(dayType) {
											var weekInMonthList = dayType.weekInMonthList.split(',');
											var dayInWeekList = dayType.dayInWeekList.split(',');
											$scope.weekInMonth.map(function(week) {
												for (var i = 0; i < weekInMonthList.length; i++) {
													if (week.name == weekInMonthList[i]) {
														week.ticked = true;
													}
												}
											});

											$scope.dayInWeek.map(function(day) {
												for (var j = 0; j < dayInWeekList.length; j++) {
													if (day.name == dayInWeekList[j]) {
														day.ticked = true;
													}
												}
											});
										}
										resetDayInMonth();
										resetWeekInMonth();

										//ADD exception operation
										$scope.addException = function() {
											$scope.addExceptionsMessage = cvUtil.emptyMsg();
											$scope.addExistException = false;
											if ($scope.dayType == 'dayInMonth') {
												var list = {
													dayInMonth: []
												};
												$scope.selectedDaysInMonth.map(function(day) {
													list.dayInMonth.push(day.name);
												});
												if (list.dayInMonth.length === 0) {
													$scope.addExceptionsMessage = {
														message: cvLoc('error.selectDays'),
														type: 'error'
													};
													return;
												}
												list.dayInMonth = list.dayInMonth.join();
												if (list.dayInMonth.length > 0) {
													$scope.dayInMonthList.map(function(data) {
														if (data.dayInMonth == list.dayInMonth) {
															$scope.addExistException = true;
														}
													});
													if ($scope.addExistException) {
														$scope.addExceptionsMessage = {
															message: cvLoc('label.existedExceptions'),
															type: 'error'
														};
														return;
													} else {
														$scope.dayInMonthList.push(list);
													}
												}
												resetDayInMonth();
											}
											if ($scope.dayType == 'weekInMonth') {
												var list = {
													weekInMonthList: [],
													dayInWeekList: []
												};
												list.weekInMonthList = [];
												list.dayInWeekList = [];
												$scope.selectedWeeksInMonth.map(function(week) {
													list.weekInMonthList.push(week.name);
												});

												$scope.selectedDaysInWeek.map(function(day) {
													list.dayInWeekList.push(day.name);
												});
												list.weekInMonthList = list.weekInMonthList.join();
												list.dayInWeekList = list.dayInWeekList.join();
												if (list.weekInMonthList.length === 0) {
													$scope.addExceptionsMessage = {
														message: cvLoc('error.selectWeekInMonth'),
														type: 'error'
													};
													return;
												}
												if (list.dayInWeekList.length === 0) {
													$scope.addExceptionsMessage = {
														message: cvLoc('error.selectDayInWeek'),
														type: 'error'
													};
													return;
												}
												if (list.weekInMonthList.length > 0 && list.dayInWeekList.length > 0) {
													$scope.dayAndWeekList.map(function(data) {
														if (
															data.dayInWeekList == list.dayInWeekList &&
															data.weekInMonthList == list.weekInMonthList
														) {
															$scope.addExistException = true;
														}
													});
													if ($scope.addExistException) {
														$scope.addExceptionsMessage = {
															message: cvLoc('label.existedExceptions'),
															type: 'error'
														};
														return;
													} else {
														$scope.dayAndWeekList.push(list);
													}
												}
												//reset select options
												resetWeekInMonth();
											}
											$scope.showEdit = false;
										};

										$scope.editDayInMonthException = function() {
											$scope.addExceptionsMessage = cvUtil.emptyMsg();
											var list = {
												dayInMonth: []
											};
											$scope.selectedDaysInMonth.map(function(day) {
												list.dayInMonth.push(day.name);
											});
											if (list.dayInMonth.length === 0) {
												$scope.addExceptionsMessage = {
													message: cvLoc('error.selectDays'),
													type: 'error'
												};
												return;
											}
											for (var i in $scope.dayInMonthList) {
												if (JSON.stringify($scope.dayInMonthList[i]) == JSON.stringify($scope.day)) {
													$scope.dayInMonthList[i].dayInMonth = list.dayInMonth.join();
												}
											}
											resetDayInMonth();
											$scope.showEdit = false;
										};
										$scope.editExceptions = function() {
											$scope.addExceptionsMessage = cvUtil.emptyMsg();
											var list = {
												weekInMonthList: [],
												dayInWeekList: []
											};
											$scope.selectedWeeksInMonth.map(function(week) {
												list.weekInMonthList.push(week.name);
											});

											$scope.selectedDaysInWeek.map(function(day) {
												list.dayInWeekList.push(day.name);
											});
											if (list.weekInMonthList.length === 0) {
												$scope.addExceptionsMessage = {
													message: cvLoc('error.selectWeekInMonth'),
													type: 'error'
												};
												return;
											}
											if (list.dayInWeekList.length === 0) {
												$scope.addExceptionsMessage = {
													message: cvLoc('error.selectDayInWeek'),
													type: 'error'
												};
												return;
											}
											for (var i in $scope.dayAndWeekList) {
												if (JSON.stringify($scope.dayAndWeekList[i]) == JSON.stringify($scope.week)) {
													$scope.dayAndWeekList[i].weekInMonthList = list.weekInMonthList.join();
													$scope.dayAndWeekList[i].dayInWeekList = list.dayInWeekList.join();
												}
											}
											resetWeekInMonth();
											$scope.showEdit = false;
										};

										$scope.removeDayInMonth = function(day, index) {
											if ($scope.dayInMonthList == 1) {
												$scope.dayInMonthList.splice(index, 1);
												resetDayInMonth();
											} else {
												$scope.dayInMonthList.splice(index, 1);
												resetDayInMonth();
											}
										};

										$scope.removeWeekInMonth = function(list, index) {
											if ($scope.dayAndWeekList.length == 1) {
												$scope.dayAndWeekList.splice(index, 1);
												resetWeekInMonth();
											} else {
												if (index == 0) {
													$scope.dayAndWeekList.splice(index, 1);
													//reset select options
													resetWeekInMonth();
													//findDate($scope.dayAndWeekList[0]);
												} else {
													$scope.dayAndWeekList.splice(index, 1);
													//reset select options
													resetWeekInMonth();
													//findDate($scope.dayAndWeekList[index - 1]);
												}
											}
										};

										$scope.editDayInMonth = function(data, inedx) {
											var dayInMonth = data.dayInMonth.split(',');
											$scope.dayInMonth.map(function(day) {
												for (var i = 0; i < dayInMonth.length; i++) {
													if (day.name == dayInMonth[i]) {
														day.ticked = true;
													}
												}
											});
											$scope.day = data;
											$scope.showEdit = true;
											$scope.dayType = 'dayInMonth';
										};

										$scope.editWeekInMonth = function(week, index) {
											//reset select options
											resetWeekInMonth();
											findDate(week);
											$scope.showEdit = true;
											$scope.dayType = 'weekInMonth';
											$scope.week = week;
										};

										$scope.submitExceptions = function() {
											var exceptions = {
												dayAndWeekList: [],
												dayInMonthList: []
											};
											if ($scope.dayInMonthList.length > 0) {
												$scope.dayInMonthList.map(function(data) {
													data.dayInMonth = data.dayInMonth.split(',');
												});
												exceptions.dayInMonthList = $scope.dayInMonthList;
											}
											if ($scope.dayAndWeekList.length > 0) {
												$scope.dayAndWeekList.map(function(data) {
													data.dayInWeekList = data.dayInWeekList.split(',');
													data.weekInMonthList = data.weekInMonthList.split(',');
												});
												exceptions.dayAndWeekList = $scope.dayAndWeekList;
											}
											$rootScope.$emit('exceptionsAdded', exceptions);
											$modalInstance.dismiss();
										};

										$scope.cancel = function() {
											$modalInstance.dismiss();
										};
									}
								],
								resolve: {
									prefixDayList: function() {
										return $scope.model.prefixDayList;
									},
									days: function() {
										return $scope.model.days;
									},
									exceptionsList: function() {
										return $scope.exceptionsList;
									},
									repeatException: function() {
										return $scope.model.repeatException;
									}
								}
							});
						};

						function isDuplicateScheduleAvailable(currentScheduleName, existingSchedules) {
							if (angular.isArray(existingSchedules) && existingSchedules.length > 0) {
								return existingSchedules.some(name => name && name == currentScheduleName);
							}
							return false;
						}

						$scope.validateAndManageForceBackup = function() {
							if (
								$scope.isLaptopPlan &&
								!isMinMaxMinutesOutOfRange() &&
								!isMinHoursOutOfRange() &&
								!isMinBackupZero() &&
								!isMinHoursMinutesOutOfRange()
							) {
								if ($scope.model.maxBackupIntervalHours % 24 == 0 && !$scope.model.maxBackupIntervalMinutes) {
									$scope.model.maxBackupIntervalHours = Math.ceil($scope.model.minBackupIntervalHours / 24) * 24;
									if ($scope.model.minBackupIntervalHours % 24 == 0 && $scope.model.minBackupIntervalMinutes) {
										$scope.model.maxBackupIntervalHours = $scope.model.maxBackupIntervalHours + 24;
									}
									$scope.model.maxBackupIntervalMinutes = 0;
								}
							}
						};

						function isMinBackupZero() {
							return !$scope.model.minBackupIntervalMinutes && !$scope.model.minBackupIntervalHours;
						}

						function isMaxBackupZero() {
							return !$scope.model.maxBackupIntervalHours && !$scope.model.maxBackupIntervalMinutes;
						}

						function isMinBackupGreaterThanMaxBackup() {
							return (
								($scope.model.maxBackupIntervalHours ? $scope.model.maxBackupIntervalHours : 0) * 60 +
									($scope.model.maxBackupIntervalMinutes ? $scope.model.maxBackupIntervalMinutes : 0) <
								($scope.model.minBackupIntervalHours ? $scope.model.minBackupIntervalHours : 0) * 60 +
									($scope.model.minBackupIntervalMinutes ? $scope.model.minBackupIntervalMinutes : 0)
							);
						}

						function isMinHoursOutOfRange() {
							return $scope.model.minBackupIntervalHours > 168;
						}

						function isMaxHoursOutOfRange() {
							return $scope.model.maxBackupIntervalHours > 168;
						}

						function isMinHoursMinutesOutOfRange() {
							if ($scope.model.minBackupIntervalHours == 168) {
								return $scope.model.minBackupIntervalMinutes > 0;
							} else {
								return false;
							}
						}

						function isMinMaxMinutesOutOfRange() {
							return (
								$scope.model.minSyncIntervalMinutes < 0 ||
								$scope.model.minSyncIntervalMinutes >= 60 ||
								$scope.model.maxBackupIntervalMinutes < 0 ||
								$scope.model.maxBackupIntervalMinutes >= 60 ||
								$scope.model.minBackupIntervalMinutes < 0 ||
								$scope.model.minBackupIntervalMinutes >= 60
							);
						}

						function validateScheduleModel() {
							var errorMsg;
							if ($scope.isInstallUpdateSchedule) {
								if (_.get($scope, 'treeParams.result.selected', []).length < 1) {
									$scope.accordionStatus.serversList = true;
									errorMsg = cvUtil.errMsgLoc('error.selectServer');
								}
							}

							if (!_.get(attrs, 'scheduleNameNotRequired', false)) {
								//for schedule policies, creating/editing schedules without names is allowed.
								if ($scope.model.name === undefined || $scope.model.name === '' || $scope.model.name === null) {
									errorMsg = cvUtil.errMsgLoc('error.scheduleName');
								}
							}

							if (attrs && attrs.existingSchedules) {
								if (isDuplicateScheduleAvailable($scope.model.name, attrs.existingSchedules)) {
									errorMsg = cvUtil.errMsgLoc('error.duplicateScheduleName');
								}
							}

							if ($scope.model.freqType == 'AUTOMATIC_SCHEDULE') {
								//added validations for automatic schedules just as
								//the validations done on GUI for every input
								if ($scope.model.minBackupIntervalHours < 0) {
									errorMsg = cvUtil.errMsgLoc('error.invalidTimeFor', cvLoc('label.min.interval'));
								}

								if ($scope.model.maxBackupIntervalHours < 0) {
									errorMsg = cvUtil.errMsgLoc('error.invalidTimeFor', cvLoc('label.max.interval'));
								}

								if ($scope.model.minSyncIntervalHours < 0) {
									errorMsg = cvUtil.errMsgLoc('error.invalidTimeFor', cvLoc('label.min.syncInterval'));
								}

								if (isMinMaxMinutesOutOfRange()) {
									errorMsg = cvUtil.errMsgLoc('error.rpoTime');
								}

								if ($scope.isLaptopPlan) {
									if ($scope.model.cpuBelowThreshold > 100 || $scope.model.cpuBelowThreshold < 0) {
										errorMsg = cvUtil.errMsgLoc('error.cpuUtilisationVal');
										return errorMsg;
									}
									if (isMinHoursOutOfRange() || isMaxHoursOutOfRange()) {
										errorMsg = cvUtil.errMsgLoc('error.rpoHoursLaptop');
										return errorMsg;
									}

									if (isMinHoursMinutesOutOfRange()) {
										errorMsg = cvUtil.errMsgLoc('error.rpoHoursLaptop');
										return errorMsg;
									}

									if (isMinBackupGreaterThanMaxBackup()) {
										errorMsg = cvUtil.errMsgLoc('error.laptopForceBackupLessThanBackup');
										return errorMsg;
									}

									if (isMaxBackupZero() || isMinBackupZero()) {
										errorMsg = cvUtil.errMsgLoc('error.rpoZero');
										return errorMsg;
									}
								}

								if (
									model.minNetworkBandwidth &&
									($scope.model.networkBandwidth < 0 || $scope.model.networkBandwidth > 5120)
								) {
									errorMsg = cvUtil.errMsgLoc('error.minNetworkBandwidthRange');
								}

								if (model.useSpecificNetwork) {
									if (model.specificNetworkNumber < 1 || model.specificNetworkNumber > 32) {
										errorMsg = cvUtil.errMsgLoc('error.ipSubnet');
									}
									var ipRegex = new RegExp($scope.ipPattern);
									if (!ipRegex.test(model.specificNetworkIp)) {
										errorMsg = cvUtil.errMsgLoc('error.ipAddress');
									}
								}
							}
							return errorMsg;
						}
					}
				],
				resolve: {
					model: function() {
						return modalInfo;
					},
					dismissModal: function() {
						return dismissModal;
					},
					planId: function() {
						return planId;
					},
					attrs: function() {
						return attrs;
					},
					rpo: function() {
						return rpo;
					},
					primaryRetentionDays: function() {
						return primaryRetentionDays;
					},
					disablePrimaryRetentionDays: function() {
						return disablePrimaryRetentionDays;
					}
				}
			});
		};

		//Utility method to get the next available SLA schedule
		factory.getNextSLASchedule = function(listOfSchedules) {
			var nextSLASchedul = {};
			if (listOfSchedules.length >= 1) {
				var slaSchIndex = 0;
				var rpoInHours = 99999999; //Some max values default
				for (var i in listOfSchedules) {
					var tempRpo = 0;
					var scheduleType = listOfSchedules[i].freqType;
					if (listOfSchedules[i].operationType !== 'BACKUP') {
						continue; //we have to check only backup schedule, auxcopy schedules should skip
					}
					if (scheduleType === 'DAILY') {
						if (listOfSchedules[i].repeat && listOfSchedules[i].repeat.enabled) {
							tempRpo = listOfSchedules[i].repeat.hrs;
						} else {
							tempRpo = 24; //if it is daily then it will be 24 hrs
						}
					} else if (scheduleType === 'WEEKLY') {
						tempRpo = 7 * 24; //if it is weekly then it will be 7 dasy * 24 hrs
					} else if (scheduleType === 'MONTHLY' || scheduleType === 'MONTHLY_RELATIVE') {
						tempRpo = 31 * 24; //if it is monthly then it will be 31 dasy * 24 hrs
					}
					if (rpoInHours > tempRpo) {
						rpoInHours = tempRpo;
						slaSchIndex = i;
					}
				}

				nextSLASchedul.schedule = listOfSchedules[slaSchIndex];
				nextSLASchedul.slaInHours = rpoInHours; // TODO nsicoco: remove this once all plans are changed from old sla to rpo+sla
				nextSLASchedul.rpoInHours = rpoInHours;
			}
			return nextSLASchedul;
		};

		factory.editWorkflowSchedule = function(schedule) {
			schedule.hideDelete = true;

			var modelData = {
				source: 'createProfile',
				model: schedule
			};
			factory.addSchedule(
				modelData,
				true,
				undefined,
				false,
				undefined,
				null,
				{ operationType: 'WORK_FLOW' },
				null,
				undefined
			);
		};

		factory.addNewWorkflowSchedule = function() {
			var modelData = {
				source: 'createProfile'
			};
			factory.addSchedule(
				modelData,
				false,
				undefined,
				false,
				undefined,
				null,
				{ operationType: 'WORK_FLOW' },
				null,
				undefined
			);
		};

		factory.addNewSchedule = function(data, planSubType, emitOn) {
			var isScheduleEdting = false;
			var modelData = {
				source: 'createProfile'
			};
			if (data) {
				modelData.model = data;
				isScheduleEdting = true;
			}

			// TODO nsicoco: remove references to data.sla once all plans are changed from old sla to rpo+sla
			var rpo = null;
			if (data && (data.rpo || data.sla)) {
				rpo = data.rpo || data.sla;
			}

			var planId;
			factory.addSchedule(modelData, isScheduleEdting, planSubType, false, planId, null, null, rpo, emitOn);
		};

		factory.updateSchedules = function(schedulesList) {
			schedulesList.map(function(schedule) {
				if (schedule.repeatEnabled != undefined) {
					schedule.repeat = {
						enabled: schedule.repeatEnabled,
						duration: schedule.repeatDuration,
						hrs: schedule.repeatHrs,
						mins: schedule.repeatMins,
						time: schedule.repeatTime
					};
					delete schedule.repeatEnabled;
					delete schedule.repeatDuration;
					delete schedule.repeatHrs;
					delete schedule.repeatMins;
					delete schedule.repeatTime;
				}
				if (schedule.tempTimeConvert != undefined) {
					schedule.scheduleTime = schedule.tempTimeConvert;
				}
				if (schedule.tempRepeatTime != undefined) {
					schedule.repeat.time = schedule.tempRepeatTime;
				}
				//handle synthetic auto schedule
				if (schedule.backupLevel === 'SYNTHETIC_FULL' && schedule.freqType === 'AUTOMATIC_SCHEDULE') {
					schedule.daysBetweenSyntheticBackup =
						$scope.globalTemplate.storageInfo.primaryRetentionInDays > 90
							? 90
							: $scope.globalTemplate.storageInfo.primaryRetentionInDays;
				}
			});
		};

		factory.convertScheduleToSubTaskInfo = function(schedule) {
			// This map is used to convert ScheduleFreqType enum to FreqType enum
			var freqTypeMap = {
				ONE_TIME: 'One_Time',
				DAILY: 'Daily',
				WEEKLY: 'Weekly',
				AUTOMATIC_SCHEDULE: 'Automatic_Schedule',
				MONTHLY: 'Monthly',
				MONTHLY_RELATIVE: 'Monthly_Relative',
				AFTER_JOB_COMPLETES: 'After_Job_Completes'
			};

			// This is created from Day enum
			var dayMap = [
				'None',
				'Sunday',
				'Monday',
				'Tuesday',
				'Wednesday',
				'Thursday',
				'Friday',
				'Saturday',
				'Day',
				'Weekday',
				'Weekend_Day'
			];

			// This is created from WeekOfMonth enum
			var weekOfMonthMap = ['None', 'First', 'Second', 'Third', 'Fourth', 'Last', 'SpecificDay'];

			// CSTimeZoneId.CS_TZ enum value
			var clientTimezone = {
				TimeZoneID: 1000
			};

			var dasyMaskValues = [
				1 << 1, //DAYMASK_MONDAY
				1 << 2, //DAYMASK_TUESDAY
				1 << 3, //DAYMASK_WEDNESDAY
				1 << 4, //DAYMASK_THURSDAY
				1 << 5, //DAYMASK_FRIDAY
				1 << 6, //DAYMASK_SATURDAY
				1 << 0
			];

			// convert day map
			var weeklyFreqInterval = function(daysToRun) {
				// daysToRun is from monday to sunday
				// dayMask is from sunday to saturday

				var dayMask = 0;
				if (daysToRun != null) {
					for (var i in daysToRun) {
						if (daysToRun[i]) {
							dayMask = dayMask | dasyMaskValues[i];
						}
					}
				}
				return parseInt(dayMask);
			};

			var daysToRunToObject = function(lbDtr) {
				// lbDtr is from monday to sunday
				if (lbDtr == null) {
					return null;
				}
				var dtr = {};
				dtr.Monday = lbDtr[0];
				dtr.Tuesday = lbDtr[1];
				dtr.Wednesday = lbDtr[2];
				dtr.Thursday = lbDtr[3];
				dtr.Friday = lbDtr[4];
				dtr.Saturday = lbDtr[5];
				dtr.Sunday = lbDtr[6];
				return dtr;
			};

			var patternObj = {
				name: schedule.name,
				freq_type: freqTypeMap[schedule.freqType],
				freq_recurrence_factor: schedule.repeat ? schedule.repeat.duration : 0,
				freq_subday_interval:
					schedule.repeat && schedule.repeat.enabled ? schedule.repeat.hrs * 3600 + schedule.repeat.mins * 60 : 0,
				active_start_time: schedule.activeStartTime,
				active_end_time: schedule.repeat && schedule.repeat.enabled ? schedule.repeat.time : undefined
			};

			// Set pattern object based on frequency type
			switch (patternObj.freq_type) {
				case 'Daily':
					patternObj.timeZone = clientTimezone;
					patternObj.freq_interval = 1;
					patternObj.daysToRun = null;
					break;
				case 'Weekly':
					patternObj.timeZone = clientTimezone;
					patternObj.freq_interval = 1;
					// These two are basically duplicates, but the server needs them both:
					patternObj.freq_interval = weeklyFreqInterval(schedule.daysToRun);
					patternObj.daysToRun = daysToRunToObject(schedule.daysToRun);
					break;
				case 'Automatic_Schedule':
					patternObj.active_start_time = 0;
					patternObj.daysToRun = null;
					break;
				case 'Monthly':
					patternObj.freq_relative_interval = 0;
					patternObj.freq_interval = schedule.dayOfMonth;
					patternObj.daysToRun = {
						onDayNumber: schedule.dayOfMonth
					};
					break;
				case 'Monthly_Relative':
					patternObj.freq_relative_interval = schedule.weekOfMonth;
					patternObj.freq_interval = schedule.dayOfWeek;
					patternObj.daysToRun = {
						day: dayMap[schedule.dayOfWeek],
						week: weekOfMonthMap[schedule.weekOfMonth]
					};
					break;
				case 'One_Time':
					patternObj.timeZone = clientTimezone;
					patternObj.active_start_time = schedule.active_start_time;
					patternObj.active_start_date = schedule.active_start_date;
					break;
				case 'After_Job_Completes':
					patternObj.freq_interval = schedule.frequency_interval ? schedule.frequency_interval : 30; // minutes after job completes
					patternObj.timeZone = clientTimezone;
					patternObj.description = schedule.description ? schedule.description : undefined;
					break;
				default:
					/*
					 * if this happens, it means either the frequency type was null or we added support for a
					 * new type and didn't update this method.
					 */
					console.log('Schedule frequency not supported');
			}

			// subTaskInfo:
			var subTaskInfo = {
				pattern: patternObj,
				subTask: {
					operationType: schedule.operationType,
					subTaskType: schedule.subTaskType,
					flags: schedule.flags,
					subTaskName: schedule.name || 'Admin Console backup schedule ' + new Date() // TODO: Do we need to format this date according to java file
				},
				options: {
					backupOpts: {
						autoConvertBackupLevel: schedule.autoConvertBackupLevel,
						backupLevel: schedule.backupLevel || 'INCREMENTAL',
						doNotTruncateLog: false,
						incLevel: 'BEFORE_SYNTH',
						isSpHasInLineCopy: false,
						runIncrementalBackup: true,
						runSILOBackup: false,
						sybaseSkipFullafterLogBkp: false,
						//collectMetaInfo: schedule.collectMetadata,
						dataOpt: {
							daysBetweenSyntheticBackup: schedule.daysBetweenSyntheticBackup
						}
					},
					adminOpts: {
						updateOption: {
							invokeLevel: 'NONE'
						}
					}
				}
			};

			// for backup copy, if granular recovery is set to false
			//			if (schedule.operationType === "SNAP_TO_TAPE") {
			//				subTaskInfo.options.backupOpts.dataOpt.collectVMGranularRecoveryMetadataForBkpCopy = !!schedule.collectMetadata;
			//			}

			// handling special conditions
			if (schedule.freqType === 'AUTOMATIC_SCHEDULE' && schedule.backupLevel === 'SYNTHETIC_FULL') {
				subTaskInfo.options.backupOpts.runIncrementalBackup = false;
				subTaskInfo.options.backupOpts.dataOpt.autoCopy = true;
			}
			if (schedule.backupLevel === 'STUBBING') {
				subTaskInfo.options.backupOpts.runIncrementalBackup = false;
			}
			// if automatic_schedule
			if (schedule.freqType === 'AUTOMATIC_SCHEDULE') {
				var buildThresholds = function(_enabled, _threshold) {
					return {
						enabled: _enabled,
						threshold: _threshold
					};
				};

				subTaskInfo.options.commonOpts = {
					automaticSchedulePattern: {
						//Job interval
						minBackupInterval: schedule.minBackupIntervalHours,
						minBackupIntervalMinutes: schedule.minBackupIntervalMinutes,

						maxBackupInterval: schedule.maxBackupIntervalHours,
						maxBackupIntervalMinutes: schedule.maxBackupIntervalMinutes,

						minSyncIntervalMinutes: schedule.minSyncIntervalMinutes,
						minSyncInterval: schedule.minSyncIntervalHours,

						ignoreOpWindowPastMaxInterval: schedule.ignoreAtMaxInterval,

						//Network management
						wiredNetworkConnection: buildThresholds(schedule.useOnlyWiredWork, null),
						minNetworkBandwidth: buildThresholds(schedule.minNetworkBandwidth, schedule.networkBandwidth),
						specfificNetwork: {
							enabled: schedule.useSpecificNetwork,
							ipAddress: {
								address: schedule.specificNetworkIp,
								subnet: schedule.specificNetworkNumber
							}
						},

						//Power management
						stopIfOnBattery: buildThresholds(schedule.stopIfBatteryMode, null),
						acPower: buildThresholds(schedule.startOnlyOnAc, null),
						stopSleepIfBackUp: buildThresholds(schedule.preventSleep, null),

						//Resource Utilization
						cpuUtilization: schedule.cpuBelowThresholdEnabled
							? buildThresholds(schedule.cpuBelowThresholdEnabled, schedule.cpuBelowThreshold)
							: undefined,
						diskSpace: schedule.spaceBelowThresholdEnabled
							? buildThresholds(schedule.spaceBelowThresholdEnabled, schedule.spaceBelowThreshold)
							: undefined,

						//File Management
						newOrModifiedFile: buildThresholds(schedule.startOnlyfileBackUp, null),

						//Database management
						diskUsedPercent: schedule.automaticSchedulePattern
							? schedule.automaticSchedulePattern.logPercent
							: undefined,
						logPercent: schedule.automaticSchedulePattern ? schedule.automaticSchedulePattern.logPercent : undefined,
						logFileNum: schedule.automaticSchedulePattern ? schedule.automaticSchedulePattern.logFileNum : undefined
					}
				};
			}

			return subTaskInfo;
		};

		factory.convertSubTaskInfoToSchedule = function(st, planSubType, index) {
			var newSchedule = {
				planSubType: planSubType,
				name: st.subTask.subTaskName,
				autoConvertBackupLevel: st.options.backupOpts ? st.options.backupOpts.autoConvertBackupLevel : undefined,
				backupLevel: st.options.backupOpts ? st.options.backupOpts.backupLevel : undefined,
				//collectMetadata: st.options.backupOpts ? st.options.backupOpts.collectMetaInfo : undefined,
				operationType: st.subTask.operationType,
				flags: st.subTask.flags ? st.subTask.flags : 0,
				subTaskType: st.subTask.subTaskType,
				id: Date.now() + index
				// TODO: this is changed back, because subtaskId from master profile is the same of all the schedules. Need a unique id of each schedule.
			};
			//to check if active end date is there or to set it to default
			var isRepeatActive = st.pattern.freq_subday_interval;
			var tempRepeatTime = isRepeatActive && isRepeatActive != 0 ? st.pattern.active_end_time : defaultEndTime;
			var setDefaultTime = function() {
				var d = new Date();
				d.setHours(0);
				d.setMinutes(0);
				return d;
			};

			var repeatSettings = {
				enabled:
					st.subTask.operationType == 'SNAP_TO_TAPE' ||
					st.subTask.operationType == 'AUX_COPY' ||
					st.subTask.operationType == 'BACKUP' ||
					((st.subTask.operationType == 'DOWNLOAD_UPDATES' ||
						st.subTask.operationType == 'DRORCHESTRATION' ||
						st.subTask.operationType == 'INSTALL_UPDATES') &&
						(st.pattern.freq_subday_interval ? st.pattern.freq_subday_interval > 0 : false))
						? true
						: false,
				duration: st.pattern.freq_recurrence_factor || 1,
				time: tempRepeatTime ? cvUtil.convertCvTimeToDate(tempRepeatTime) : setDefaultTime()
			};

			var weekOfMonthList = [
				{
					name: 'First',
					value: 1
				},
				{
					name: 'Second',
					value: 2
				},
				{
					name: 'Third',
					value: 3
				},
				{
					name: 'Fourth',
					value: 4
				},
				{
					name: 'Last',
					value: 5
				}
			];

			var dayOfweekList = [
				{
					name: 'Sunday',
					value: 1
				},
				{
					name: 'Monday',
					value: 2
				},
				{
					name: 'Tuesday',
					value: 3
				},
				{
					name: 'Wednesday',
					value: 4
				},
				{
					name: 'Thursday',
					value: 5
				},
				{
					name: 'Friday',
					value: 6
				},
				{
					name: 'Saturday',
					value: 7
				},
				{
					name: 'Day',
					value: 8
				},
				{
					name: 'Weekday',
					value: 9
				},
				{
					name: 'Weekend_Day',
					value: 10
				}
			];

			function convertOnDayValue(id) {
				for (var i in dayOfweekList) {
					if (dayOfweekList[i].value == id) {
						return dayOfweekList[i].name;
					}
				}
			}

			function convertOnWeekValue(id) {
				for (var i in weekOfMonthList) {
					if (weekOfMonthList[i].value == id) {
						return weekOfMonthList[i].name;
					}
				}
			}

			function getOnDay(onDay) {
				var exceptionDays = [];
				var count = 1;
				while (onDay != 0) {
					if ((onDay & 1) == 1) {
						exceptionDays.push(convertOnDayValue(count));
					}
					onDay = onDay >> 1;
					count++;
				}
				return exceptionDays;
			}

			function getOnWeek(onWeek) {
				var exceptionWeek = [];
				var count = 1;
				while (onWeek != 0) {
					if ((onWeek & 1) == 1) {
						exceptionWeek.push(convertOnWeekValue(count));
					}
					onWeek = onWeek >> 1;
					count++;
				}
				return exceptionWeek;
			}

			function getDays(days) {
				var daysRet = [];
				var count = 1;
				while (days != 0) {
					if ((days & 1) == 1) {
						daysRet.push(count);
					}
					days = days >> 1;
					count++;
				}
				return daysRet;
			}

			var converRepeatPattern = function(repeatPattern) {
				repeatPattern.map(function(repeat) {
					var onDay = getOnDay(repeat.onDay);
					var onWeek = getOnWeek(repeat.occurrence);
					var days = getDays(repeat.onDayNumber);
					if (repeat.onDayNumber && repeat.onDayNumber !== 0) {
						repeat.days = days;
					}

					for (var i = 0; i < onDay.length; i++) {
						onDay[i] = onDay[i].toUpperCase();
						if (onDay[i] == 'WEEKDAY') {
							onDay[i] = 'WEEKDAYS';
						}
						if (onDay[i] == 'WEEKEND DAY') {
							onDay[i] = 'WEEKEND_DAYS';
						}
					}
					for (var j = 0; j < onWeek.length; j++) {
						onWeek[j] = onWeek[j].toUpperCase();
					}
					repeat.onDays = onDay;
					repeat.onWeek = onWeek;
					delete repeat.onDay;
					delete repeat.onDayNumber;
					delete repeat.occurrence;
				});
			};

			if (st.context == 'SCHEDULE_POLICY') {
				if (st.pattern.freq_subday_interval == 0) {
					repeatSettings.hrs = 0;
					repeatSettings.mins = 0;
					repeatSettings.enabled = false;
				} else {
					repeatSettings.hrs = Math.floor(st.pattern.freq_subday_interval / 60 / 60);
					repeatSettings.mins = Math.floor((st.pattern.freq_subday_interval / 60) % 60);
					if (repeatSettings.mins >= 30 && repeatSettings.hrs > 0) {
						repeatSettings.hrs = parseInt(repeatSettings.hrs.toFixed(0) - 1);
					} else {
						repeatSettings.hrs = parseInt(repeatSettings.hrs.toFixed(0)); //this should be always integer
					}
				}
			} else {
				if (st.pattern.freq_subday_interval) {
					if (st.pattern.freq_subday_interval == 0) {
						if (st.subTask.flags && st.subTask.flags === SCHEDULE_PROPERTY.SLA_FLAG) {
							repeatSettings.hrs = 0;
							repeatSettings.mins = 0;
						} else {
							repeatSettings.hrs = 8;
							repeatSettings.mins = 0;
						}
					} else {
						repeatSettings.hrs = Math.floor(st.pattern.freq_subday_interval / 60 / 60);
						repeatSettings.mins = Math.floor((st.pattern.freq_subday_interval / 60) % 60);
						if (repeatSettings.mins >= 30 && repeatSettings.hrs > 0) {
							repeatSettings.hrs = parseInt(repeatSettings.hrs.toFixed(0) - 1);
						} else {
							repeatSettings.hrs = parseInt(repeatSettings.hrs.toFixed(0)); //this should be always integer
						}
					}
				} else {
					if (st.subTask.flags && st.subTask.flags === SCHEDULE_PROPERTY.SLA_FLAG) {
						repeatSettings.hrs = 0;
						repeatSettings.mins = 0;
					} else {
						repeatSettings.hrs = 8;
						repeatSettings.mins = 0;
					}
				}
			}

			angular.extend(newSchedule, {
				calendar: st.pattern.calendar,
				timeZone: st.pattern.timeZone,
				active_end_occurence: st.pattern.active_end_occurence,
				active_end_date: st.pattern.active_end_date,
				active_start_date: st.pattern.active_start_date,
				activeStartTime: st.pattern.active_start_time,
				freqType: st.pattern.freq_type,
				skipDayNumber: st.pattern.skipDayNumber,
				skipOccurence: st.pattern.skipOccurence
			});

			if (st.pattern.freq_type === 'Automatic_Schedule') {
				newSchedule.freqType = 'AUTOMATIC_SCHEDULE';
				newSchedule.automaticSchedulePattern = st.options.commonOpts.automaticSchedulePattern;
				newSchedule.maxBackupIntervalHours = st.options.commonOpts.automaticSchedulePattern.maxBackupInterval || 0;
				newSchedule.maxBackupIntervalMinutes =
					st.options.commonOpts.automaticSchedulePattern.maxBackupIntervalMinutes || 0;
				newSchedule.minBackupIntervalHours = st.options.commonOpts.automaticSchedulePattern.minBackupInterval || 0;
				newSchedule.minBackupIntervalMinutes =
					st.options.commonOpts.automaticSchedulePattern.minBackupIntervalMinutes || 0;
				if (
					angular.isDefined(st.options.backupOpts) &&
					angular.isDefined(st.options.backupOpts.backupLevel) &&
					st.options.backupOpts.backupLevel == 'SYNTHETIC_FULL'
				) {
					newSchedule.daysBetweenSyntheticBackup = st.options.backupOpts.dataOpt.daysBetweenSyntheticBackup || 30;
				} else {
					newSchedule.minSyncIntervalHours = st.options.commonOpts.automaticSchedulePattern.minSyncInterval || 0;
					newSchedule.minSyncIntervalMinutes =
						st.options.commonOpts.automaticSchedulePattern.minSyncIntervalMinutes || 0;
					newSchedule.ignoreAtMaxInterval =
						st.options.commonOpts.automaticSchedulePattern.ignoreOpWindowPastMaxInterval || false;
					newSchedule.useOnlyWiredWork = st.options.commonOpts.automaticSchedulePattern.wiredNetworkConnection
						? st.options.commonOpts.automaticSchedulePattern.wiredNetworkConnection.enabled
						: false;
					newSchedule.minNetworkBandwidth = st.options.commonOpts.automaticSchedulePattern.minNetworkBandwidth
						? st.options.commonOpts.automaticSchedulePattern.minNetworkBandwidth.enabled
						: false;
					newSchedule.networkBandwidth = st.options.commonOpts.automaticSchedulePattern.minNetworkBandwidth
						? st.options.commonOpts.automaticSchedulePattern.minNetworkBandwidth.threshold
						: 128;
					newSchedule.useSpecificNetwork = st.options.commonOpts.automaticSchedulePattern.specfificNetwork
						? st.options.commonOpts.automaticSchedulePattern.specfificNetwork.enabled
						: false;
					newSchedule.specificNetworkIp = _.get(
						st,
						'options.commonOpts.automaticSchedulePattern.specfificNetwork.ipAddress.address',
						'0.0.0.0'
					);
					newSchedule.specificNetworkNumber = _.get(
						st,
						'options.commonOpts.automaticSchedulePattern.specfificNetwork.ipAddress.subnet',
						24
					);
					newSchedule.startOnlyOnAc = st.options.commonOpts.automaticSchedulePattern.acPower
						? st.options.commonOpts.automaticSchedulePattern.acPower.enabled
						: false;
					newSchedule.stopIfBatteryMode = st.options.commonOpts.automaticSchedulePattern.stopIfOnBattery
						? st.options.commonOpts.automaticSchedulePattern.stopIfOnBattery.enabled
						: false;
					newSchedule.preventSleep = st.options.commonOpts.automaticSchedulePattern.stopSleepIfBackUp
						? st.options.commonOpts.automaticSchedulePattern.stopSleepIfBackUp.enabled
						: false;
					newSchedule.cpuBelowThresholdEnabled = st.options.commonOpts.automaticSchedulePattern.cpuUtilization
						? st.options.commonOpts.automaticSchedulePattern.cpuUtilization.enabled
						: false;
					newSchedule.cpuBelowThreshold = st.options.commonOpts.automaticSchedulePattern.cpuUtilization
						? st.options.commonOpts.automaticSchedulePattern.cpuUtilization.threshold
						: 10;
					newSchedule.startOnlyfileBackUp = st.options.commonOpts.automaticSchedulePattern.newOrModifiedFile
						? st.options.commonOpts.automaticSchedulePattern.newOrModifiedFile.enabled
						: false;
				}
			}
			if (st.pattern.freq_type === 'Daily') {
				newSchedule.freqType = 'DAILY';
				var time = st.pattern.active_start_time;
				newSchedule.activeStartTime = time;
				newSchedule.tempTimeConvert = st.pattern.active_start_time;
				newSchedule.scheduleTime = cvUtil.convertCvTimeToDate(time);
				newSchedule.dailyBackupHours = newSchedule.scheduleTime.getHours();
				newSchedule.dailyBackupMinutes = newSchedule.scheduleTime.getMinutes();
				newSchedule.repeat = repeatSettings;
				newSchedule.tempTimeConvert = st.pattern.active_start_time;
				newSchedule.tempRepeatTime = tempRepeatTime;
				if (st.pattern.repeatPattern) {
					converRepeatPattern(st.pattern.repeatPattern);
					newSchedule.repeatException = st.pattern.repeatPattern;
				} else {
					newSchedule.repeatException = [];
				}
			}
			if (st.pattern.freq_type === 'Monthly') {
				newSchedule.freqType = 'MONTHLY';
				var time = st.pattern.active_start_time;
				newSchedule.activeStartTime = time;
				newSchedule.scheduleTime = cvUtil.convertCvTimeToDate(time);
				newSchedule.dailyBackupHours = newSchedule.scheduleTime.getHours();
				newSchedule.dailyBackupMinutes = newSchedule.scheduleTime.getMinutes();
				newSchedule.dayOfMonth = st.pattern.daysToRun
					? st.pattern.daysToRun.onDayNumber || 1
					: st.pattern.freq_interval;
				newSchedule.repeat = repeatSettings;
				newSchedule.tempRepeatTime = tempRepeatTime;
				newSchedule.tempTimeConvert = st.pattern.active_start_time;
				if (st.pattern.repeatPattern) {
					converRepeatPattern(st.pattern.repeatPattern);
					newSchedule.repeatException = st.pattern.repeatPattern;
				} else {
					newSchedule.repeatException = [];
				}
			}
			if (st.pattern.freq_type === 'Monthly_Relative') {
				newSchedule.freqType = 'MONTHLY_RELATIVE';
				var time = st.pattern.active_start_time;
				newSchedule.activeStartTime = time;
				newSchedule.scheduleTime = cvUtil.convertCvTimeToDate(time);
				newSchedule.dailyBackupHours = newSchedule.scheduleTime.getHours();
				newSchedule.dailyBackupMinutes = newSchedule.scheduleTime.getMinutes();
				var dayOfWeek = st.pattern.daysToRun ? st.pattern.daysToRun.day : st.pattern.freq_interval;
				var weekOfMonth = st.pattern.daysToRun ? st.pattern.daysToRun.week : st.pattern.freq_relative_interval;

				weekOfMonthList.map(function(week) {
					if (weekOfMonth == week.name || weekOfMonth == week.value) {
						newSchedule.weekOfMonth = week.value;
					}
				});

				dayOfweekList.map(function(day) {
					if (dayOfWeek == day.name || dayOfWeek == day.value) {
						newSchedule.dayOfWeek = day.value;
					}
				});

				newSchedule.repeat = repeatSettings;
				newSchedule.tempTimeConvert = st.pattern.active_start_time;
				newSchedule.tempRepeatTime = tempRepeatTime;
				if (st.pattern.repeatPattern) {
					converRepeatPattern(st.pattern.repeatPattern);
					newSchedule.repeatException = st.pattern.repeatPattern;
				} else {
					newSchedule.repeatException = [];
				}
			}

			if (st.pattern.freq_type === 'Yearly') {
				newSchedule.freqType = 'YEARLY';
				var time = st.pattern.active_start_time;
				newSchedule.activeStartTime = time;
				newSchedule.scheduleTime = cvUtil.convertCvTimeToDate(time);
				newSchedule.dailyBackupHours = newSchedule.scheduleTime.getHours();
				newSchedule.dailyBackupMinutes = newSchedule.scheduleTime.getMinutes();
				newSchedule.dayOfMonth = st.pattern.daysToRun
					? st.pattern.daysToRun.onDayNumber || 1
					: st.pattern.freq_interval;
				newSchedule.monthOfYear = st.pattern.freq_recurrence_factor;
				newSchedule.repeat = repeatSettings;
				newSchedule.tempRepeatTime = tempRepeatTime;
				newSchedule.tempTimeConvert = st.pattern.active_start_time;
				if (st.pattern.repeatPattern) {
					converRepeatPattern(st.pattern.repeatPattern);
					newSchedule.repeatException = st.pattern.repeatPattern;
				} else {
					newSchedule.repeatException = [];
				}
			}
			if (st.pattern.freq_type === 'Yearly_Relative') {
				newSchedule.freqType = 'YEARLY_RELATIVE';
				var time = st.pattern.active_start_time;
				newSchedule.activeStartTime = time;
				newSchedule.scheduleTime = cvUtil.convertCvTimeToDate(time);
				newSchedule.dailyBackupHours = newSchedule.scheduleTime.getHours();
				newSchedule.dailyBackupMinutes = newSchedule.scheduleTime.getMinutes();
				newSchedule.monthOfYear = st.pattern.freq_recurrence_factor;
				var dayOfWeek = st.pattern.daysToRun ? st.pattern.daysToRun.day : st.pattern.freq_interval;
				var weekOfMonth = st.pattern.daysToRun ? st.pattern.daysToRun.week : st.pattern.freq_relative_interval;
				weekOfMonthList.map(function(week) {
					if (weekOfMonth == week.name || weekOfMonth == week.value) {
						newSchedule.weekOfMonth = week.value;
					}
				});

				dayOfweekList.map(function(day) {
					if (dayOfWeek == day.name || dayOfWeek == day.value) {
						newSchedule.dayOfWeek = day.value;
					}
				});
				newSchedule.repeat = repeatSettings;
				newSchedule.tempTimeConvert = st.pattern.active_start_time;
				newSchedule.tempRepeatTime = tempRepeatTime;
				if (st.pattern.repeatPattern) {
					converRepeatPattern(st.pattern.repeatPattern);
					newSchedule.repeatException = st.pattern.repeatPattern;
				} else {
					newSchedule.repeatException = [];
				}
			}
			if (st.pattern.freq_type === 'Weekly') {
				newSchedule.freqType = 'WEEKLY';
				var time = st.pattern.active_start_time;
				newSchedule.activeStartTime = time;
				var days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
				newSchedule.daysToRun = [false, false, false, false, false, false, false];
				if (st.pattern.daysToRun) {
					for (var day in st.pattern.daysToRun) {
						for (var i = 0; i < days.length; i++) {
							if (days[i] == day && st.pattern.daysToRun[day]) {
								newSchedule.daysToRun[i] = true;
							}
						}
					}
				} else if (st.pattern.freq_interval) {
					/**
					 * http://documentation.commvault.com/commvault/v11/article?p=features/rest_api/operations/post_schedule_policy_pattern_modify.htm ->
					 * freq_interval The freq_interval field is in Sun-Sat format and has to be converted to
					 * Mon-Sun format since the GUI and daysToRun use Mon-Sun
					 */
					for (var i = 0; i < days.length; i++) {
						var bit = 1 << i;
						if ((st.pattern.freq_interval & bit) == bit) {
							if (i === 0) {
								newSchedule.daysToRun[6] = true;
							} else {
								newSchedule.daysToRun[i - 1] = true;
							}
						}
					}
				}
				newSchedule.scheduleTime = cvUtil.convertCvTimeToDate(time);
				newSchedule.dailyBackupHours = newSchedule.scheduleTime.getHours();
				newSchedule.dailyBackupMinutes = newSchedule.scheduleTime.getMinutes();

				newSchedule.repeat = repeatSettings;
				newSchedule.tempTimeConvert = st.pattern.active_start_time;
				newSchedule.tempRepeatTime = tempRepeatTime;
				if (st.pattern.repeatPattern) {
					converRepeatPattern(st.pattern.repeatPattern);
					newSchedule.repeatException = st.pattern.repeatPattern;
				} else {
					newSchedule.repeatException = [];
				}
			}
			if (st.pattern.freq_type === 'One_Time') {
				newSchedule.freqType = 'ONE_TIME';
				newSchedule.activeStartTime = st.pattern.active_start_time;
				newSchedule.active_start_date = st.pattern.active_start_date;
			}
			if (st.pattern.freq_type === 'After_Job_Completes') {
				newSchedule.freqType = 'AFTER_JOB_COMPLETES';
				newSchedule.freq_interval = st.pattern.freq_interval;
			}

			return newSchedule;
		};

		factory.scheduleDisplayString = function(pattern, requireStartAndEndString) {
			var freqType = pattern.freq_type;
			var when = '';
			var prefixList = [
				{
					label: cvLoc('label.first'),
					name: 'First',
					value: 1
				},
				{
					label: cvLoc('label.second'),
					name: 'Second',
					value: 2
				},
				{
					label: cvLoc('label.third'),
					name: 'Third',
					value: 3
				},
				{
					label: cvLoc('label.fourth'),
					name: 'Fourth',
					value: 4
				},
				{
					label: cvLoc('label.last'),
					name: 'Last',
					value: 5
				}
			];

			var daysOfWeekList = [
				{
					name: cvLoc('label.day.sun'),
					value: 'SUNDAY'
				},
				{
					name: cvLoc('label.day.mon'),
					value: 'MONDAY'
				},
				{
					name: cvLoc('label.day.tue'),
					value: 'TUESDAY'
				},
				{
					name: cvLoc('label.day.wed'),
					value: 'WEDNESDAY'
				},
				{
					name: cvLoc('label.day.thu'),
					value: 'THURSDAY'
				},
				{
					name: cvLoc('label.day.fri'),
					value: 'FRIDAY'
				},
				{
					name: cvLoc('label.day.sat'),
					value: 'SATURDAY'
				},
				{
					name: cvLoc('label.day'),
					value: 'Day'
				},
				{
					name: cvLoc('label.weekday'),
					value: 'Weekday'
				},
				{
					name: cvLoc('label.weekend'),
					value: 'Weekend Day'
				}
			];

			switch (freqType) {
				case 'Daily':
					if (pattern.freq_recurrence_factor > 1) {
						when = cvLoc('label.daysPattern', pattern.freq_recurrence_factor);
					} else {
						when = cvLoc('label.dayPattern');
					}
					break;
				case 'Weekly':
					var daySelected = '';
					for (var i = 0; i < daysOfWeekList.length; i++) {
						var bit = 1 << i;
						if ((pattern.freq_interval & bit) == bit) {
							if (daySelected.length > 0) {
								daySelected += ', ';
							}
							daySelected += daysOfWeekList[i].name;
						}
					}
					if (pattern.freq_recurrence_factor > 1) {
						when = cvLoc('label.weeksPattern', pattern.freq_recurrence_factor, daySelected);
					} else {
						when = cvLoc('label.weekPattern', daySelected);
					}
					break;
				case 'Monthly':
					if (pattern.freq_recurrence_factor > 1) {
						when = cvLoc('label.monthsPattern', pattern.freq_recurrence_factor, pattern.freq_interval);
					} else {
						when = cvLoc('label.monthPattern', pattern.freq_interval);
					}
					break;
				case 'Monthly_Relative':
					if (pattern.freq_recurrence_factor > 1) {
						when = cvLoc(
							'label.monthsRealtivePattern',
							pattern.freq_recurrence_factor,
							prefixList[
								pattern.freq_relative_interval == 0
									? pattern.freq_relative_interval
									: pattern.freq_relative_interval - 1
							].label,
							daysOfWeekList[pattern.freq_interval == 0 ? pattern.freq_interval : pattern.freq_interval - 1].name
						);
					} else {
						when = cvLoc(
							'label.monthRealtivePattern',
							prefixList[
								pattern.freq_relative_interval == 0
									? pattern.freq_relative_interval
									: pattern.freq_relative_interval - 1
							].label,
							daysOfWeekList[pattern.freq_interval == 0 ? pattern.freq_interval : pattern.freq_interval - 1].name
						);
					}
					break;
				default:
					console.log('Schedule frequency not supported');
			}

			var displayString = '';
			var startMsg = '';
			var repeadMsg = '';
			// Start and end time are in seconds - 0 for 12:00AM and 86400 for 11:59:59PM
			var startTime =
				angular.isDefined(pattern.active_start_time) &&
				pattern.active_start_time >= 0 &&
				pattern.active_start_time < 86400
					? cvUtil.convertCvTimeToDate(pattern.active_start_time)
					: new Date();
			var endTime =
				angular.isDefined(pattern.active_end_time) && pattern.active_end_time >= 0 && pattern.active_end_time < 86400
					? cvUtil.convertCvTimeToDate(pattern.active_end_time)
					: new Date();

			function convertDatetoTime(hours, minutes) {
				var meridian = 'AM';
				if (hours >= 12) {
					meridian = 'PM';
				}

				hours %= 12;
				if (hours == 0) {
					hours = 12; // For 12AM and 12PM the hours will become zero
				}

				if (minutes < 10) {
					minutes = '0' + minutes;
				}

				return hours + ':' + minutes + ' ' + meridian;
			}

			displayString = cvLoc(
				'label.everyPattern',
				when,
				convertDatetoTime(startTime.getHours(), startTime.getMinutes())
			);
			startMsg = cvLoc('label.startOnPattern', startTime.toDateString());

			if (pattern.freq_subday_interval > 0) {
				var hr = parseInt(pattern.freq_subday_interval / 3600);
				var min = parseInt(pattern.freq_subday_interval / 60 - hr * 60);
				repeadMsg = cvLoc(
					'label.repeatEveryPattern',
					hr,
					min,
					convertDatetoTime(endTime.getHours(), endTime.getMinutes())
				);
			}

			if (requireStartAndEndString === false) {
				// For One Time use only time
				if (freqType === 'One_Time') {
					displayString = convertDatetoTime(startTime.getHours(), startTime.getMinutes());
				}

				return {
					timeStr: displayString,
					repeatStr:
						pattern.freq_subday_interval > 0
							? cvLoc('label.repeatPattern', hr, min, convertDatetoTime(endTime.getHours(), endTime.getMinutes()))
							: undefined,
					startDate: startTime ? startTime.toDateString() : undefined,
					intervalBetweenTwoJobs: freqType === 'After_Job_Completes' ? pattern.freq_interval : undefined
				};
			}

			return displayString + ' ' + startMsg + ' ' + repeadMsg;
		};

		return factory;
	}
]);

scheduleMod.directive('cvDataScheduleTile', [
	'scheduleUIFactory',
	'$rootScope',
	'scheduleService',
	'cvUtil',
	'$dialogs',
	'cvLoc',
	'profileService',
	'SCHEDULE_PROPERTY',
	'AppTypes',
	function(
		scheduleUIFactory,
		$rootScope,
		scheduleService,
		cvUtil,
		$dialogs,
		cvLoc,
		profileService,
		SCHEDULE_PROPERTY,
		AppTypes
	) {
		return {
			templateUrl: appUtil.appRoot + 'modules/schedule/partials/scheduleTile.jsp',
			scope: {
				model: '='
			},
			link: function(scope, element, attrs) {
				scope.dataModel = scope.model;
				scope.slaFlag = SCHEDULE_PROPERTY.SLA_FLAG;

				//Update the title
				if (scope.dataModel.scheduleTitle) {
					scope.scheduleTitle;
				} else {
					scope.scheduleTitle = cvLoc('header.schedules');
				}

				scope.sla = false;
				if (scope.dataModel.sla) {
					scope.sla = scope.dataModel.sla;
				}

				scope.scheduleType = '';
				if (scope.dataModel.scheduleType) {
					scope.scheduleType = scope.dataModel.scheduleType;
				}
				scope.planId = null;
				if (scope.dataModel.planId) {
					scope.planId = scope.dataModel.planId;
				}

				scope.planSubType = null;
				if (scope.dataModel.planSubType) {
					scope.planSubType = scope.dataModel.planSubType;
				}

				if (scope.dataModel.taskId) {
					scope.taskId = scope.dataModel.taskId;
				}

				scope.editPlanEnabled = true;
				if (scope.dataModel.editPlanEnabled) {
					scope.editPlanEnabled = scope.dataModel.editPlanEnabled;
				}

				scope.showEdit = true;
				if (scope.dataModel.showEdit) {
					scope.showEdit = scope.dataModel.showEdit;
				}
				scope.isScheduleEditable = true;

				var schedulAdd = 'scheduleAdded' + scope.scheduleType;
				scope.addSchedule = function() {
					var planId;
					scheduleUIFactory.addSchedule(
						'',
						false,
						scope.planSubType,
						true,
						scope.planId,
						scope.appType,
						null,
						null,
						schedulAdd
					);
				};

				var scheduleAddedListener = $rootScope.$on(schedulAdd, function(evt, schedule) {
					scheduleService
						.addSchedule(scope.subclientId, scope.taskId, schedule)
						.success(function(data) {
							scope.getSchedulesWithTaskId();
							scope.$emit('scheduleDataChanged', data);
						})
						.error(function(err) {
							scope.$emit('editScheduleFailed', err);
						});
				});

				var editScheduleOn = 'scheduleEdited' + scope.scheduleType;
				scope.editSchedule = function(schedule) {
					scope.currentSchedule = schedule;
					var sencondarySchedule = null;
					scheduleService.getScheduleDetails(schedule, sencondarySchedule).success(function(data) {
						//For the database plan we have to allow deletion of the SLA schedules
						// Our time picker needs a javascript Date object here; create one:
						var time = 0;
						var repeatTime = 0;
						data.taskId = scope.currentSchedule.taskId;
						data.subtaskId = scope.currentSchedule.subtaskId;
						data.isScheduleFromPolicy = scope.currentSchedule.taskType == 'SCHEDULE_POLICY' ? true : false;
						data.planSubType = scope.planSubType;
						if (data.activeStartTime || data.activeStartTime == 0) {
							time = data.activeStartTime;
							data.scheduleTime = cvUtil.convertCvTimeToDate(time);
							data.dailyBackupHours = data.scheduleTime.getHours();
							data.dailyBackupMinutes = data.scheduleTime.getMinutes();
						}
						if (data.repeat.time || data.repeat.time == 0) {
							repeatTime = data.repeat.time;
							data.repeat.time = cvUtil.convertCvTimeToDate(repeatTime);
						}
						//For the database plan data SLA schedule can be deleted
						if (scope.planSubType === 'Database' && scope.scheduleType === 'Data') {
							/*
							 * var hideDelete = false; if (data.freqType === 'AUTOMATIC_SCHEDULE') { // we
							 * should not allow deletion for the log SLAs hideDelete = true; } else if
							 * (data.flags == scope.slaFlag) { if (scope.scheduleIdentifierList.length < 2) {
							 * hideDelete = true; } }
							 */
							data.hideDelete = true;
						}
						data.scheduleType = scope.scheduleType;
						scheduleUIFactory.addSchedule(
							{
								source: '',
								model: data
							},
							scope.showEdit,
							scope.planSubType,
							true,
							scope.planId,
							scope.appType,
							attrs,
							null,
							editScheduleOn
						);
					});
				};

				var scheduleEditedListener = $rootScope.$on(editScheduleOn, function(evt, schedule) {
					scheduleService
						.modifySchedule(schedule.taskId, schedule.subtaskId, schedule, scope.subclientId)
						.success(function(data) {
							scope.getSchedulesWithTaskId();
							scope.$emit('scheduleDataChanged', schedule);
						})
						.error(function(err) {
							scope.$emit('editScheduleFailed', err);
						});
				});

				scope.getSchedulesWithTaskId = function() {
					// No need to get details from server as profile details request already gives the schedule details
					//using plan id instead of task id since api of getting schedules has been changed.
					//Todo: refactory this part of code with proper name in sp13
					scheduleService
						.getScheduleWithPlanId(scope.planId)
						.success(function(data) {
							// Update schedule data stored in the factory:
							if (data.scheduleIdentifierList) {
								scope.scheduleIdentifierList = data.scheduleIdentifierList;
								scope.oldTaskId = data.taskId;
								scope.currentSchedulePolicy = {
									taskId: data.taskId,
									taskName: data.taskName
								};
								scope.getSchedulePolicyRequest = true;
							} else {
								scope.scheduleIdentifierList = {};
							}
						})
						.error(function(data, status, headers, config) {
							scope.serverMessage = cvUtil.errMsgLoc('error.loadSchedules');
							scope.getSchedulePolicyRequest = true;
							scope.scheduleIdentifierList = {};
						});
				};
				scope.getSchedulesWithTaskId();

				scope.getScheduleName = function(scheduleIdentifier) {
					var scheduleName = '';
					if (scheduleIdentifier) {
						try {
							if (scheduleIdentifier.name && scheduleIdentifier.name != '') {
								scheduleName = scheduleIdentifier.name;
							} else {
								scheduleName = scheduleIdentifier.subtaskOptions.backupOpts.backupLevel;
							}
						} catch (e) {
							console.log(e);
						}
					}
					return scheduleName;
				};
				var deleteSchedule = 'scheduleDeleted' + scope.scheduleType;
				scope.deleteSchedule = function(schedule) {
					scope.currentSchedule = schedule;
					scheduleService
						.getScheduleDetails(schedule)
						.success(function(data) {
							data.taskId = scope.currentSchedule.taskId;
							data.subtaskId = scope.currentSchedule.subtaskId;
							scope.$emit(deleteSchedule, data);
						})
						.error(function(e) {
							scope.serverMessage = cvUtil.errMsgLoc('error.loadSchedules');
						});
				};

				scope.deleteScheduleAction = function(schedule) {
					scheduleService
						.deleteSchedule(schedule.taskId, schedule.subtaskId, scope.subclientId)
						.success(function(data) {
							scope.getSchedulesWithTaskId();
						})
						.error(function(e) {
							scope.serverMessage = cvUtil.errMsgLoc('error.deleteSchedule');
						});
				};
				var scheduleDeletedListener = $rootScope.$on(deleteSchedule, function(evt, schedule) {
					$dialogs.confirm(cvLoc('title.confirmDelete'), cvLoc('prompt.confirmDeleteSchedule'), {
						noFunction: function() {},
						yesFunction: function() {
							scope.deleteScheduleAction(schedule);
						}
					});
				});

				scope.$on('$destroy', function() {
					scheduleAddedListener();
					scheduleDeletedListener();
					scheduleEditedListener();
				});
			}
		};
	}
]);

scheduleMod.directive('cvScheduleTile', [
	'scheduleUIFactory',
	'$rootScope',
	'scheduleService',
	'cvUtil',
	'$dialogs',
	'cvLoc',
	'profileService',
	'SCHEDULE_PROPERTY',
	'AppTypes',
	'$state',
	function(
		scheduleUIFactory,
		$rootScope,
		scheduleService,
		cvUtil,
		$dialogs,
		cvLoc,
		profileService,
		SCHEDULE_PROPERTY,
		AppTypes,
		$state
	) {
		return {
			templateUrl: appUtil.appRoot + 'modules/schedule/partials/scheduleTile.jsp',
			scope: {
				subclientId: '=',
				taskId: '=',
				policyId: '=',
				showEdit: '=?',
				isScheduleEditable: '=?',
				planSubType: '=',
				showLoader: '=',
				appType: '=',
				schedules: '=',
				sla: '@',
				overrideText: '=?',
				profileId: '=',
				isLog: '@',
				helpText: '@'
			},
			link: function(scope, element, attrs) {
				var planSubType = scope.planSubType;
				scope.sla = angular.isDefined(attrs.sla) && attrs.sla == 'true' ? true : false;
				scope.isLog = angular.isDefined(attrs.isLog) && attrs.isLog == 'true' ? true : false;
				scope.slaFlag = SCHEDULE_PROPERTY.SLA_FLAG;
				scope.databasePlan = scope.planSubType === 'Database';
				scope.helpText = angular.isDefined(attrs.helpText) ? attrs.helpText : false;
				//handle schedule title based on passing id
				scope.scheduleTitle = attrs.subclientId
					? cvLoc('header.schedules')
					: attrs.taskId
					? cvLoc('title.primarySchedule')
					: planSubType == 'Snap'
					? cvLoc('title.snapToTape')
					: cvLoc('title.secondarySchedule');
				if (scope.sla) {
					scope.scheduleTitle = cvLoc('label.associatedSchedule');
				}
				//Copying the taskId into logTaskid to work log SLA schedule to work
				scope.logTaskId = attrs.taskId;
				scope.logPolicyId = attrs.policyId;

				scope.fullBackupRPOFlag = SCHEDULE_PROPERTY.FULL_BACKUP_RPO;

				scope.$watch('showLoader', function(newValue, oldValue) {
					if (newValue === null) {
						scope.getSchedulePolicyRequest = true;
					}
				});

				scope.serverMessage = {
					message: cvUtil.infoMsgLoc('Loading').message,
					type: 'loader'

					// Initailize isScheduleEditable only if the value is not provided from the directive
				};
				if (scope.isScheduleEditable === undefined) {
					scope.isScheduleEditable = true;

					if (
						scope.subclientId &&
						scope.appType != AppTypes.SQL_SERVER &&
						scope.appType != AppTypes.ORACLE &&
						scope.appType != AppTypes.POSTGRESQL
					) {
						// schedules are ineditable if subclient is associated to plan
						profileService
							.getPlanForSubclient(scope.subclientId)
							.success(function(data) {
								if (data.errorMessage) {
									scope.planMessage = {
										message: data.errorMessage,
										type: 'error'
									};
								} else {
									scope.isScheduleEditable = false;
								}
							})
							.error(function(e) {
								scope.planMessage = {
									message: e,
									type: 'error'
								};
							});
					}
				}

				scope.addSchedule = function() {
					var planId;
					scheduleUIFactory.addSchedule('', false, scope.planSubType, true, planId, scope.appType, attrs);
				};

				scope.deleteSchedule = function(schedule) {
					scope.currentSchedule = schedule;
					scheduleService
						.getScheduleDetails(schedule)
						.success(function(data) {
							data.taskId = scope.currentSchedule.taskId;
							data.subtaskId = scope.currentSchedule.subtaskId;
							scope.$emit('scheduleDeleted', data);
						})
						.error(function(e) {
							scope.serverMessage = cvUtil.errMsgLoc('error.loadSchedules');
						});
				};

				scope.deleteScheduleAction = function(schedule) {
					scheduleService
						.deleteSchedule(schedule.taskId, schedule.subtaskId, scope.subclientId)
						.success(function(data) {
							if (attrs.taskId) {
								scope.getSchedulesWithTaskId();
							} else {
								scope.getSchedules();
							}
							scope.$emit('scheduleDataChanged', data);
						})
						.error(function(e) {
							scope.serverMessage = cvUtil.errMsgLoc('error.deleteSchedule');
						});
				};

				scope.editSchedule = function(schedule) {
					scope.currentSchedule = schedule;
					//scope.localLang = cvUtil.getIStevenLocLabels();
					if (attrs.policyId) {
						var sencondarySchedule = true;
					}
					scheduleService
						.getScheduleDetails(schedule, sencondarySchedule)
						.success(function(data) {
							// Our time picker needs a javascript Date object here; create one:
							var time = 0;
							var repeatTime = 0;
							data.isScheduleFromPolicy = scope.currentSchedule.taskType == 'SCHEDULE_POLICY' ? true : false;
							data.taskId = scope.currentSchedule.taskId;
							data.subtaskId = scope.currentSchedule.subtaskId;
							data.planSubType = scope.planSubType;
							if (data.activeStartTime || data.activeStartTime == 0) {
								time = data.activeStartTime;
								data.scheduleTime = cvUtil.convertCvTimeToDate(time);
								data.dailyBackupHours = data.scheduleTime.getHours();
								data.dailyBackupMinutes = data.scheduleTime.getMinutes();
							}
							if (data.repeat.time || data.repeat.time == 0) {
								repeatTime = data.repeat.time;
								data.repeat.time = cvUtil.convertCvTimeToDate(repeatTime);
							}
							var planId;

							if (
								(data.flags == scope.slaFlag && scope.planSubType === 'Database') ||
								(scope.planSubType === 'Server' && data.operationType === 'SNAP_TO_TAPE')
							) {
								data.hideDelete = true; // database SLA schedule should not allowd to delete
							}

							//when edit automatic sla schedule, pass rpo minutes to check validation.(RPO time can not be less than min job interval)
							if (data.flags == scope.slaFlag && data.freqType === 'AUTOMATIC_SCHEDULE') {
								var rpo = data.maxBackupIntervalHours * 60 + data.maxBackupIntervalMinutes;
								if (scope.planSubType === 'Laptop') {
									rpo = data.minBackupIntervalHours * 60 + data.minBackupIntervalMinutes;
								}
								scheduleUIFactory.addSchedule(
									{
										source: '',
										model: data
									},
									scope.showEdit,
									scope.planSubType,
									true,
									planId,
									scope.appType,
									attrs,
									rpo
								);
							} else {
								scheduleUIFactory.addSchedule(
									{
										source: '',
										model: data
									},
									scope.showEdit,
									scope.planSubType,
									true,
									planId,
									scope.appType,
									attrs
								);
							}
						})
						.error(function(e) {
							scope.serverMessage = cvUtil.errMsgLoc('error.loadSchedules');
						});
				};

				//for secondarySchedule edit
				var secondaryScheduleEditedListener = $rootScope.$on('secondaryScheduleEdited', function(evt, schedule) {
					if (attrs.policyId) {
						scheduleService
							.modifySchedule(schedule.taskId, schedule.subtaskId, schedule, scope.subclientId, true)
							.success(function(data) {
								scope.getSchedulesWithPolicyId();
								scope.$emit('scheduleDataChanged', data);
							})
							.error(function(err) {
								scope.$emit('editScheduleFailed', err);
							});
					}
				});

				if (!$rootScope.$$listenerCount['scheduleEdited']) {
					var scheduleEditedListener = $rootScope.$on('scheduleEdited', function(evt, schedule) {
						if (
							!attrs.policyId ||
							(schedule.flags === SCHEDULE_PROPERTY.SLA_FLAG && schedule.planSubType === 'Laptop')
						) {
							scheduleService
								.modifySchedule(schedule.taskId, schedule.subtaskId, schedule, scope.subclientId)
								.success(function(data) {
									// only name change is visible on tile. Rest values are populated on load
									scope.scheduleIdentifierList.forEach(function(sch) {
										if (sch.subtaskId === schedule.subtaskId) {
											sch.name = schedule.name;
										}
									});
									scope.$emit('scheduleDataChanged', schedule);
									if (schedule.flags === SCHEDULE_PROPERTY.SLA_FLAG && schedule.planSubType === 'Laptop') {
										$state.reload();
									}
								})
								.error(function(err) {
									scope.$emit('editScheduleFailed', err);
								});
						}
					});
				}

				var scheduleDeletedListener = $rootScope.$on('scheduleDeleted', function(evt, schedule) {
					//this event will be triggerd twice when plan has secondary schedule, for secondary schedule, don't do anything
					if (!attrs.policyId) {
						$dialogs.confirm(cvLoc('title.confirmDelete'), cvLoc('prompt.confirmDeleteSchedule'), {
							noFunction: function() {},
							yesFunction: function() {
								scope.deleteScheduleAction(schedule);
							}
						});
					}
				});

				var scheduleAddedListener = $rootScope.$on('scheduleAdded', function(evt, schedule) {
					//this event will be triggerd twice when plan has secondary schedule, for secondary schedule, don't do anything
					if (!attrs.policyId) {
						scheduleService
							.addSchedule(scope.subclientId, scope.taskId, schedule)
							.success(function(data) {
								if (attrs.taskId) {
									scope.getSchedulesWithTaskId();
								} else {
									scope.getSchedules();
								}
								scope.$emit('scheduleDataChanged', data);
							})
							.error(function(err) {
								scope.$emit('editScheduleFailed', err);
							});
					}
				});

				var reloadScheduleListListener = $rootScope.$on('reloadScheduleList', function() {
					$log.debug('reloadScheduleList....');
					if (attrs.taskId) {
						scope.getSchedulesWithTaskId();
					} else if (attrs.policyId) {
						scope.getSchedulesWithPolicyId();
					} else {
						scope.getSchedules();
					}
				});

				scope.$on('$destroy', function() {
					scheduleAddedListener();
					reloadScheduleListListener();
					scheduleDeletedListener();
					if (scheduleEditedListener) {
						scheduleEditedListener();
					}
					secondaryScheduleEditedListener();
				});

				scope.getSchedules = function() {
					scheduleService
						.getScheduleIdentifierList(scope.subclientId)
						.success(function(data) {
							// Update schedule data stored in the factory:
							if (data.scheduleIdentifierList) {
								scope.scheduleIdentifierList = data.scheduleIdentifierList;
								scope.oldTaskId = data.taskId;
								scope.currentSchedulePolicy = {
									taskId: data.taskId,
									taskName: data.taskName
								};
								scope.getSchedulePolicyRequest = true;
							} else {
								scope.scheduleIdentifierList = {};
							}
							scope.schedulesLoaded = true;
						})
						.error(function(data, status, headers, config) {
							scope.serverMessage = cvUtil.errMsgLoc('error.loadSchedules');
							scope.getSchedulePolicyRequest = true;
							scope.scheduleIdentifierList = {};
							scope.schedulesLoaded = true;
						});
				};

				scope.getSchedulesWithTaskId = function() {
					// No need to get details from server as profile details request already gives the schedule details

					//using plan id instead of task id since api of getting schedules has been changed.
					//Todo: refactory this part of code with proper name in sp13
					scheduleService
						.getScheduleWithPlanId(scope.profileId, scope.isLog)
						.success(function(data) {
							// Update schedule data stored in the factory:
							if (data.scheduleIdentifierList && data.scheduleIdentifierList.length) {
								// Checking the array elements also
								scope.scheduleIdentifierList = data.scheduleIdentifierList;
								scope.oldTaskId = data.taskId;
								scope.currentSchedulePolicy = {
									taskId: data.taskId,
									taskName: data.taskName
								};
								scope.getSchedulePolicyRequest = true;
							} else {
								scope.schedulesLoaded = true; // This will show the message "No backups scheduled"
								scope.getSchedulePolicyRequest = true; // Stops refreshing of the tile
								scope.scheduleIdentifierList = {};
							}
						})
						.error(function(data, status, headers, config) {
							scope.serverMessage = cvUtil.errMsgLoc('error.loadSchedules');
							scope.getSchedulePolicyRequest = true;
							scope.scheduleIdentifierList = {};
						});
				};

				scope.getSchedulesWithPolicyId = function() {
					// No need to get details from server as profile details request already gives the schedule details
					var isSecondarySchedule = true;
					scheduleService
						.getScheduleWithPlanId(scope.profileId, scope.isLog, isSecondarySchedule)
						.success(function(data) {
							// Update schedule data stored in the factory:
							if (data.scheduleIdentifierList && data.scheduleIdentifierList.length) {
								// Checking the array elements also
								scope.scheduleIdentifierList = data.scheduleIdentifierList;
								scope.oldTaskId = data.taskId;
								scope.currentSchedulePolicy = {
									taskId: data.taskId,
									taskName: data.taskName
								};
								scope.getSchedulePolicyRequest = true;
							} else {
								scope.schedulesLoaded = true; // This will show the message "No backups scheduled"
								scope.getSchedulePolicyRequest = true; // Stops refreshing of the tile
								scope.scheduleIdentifierList = {};
							}
						})
						.error(function(data, status, headers, config) {
							scope.serverMessage = cvUtil.errMsgLoc('error.loadSchedules');
							scope.getSchedulePolicyRequest = true;
							scope.scheduleIdentifierList = {};
						});
				};

				scope.getSchedulePolicyRequest = false;

				// if schedules are not provided get schedules
				if (scope.schedules === undefined) {
					if (attrs.subclientId) {
						var unbindWatch = scope.$watch(attrs.subclientId, function(value) {
							if (value) {
								scope.getSchedules();
								unbindWatch();
							}
						});
					}
					if (attrs.taskId) {
						var unbindWatch = scope.$watch(attrs.taskId, function(value) {
							if (value) {
								scope.getSchedulesWithTaskId();
								unbindWatch();
							}
						});
					}

					if (attrs.policyId) {
						var unbindWatch = scope.$watch(attrs.policyId, function(value) {
							if (value) {
								scope.getSchedulesWithPolicyId();
								unbindWatch();
							}
						});
					}
				} else {
					// use the subtasks provided
					var convertTaskInfoToScheduleIdentifierList = function(taskInfo) {
						if (taskInfo != null) {
							var schedulePolicyData = {
								taskId: taskInfo.task.taskId,
								taskName: taskInfo.task.taskName,
								scheduleIdentifierList: []
							};
							for (var idx in taskInfo.subTasks) {
								var subTaskInfo = taskInfo.subTasks[idx];
								schedulePolicyData.scheduleIdentifierList.push({
									taskId: subTaskInfo.subTask.subTask.taskId || schedulePolicyData.taskId,
									subtaskId: subTaskInfo.subTask.subTaskId,
									name: subTaskInfo.subTask.subTaskName,
									description: subTaskInfo.pattern.description,
									flags: subTaskInfo.subTask.flags,
									fromPolicy: true,
									subtaskOptions: subTaskInfo.options
								});
							}
							return schedulePolicyData;
						} else {
							return null;
						}
					};

					var data = convertTaskInfoToScheduleIdentifierList(scope.schedules);

					scope.scheduleIdentifierList = data.scheduleIdentifierList;
					scope.oldTaskId = data.taskId;
					scope.currentSchedulePolicy = {
						taskId: data.taskId,
						taskName: data.taskName
					};
					scope.getSchedulePolicyRequest = true;
				}

				if (attrs.showEdit == undefined) {
					scope.showEdit = true;
				}

				scope.getScheduleName = function(scheduleIdentifier) {
					var scheduleName = '';
					if (scheduleIdentifier) {
						try {
							if (scheduleIdentifier.name && scheduleIdentifier.name != '') {
								scheduleName = scheduleIdentifier.name;
							} else {
								scheduleName = scheduleIdentifier.subtaskOptions.backupOpts.backupLevel;
							}
						} catch (e) {
							console.log(e);
						}
					}
					return scheduleName;
				};

				scope.isScheduleDeleteAllowed = function(scheduleIdentifier) {
					if (scheduleIdentifier.flags === scope.slaFlag) {
						return false;
					}

					if (scheduleIdentifier.flags === SCHEDULE_PROPERTY.FULL_BACKUP_RPO) {
						return false;
					}

					if (scope.planSubType === 'Server' && scheduleIdentifier.operationType === 'SNAP_TO_TAPE') {
						return false;
					}

					if (scheduleIdentifier.taskType == 'SCHEDULE_POLICY') {
						return false;
					}
					return scope.showEdit && scope.scheduleIdentifierList.length > 1 && !scope.policyId;
				};
			}
		};
	}
]);

export default scheduleMod;
