<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.reports">
<div class="need-attention-detail" data-ng-controller="NeedsAttentionJobsController as ctrl" >
	<h2><fmt:message key="jobs.detail.title"/></h2>
	<div class="detail-row row" data-ng-repeat="job in ctrl.data.jobs">
		<div class="col-lg-2 col-md-2 col-sm-2">
			<div class="entity-name job-name">
				<img data-ng-src="{{ctrl.jobImg}}"/>
				<span><a href="#/jobs/{{job.jobId}}">{{job.jobId}}</a></span>
			</div>
		</div>
		<div class="col-lg-10 col-md-10 col-sm-10">
			<div class="row">
				<div class="col-lg-3 col-md-3 col-sm-3 prop-col">
					<span class="prop-label"><fmt:message key="jobs.detail.server"/></span>
					<span class="prop-value">{{job.clientName}}</span>
				</div>
				<div class="col-lg-3 col-md-3 col-sm-3 prop-col">
					<span class="prop-label"><fmt:message key="jobs.detail.application"/></span>
					<span class="prop-value">{{job.appName}}</span>
				</div>
				<div class="col-lg-3 col-md-3 col-sm-3 prop-col">
					<span class="prop-label"><fmt:message key="jobs.detail.percelComplete"/></span>
					<span class="prop-value">{{job.percentComplete}}</span>
				</div>
				<div class="col-lg-3 col-md-3 col-sm-3 prop-col">
					<span class="prop-label"><fmt:message key="jobs.detail.state"/></span>
					<span class="prop-value">{{job.status}}</span>
				</div>
			</div>
			<div class="row second-row">
				<div class="col-lg-3 col-md-3 col-sm-3">
					<span class="prop-label"><fmt:message key="jobs.detail.commcell"/></span>
					<span class="prop-value">{{job.commCellName}}</span>
				</div>
				<div class="col-lg-3 col-md-3 col-sm-3">
					<span class="prop-label"><fmt:message key="jobs.detail.subclient"/></span>
					<span class="prop-value">{{job.subclientName}}</span>
				</div>
				<div class="col-lg-3 col-md-3 col-sm-3 ">
					<span class="prop-label"><fmt:message key="jobs.detail.runtTime"/></span>
					<span class="prop-value">{{job.elapseTime}}</span>
				</div>
				<div class="col-lg-3 col-md-3 col-sm-3 ">
					<span class="prop-label"><fmt:message key="jobs.detail.anomalyThreshold"/></span>
					<span class="prop-value">{{job.threshold}}</span>
				</div>
			</div>
		</div>
	</div>
	<cv-reports-show-loader show-loader="ctrl.data.showLoader"></cv-reports-show-loader>
	<cv-reports-no-data data-ng-if="ctrl.data.noData" no-data="ctrl.data.noData"></cv-reports-no-data>
</div>
</fmt:bundle>
