<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.reports">
<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header  data-title="systemCtrl.data.title"   title-details-link="systemCtrl.data.titleDetailsLink">
		</cv-reports-pane-header>
		<div class="dash-pane-content system-content">
			<div class="col-lg-6 col-md-6 col-sm-6 system-entities {{entity.type}}"   data-ng-repeat="entity in systemCtrl.data.entities">
					<div class="system-chart-title">{{entity.title}}</div>
					<a data-ng-href="{{systemCtrl.data.titleDetailsLink}}">
						<highchart config="entity.chartConfig"></highchart>
					</a>
					<div class="custom-legend-wrapper">
						<div data-ng-if="entity.customLegend.length == 0" class="no-system-error">
							<span><fmt:message key="appliance.system.allGood"></fmt:message></span>
						</div>
						<div data-ng-if="entity.customLegend.length > 0" class="custom-legend row">
							<div data-ng-class="{'col-sm-6': entity.customLegend.length ==2, 'col-sm-12': entity.customLegend.length ==1}">
								<span class="legend-value">{{entity.customLegend[0].value}}</span>
								<span class="legend-label">{{entity.customLegend[0].label}}</span>
							</div>
							<div data-ng-if="entity.customLegend.length ==2" class="col-sm-6">
								<span class="legend-value">{{entity.customLegend[1].value}}</span>
								<span class="legend-label">{{entity.customLegend[1].label}}</span>
							</div>
						</div>
					</div>
					<div data-ng-if="entity.type == 'memory'">
						<div class="usage-wrapper">
							<span class="usage-text"><fmt:message key="appliance.system.using" />:</span><span class="usage-values">{{systemCtrl.memoryUsage.used.value}}<span class="usage-unit">{{systemCtrl.memoryUsage.used.unit}}</span>/{{systemCtrl.memoryUsage.total.value}}<span class="usage-unit">{{systemCtrl.memoryUsage.total.unit}}</span></span>
						</div>
					</div>
				</div>
			<cv-reports-show-loader show-loader="systemCtrl.data.showLoader"></cv-reports-show-loader>
			<cv-reports-no-data data-ng-if="systemCtrl.data.noData" no-data="systemCtrl.data.noData"></cv-reports-no-data>
		</div>
	</div>
</div>
</fmt:bundle>