<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>

<div class="dash-pane" >
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header title="storageCtrl.data.title" titletooltip="storageCtrl.data.title" ></cv-reports-pane-header>
		<div class="dash-pane-content storage-usage-content">
			<div class="entities" data-ng-class="{'entity-seperator': !!entity.addSeperator }" ng-repeat="entity in storageCtrl.data.entities">
				<div class="storage-entity" >
					<a data-ng-if="entity.breakDown" cv-call-out title="{{entity.tooltip}}" template-path="{{storageCtrl.calloutTemplate}}" params="entity.breakDown">
						<div class="no-image-block">
							<div class="entity-title entity-link">
								<span>{{entity.title.value}}</span>
							</div>
							<div>
								<span class="entity-value">{{entity.value}}</span>
								<span class="entity-unit">{{entity.unit}}</span>
							</div>
						</div>
					</a>
					<a data-ng-if="!entity.breakDown" data-ng-href="{{entity.detailsLink}}" data-ng-click="storageCtrl.entityClicked()" title="{{entity.tooltip}}">
						<div class="no-image-block">
							<div class="entity-title entity-link">
								<span>{{entity.title.value}}</span>
							</div>
							<div>
								<span class="entity-value">{{entity.value}}</span>
								<span class="entity-unit">{{entity.unit}}</span>
							</div>
						</div>
					</a>
				</div>
			</div>
			<cv-reports-show-loader show-loader="storageCtrl.data.showLoader"></cv-reports-show-loader>
			<cv-reports-no-data data-ng-if="storageCtrl.noData" no-data="storageCtrl.noData"></cv-reports-no-data>
		</div>
	</div>
</div>


