<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script  nonce="${sessionScope.cspNonce}" type="text/ng-template"  id="cv_reports_pane_entity_inner.html">
	<div class="col-lg-4 col-md-4 col-sm-4 entity-image" data-ng-if="entity.svgSrc">
		<span ng-bind-html="entity.svgTrusted"></span>
	</div>
	<div class="col-lg-4 col-md-4 col-sm-4 entity-image" data-ng-if="entity.imgSrc">
		<img data-ng-src="{{entity.imgSrc}}"/>
	</div>
	<div data-ng-class="{ 'col-lg-8 col-md-8 col-sm-8': !!entity.hasImage, 'col-sm-12': !entity.hasImage, 'image-block': !!entity.hasImage, 'no-image-block': !entity.hasImage }">
		<div class="entity-title"
			data-ng-if="entity.title.placement && entity.title.placement === 'top' || entity.title.placement === 'both'"
			data-ng-class="{ 'entity-link': !!entity.detailsLink, 'no-entity-link': !entity.detailsLink }">
			<span data-ng-bind="entity.title.value.top ? entity.title.value.top : entity.title.value" />
		</div>
		<div data-ng-if="!reportsPaneEntityCtrl.showDataLoader">
			<span data-ng-if="!!entity.multiValues">
				<span class="sub-entity" ng-repeat="subentity in entity.multiValues">
					<span class="entity-value" data-ng-bind="subentity.value"></span>
					<span class="entity-subtitle" data-ng-class="{ 'entity-link': !!entity.detailsLink, 'no-entity-link': !entity.detailsLink }" data-ng-bind="::subentity.title"></span>
				</span>
			</span>
			<span data-ng-if="!entity.multiValues" class="entity-value" data-ng-bind="entity.value"></span>
			<span data-ng-if="!entity.multiValues" class="entity-unit" data-ng-if="entity.unit" data-ng-bind="::entity.unit"></span>
		</div>
		<div data-ng-if="reportsPaneEntityCtrl.showDataLoader" class="entity-data-loader"></div>
		<div class="entity-title"
			data-ng-if="!entity.title.placement || entity.title.placement === 'bottom' || entity.title.placement === 'both'"
			data-ng-class="{ 'entity-link': !!entity.detailsLink, 'no-entity-link': !entity.detailsLink }">
			<span data-ng-bind="::entity.title.value ? (entity.title.value.bottom ? entity.title.value.bottom : entity.title.value) : entity.title" />
		</div>
		<div ng-repeat="value in entity.change" class="trend-content">
			<span data-ng-if="value.subEntityHref"><a ng-href={{value.subEntityHref}} data-ng-bind="::value.name"/> </span>
			<span data-ng-if="!value.subEntityHref" class="trend-name"  data-ng-bind="::value.name"></span>
			<span class="trend-increase" data-ng-if="value.change === 'increase'">+</span>
			<span class="trend-decrease" data-ng-if="value.change === 'decrease'">-</span>
			<span data-ng-if="value.subEntityHref"><a ng-href={{value.subEntityHref}} data-ng-bind="::value.value"/> </span>
			<span data-ng-if="!value.subEntityHref" class="trend-value" data-ng-bind="value.value"></span>
			<span class="trend-unit" data-ng-if="value.unit" data-ng-bind="value.unit"></span>
		</div>
		<div data-ng-if="entity.anomaly" class="entity-anomaly" cv-call-out template-path="{{reportsPaneEntityCtrl.calloutTemplate}}" bypass="!entity.anomaly.breakDown || entity.anomaly.hideCallout" params="entity.anomaly.breakDown" ng-click="$event.stopPropagation()">
			<span class="entity-anomaly-value"><img class="entity-anomaly-icon" data-ng-src="{{entity.anomaly.imgSrc}}"/>{{entity.anomaly.currentCount}}</span><span class="entity-anomaly-value-text">{{entity.anomaly.lastHourText}}</span>
			<span class="entity-anomaly-text" data-ng-bind="entity.anomaly.text"></span>
		</div>
	</div>
</script>
<div class="dash-pane-content">
	<div class="entities" ng-repeat="entity in reportsPaneEntityCtrl.entities"
		data-ng-style="{width: '{{reportsPaneEntityCtrl.width}}'}" data-ng-class="{ '{{reportsPaneEntityCtrl.entityColClass}}': !!reportsPaneEntityCtrl.entityColClass}" >
		<div data-ng-if="!entity.isDummyEntity" data-ng-class="{ '{{entity.entityClass}}': !!entity.entityClass, 'entity-seperator': !!entity.addSeperator }">
			<div data-ng-if="entity.noData">
				<cv-reports-no-data no-data="entity.noData" />
			</div>
			<div>
				<a cv-call-out class="row entity-container" data-ng-class="{ 'disable-entity-link': !entity.detailsLink, 'dropdown-toggle': entity.breakDown }" ng-href="{{!entity.breakDown ? entity.detailsLink : ''}}" title="{{::entity.tooltip || entity.title.value}}" template-path="{{reportsPaneEntityCtrl.calloutTemplate}}" bypass="entity.hideCallout || !entity.breakDown" params="entity.breakDown">
					<div  ng-include="'cv_reports_pane_entity_inner.html'">
					</div>
				</a>
			</div>
		</div>
	</div>
	<div data-ng-if="reportsPaneEntityCtrl.notesEntity">
		<span class="entity-notes">
			<span data-ng-bind="::reportsPaneEntityCtrl.notesEntity.title.value"></span>: <span data-ng-bind="::reportsPaneEntityCtrl.notesEntity.value"></span>
		</span>
	</div>
</div>