<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script  nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
</script>

<div class="dash-pane">
	<div class="dash-pane-wrapper">
		<cv-reports-pane-header title="lastMonthJobsStatsCtrl.paneData.title" titletooltip="lastMonthJobsStatsCtrl.paneData.titletooltip">
		</cv-reports-pane-header>
		<div class="dash-pane-content">
			<div data-ng-if="!lastMonthJobsStatsCtrl.noData" class="entities col-lg-4 col-md-4 col-sm-4 col-xs-4"  ng-repeat="entity in lastMonthJobsStatsCtrl.paneData.entities">
				<div data-ng-class="{ '{{entity.entityClass}}': !!entity.entityClass, 'entity-seperator': !!entity.addSeperator }">
					<div data-ng-class="col-sm-12">
						<div class="entity-title-last-month-stats">
						<span data-ng-bind="entity.title.value"></span>
						</div>  					
					</div>
					
					<div class="entites col-lg-6 col-md-6 col-sm-6 col-xs-6" ng-repeat="result in entity.dataObject">
						<div data-ng-class="{ '{{result.entityClass}}': !!result.entityClass, 'entity-seperator': !!result.addSeperator }">
							<div data-ng-class="col-sm-12">
								<div class="entity-title-last-month-stats">
									<a href="{{result.filterUrl.url}}"><span data-ng-bind="result.title.value"></span></a>
									<br>
									<span class="entity-value" data-ng-bind="result.value.valueCount"></span>
								</div>
							</div>
						</div>
					</div>	
				</div>
			</div>
			<div data-ng-if="lastMonthJobsStatsCtrl.noData">
				<cv-reports-no-data no-data="lastMonthJobsStatsCtrl.paneData.noData " />
			</div>
		</div>
	</div>
</div>