<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/angular-gridster/jquery.resize.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/angular-gridster/angular-gridster.min.js?${applicationScope.BUILD_TS}"></script>
<link rel="stylesheet" href="${pageContext.request.contextPath}/reportsplus/js/angular-gridster/angular-gridster.min.css?${applicationScope.BUILD_TS}">

<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.network"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>

<div class="dashboard"  data-ng-controller="DashboardController as dashboard">
	<div  data-ng-if="!dashboard.dashboardError && !dashboard.loaded">
	  	 <cv:msg key="Loading" bundle="messages" />
	 </div>

	<dashboard-tile-panel data-ng-show="dashboard.isEditing"> </dashboard-tile-panel>

	<div data-ng-if="dashboard.loaded" class="dashboard-content">

	<div class="dashboard-error-wrapper" data-ng-if="dashboard.dashboardError">
	   <span>{{dashboard.dashboardErrorMsg}}</span>
	 </div>

	<div class="row" data-ng-if="!dashboard.dashboardError">
		<cv-dashboard-title-dropdown data-ng-if="dashboard.loaded"
			dashboard-type="dashboard.dashboardType"
			dashboard-name="dashboard.dashboardName"
			dashboard-overrides="dashboard.overrides"
			dashboard-name-changed="dashboard.nameChanged">
		</cv-dashboard-title-dropdown>
	</div>

	<div class="row" data-ng-if="!dashboard.dashboardError">
		<div data-ng-if="dashboard.showCommCellInfo" class="float-left">
	       <cv-commcell-info></cv-commcell-info>
		</div>

		<div class="meta-info" data-ng-if="dashboard.dashboardType === 'activate' && dashboard.fsoLastCollectionTime && dashboard.sdaLastCollectionTime">
			<span class="meta-item">
				<span class="meta-name"><cv:msg key="message.lastCollectionTime" bundle="reports"/>:</span>
				<span class="meta-val" data-ng-bind="dashboard.getMostRecentCollectionTime()"></span>
			</span>
	   </div>

		<div class="float-right dashboard-action-panel" data-ng-if="dashboard.dashboardEditor">
			<div data-ng-if="!dashboard.isEditing">
				<div class="dropdown page-action-item margin-0" uib-dropdown="uib-dropdown">
					 <button class="btn btn-link dropdown-toggle padding-5 padding-left-0" type="button" data-toggle="dropdown" uib-dropdown-toggle="uib-dropdown-toggle"><span class="k-icon k-i-more-vertical"></span></button>
			  		 <ul class="dropdown-menu" uib-dropdown-menu="uib-dropdown-menu">
			  		   	<li  data-ng-if="!dashboard.isEditing">
			  		   		<a data-ng-click="dashboard.setGridEditable(true)" title="<cv:msg key='dashboard.customizeTiles' bundle='reports'/>"><cv:msg key='dashboard.customize' bundle="reports"/></a>
			  		   	</li>

			  		   	<li  data-ng-if="!dashboard.isEditing">
	                        <a data-ng-click="dashboard.saveAsDashboard()" title="<cv:msg key='dashboard.cloneText' bundle='reports'/>"><cv:msg key='dashboard.clone' bundle="reports"/></a>
                        </li>
			  		   	<li  data-ng-if="dashboard.isCustomDashboard && !dashboard.builtInCustom">
			  		   		<a data-ng-click="dashboard.showSecurityModal()" title="<cv:msg key='dashboard.setPermissions' bundle='reports'/>"><cv:msg key='dashboard.security' bundle="reports"/></a>
			  		   	</li>

			  		   	<li data-ng-if="dashboard.isCustomDashboard"  class="menu-separator">
			  		   		<a data-ng-click="dashboard.deleteDashboard()" title="{{dashboard.deleteTooltip}}">{{dashboard.deleteText}}</a>
			  		   	</li>
			  		</ul>
			  	</div>
			  	<a data-ng-if="dashboard.dashboardType === 'activate'" class="page-action-item margin-top-5" data-ng-click="dashboard.doSyncCall()" title='<cv:msg key="label.sync" bundle="reports"/>'><span><cv:msg key="label.sync" bundle="reports"/></span><span class="glyphicon glyphicon-refresh sync-icon margin-left-5"></span></a>
			 </div>
		      <span data-ng-if="dashboard.isEditing" title="<cv:msg key='dashboard.saveChanges' bundle="reports"/>"><a class="page-action-item" data-ng-class="{disabled: !(dashboard.tileChanged || dashboard.nameChanged)}" data-ng-click="dashboard.saveDashboard()"><cv:msg key='dashboard.save' bundle='reports'/></a></span>
			  <span data-ng-if="dashboard.isEditing" title='<cv:msg key="dashboard.cancelChanges" bundle="reports"/>'><a class="page-action-item" data-ng-click="dashboard.cancelEdit()"><cv:msg key='dashboard.cancel' bundle='reports'/></a></span>
		</div>
	</div>
	<div class="drag-target-wrapper" x-lvl-drop-target="true" x-on-drop="dashboard.tileDropped(dragEl, dropEl, event)">
		<div class="no-tiles" data-ng-if="dashboard.isEmptyDashboard()">
			<label><cv:msg key="dashboard.dragDropTilesHere" bundle="reports"/></label>
		</div>
		<div data-gridster="dashboard.gridsterOpts" class="dashboard-grid">
			<ul>
				<li data-gridster-item="tile"  data-ng-repeat="(index, tile) in dashboard.tiles track by $index" class="dashboard-tile" >
					<span class="k-icon k-i-x remove-dashboard-tile"  data-ng-click="dashboard.removeTile(index, $event)" title="<cv:msg key='dashboard.removeTile' bundle='reports'/>"> </span>
					<cv-dashboard-tile
						tile-type="tile.tileType"
						dashboard-type="dashboard.dashboardType"
						data="dashboard.data"
						custom-class="dashboard.customClass"
						fso-last-collection-time='dashboard.fsoLastCollectionTime'
						sda-last-collection-time='dashboard.sdaLastCollectionTime'>
					</cv-dashboard-tile>
				</li>
			</ul>
		</div>
	</div>
	</div>
</div>

