import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/reports.constants.js';

reportsDashboardModule.service('reportsDashboardService', [
	'$http',
	'$q',
	'$log',
	'ReportsConstants',
	function reportsDashboardService($http, $q, $log, ReportsConstants) {
		var baseUrl = cvUtil.getContextPath() + '/proxy/cr/reportsplusengine/datasets';

		const datasetGuids = {
			LAST24HOURSTATS: '075e703a-b29f-46d6-ad29-7c1a60f7e4f3',
			DISKSPACEDATA: '2b366703-52e1-4775-8047-1f4cfa13d2db',
			SLAINFO: 'GetSLACounts',
			LARGESTSEVERSDATA: '841800ea-53c4-4249-91fa-76ea0d60f6a4',
			OVERVIEW: 'd0a73c45-b06d-4358-8d7e-d55d428ba75c'
		};

		function correctedCommUniId(commUniId) {
			if (cv.isCometApp) {
				return 0;
			}
			return commUniId;
		}

		return {
			getHealthSummary: getHealthSummary,
			getCurrentCapacity: getCurrentCapacity,
			getSLAInfo: getSLAInfo,
			getVSASLAInfo: getVSASLAInfo,
			getLast24HrsStats: getLast24HrsStats,
			getDiskSpaceData: getDiskSpaceData,
			getMetricsCommUniqId: getMetricsCommUniqId,
			getDataRetentionData: getDataRetentionData,
			getOverviewData: getOverviewData,
			getStorageUsageData: getStorageUsageData,
			getLastNBackupJobsSummary: getLastNBackupJobsSummary,
			getLargestSeversData: getLargestSeversData,
			getHardwareData: getHardwareData,
			getDataset: getDataset,
			getCriticalAlerts: getCriticalAlerts,
			getNeedAttentionData: getNeedAttentionData,
			getCPUandMemoryUsage: getCPUandMemoryUsage,
			getServerNeedsAttentionData: getServerNeedsAttentionData,
			getInfrastructureNeedsAttentionData: getInfrastructureNeedsAttentionData,
			getJobsNeedsAttentionData: getJobsNeedsAttentionData,
			getJobsAnomalyData: getJobsAnomalyData,
			getLastMonthStats: getLastMonthStats,
			getCommCellInfo: getCommCellInfo,
			getLaptopLocation: getLaptopLocation,
			getServerGroups: getServerGroups,
			getClientsCounts: getClientsCounts,
			getDrOverviewData: getDrOverviewData,
			getNewLastMonthStats: getNewLastMonthStats,
			getSiteReplicationData: getSiteReplicationData,
			getActivateSummary,
			doSyncCallForActivateSummary
		};

		function getDataset(datasetName) {
			return $http.get(baseUrl + '/' + datasetName + '/data');
		}
		function getHealthSummary(commUniId) {
			var url = `${baseUrl}/b50b20ed-5fc4-4b4c-f7c4-fc6b84eb35cc/data?cache=true&parameter.commUniId=${correctedCommUniId(
				commUniId
			)}`;
			return $http.get(url, httpHeader.jsonDefaultHeader);
		}

		function getCurrentCapacity(commUniId) {
			var url =
				baseUrl +
				'/METRICS_DEFAULT/data?cache=true&parameter.param8=12&parameter.param2=1&parameter.param3=0&parameter.param1=-1&parameter.param6=NULL&operation=METRICS_EXECUTE_SP&parameter.param7=0&parameter.spName=RptCapacityLicenseSurvey&parameter.param4=' +
				correctedCommUniId(commUniId) +
				'&parameter.param5=NULL';
			return $http.get(url, httpHeader.jsonDefaultHeader);
		}

		function getSLAInfo(dashboardType, slaType) {
			var url = `${baseUrl}/${datasetGuids.SLAINFO}/data?cache=true&parameter.i_DashboardType=${dashboardType}`;
			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getVSASLAInfo(clientId, subclientId) {
			var url = baseUrl + '/GetRPOClientStats/data?cache=true';
			if (clientId) {
				url += '&parameter.i_clientId=' + clientId;
			}
			if (subclientId) {
				url += '&parameter.i_subclientId=' + subclientId;
			}

			return $http.get(url);
		}

		function getLast24HrsStats(dashboardType) {
			var url = `${baseUrl}/${datasetGuids.LAST24HOURSTATS}/data?cache=true&parameter.i_DashboardType=${dashboardType}`;
			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getDiskSpaceData(dashboardType, storageType) {
			//storageType=0 Disk
			//storageType=2 Cloud
			if (storageType == undefined) {
				storageType = 0;
			}
			if (dashboardType == undefined) {
				dashboardType = 'commcell';
			}
			var orderbyVal = window.encodeURIComponent('"Date to be Full"');
			var url = `${baseUrl}/${datasetGuids.DISKSPACEDATA}/data?cache=true&parameter.i_DashboardType=${dashboardType}&parameter.storageType=${storageType}&orderby=${orderbyVal}`;
			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getOverviewData(dashboardType) {
			var url = `${baseUrl}/${datasetGuids.OVERVIEW}/data?cache=true&parameter.i_DashboardType=${dashboardType}`;
			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getStorageUsageData() {
			var url = `${baseUrl}/${datasetGuids.DISKSPACEDATA}/data?cache=true`;
			return $http.get(url, httpHeader.jsonDefaultHeader);
		}

		function getLastNBackupJobsSummary(dashboardType, days) {
			var timeZone = window.encodeURIComponent(cvUtil.getTimeZone().replace('Daylight', 'Standard'));
			var url =
				baseUrl +
				'/81fac2f4-d0d0-40f2-bcf7-1cbf5c9bbbc4/data?cache=true&parameter.i_DashboardType=' +
				dashboardType +
				'&parameter.nDays=' +
				days +
				'&parameter.timeZoneName=' +
				timeZone +
				'&orderby=DayBeginDT';

			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getMetricsCommUniqId() {
			var url = baseUrl + '/d08a6b3b-d27d-4c5a-90ba-2f74fd55387b/data?cache=true';
			return $http.get(url);
		}

		function getDataRetentionData(commUniId) {
			var url =
				baseUrl +
				'/METRICS_DEFAULT/data?cache=true&parameter.param2=0&parameter.param3=1&parameter.param1=-1&parameter.param6=NULL&operation=METRICS_EXECUTE_SP&parameter.spName=RptBkpDataRetention&parameter.param4=' +
				commUniId +
				'&parameter.param5=NULL';
			return $http.get(url);
		}

		function getLargestSeversData(dashboardType) {
			var param = '';
			if (dashboardType) {
				param = '?cache=true&parameter.i_dashboardType=' + dashboardType;
			}

			var url = `${baseUrl}/${datasetGuids.LARGESTSEVERSDATA}/data${param}`;

			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getHardwareData(storagePoolId) {
			var param = '';
			if (storagePoolId) {
				param = '&parameter.storagePoolId=' + storagePoolId;
			}
			var url = baseUrl + '/53db4dd8-d11b-4b42-a669-4068e7cc92c9/data?cache=true' + param;
			return $http.get(url);
		}

		function getCriticalAlerts(dashboardType) {
			var url = baseUrl + '/735e5e38-711c-48e0-9249-360acc05ac67/data?cache=true&parameter.nDays=1';
			return $http.get(url);
		}

		function getNeedAttentionData(entityTypes, dashboardType) {
			var url = '';
			if (dashboardType === 'Replication') {
				url =
					cvUtil.getContextPath() +
					'/proxy/CommServ/Anomaly/Entity/Count?anomalousEntityType=' +
					entityTypes +
					'&' +
					'dashboardType=' +
					dashboardType;
			} else {
				url = cvUtil.getContextPath() + '/proxy/CommServ/Anomaly/Entity/Count?anomalousEntityType=' + entityTypes;
			}
			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getServerNeedsAttentionData(anomalyType, drDashboardFilter) {
			var url =
				cvUtil.getContextPath() +
				'/proxy/CommServ/Anomaly/Clients?anomalyType=' +
				anomalyType +
				'&' +
				'anomalousDrClient=' +
				drDashboardFilter;
			return $http.get(url, httpHeader.jsonDefaultHeader);
		}

		function getInfrastructureNeedsAttentionData() {
			var url = cvUtil.getContextPath() + '/proxy/CommServ/Anomaly/Infrastructures?anomalyType=0';
			return $http.get(url, httpHeader.jsonDefaultHeader);
		}

		function getJobsNeedsAttentionData() {
			return $http.get('jobList.do?completedJobLookupTime=86400&showAnomalous=1');
		}

		function getJobsAnomalyData(dashboardType) {
			let url = cvUtil.getContextPath() + '/proxy/CommServ/Anomaly/Jobs';
			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getCPUandMemoryUsage(anomalyType) {
			var url =
				cvUtil.getContextPath() + '/proxy/CommServ/AnomalyType/Appliance/Nodes/Count?anomalyType=' + anomalyType;
			return $http.get(url);
		}

		function getLastMonthStats(dashboardType) {
			return $http.get(baseUrl + '/OrchestrationLastMonthStats/data?parameter.i_Type=' + dashboardType);
		}

		function getCommCellInfo() {
			//Commcell info dataset from metrics
			//var url = baseUrl + '/METRICS_DEFAULT/data?livefeed=true&parameter.surveyId=0&operation=METRICS_COMMCELL_DETAILS_2&parameter.surveyId=0&parameter.commUniId='+commUniId;

			//Commcell info dataset from commserv db
			var url = baseUrl + '/a0f077a5-2dfe-4010-a957-57a24cae89a8/data?cache=true';
			return $http.get(url);
		}

		function getLaptopLocation() {
			var url = baseUrl + '/fc7d932c-0ea2-44e5-cef1-fc15bd97faed/data?cache=true';
			return $http.get(url);
		}

		function getServerGroups() {
			var url = cvUtil.getContextPath() + '/proxy/ClientGroup';
			return $http.get(url);
		}

		function getClientsCounts(entityTypes, dashboardType) {
			//entityType - comma seperated like fileserver,vm,laptop,server
			if (!entityTypes) {
				entityTypes = 'fileserver,vm,laptop';
			}
			var url = cvUtil.getContextPath() + '/proxy/clients/count?type=' + entityTypes;
			return $http.get(url, getJsonHeader(dashboardType));
		}

		function getDrOverviewData(dashboardType) {
			var url =
				baseUrl + '/44020acb-d48f-4c30-885a-10e26197c60d/data?cache=true&parameter.i_DashboardType=' + dashboardType;
			return $http.get(url);
		}

		function getNewLastMonthStats(dashboardType) {
			var url =
				baseUrl + '/e2c99b2a-a0ab-493a-af79-8eac58959ab8/data?cache=true&parameter.i_DashboardType=' + dashboardType;
			return $http.get(url);
		}

		function getSiteReplicationData(dashboardType) {
			var url =
				baseUrl + '/b8a977ac-f9f2-4c1d-f048-d38e0e7a6758/data?cache=true&parameter.i_DashboardType=' + dashboardType;
			return $http.get(url);
		}

		function getActivateSummary(summaryType) {
			return $http.get(`${cvUtil.getContextPath()}/api/EDiscoveryClients/${summaryType}/Summary`);
		}

		function doSyncCallForActivateSummary() {
			const syncOperationTimeStamp = Date.now();
			sessionStorage.setItem('lastSyncTime', syncOperationTimeStamp);
			return $http.post(
				`${cvUtil.getContextPath()}/api/dcube/syncdsstatus?refresh=true`,
				{},
				{ 'Content-Type': 'text/plain' }
			);
		}

		function isMetallicSupportedDashboard(dashboardType) {
			let dashboardIndex = _.findIndex(metallicSupportedDashboards, dashboard => {
				return dashboard === dashboardType;
			});
			return dashboardIndex > -1;
		}

		function getJsonHeader(dashboardType) {
			let jsonHeader = httpHeader.jsonDefaultHeader;
			return jsonHeader;
		}
	}
]);

export default reportsDashboardModule;
