import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsUsageOverview', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<cv-reports-pane pane-data="UsageOverviewCtrl.overviewPane"></cv-reports-pane>`,
		require: [],
		bindToController: {
			dashboardType: '=',
			entityClass: '='
		},
		controller: 'UsageOverviewController',
		controllerAs: 'UsageOverviewCtrl'
	};
});
app.controller('UsageOverviewController', [
	'$location',
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	'multiCommcellFactory',
	function UsageOverviewController(
		$location,
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster,
		multiCommcellFactory
	) {
		var self = this;
		this.$onInit = function() {
			var entityClass = 'overview-env-entity';
			if (!!self.entityClass) {
				entityClass = self.entityClass;
			}

			var overviewEntitiesInfo = {
				servers: getEntityObj(cvLoc('entity.label.servers').toUpperCase(), getSeparatorPresence('servers')),
				vms: getEntityObj(cvLoc('entity.label.vms'), getSeparatorPresence('vms')),
				laptops: getEntityObj(cvLoc('entity.label.laptops').toUpperCase(), getSeparatorPresence('laptops')),
				users: getEntityObj(cvLoc('entity.label.users').toUpperCase(), getSeparatorPresence('users')),
				fileservers: getEntityObj(cvLoc('entity.label.fileServers').toUpperCase(), getSeparatorPresence('fileservers')),
				databases: getEntityObj(cvLoc('entity.label.databases').toUpperCase(), getSeparatorPresence('databases')),
				nasfilers: getEntityObj(cvLoc('entity.label.nas').toUpperCase(), getSeparatorPresence('nasfilers')),
				others: getEntityObj(
					cvLoc('entity.label.others').toUpperCase(),
					getSeparatorPresence('others'),
					PaneEntityTypes.NOTE
				),
				appliances: getEntityObj(cvLoc('entity.label.appliances'), getSeparatorPresence('appliances')),
				alerts: getEntityObj(cvLoc('entity.label.critical.alerts').toUpperCase(), getSeparatorPresence('alerts'))
			};

			function getSeparatorPresence(key) {
				var separatorPresenceMap = {
					servers: true,
					vms: true,
					laptops: true,
					users: false,
					fileservers: true,
					databases: false,
					nasfilers: true,
					others: false,
					appliances: true,
					alerts: false
				};

				if (separatorPresenceMap[key] != undefined) {
					return separatorPresenceMap[key];
				}
				return true;
			}

			function getEntityObj(title, addSeperator, type) {
				let data = {
					title: {
						value: title,
						placement: 'top'
					},
					value: 0,
					type: type ? type : PaneEntityTypes.OVERVIEW,
					//change: [{
					//		name: cvLoc('dashboard.label.trend.week').toUpperCase(),
					//		change: 'increase',
					//		value: 0
					//	}],
					entityClass: entityClass,
					addSeperator: addSeperator
				};
				if (cv.isCometApp) {
					data.breakDown = {
						isCallout: true,
						perCommcellData: []
					};
				}
				return data;
			}

			var path = $location.path().substring(1);

			overviewEntitiesInfo.fileservers.detailsLink = '#/fsServers?nav=' + path;
			overviewEntitiesInfo.vms.detailsLink = '#/virtualization/vms?vmStatus=ALL&nav=' + path;
			overviewEntitiesInfo.laptops.detailsLink = '#/devices';

			if (cv.userRole == 'Role_Restricted_User' || cv.userRole == 'Role_Tenant_User') {
				//No users entity, so do not add separator to the laptops
				overviewEntitiesInfo.laptops.addSeperator = false;
			} else {
				overviewEntitiesInfo.users.detailsLink = '#/users';
			}

			if (self.dashboardType !== 'appliance') {
				overviewEntitiesInfo.appliances.detailsLink = '#/applianceDashboard';
			} else {
				if (cv.csEnvironmentInfo) {
					if (
						cv.csEnvironmentInfo.isApplianceCS ||
						cv.csEnvironmentInfo.isCSWithApplianceNode ||
						cv.csEnvironmentInfo.isRefArchitecture
					) {
						overviewEntitiesInfo.appliances.detailsLink = '#/storage/hyperscale?nav=' + path;
					}
				}
			}

			overviewEntitiesInfo.alerts.detailsLink = '#/triggeredAlerts?view=critical-alerts';

			overviewEntitiesInfo.others.note = true;
			overviewEntitiesInfo.alerts.tooltip = cvLoc('entity.critical.alerts.tooltip');

			self.overviewPane = {
				title: cvLoc('usageOverview.title')
			};

			getOverviewData();
			if (self.dashboardType == 'appliance') {
				getCriticalAlerts();
			}

			function processOverviewStats(data) {
				data = reportsDashboardFactory.getJsonFromDSResult(data);
				//console.log(data);
				angular.forEach(data, function(row, i) {
					if (cv.isCometApp && row['Data Source'] != 'comet') {
						return;
					}
					var entityName = row['PropertyType'].toLowerCase();
					if (entityName == 'servers' || entityName == 'vms' || entityName == 'laptops') {
						return; //Will use new API to get client entity counts
					}
					if (entityName == 'blocks' || entityName == 'nodes') {
						if (entityName == 'blocks') {
							overviewEntitiesInfo.appliances.value = reportsDashboardFactory.getFormattedNumberNA(
								row['PropertyCount']
							);
						}
						//overviewEntitiesInfo.appliances.multiValues = overviewEntitiesInfo.appliances.multiValues || [];
						//overviewEntitiesInfo.appliances.multiValues.push({title: cvLoc('entity.label.'+entityName).toUpperCase(), value: reportsDashboardFactory.getFormattedNumberNA(row['PropertyCount'])});
					} else {
						var entity = overviewEntitiesInfo[entityName];
						entity.value = reportsDashboardFactory.getFormattedNumberNA(row['PropertyCount']);
					}
				});
				var entities = [];
				if (
					self.dashboardType == 'commcell' ||
					self.dashboardType == 'appliancecommcell' ||
					self.dashboardType == 'tenant'
				) {
					if (self.dashboardType == 'appliancecommcell') {
						entities.push(overviewEntitiesInfo.appliances);
					}
					entities.push(overviewEntitiesInfo.fileservers);
					entities.push(overviewEntitiesInfo.vms);
					entities.push(overviewEntitiesInfo.laptops);
					if (!(cv.userRole == 'Role_Restricted_User' || cv.userRole == 'Role_Tenant_User')) {
						entities.push(overviewEntitiesInfo.users);
					}
				} else if (self.dashboardType == 'server') {
					entities.push(overviewEntitiesInfo.fileservers);
					entities.push(overviewEntitiesInfo.nasfilers);
					entities.push(overviewEntitiesInfo.databases);
					entities.push(overviewEntitiesInfo.others);
				} else if (self.dashboardType == 'appliance') {
					entities.push(overviewEntitiesInfo.appliances);
					entities.push(overviewEntitiesInfo.fileservers);
					entities.push(overviewEntitiesInfo.vms);
					entities.push(overviewEntitiesInfo.alerts);
				}
				self.overviewPane.showLoader = false;
				self.overviewPane.entities = entities;
			}

			function getCriticalAlerts() {
				reportsDashboardService
					.getCriticalAlerts(self.dashboardType)
					.success(function(data) {
						data = reportsDashboardFactory.getJsonFromDSResult(data);
						//console.log(data);

						angular.forEach(data, function(row, i) {
							var current = row['CriticalAlerts'];
							var previous = row['PreviousCriticalAlerts'];
							var diff = current - previous;
							overviewEntitiesInfo.alerts.value = reportsDashboardFactory.getFormattedNumberNA(current);
							//overviewEntitiesInfo.alerts.change[0].value = Math.abs(diff);
							//overviewEntitiesInfo.alerts.change[0].change = (diff >= 0)?'increase':'decrease';
						});
					})
					.error(function(err) {
						console.log(err);
						reportsDashboardFactory.showErrorMessage(err, 'Critical Alerts');
					});
			}

			function cleanData(data) {
				if (data.fileServerCount) {
					data.fileServerCount = reportsDashboardFactory.getFormattedNumberNA(
						data.fileServerCount > 0 ? data.fileServerCount : 0
					);
				}
				if (data.vmCount) {
					data.vmCount = reportsDashboardFactory.getFormattedNumberNA(data.vmCount > 0 ? data.vmCount : 0);
				}
				if (data.laptopCount) {
					data.laptopCount = reportsDashboardFactory.getFormattedNumberNA(data.laptopCount > 0 ? data.laptopCount : 0);
				}
				return data;
			}

			function processClientCounts(data) {
				if (data) {
					let content = {};
					if (cv.isCometApp) {
						content = cleanData(data.totalCount);
					} else {
						content = cleanData(data);
					}
					overviewEntitiesInfo.fileservers.value = _.get(content, 'fileServerCount', 0);
					overviewEntitiesInfo.vms.value = _.get(content, 'vmCount', 0);
					overviewEntitiesInfo.laptops.value = _.get(content, 'laptopCount', 0);
				}
			}

			function getDefaultGridObject(commcellName) {
				return {
					commcellName,
					commcellLink: cvUtil.modifyUrlForComet('#/dashboard/commcell', commcellName),
					fileServerLink: cvUtil.modifyUrlForComet(overviewEntitiesInfo.fileservers.detailsLink, commcellName),
					vmsLink: cvUtil.modifyUrlForComet(overviewEntitiesInfo.vms.detailsLink, commcellName),
					usersLink: cvUtil.modifyUrlForComet(overviewEntitiesInfo.users.detailsLink, commcellName),
					laptopLink: cvUtil.modifyUrlForComet(overviewEntitiesInfo.laptops.detailsLink, commcellName),
					target: '_blank',
					users: 0,
					vmCount: 0,
					laptopCount: 0,
					fileServerCount: 0
				};
			}

			function createGrid(clientCounts, overviewStats) {
				if (!cv.isCometApp) {
					return;
				}
				overviewStats = reportsDashboardFactory.getJsonFromDSResult(overviewStats);
				const entityToCountMap = {
					fileservers: 'fileServerCount',
					laptops: 'laptopCount',
					vms: 'vmCount'
				};
				_.forEach(overviewEntitiesInfo, (overviewEntity, key) => {
					if (_.includes(_.keys(entityToCountMap), key) && clientCounts.cometClientCount) {
						_.forEach(clientCounts.cometClientCount, clientCount => {
							let commcellName = _.get(clientCount, 'commcell.commCellName', '');
							let valueData = clientCount[entityToCountMap[key]];
							overviewEntity.breakDown.perCommcellData.push({
								commcellName,
								rowData: [
									{
										columnName: key,
										value: valueData,
										link: cvUtil.modifyUrlForComet(overviewEntity.detailsLink, commcellName),
										target: '_blank'
									}
								],
								visible: valueData > 0
							});
						});
					}
					let clickFunction = multiCommcellFactory.redirectToCommcell;
					if (key == 'users') {
						_.forEach(overviewStats, row => {
							let commcellName = row['Data Source'];
							if (commcellName == 'comet') {
								return;
							}
							if (_.get(row, 'PropertyType', '').toLowerCase() != key) {
								return;
							}
							overviewEntity.breakDown.perCommcellData.push({
								commcellName,
								rowData: [
									{
										columnName: key,
										value: row.PropertyCount,
										link: cvUtil.modifyUrlForComet(overviewEntity.detailsLink, commcellName),
										target: '_blank'
									}
								],
								visible: row.PropertyCount > 0,
								clickFunction
							});
						});
					}
				});
			}

			function getOverviewData() {
				var entityTypes = 'fileserver,vm,laptop';
				self.overviewPane.showLoader = true;
				let promises = [
					reportsDashboardService.getClientsCounts(entityTypes, self.dashboardType),
					reportsDashboardService.getOverviewData(self.dashboardType)
				];
				Promise.all(promises)
					.then(results => {
						let clientCounts = results[0].data;
						processClientCounts(clientCounts);
						let overviewStats = results[1].data;
						processOverviewStats(overviewStats);
						createGrid(clientCounts, overviewStats);
					})
					.catch(err => {
						if (err.xhrStatus !== 'abort') {
							self.overviewPane.showLoader = false;
							reportsDashboardFactory.showErrorMessage(err, self.overviewPane.title);
							self.overviewPane.paneClass = 'overview-env';
							self.overviewPane.noData = { text: cvLoc('dashboard.error.server') };
						}

						console.log(err);
					});
			}
		};
	}
]);
