import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsSla', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsSla.jsp',
		bindToController: {
			slaData: '='
		},
		controller: 'DashboardSLAController',
		controllerAs: 'slaCtrl'
	};
});
app.controller('DashboardSLAController', [
	'$location',
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'ChartColors',
	'cvToaster',
	'multiCommcellFactory',
	function DashboardSLAController(
		$location,
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		ChartColors,
		cvToaster,
		multiCommcellFactory
	) {
		var self = this;
		this.$onInit = function() {
			self.docLink =
				'http://documentation.commvault.com/commvault/v11/article?p=features/reports/metrics/health_check_settings.htm#improving_sla';
			self.data = {
				title: self.slaData.dashboardType == 'virtualization' ? cvLoc('sla.commcell.title') : cvLoc('sla.title'),
				detailsLink: self.slaData.link
					? self.slaData.link
					: self.slaData.dashboardType === 'Replication'
					? '/adminconsole/#/replicationMonitor'
					: '/adminconsole/#/reportDetails?reportId=SLA&app=ADMIN_CONSOLE',
				detailsLinkNewPage: !!self.slaData.linkNewPage ? true : false
			};
			self.slaBreakdown = {};
			if (cv.isCometApp) {
				self.data.breakDown = {
					isCallout: true,
					perCommcellData: []
				};
			}
			if (self.slaData.dashboardType !== 'Replication') {
				var path = $location.path().substring(1);
				self.data.detailsLink = self.data.detailsLink + '&nav=' + path;
			}
			if (!!self.slaData) {
				self.showTitle = self.slaData.showTitle == undefined || self.slaData.showTitle ? true : false;
				self.showRpo = self.slaData.showRpo == undefined || self.slaData.showRpo ? true : false;
				self.showRto = self.slaData.showRto == undefined || self.slaData.showRto ? true : false;
				self.showDocLink = self.slaData.showDocLink == undefined || self.slaData.showDocLink ? true : false;
			} else {
				self.showTitle = true;
				self.showRpo = true;
				self.showRto = true;
				self.showDocLink = true;
			}
			self.showRpo = true;
			self.showRto = false;
			if (self.slaData.showAsSmaller) {
				self.showDocLink = false;
			}
			self.showBoth = self.showRpo && self.showRto;

			var SLA_TYPE = {
				RPO: 1,
				RTO: 2,
				BOTH: 3
			};
			self.excludedClients = 0;
			self.getFormattedNumberNA = function(val) {
				return reportsDashboardFactory.getFormattedNumberNA(val);
			};

			getSLAInfo(SLA_TYPE.RPO);

			function getSLAInfo(type) {
				self.data.showLoader = true;
				if (self.slaData.dashboardType == 'serverDetails' || self.slaData.dashboardType === 'colletionDetails') {
					reportsDashboardService
						.getVSASLAInfo(self.slaData.clientId, self.slaData.subclientId)
						.then(function(data) {
							onSuccess(data.data, type);
						})
						.catch(function(err) {
							onError(err);
						});
				} else {
					reportsDashboardService
						.getSLAInfo(self.slaData.dashboardType)
						.then(function(data) {
							onSuccess(data.data, type);
						})
						.catch(function(err) {
							onError(err);
						});
				}
			}

			function setSlaGrid() {
				self.data.detailsLinkModified = self.data.detailsLink;
				if (!cv.isCometApp) {
					return;
				}
				self.calloutTemplate = appUtil.appRoot + 'modules/reports/partials/perDashboardCallout.jsp';
				self.data.detailsLinkModified = undefined;
				_.forEach(self.slaBreakdown, (commcellData, commcellName) => {
					let clickFunction = multiCommcellFactory.redirectToCommcell;
					self.data.breakDown.perCommcellData.push({
						commcellName,
						// Use a single link for the entire row
						singleRowLink: true,
						commcellColumnName: cvLoc('label.commcell'),
						rowData: [
							{
								columnName: cvLoc('label.metSLA'),
								value: commcellData.MetSLA || 0,
								link: commcellData.detailsLink,
								target: commcellData.target
							},
							{
								columnName: cvLoc('label.missedSLA'),
								value: commcellData.MissedSLA || 0,
								link: commcellData.detailsLink,
								target: commcellData.target
							}
						],
						clickFunction
					});
				});
				self.data.breakDown.perCommcellData = _.orderBy(
					self.data.breakDown.perCommcellData,
					['rowData[1].value', 'commcellName'],
					['desc', 'asc']
				);
			}

			function onSuccess(data, type) {
				self.data.showLoader = false;
				data = reportsDashboardFactory.getJsonFromDSResult(data);
				if (data.length > 0) {
					var sla_rpo = {
						protectedClients: 0,
						unprotectedClients: 0
					};

					var weeklySla = {
						protectedClients: 0,
						unprotectedClients: 0
					};
					angular.forEach(data, function(row, r) {
						if (cv.isCometApp && row['Data Source'] != 'comet') {
							if (!self.slaBreakdown[row['Data Source']]) {
								self.slaBreakdown[row['Data Source']] = {
									commcellName: row['Data Source'],
									commcellLink: cvUtil.modifyUrlForComet('#/overviewDashboard', row['Data Source'])
								};
							}
							self.slaBreakdown[row['Data Source']][row.SLAStatus.replace(' ', '')] = row.CurrentCount;
							self.slaBreakdown[row['Data Source']].detailsLink = cvUtil.modifyUrlForComet(
								'#/reportDetails?reportId=SLA&app=ADMIN_CONSOLE',
								row['Data Source']
							);
							self.slaBreakdown[row['Data Source']].target = '_blank';
						} else {
							if (self.slaData.dashboardType == 'endpoint' && row.ExcludeCount) {
								self.excludedClients = row.ExcludeCount;
							}
							if (self.slaData.dashboardType == 'Replication') {
								if (row['Data Source'] === cv.commcellName) {
									if (row.SLAStatus == 'Met SLA') {
										sla_rpo.protectedClients = row.CurrentCount;
										//weeklySla.protectedClients = row.LastWeekCount;
									} else if (row.SLAStatus == 'Missed SLA') {
										sla_rpo.unprotectedClients = row.CurrentCount;
										//weeklySla.unprotectedClients = row.LastWeekCount;
									}
								}
							} else {
								if (row.SLAStatus == 'Met SLA') {
									sla_rpo.protectedClients = row.CurrentCount;
									//weeklySla.protectedClients = row.LastWeekCount;
								} else if (row.SLAStatus == 'Missed SLA') {
									sla_rpo.unprotectedClients = row.CurrentCount;
									//weeklySla.unprotectedClients = row.LastWeekCount;
								}
							}
						}
					});
					setSlaGrid();
					if (!(sla_rpo.protectedClients <= 0 && sla_rpo.unprotectedClients <= 0)) {
						buildSLAData(SLA_TYPE.RPO, sla_rpo, weeklySla);
						if (self.excludedClients > 0) {
							var msgKey = 'sla.excluded.commcell';
							if (self.slaData.dashboardType) {
								msgKey = 'sla.excluded.' + self.slaData.dashboardType.toLowerCase();
							}
							self.excludedClientsStr = cvLoc(
								msgKey,
								reportsDashboardFactory.getFormattedNumberNA(self.excludedClients)
							);
						}
					} else {
						self.noData = { text: cvLoc('sla.msg.no_data_available') };
					}
				} else {
					self.noData = { text: cvLoc('sla.msg.no_data_available') };
				}
			}

			function onError(err) {
				if (err.xhrStatus !== 'abort') {
					self.data.showLoader = false;
					reportsDashboardFactory.showErrorMessage(err, self.data.title);
					self.noData = { text: cvLoc('dashboard.error.server') };
				}
			}
			function buildSLAData(type, sla, weeklySla) {
				sla = calcSLAPercent(sla);
				weeklySla = calcSLAPercent(weeklySla);
				var diff = sla.slaPercent - weeklySla.slaPercent;
				var slaData = {
					sla: sla,
					weeklySla: weeklySla,
					trend: {
						diff: diff,
						dispVal: Math.abs(diff),
						symbol: diff > 0 ? '+' : diff < 0 ? '-' : ''
					}
				};
				slaData.type = type;
				if (type == SLA_TYPE.RPO) {
					slaData.title = cvLoc('sla.label.rpo').toUpperCase();
				} else {
					slaData.title = cvLoc('sla.label.rto').toUpperCase();
				}
				processData(slaData);
			}
			function calcSLAPercent(data) {
				var slapercent = 0;
				if (data.protectedClients > 0 || data.unprotectedClients > 0) {
					slapercent = parseFloat(
						(data.protectedClients / (data.protectedClients + data.unprotectedClients)) * 100
					).toFixed(2);
					slapercent = Math.floor(slapercent);
				}

				data.slaPercent = slapercent;
				data.failPercent = 100 - slapercent;

				return data;
			}
			function processData(data) {
				var sla = {
					met: {
						name: cvLoc('sla.label.met').toUpperCase(),
						y: data.sla.protectedClients,
						slaPercent: data.sla.slaPercent,
						dispValue: reportsDashboardFactory.getFormattedNumberNA(data.sla.protectedClients),
						cls: 'background-color-success'
					},
					missed: {
						name: cvLoc('sla.label.missed').toUpperCase(),
						y: data.sla.unprotectedClients,
						slaPercent: data.sla.failPercent,
						dispValue: reportsDashboardFactory.getFormattedNumberNA(data.sla.unprotectedClients),
						cls: 'background-color-critical',
						details: true
					}
				};
				var trendClass = data.trend.diff >= 0 ? 'color-success' : 'color-critical';
				var chartData = [];
				chartData.push(sla.met);
				chartData.push(sla.missed);

				var dialColors = [ChartColors.SUCCESS, ChartColors.FAILURE];
				var chartConfig = {
					options: {
						chart: {
							type: 'pie',
							margin: [0, 0, 0, 0],
							spacingTop: 0,
							spacingBottom: 30,
							spacingLeft: 0,
							spacingRight: 0
						},
						tooltip: {
							enabled: false,
							headerFormat: '',
							useHTML: true,
							style: {
								fontSize: '0.75em'
							},
							formatter: function() {
								return this.point.name + ': <b>' + this.point.dispValue + ' (' + this.point.slaPercent + '%)</b>';
							}
						},
						plotOptions: {
							pie: {
								cursor: 'pointer',
								dataLabels: {
									enabled: false
								},
								showInLegend: true,
								point: {
									events: {
										click: function() {
											if (this.options.details) {
												//location.href = detailsLink;
											}
										},
										mouseOver: function(jqEvent) {
											if (this.options.details) {
												this.graphic.element.style.cursor = 'pointer';
											}
										}
									}
								}
							},
							series: {
								states: {
									hover: {
										enabled: false
									}
								}
							}
						},
						legend: {
							enabled: false
						},
						exporting: {
							enabled: false
						},

						colors: dialColors
					},
					title: {
						text: ''
					},
					enabled: false,
					subtitle: {
						text:
							'<div class="dial-center-wrapper"><div class="dial-center-percent">' +
							sla.met.slaPercent +
							'%</div></div>',
						x: 0,
						y: 52,
						floating: true,
						useHTML: true
					},
					credits: {
						enabled: false
					},

					series: [
						{
							colorByPoint: true,
							animation: true,
							innerSize: '85%',
							data: chartData
						}
					]
				};

				self.entities = self.entities || [];
				self.entities.push({
					type: data.type,
					title: data.title,
					chartConfig: chartConfig,
					data: sla
				});
			}
		};
	}
]);

export default app;
