import { reportsDashboardModule } from 'common/js/modules';

var app = reportsDashboardModule;

/**
 * Creates a single entity tile for the Reports Dashboard
 *
 * Usage <br>
 * ========= <br>
 *
 * <p>
 * Provide an object input(data) with the below structure
 * </p>
 *
 * <code>
 * var tileData = {
 * 	text: '', //The label for the tile
 *  value: '', //Value for the tile
 *  unit: '' //Units
 *  imgSrc: '', //Icon for the tile
 * 	tileClass: '', //css classes to apply for the entire tile
 *  detailsLink: '', //hyperlink for the tile
 *  noData: {},	// See cv-reports-no-data-directive.js for usage
 *  showLoader: true | false // Shows the AC loader
 * }
 * <code>
 *
 * <p>tileData is fed to the cv-reports-single-entity.js file that handles displaying the data on the tile</p>
 */
app.directive('cvReportsSingleEntity', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsSingleEntityTile.jsp',
		require: [],
		bindToController: {
			tileData: '='
		},
		controller: 'SingleEntityController',
		controllerAs: 'entityCtrl'
	};
});
app.controller('SingleEntityController', [
	'cvLoc',
	function SingleEntityController(cvLoc) {
		var self = this;
	}
]);
