import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

const app = reportsDashboardModule;

app.directive('cvReportsSdaOverview', function() {
	return {
		restrict: 'E',
		scope: {
			sdaLastCollectionTime: '='
		},
		template: `<cv-reports-pane pane-data="sdaOverviewCtrl.overviewPane"></cv-reports-pane>`,
		require: [],
		bindToController: true,
		controller: 'SdaOverviewController',
		controllerAs: 'sdaOverviewCtrl'
	};
});
app.controller('SdaOverviewController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	'$timeout',
	function SdaOverviewController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster,
		$timeout
	) {
		this.$onInit = function() {
			const entityClass = 'activate-report-pane-entity';
			const overviewEntitiesInfo = {
				totalCount: getEntityObj(
					cvLoc('entity.sdaOverview.label.projects').toUpperCase(),
					undefined,
					true,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50">
						<path d="M7 17V3a.4.4 0 0 1 .3-.3H25a.6.6 0 0 1 .6.5v5.3a1 1 0 0 0 1 1h4.8a.6.6 0 0 1 .6.6v16.2h2V8.6a1.1 1.1 0 0 0-.3-.8L27.5 1a.9.9 0 0 0-.8-.3H7.3c-1.5 0-2.4.4-2.4 2V17H1.3a1.9 1.9 0 0 0-1 .3 1.3 1.3 0 0 0-.3 1v27.1a1.3 1.3 0 0 0 1.3 1.3H3L7 39V17z"></path>
						<path d="M48.4 27.2h-9.9v-7.3a2.8 2.8 0 0 0-2.5-2.7v10H14.4a3 3 0 0 0-2.5 1.7L7 39v7.3a3 3 0 0 0 3 3h27.7a3.7 3.7 0 0 0 2.7-1.8L49.7 30c.8-1.6-.1-2.8-1.3-2.8zM28.9 11.7H10.2a1.2 1.2 0 1 0 0 2.4H29a1.2 1.2 0 0 0 1.2-1.2 1.3 1.3 0 0 0-1.3-1.2z"></path>
						<path d="M30.2 20.3A1.2 1.2 0 0 0 29 19H10.2a1.2 1.2 0 0 0 0 2.5H29a1.3 1.3 0 0 0 1.2-1.2zM8.8 27.6a1.2 1.2 0 0 0 1.3 1.2h.5a4 4 0 0 1 2.8-2.5h-3.2a1.4 1.4 0 0 0-1.3 1.3z"></path>
				</svg>`,
					`#/sdg`
				),
				totalEntitiesCount: getEntityObj(
					cvLoc('entity.sdaOverview.label.sensitive').toUpperCase(),
					cvLoc('entity.sdaOverview.label.sensitiveDocs').toUpperCase(),
					true,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<g><g><path d="M7.2,12.367h6.2c0.571,0,1.034-0.462,1.034-1.033c0-0.572-0.463-1.034-1.034-1.034H7.2
							c-0.571,0-1.034,0.462-1.034,1.034C6.166,11.904,6.629,12.367,7.2,12.367z"></path>
						<path d="M18.567,12.367h9.3c0.571,0,1.033-0.462,1.033-1.033c0-0.572-0.462-1.034-1.033-1.034h-9.3
							c-0.571,0-1.034,0.462-1.034,1.034C17.533,11.904,17.996,12.367,18.567,12.367z"></path>
						<path d="M7.2,23.733h33.066c0.57,0,1.033-0.462,1.033-1.033c0-0.571-0.463-1.034-1.033-1.034H7.2
							c-0.571,0-1.034,0.463-1.034,1.034C6.166,23.271,6.629,23.733,7.2,23.733z"></path>
						<path d="M7.2,27.867h14.466c0.572,0,1.034-0.462,1.034-1.033c0-0.572-0.462-1.034-1.034-1.034H7.2
							c-0.571,0-1.034,0.462-1.034,1.034C6.166,27.404,6.629,27.867,7.2,27.867z"></path>
						<path d="M7.2,36.133h14.466c0.572,0,1.034-0.462,1.034-1.033c0-0.57-0.462-1.033-1.034-1.033H7.2
							c-0.571,0-1.034,0.463-1.034,1.033C6.166,35.671,6.629,36.133,7.2,36.133z"></path>
						<path d="M7.2,44.4h14.466c0.572,0,1.034-0.464,1.034-1.033c0-0.571-0.462-1.035-1.034-1.035H7.2
							c-0.571,0-1.034,0.464-1.034,1.035C6.166,43.937,6.629,44.4,7.2,44.4z"></path>
						<path d="M7.2,52.668h14.466c0.572,0,1.034-0.464,1.034-1.035c0-0.569-0.462-1.033-1.034-1.033H7.2
							c-0.571,0-1.034,0.464-1.034,1.033C6.166,52.204,6.629,52.668,7.2,52.668z"></path>
						<path d="M62.379,31.101L50.6,26.014V4.1c0-1.712-1.388-3.1-3.1-3.1H8.233
							c-1.712,0-3.1,1.388-3.1,3.1v1.033H4.1c-1.712,0-3.1,1.388-3.1,3.1V59.9C1,61.612,2.388,63,4.1,63h39.267
							c0.836-0.002,1.635-0.342,2.217-0.943l0.848,0.603c0.64,0.454,1.497,0.454,2.137,0l10-7.117c2.77-1.966,4.421-5.151,4.432-8.549
							V32.05C63.002,31.638,62.756,31.266,62.379,31.101z M7.2,4.1c0-0.571,0.462-1.033,1.033-1.033H47.5
							c0.57,0,1.034,0.462,1.034,1.033v21.021l-0.621-0.27c-0.26-0.113-0.557-0.113-0.818,0l-0.619,0.27v-6.554
							c0-0.022-0.013-0.044-0.014-0.067c-0.007-0.086-0.023-0.172-0.05-0.254c-0.008-0.023-0.007-0.048-0.016-0.071
							c-0.009-0.023-0.017-0.023-0.021-0.036c-0.051-0.112-0.121-0.215-0.207-0.303l-12.4-12.4C33.68,5.35,33.579,5.28,33.465,5.229
							c-0.013-0.006-0.022-0.017-0.035-0.022C33.418,5.203,33.383,5.2,33.36,5.192c-0.084-0.027-0.17-0.044-0.258-0.05
							c-0.025,0.003-0.047-0.008-0.069-0.008H7.2V4.1z M34.066,8.662l8.871,8.872H35.1c-0.57,0-1.033-0.462-1.033-1.033V8.662z
							 M43.367,60.934H4.1c-0.571,0-1.033-0.463-1.033-1.033V8.233C3.067,7.663,3.529,7.2,4.1,7.2H32v9.3c0,1.712,1.388,3.1,3.1,3.1
							H44.4v6.414l-3.326,1.439c0.143-0.175,0.222-0.394,0.226-0.619c0-0.572-0.463-1.034-1.033-1.034H25.8
							c-0.57,0-1.033,0.462-1.033,1.034c0,0.57,0.462,1.033,1.033,1.033H40.11l-4.785,2.067H7.2c-0.571,0-1.034,0.463-1.034,1.033
							C6.166,31.538,6.629,32,7.2,32h24.807c0,0.017-0.007,0.033-0.007,0.05v2.017h-6.2c-0.57,0-1.033,0.463-1.033,1.033
							c0,0.571,0.462,1.033,1.033,1.033H32V38.2H7.2c-0.571,0-1.034,0.463-1.034,1.033c0,0.569,0.463,1.033,1.034,1.033H32v2.065h-6.2
							c-0.57,0-1.033,0.464-1.033,1.035c0,0.569,0.462,1.033,1.033,1.033H32v2.065H7.2c-0.571,0-1.034,0.464-1.034,1.034
							s0.463,1.034,1.034,1.034h24.928c0.104,0.703,0.279,1.396,0.524,2.065H25.8c-0.57,0-1.033,0.464-1.033,1.033
							c0,0.571,0.462,1.035,1.033,1.035h7.896c0.489,0.758,1.071,1.453,1.737,2.065H7.2c-0.571,0-1.034,0.464-1.034,1.033
							c0,0.57,0.463,1.033,1.034,1.033h31l5.629,4.009C43.688,60.886,43.529,60.93,43.367,60.934z M60.934,46.993
							c-0.011,2.729-1.338,5.285-3.564,6.866L47.5,60.884l-9.869-7.026c-2.227-1.579-3.554-4.136-3.564-6.864V32.732l1.871-0.807
							l0.02-0.008L47.5,26.925l13.434,5.804V46.993z"></path>
						<g>
							<path d="M54.75,51.078v-10.5c0-0.646-0.527-1.166-1.167-1.166h-1.167v-2.334c0-2.57-2.087-4.666-4.666-4.666
								c-2.573,0-4.665,2.095-4.665,4.666v2.334h-1.169c-0.644,0-1.165,0.52-1.165,1.166v10.5c0,0.651,0.521,1.177,1.165,1.177h11.667
								C54.223,52.255,54.75,51.729,54.75,51.078z M45.416,37.078c0-1.285,1.046-2.329,2.334-2.329c1.294,0,2.332,1.044,2.332,2.329
								v2.334h-4.666V37.078z M52.416,49.913h-9.331v-8.159h9.331V49.913z"></path>
							<path d="M46.584,44.077h2.333v3.502h-2.333V44.077z"></path>
						</g></g></g></svg>`
				),
				totalDocs: getEntityObj(
					cvLoc('entity.sdaOverview.label.total').toUpperCase(),
					cvLoc('entity.sdaOverview.label.totalDocs').toUpperCase(),
					false,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<g><path d="M7.635,13.212v48.849c0,0.52,0.42,0.939,0.939,0.939h35.697c0.519,0,0.938-0.421,0.938-0.939V22.606
						c0-0.021-0.011-0.039-0.013-0.059c-0.006-0.082-0.021-0.164-0.049-0.241c-0.01-0.03-0.018-0.06-0.029-0.089
						c-0.046-0.102-0.109-0.195-0.188-0.275l-9.396-9.394c-0.078-0.079-0.173-0.143-0.274-0.188c-0.029-0.012-0.058-0.022-0.088-0.031
						c-0.078-0.027-0.158-0.043-0.242-0.049c-0.017,0.002-0.035-0.007-0.055-0.007H8.574C8.055,12.273,7.635,12.693,7.635,13.212z
						 M42.004,21.667h-6.188V15.48L42.004,21.667z M9.513,14.151h24.424v8.455c0,0.519,0.422,0.939,0.938,0.939h8.455v37.577H9.513
						V14.151z"></path>
					<path d="M47.09,55.484v1.879h2.818c0.519,0,0.939-0.42,0.939-0.938V7.576c0-0.519-0.422-0.939-0.939-0.939H14.21
						c-0.519,0-0.939,0.42-0.939,0.939v2.818h1.879V8.515h33.818v46.969H47.09z"></path>
					<g>
						<rect x="15.15" y="25.424" width="22.545" height="1.878"></rect>
						<rect x="15.15" y="19.788" width="7.515" height="1.879"></rect>
						<rect x="15.15" y="31.061" width="15.03" height="1.878"></rect>
						<rect x="32.059" y="31.061" width="5.636" height="1.878"></rect>
						<rect x="15.15" y="36.695" width="22.545" height="1.881"></rect>
						<rect x="15.15" y="47.971" width="22.545" height="1.879"></rect>
						<rect x="23.604" y="42.334" width="14.091" height="1.878"></rect>
						<rect x="15.15" y="42.334" width="6.575" height="1.878"></rect>
						<rect x="15.15" y="53.605" width="3.757" height="1.879"></rect>
						<rect x="20.786" y="53.605" width="16.909" height="1.879"></rect>
					</g>
					<path d="M52.607,49.85v1.877h2.817c0.521,0,0.938-0.42,0.938-0.938V1.939C56.365,1.42,55.945,1,55.426,1H19.729
						C19.21,1,18.79,1.42,18.79,1.939v2.818h1.879V2.878h33.819v46.97h-1.881V49.85z"></path>
				</g></svg>`
				)
			};
			function getEntityObj(title, tooltip, addSeperator, image, detailsLink) {
				return {
					title: {
						value: title,
						placement: 'bottom'
					},
					type: PaneEntityTypes.OVERVIEW,
					entityClass: entityClass,
					addSeperator: addSeperator,
					svgSrc: image,
					detailsLink: detailsLink,
					tooltip
				};
			}

			this.overviewPane = {
				title: cvLoc('sdaOverview.title'),
				titleDetailsLink: `#/sdg`,
				entities: Object.values(overviewEntitiesInfo)
			};

			this.getOverviewStats = () => {
				this.overviewPane.showDataLoader = true;
				const entities = [];
				const summaryType = 'SensitiveDataAnalysis';
				reportsDashboardService
					.getActivateSummary(summaryType)
					.success(data => {
						this.overviewPane.showDataLoader = false;
						if (data.genericActivateSummary && data.genericActivateSummary.length) {
							data = data.genericActivateSummary[0];
							Object.keys(overviewEntitiesInfo).forEach(key => {
								const entity = overviewEntitiesInfo[key] || {};
								entity.value = reportsDashboardFactory.formatNumber(data[key]);
								entities.push(entity);
							});
							this.sdaLastCollectionTime = data.lastSyncTime;
						}
						this.overviewPane.entities = entities;
						const lastSyncTime = sessionStorage.getItem('lastSyncTime');
						// do polling if last data collection time is less than last sync operation time
						if (lastSyncTime && lastSyncTime > this.sdaLastCollectionTime) {
							this.statApiTimeout = $timeout(() => this.getOverviewStats(), 30000);
						} else if (this.statApiTimeout) {
							$timeout.cancel(this.statApiTimeout);
						}
					})
					.error(err => {
						cvToaster.showErrorMessage({
							message: err.errorMessage ? err.errorMessage : err
						});
					});
			};
			this.getOverviewStats();
		};
	}
]);
