import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

const app = reportsDashboardModule;

app.directive('cvReportsReqManagerOverview', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<cv-reports-pane pane-data="reqManagerOverviewCtrl.overviewPane"></cv-reports-pane>`,
		require: [],
		bindToController: true,
		controller: 'ReqManagerOverviewCtrl',
		controllerAs: 'reqManagerOverviewCtrl'
	};
});
app.controller('ReqManagerOverviewCtrl', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	function ReqManagerOverviewCtrl(cvLoc, reportsDashboardService, reportsDashboardFactory, PaneEntityTypes, cvToaster) {
		const self = this;
		this.$onInit = function() {
			const entityClass = 'activate-report-pane-entity';
			const overviewEntitiesInfo = {
				totalCount: getEntityObj(
					cvLoc('entity.reqManagerOverview.label.requests').toUpperCase(),
					true,
					`#/taskManager`,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<path d="M52.7 3.6H11.3c-.6 0-1.1.6-1.1 1.3v54.2c0 .7.5 1.3 1.1 1.3h41.3c.6 0 1.1-.6 1.1-1.3V4.9c.1-.7-.4-1.3-1-1.3zM30.1 14.9h13.5c.5 0 .8.4.8.8s-.4.8-.8.8H30.1c-.5 0-.8-.4-.8-.8s.3-.8.8-.8zm-17-3.8c0-.7.6-1.3 1.3-1.3h7.3v1.3h-7.3v10h10v-3.3h1.3v3.3c0 .7-.6 1.3-1.3 1.3h-10c-.7 0-1.3-.6-1.3-1.3v-10zm0 16.1c0-.7.6-1.3 1.3-1.3h7.3v1.3h-7.3v10h10v-3.3h1.3v3.3c0 .7-.6 1.3-1.3 1.3h-10c-.7 0-1.3-.6-1.3-1.3v-10zm12.6 26.5c0 .7-.6 1.3-1.3 1.3h-10c-.7 0-1.3-.6-1.3-1.3v-10c0-.7.6-1.3 1.3-1.3h7.3v1.3h-7.3v10h10v-3.3h1.3v3.3zm3.1-10.2l-6.7 6.7c-.1.1-.3.2-.5.2s-.4-.1-.5-.2l-2.7-2.7c-.1-.1-.2-.3-.2-.5s.1-.4.2-.5c.1-.1.3-.2.5-.2s.4.1.5.2l2.2 2.2 6.1-6.1c.3-.3.8-.3 1.1 0l.1.1c.1.1.2.3.2.5-.1 0-.2.2-.3.3zm0-16.4l-6.7 6.7c-.1.1-.3.2-.5.2s-.4-.1-.5-.2L18.3 31c-.1-.1-.2-.3-.2-.5s.1-.4.2-.5c.1-.1.3-.2.5-.2s.4.1.5.2l2.2 2.2 6.1-6.1c.3-.3.8-.3 1.1 0l.1.1c.1.1.2.3.2.5l-.2.4zm0-16.1l-6.7 6.7c-.1.1-.3.2-.5.2s-.4-.1-.5-.2L18.4 15c-.1-.1-.2-.3-.2-.5s.1-.4.2-.5c.1-.1.3-.2.5-.2s.4.1.5.2l2.2 2.2 6.1-6.1c.3-.3.8-.3 1.1 0l.1.1c.1.1.2.3.2.5-.1-.1-.2.1-.3.3zm1.3 8.8h18.4c.5 0 .8.4.8.8s-.4.8-.8.8H30.1c-.5 0-.8-.4-.8-.8s.3-.8.8-.8zm14.4 12c0 .5-.4.8-.8.8H30.1c-.5 0-.8-.4-.8-.8s.4-.8.8-.8h13.5c.5-.1.9.3.9.8zm4 22.1H30.1c-.5 0-.8-.4-.8-.8s.4-.8.8-.8h18.4c.5 0 .8.4.8.8s-.3.8-.8.8zm-19.2-5.7c0-.5.4-.8.8-.8h13.5c.5 0 .8.4.8.8s-.3.8-.7.8H30.1c-.4 0-.8-.3-.8-.8zm19.2-10.8H30.1c-.5 0-.8-.4-.8-.8s.4-.8.8-.8h18.4c.5 0 .8.4.8.8s-.3.8-.8.8z" fill="none"/>
					<path d="M30.1 16.6h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1c-.5 0-.8.4-.8.8s.3.8.8.8zM30.1 21.4h18.4c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1c-.5 0-.8.4-.8.8s.3.8.8.8zM30.1 30.9c-.5 0-.8.4-.8.8s.4.8.8.8h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1zM48.5 35.8H30.1c-.5 0-.8.4-.8.8s.4.8.8.8h18.4c.5 0 .8-.4.8-.8s-.3-.8-.8-.8zM30.1 49h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1c-.5 0-.8.4-.8.8s.4.8.8.8zM48.5 52.2H30.1c-.5 0-.8.4-.8.8s.4.8.8.8h18.4c.5 0 .8-.4.8-.8s-.3-.8-.8-.8z"/>
					<path d="M52.7 2H11.3C9.9 2 8.8 3.3 8.8 4.9v54.2c0 1.6 1.1 2.9 2.6 2.9h41.3c1.4 0 2.6-1.3 2.6-2.9V4.9C55.2 3.3 54.1 2 52.7 2zm1.1 57.1c0 .7-.5 1.3-1.1 1.3H11.3c-.6 0-1.1-.6-1.1-1.3V4.9c0-.7.5-1.3 1.1-1.3h41.3c.6 0 1.1.6 1.1 1.3v54.2z"/>
					<path d="M14.4 22.4h10c.7 0 1.3-.6 1.3-1.3v-3.3h-1.3v3.3h-10v-10h7.3V9.8h-7.3c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3z"/>
					<path d="M28.8 9.9c-.3-.3-.8-.3-1.1 0L21.6 16l-2.2-2.2c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2l6.7-6.7c.1-.1.2-.3.2-.5l-.2-.4zM14.4 38.5h10c.7 0 1.3-.6 1.3-1.3v-3.3h-1.3v3.3h-10v-10h7.3v-1.3h-7.3c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3z"/>
					<path d="M28.8 26c-.3-.3-.8-.3-1.1 0l-6.1 6.1-2.2-2.2c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2l6.7-6.7c.1-.1.2-.3.2-.5l-.2-.4zM24.4 53.7h-10v-10h7.3v-1.3h-7.3c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3h10c.7 0 1.3-.6 1.3-1.3v-3.3h-1.3v3.3z"/>
					<path d="M28.8 42.5c-.3-.3-.8-.3-1.1 0l-6.1 6.1-2.2-2.2c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2l6.7-6.7c.1-.1.2-.3.2-.5 0-.1-.1-.3-.2-.4z"/>
					</svg>`
				),
				totalOpenRequests: getEntityObj(
					cvLoc('entity.reqManagerOverview.label.openRequests').toUpperCase(),
					true,
					`#taskManager?taskStatus=OpenRequests`,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<path d="M55.3 2H8.7C7.2 2 5.9 3.3 5.9 4.9v54.2c0 1.6 1.3 2.9 2.9 2.9h46.5c1.6 0 2.9-1.3 2.9-2.9V4.9C58.1 3.3 56.8 2 55.3 2zM38.6 4.7l8.5 7.1h-8.5V4.7zm10 55.7H8.7c-.7 0-1.3-.6-1.3-1.3V4.9c0-.7.6-1.3 1.3-1.3H37v9c0 .5.4.8.8.8h10.8v47zm7.9-1.3c0 .7-.6 1.3-1.3 1.3h-5V12.6c0-.2-.1-.5-.3-.6l-10-8.4h15.4c.7 0 1.3.6 1.3 1.3v54.2z"/>
					<path d="M29.1 18.4c0 .5.3.8.8.8h10.3c.5 0 .8-.3.8-.8s-.3-.8-.8-.8H30c-.5 0-.9.3-.9.8zM29.1 23.1c0 .5.4.8.9.8h13.3c.6 0 .9-.3.9-.8s-.4-.8-.9-.8H30.1c-.6 0-1 .3-1 .8zM43.6 31.1H13.3c-.5 0-.9.4-.9.8s.4.8.9.8h30.3c.5 0 .9-.4.9-.8s-.4-.8-.9-.8zM43.7 38.3H13.5c-.5 0-.9.4-.9.8s.4.8.9.8h30.3c.5 0 .9-.4.9-.8s-.5-.8-1-.8zM43.7 45.9H13.5c-.5 0-.9.4-.9.8s.4.8.9.8h30.3c.5 0 .9-.4.9-.8s-.5-.8-1-.8zM43.7 52.6H13.5c-.5 0-.9.4-.9.8s.4.8.9.8h30.3c.5 0 .9-.4.9-.8s-.5-.8-1-.8zM13.5 25.6h10c.7 0 1.3-.6 1.3-1.3V21h-1.3v3.3h-10v-10h7.3V13h-7.3c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3z"/>
					<path d="M18.5 17c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2l6.7-6.7c.1-.1.2-.3.2-.5s-.1-.3-.2-.5l-.1-.1c-.3-.3-.8-.3-1.1 0L20.6 19l-2.1-2z"/>
					</svg>`
				),
				totalNewRequests: getEntityObj(
					cvLoc('entity.reqManagerOverview.label.newRequests').toUpperCase(),
					false,
					`#taskManager?taskStatus=NewRequests`,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<path d="M52.7 3.6H11.3c-.6 0-1.1.6-1.1 1.3v54.2c0 .7.5 1.3 1.1 1.3h41.3c.6 0 1.1-.6 1.1-1.3V4.9c.1-.7-.4-1.3-1-1.3zM30.1 14.9h13.5c.5 0 .8.4.8.8s-.4.8-.8.8H30.1c-.5 0-.8-.4-.8-.8s.3-.8.8-.8zm-17-3.8c0-.7.6-1.3 1.3-1.3h10c.7 0 1.3.6 1.3 1.3v10c0 .7-.6 1.3-1.3 1.3h-10c-.7 0-1.3-.6-1.3-1.3v-10zm12.7 42.4c0 .7-.6 1.3-1.3 1.3h-10c-.7 0-1.3-.6-1.3-1.3v-10c0-.7.6-1.3 1.3-1.3h10c.7 0 1.3.6 1.3 1.3v10zm0-16.4c0 .7-.6 1.3-1.3 1.3h-10c-.7 0-1.3-.6-1.3-1.3v-10c0-.7.6-1.3 1.3-1.3h10c.7 0 1.3.6 1.3 1.3v10zm4.3-17.3h18.4c.5 0 .8.4.8.8s-.4.8-.8.8H30.1c-.5 0-.8-.4-.8-.8s.3-.8.8-.8zm14.4 12c0 .5-.4.8-.8.8H30.1c-.5 0-.8-.4-.8-.8s.4-.8.8-.8h13.5c.5-.1.9.3.9.8zm4 22.1H30.1c-.5 0-.8-.4-.8-.8s.4-.8.8-.8h18.4c.5 0 .8.4.8.8s-.3.8-.8.8zm-19.2-5.7c0-.5.4-.8.8-.8h13.5c.5 0 .8.4.8.8s-.3.8-.7.8H30.1c-.4 0-.8-.3-.8-.8zm19.2-10.8H30.1c-.5 0-.8-.4-.8-.8s.4-.8.8-.8h18.4c.5 0 .8.4.8.8s-.3.8-.8.8z" fill="none"/>
					<path d="M52.7 2H11.3C9.9 2 8.8 3.3 8.8 4.9v54.2c0 1.6 1.1 2.9 2.6 2.9h41.3c1.4 0 2.6-1.3 2.6-2.9V4.9C55.2 3.3 54.1 2 52.7 2zm1.1 57.1c0 .7-.5 1.3-1.1 1.3H11.3c-.6 0-1.1-.6-1.1-1.3V4.9c0-.7.5-1.3 1.1-1.3h41.3c.6 0 1.1.6 1.1 1.3v54.2z"/>
					<path d="M14.4 22.4h10c.7 0 1.3-.6 1.3-1.3v-10c0-.7-.6-1.3-1.3-1.3h-10c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3zm0-11.3h10v10h-10v-10zM30.1 16.6h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1c-.5 0-.8.4-.8.8s.3.8.8.8zM30.1 21.4h18.4c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1c-.5 0-.8.4-.8.8s.3.8.8.8zM24.5 25.8h-10c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3h10c.7 0 1.3-.6 1.3-1.3v-10c0-.7-.6-1.3-1.3-1.3zm0 11.3h-10v-10h10v10zM30.1 30.9c-.5 0-.8.4-.8.8s.4.8.8.8h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1zM48.5 35.8H30.1c-.5 0-.8.4-.8.8s.4.8.8.8h18.4c.5 0 .8-.4.8-.8s-.3-.8-.8-.8zM24.5 42.3h-10c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3h10c.7 0 1.3-.6 1.3-1.3v-10c0-.7-.6-1.3-1.3-1.3zm0 11.2h-10v-10h10v10zM30.1 49h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H30.1c-.5 0-.8.4-.8.8s.4.8.8.8zM48.5 52.2H30.1c-.5 0-.8.4-.8.8s.4.8.8.8h18.4c.5 0 .8-.4.8-.8s-.3-.8-.8-.8z"/>
					</svg>`
				)
			};
			function getEntityObj(title, addSeperator, detailsLink, image) {
				return {
					title: {
						value: title,
						placement: 'bottom'
					},
					type: PaneEntityTypes.OVERVIEW,
					entityClass: entityClass,
					addSeperator: addSeperator,
					detailsLink: detailsLink,
					svgSrc: image
				};
			}

			this.overviewPane = {
				title: cvLoc('reqManagerOverview.title'),
				titleDetailsLink: `#/taskManager`,
				entities: Object.values(overviewEntitiesInfo)
			};

			this.getOverviewStats = () => {
				this.overviewPane.showDataLoader = true;
				const entities = [];
				const self = this;
				const summaryType = 'RequestManagerSummary';
				reportsDashboardService
					.getActivateSummary(summaryType)
					.success(data => {
						self.overviewPane.showDataLoader = false;
						if (data.genericActivateSummary && data.genericActivateSummary.length) {
							data = data.genericActivateSummary[0];
							Object.keys(overviewEntitiesInfo).forEach(key => {
								const entity = overviewEntitiesInfo[key] || {};
								entity.value = reportsDashboardFactory.formatNumber(data[key]);
								entities.push(entity);
							});
						}
						self.overviewPane.entities = entities;
					})
					.error(err => {
						cvToaster.showErrorMessage({
							message: err.errorMessage ? err.errorMessage : err
						});
					});
			};
			this.getOverviewStats();
		};
	}
]);
