import 'modules/reports/js/directives/cv-reports-no-data-directive.js';
import 'modules/reports/js/directives/cv-reports-pane-entity-directive.js';
import 'modules/reports/js/directives/cv-reports-pane-entity-orchestration-directive.js';
import 'modules/reports/js/directives/cv-reports-pane-header-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';
import 'modules/reports/js/directives/cv-reports-sla-directive.js';

import { reportsDashboardModule } from 'common/js/modules';

/**
 * Creates a pane with title and list of entities for the Reports Dashboard
 *
 * Usage <br>
 * ========= <br>
 *
 * <p>
 * Provide an object input(paneData) with the below structure
 * </p>
 *
 * <code>
 * var paneData = {
 * 	title: '', // The title for the pane
 * 	entities: [], // The list of entities to display in the pane
 *  paneClass: '', // css classes to apply for the entire pane
 *  titleDetailsLink: '', // hyperlink for the title
 *  noData: {},	// See cv-reports-no-data-directive.js for usage
 *  showLoader: true | false // Shows the AC loader
 * }
 * <code>
 *
 * <p>paneData.entities is fed to the cv-reports-pane-entities-directive.js file that handles displaying the entities on the pane</p>
 */

reportsDashboardModule.directive('cvReportsPaneOrchestration', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsPaneOrchestration.jsp',
		require: [],
		bindToController: {
			paneData: '='
		},
		controller: 'reportsOrchestrationPaneController',
		controllerAs: 'orchestrationPaneCtrl'
	};
});

reportsDashboardModule.controller('reportsOrchestrationPaneController', [
	'cvLoc',
	function(cvLoc) {
		var self = this;
	}
]);

export default reportsDashboardModule;
