import 'modules/reports/js/directives/cv-reports-no-data-directive.js';
import 'modules/reports/js/directives/cv-reports-pane-header-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';

import { reportsDashboardModule } from 'common/js/modules';

/**
 * Creates a pane with title and highchart for the Reports Dashboard
 *
 * Usage <br>
 * ========= <br>
 *
 * <p>
 * Provide an object input(paneData) with the below structure
 * </p>
 *
 * <code>
 * var paneData = {
 * 	title: '', // The title for the pane
 *  paneClass: '', // css classes to apply for the entire pane
 *  titleDetailsLink: '', // hyperlink for the title
 *  noData: {},	// See cv-reports-no-data-directive.js for usage
 *  showLoader: true | false, // Shows the AC loader
 *  config: {}	// highchart config
 * }
 * <code>
 *
 * <p>paneData.entities is fed to the cv-reports-pane-entities-directive.js file that handles displaying the entities on the pane</p>
 */

reportsDashboardModule.directive('cvReportsPaneHighchart', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsPaneHighchart.jsp',
		require: [],
		bindToController: {
			paneData: '='
		},
		controller: 'reportsPaneHighchartController',
		controllerAs: 'reportsPaneHCCtrl'
	};
});

reportsDashboardModule.controller('reportsPaneHighchartController', [
	'cvLoc',
	function(cvLoc) {
		var self = this;
	}
]);

export default reportsDashboardModule;
