import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsNeedAttention', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<cv-reports-pane pane-data="needAttentionCtrl.data" class="need-attention-pane"></cv-reports-pane>`,
		require: [],
		bindToController: {
			dashboardType: '=',
			entityClass: '='
		},
		controller: 'NeedAttentionController',
		controllerAs: 'needAttentionCtrl'
	};
});
app.controller('NeedAttentionController', [
	'$state',
	'$stateParams',
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'AnomalousEntityTypes',
	'cvToaster',
	'multiCommcellFactory',
	function NeedAttentionController(
		$state,
		$stateParams,
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		AnomalousEntityTypes,
		cvToaster,
		multiCommcellFactory
	) {
		var self = this;
		this.$onInit = function() {
			var entityClass = 'need-attention-entity';
			if (!!self.entityClass) {
				entityClass = self.entityClass;
			}

			var entitiesMetaInfo = {
				servers: getEntityObj(
					cvLoc('entity.label.servers').toUpperCase(),
					'servers.svg',
					PaneEntityTypes.OVERVIEW,
					true
				),
				infrastructures: getEntityObj(
					cvLoc('entity.label.infrastructures').toUpperCase(),
					'infrastructures.svg',
					PaneEntityTypes.OVERVIEW,
					true
				),
				jobs: getEntityObj(cvLoc('entity.label.jobs').toUpperCase(), 'jobs.svg', PaneEntityTypes.OVERVIEW, false)
			};

			var param = '?nav=';
			if ($stateParams.nav) {
				param = param + $stateParams.nav + ',';
			} else if ($state.current.name === 'dashboard') {
				param = param + $state.current.name + '/' + $stateParams.dashboardId;
			} else {
				param = param + $state.current.name;
			}

			entitiesMetaInfo.servers.detailsLink = '#/needsAttention/servers' + param;
			entitiesMetaInfo.infrastructures.detailsLink = '#/needsAttention/infrastructures' + param;
			entitiesMetaInfo.jobs.detailsLink = self.dashboardType === 'Replication' ? '' : '#/activeJobs?view=anomalousJobs';

			function getEntityObj(title, image, type, addSeperator) {
				let data = {
					title: title,
					type: type,
					imgSrc: appUtil.appRoot + 'common/img/' + image,
					entityClass: entityClass,
					addSeperator: addSeperator
				};
				if (cv.isCometApp) {
					data.breakDown = {
						perCommcellData: [],
						isCallout: true
					};
				}
				return data;
			}

			self.data = {
				title: cvLoc('dashboard.needAttention'),
				titletooltip: cvLoc('needs.attention.title.tooltip')
			};

			processData();

			function processData() {
				self.data.showLoader = true;
				var entityTypes = '';
				if (self.dashboardType === 'Replication') {
					entityTypes = AnomalousEntityTypes.drServers;
					entityTypes = entityTypes | AnomalousEntityTypes.drInfrastructure;
					entityTypes = entityTypes | AnomalousEntityTypes.drJobs;
				} else {
					entityTypes = AnomalousEntityTypes.Servers;
					if (self.dashboardType !== 'server') {
						entityTypes = entityTypes | AnomalousEntityTypes.Infrastructure;
					}
					entityTypes = entityTypes | AnomalousEntityTypes.Jobs;
				}

				reportsDashboardService
					.getNeedAttentionData(entityTypes, self.dashboardType)
					.then(function(data) {
						data = data.data;
						self.data.showLoader = false;
						if (!data) {
							self.data.showLoader = false;
							self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
							return;
						}

						self.data.showLoader = false;
						formatData(data);
					})
					.catch(function(err) {
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.error.server') };
						reportsDashboardFactory.showErrorMessage(err, self.paneData.title);
					});
			}

			function formatData(rawData) {
				let data = rawData;
				if (cv.isCometApp && rawData.totalCountResp) {
					data = rawData.totalCountResp;
					const entityToCountMap = {
						servers: 'CountOfAnomalousServers',
						infrastructures: 'CountOfAnomalousInfrastructureServers',
						jobs: 'CountOfAnomalousJobs'
					};
					_.forEach(rawData.commcellEntityRespList, commcellEntity => {
						const commcellName = _.get(commcellEntity, 'commcell.commCellName');
						_.forEach(entitiesMetaInfo, (metaInfo, key) => {
							let link = cvUtil.modifyUrlForComet(metaInfo.detailsLink, commcellName);
							const value = _.get(commcellEntity, entityToCountMap[key], 0);
							let clickFunction = multiCommcellFactory.redirectToCommcell;
							metaInfo.breakDown.perCommcellData.push({
								commcellName,
								rowData: [
									{
										columnName: metaInfo.title,
										value: value,
										link,
										target: '_blank'
									}
								],
								visible: value > 0,
								clickFunction
							});
						});
					});
					// If you want to prevent the callout from coming up at all
					// _.forEach(entitiesMetaInfo, entity => {
					// 	let countOfHiddenRows = _.countBy(entity.breakDown.perCommcellData, 'visible').false;
					// 	entity.hideCallout = countOfHiddenRows == entity.breakDown.perCommcellData.length;
					// });
				}
				entitiesMetaInfo.servers.value = data.CountOfAnomalousServers || 0;
				if (self.dashboardType !== 'server') {
					entitiesMetaInfo.infrastructures.value = data.CountOfAnomalousInfrastructureServers || 0;
				}
				entitiesMetaInfo.jobs.value = data.CountOfAnomalousJobs || 0;

				if (self.dashboardType == 'server') {
					self.data.entities = [entitiesMetaInfo.servers, entitiesMetaInfo.jobs];
				} else if (self.dashboardType == 'endpoint') {
					self.data.entities = [entitiesMetaInfo.jobs];
				} else {
					self.data.entities = [entitiesMetaInfo.servers, entitiesMetaInfo.infrastructures, entitiesMetaInfo.jobs];
				}
			}
		};
	}
]);
