import 'modules/reports/js/services/reports.svc';

import { reportsDashboardModule } from 'common/js/modules';

var app = reportsDashboardModule;

app.directive('cvReportsLargestServers', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsLargestServers.jsp',
		require: [],
		bindToController: {
			dashboardType: '='
		},
		controller: 'reportsLargestServersController',
		controllerAs: 'reportsLargestServersCtrl'
	};
});

app.controller('reportsLargestServersController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvToaster',
	function(cvLoc, reportsDashboardService, reportsDashboardFactory, cvToaster) {
		var self = this;
		this.$onInit = function() {
			self.data = {
				title: cvLoc('dashboard.top5LargestServers.title'),
				titletooltip: cvLoc('dashboard.top5LargestServers.title.tooltip'),
				entities: []
			};

			processData();

			function processData() {
				self.data.showLoader = true;
				reportsDashboardService
					.getLargestSeversData(self.dashboardType)
					.then(function(data) {
						if (data) {
							data = data.data;
						}
						if (!data['records']) {
							console.log('No records found for hardware.');
							self.data.showLoader = false;
							self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
							return;
						}

						if (data.totalRecordCount <= 0) {
							console.log('Records has no rows. Returning false.');
							self.data.showLoader = false;
							self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
							return;
						}

						self.data.showLoader = false;
						formatData(data);
					})
					.catch(function(err) {
						if (err.xhrStatus !== 'abort') {
							self.data.showLoader = false;
							self.data.noData = { text: cvLoc('dashboard.error.server') };
							reportsDashboardFactory.showErrorMessage(err, self.data.title);
							console.log(err);
						}
					});
			}

			function formatData(rawData) {
				var entities = [];

				angular.forEach(rawData.records, function(rowData) {
					var row = {
						name: rowData[3],
						size: reportsDashboardFactory.autoConvertFromMB(rowData[4] * 1024),
						lastBackup: moment(rowData[5]).format('MMM DD, YYYY hh:mm a')
					};
					entities.push(row);
				});
				self.data.entities = entities;
				self.data.showLastBackColumn = self.dashboardType == 'server';
			}
		};
	}
]);

export default app;
