import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';

var app = reportsDashboardModule;

app.directive('cvReportsHealthSummary', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsHealthSummary.jsp',
		bindToController: {
			slaData: '='
		},
		controller: 'HealthSummaryController',
		controllerAs: 'healthCtrl'
	};
});

app.controller('HealthSummaryController', [
	'cvLoc',
	'reportsDashboardService',
	'$log',
	'cvToaster',
	'reportsDashboardFactory',
	'multiCommcellFactory',
	function HealthSummaryController(
		cvLoc,
		reportsDashboardService,
		$log,
		cvToaster,
		reportsDashboardFactory,
		multiCommcellFactory
	) {
		var self = this;

		self.$onInit = function() {
			self.data = {
				title: cvLoc('health.title'),
				titletooltip: cvLoc('health.title.tooltip'),
				titleDetailsLink: '/webconsole/health/health.jsp'
			};
			var summary = {
				criticalLabel: cvLoc('health.label.critical').toUpperCase(),
				warningLabel: cvLoc('health.label.warning').toUpperCase(),
				critical: 0,
				warning: 0
			};
			self.data.showLoader = true;
			self.calloutTemplate = appUtil.appRoot + 'modules/reports/partials/perDashboardCallout.jsp';
			reportsDashboardService
				.getMetricsCommUniqId()
				.then(function(data) {
					if (data) {
						data = data.data;
					}
					var commUniId = 0;
					if (!cv.isCometApp) {
						if (!data['records']) {
							self.data.showLoader = false;
							$log.error('API format is incorrect.');
							self.noData = { text: cvLoc('health.msg.no_data_available') };
							return 0;
						}
						if (data.totalRecordCount <= 0) {
							self.data.showLoader = false;
							$log.error('Records does not have .');
							self.noData = { text: cvLoc('health.msg.no_data_available') };
							return 0;
						}
						var records = data['records'];
						commUniId = records[0][2];
					}
					self.data.titleDetailsLink = '/webconsole/health/health.jsp?commUniId=' + commUniId;
					self.data.detailsLinkNewPage = true;
					self.data.criticalLink = '/webconsole/health/health.jsp?severity=4&grouping=severity&commUniId=' + commUniId;
					self.data.warningLink = '/webconsole/health/health.jsp?severity=3&grouping=severity&commUniId=' + commUniId;
					// Remove leading slash for comet
					self.data.links = {
						'3_Warning': self.data.warningLink.substring(1),
						'4_Critical': self.data.criticalLink.substring(1)
					};
					getHealthSummary(commUniId);
				})
				.catch(function(err) {
					if (err.xhrStatus !== 'abort') {
						self.data.showLoader = false;
						console.log(err);
						cvToaster.showErrorMessage({
							message: self.data.title + ': ' + err.errorMessage
						});
						self.data.noData = { text: cvLoc('dashboard.error.server') };
					}
				});

			const columnNames = {
				status: 'Status',
				dataSource: 'Data Source',
				count: 'Count'
			};
			/**
			 * Convert array of objects, to array of arrays to be compatible with existing code
			 */
			function toLegacyArray(aggregatedRecords, columns) {
				const legacyArray = [];
				_.forEach(aggregatedRecords, record => {
					const recordArray = Array(_.keys(record).length);
					_.forEach(record, (entry, key) => {
						recordArray[columns.indexOf(key)] = entry;
					});
					legacyArray.push(recordArray);
				});
				return legacyArray;
			}

			function toCometBreakDown(groupedRecords, columns) {
				const breakdown = {};
				_.forEach(groupedRecords, (groupedRecord, status) => {
					breakdown[status] = {
						perCommcellData: []
					};
					_.forEach(groupedRecord, record => {
						const commcellName = record[columns.indexOf(columnNames.dataSource)];
						const link = cvUtil.modifyUrlForComet(self.data.links[status] || '', commcellName, 'baseUrl');
						let clickFunction = multiCommcellFactory.redirectToCommcell;
						let valueData = record[columns.indexOf(columnNames.count)];
						breakdown[status].perCommcellData.push({
							commcellName,
							commcellColumnName: cvLoc('label.commcell'),
							rowData: [
								{
									columnName: status,
									value: valueData,
									link,
									target: '_blank'
								}
							],
							visible: valueData > 0,
							clickFunction
						});
					});
					breakdown[status].perCommcellData = _.orderBy(
						breakdown[status].perCommcellData,
						['rowData[0].value', 'commcellName'],
						['desc', 'asc']
					);
					// If all rows are not visible set a new property noVisibleRows
					let countOfHiddenRows = _.countBy(breakdown[status].perCommcellData, 'visible').false;
					if (breakdown[status].perCommcellData && countOfHiddenRows == breakdown[status].perCommcellData.length) {
						_.set(breakdown[status].perCommcellData, 'noVisibleRows', true);
					}
				});
				return breakdown;
			}

			function aggregateCometData(data, columns) {
				if (!cv.isCometApp) {
					return data;
				}
				data.savedRecords = data.records;
				// Group records by sattus
				const groupedRecords = _.groupBy(data.records, record => {
					return record[columns.indexOf(columnNames.status)];
				});
				// Aggregate grouped records based on status
				const aggregatedRecords = toLegacyArray(
					_.map(groupedRecords, (commcellList, status) => {
						return {
							[columnNames.dataSource]: 'comet',
							[columnNames.status]: status,
							[columnNames.count]: _.sumBy(commcellList, row => {
								return row[columns.indexOf(columnNames.count)];
							})
						};
					}),
					columns
				);
				data.records = aggregatedRecords;

				data.breakdown = toCometBreakDown(groupedRecords, columns);
				self.breakdown = data.breakdown;
				return data;
			}

			function getHealthSummary(commUniId) {
				reportsDashboardService
					.getHealthSummary(commUniId)
					.then(function(data) {
						if (data) {
							data = data.data;
						}
						self.data.showLoader = false;
						//console.log(data);
						if (!data['records']) {
							$log.error('API format is incorrect. Returning false.');
							self.noData = { text: cvLoc('health.msg.no_data_available') };
							return;
						}
						var records = data['records'];
						if (data.totalRecordCount <= 0) {
							$log.error('Records does not have . Returning false.');
							self.noData = { text: cvLoc('health.msg.no_data_available') };
							return;
						}
						var columns = [];
						$.each(data.columns, function(i, col) {
							columns.push(col.name);
						});
						var CRITICAL = '4_Critical',
							WARNING = '3_Warning',
							GOOD = '2_Info',
							INFO = '1_Good';
						data = aggregateCometData(data, columns);
						$.each(data.records, function(j, row) {
							var tileStatus = row[columns.indexOf('Status')];
							var cnt = row[columns.indexOf('Count')];
							if (tileStatus == CRITICAL) {
								summary.critical = cnt;
							} else if (tileStatus == WARNING) {
								summary.warning = cnt;
							}
						});
						self.summary = summary;
					})
					.catch(function(err) {
						if (err.xhrStatus !== 'abort') {
							self.data.showLoader = false;
							console.log(err);
							cvToaster.showErrorMessage({
								message: self.data.title + ': ' + err.errorMessage
							});
							self.noData = { text: cvLoc('dashboard.error.server') };
						}
					});
			}
		};
	}
]);

export default app;
