import 'modules/reports/js/services/reports.svc';

import { reportsDashboardModule } from 'common/js/modules';

var app = reportsDashboardModule;

app.directive('cvReportsHardware', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvReportsHardware.jsp',
		require: [],
		controller: 'DashboardHardwareController',
		controllerAs: 'reportsHardwareCtrl'
	};
});
app.controller('DashboardHardwareController', [
	'cvLoc',
	'reportsDashboardService',
	'cvToaster',
	function DashboardHardwareController(cvLoc, reportsDashboardService, cvToaster) {
		var self = this;

		self.data = {
			title: cvLoc('appliance.hardware.title'),
			titleDetailsLink: appUtil.appRoot + '#/reportDetails?name=Appliance%20Hardware%20Report&app=ADMIN_CONSOLE'
		};
		var imgRoot = appUtil.appRoot + 'common/img/';
		var criticalImg = appUtil.appRoot + 'common/img/critical-status.svg';

		self.data.criticalIconSrc = appUtil.appRoot + 'common/img/critical-status.svg';

		var entityMetaInfo = {
			disk: getEntityObj(cvLoc('appliance.hardware.disk'), imgRoot + 'disk.svg', criticalImg),
			'cache-disk': getEntityObj(cvLoc('appliance.hardware.cacheDisk'), imgRoot + 'cache-disk.svg', criticalImg),
			'power-supply': getEntityObj(cvLoc('appliance.hardware.powerSupply'), imgRoot + 'power-supply.svg', criticalImg),
			'fan-state': getEntityObj(cvLoc('appliance.hardware.fanState'), imgRoot + 'fan-state.svg', criticalImg),
			'nic-state': getEntityObj(cvLoc('appliance.hardware.nicState'), imgRoot + 'nic-state.svg', criticalImg)
		};

		function getEntityObj(name, imgSrc, criticalImgSrc) {
			return {
				name: name,
				imgSrc: imgSrc,
				criticalImgSrc: criticalImgSrc
			};
		}

		processData();

		function processData() {
			self.data.showLoader = true;

			reportsDashboardService
				.getHardwareData()
				.success(function(data) {
					if (!data['records']) {
						console.log('No records found for hardware.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					if (data.totalRecordCount <= 0) {
						console.log('Records has no rows. Returning false.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					self.data.showLoader = false;
					formatData(data);
				})
				.error(function(err) {
					console.log(err);
					self.data.showLoader = false;
					self.data.noData = { text: cvLoc('dashboard.error.server') };
					reportsDashboardFactory.showErrorMessage(err, self.data.title);
				});
		}

		function formatData(data) {
			var hardwareTypeMap = {
				1: 'disk',
				2: 'cache-disk',
				4: 'fan-state',
				8: 'power-supply',
				16: 'nic-state'
			};
			var ID_IDX = 1;
			var COUNT_IDX = 3;
			var OFFLINE_IDX = 4;

			if (data.records) {
				angular.forEach(data.records, function(rowData) {
					var id = rowData[ID_IDX];
					var entity = entityMetaInfo[hardwareTypeMap[id]];
					if (!entity) {
						return;
					}

					entity.entityCount = rowData[COUNT_IDX];
					entity.offlineCount = rowData[OFFLINE_IDX];

					if (entity.offlineCount > 0) {
						var count = '<span class="entity-count">' + entity.entityCount + '</span>';
						var offline = '<span class="entity-offline">' + entity.offlineCount + '</span>';
						if (id == 1 || id == 2) {
							entity.errorMsg = cvLoc('appliance.hardware.offline.msg', offline, count);
						} else if (id == 4 || id == 16) {
							entity.errorMsg = cvLoc('appliance.hardware.failed.msg', offline, count);
						} else if (id == 8) {
							entity.errorMsg = cvLoc('appliance.hardware.failed.msg', offline, count);
						}
					}
				});
			}

			var entities = [];
			entities.push(entityMetaInfo['disk']);
			entities.push(entityMetaInfo['cache-disk']);
			entities.push(entityMetaInfo['power-supply']);
			entities.push(entityMetaInfo['fan-state']);
			entities.push(entityMetaInfo['nic-state']);

			self.data.entities = entities;
		}
	}
]);

export default app;
