import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

const app = reportsDashboardModule;

app.directive('cvReportsFsoOverview', function() {
	return {
		restrict: 'E',
		scope: {
			fsoLastCollectionTime: '='
		},
		template: `<cv-reports-pane pane-data="fsoOverviewCtrl.overviewPane"></cv-reports-pane>`,
		require: [],
		bindToController: true,
		controller: 'FsoOverviewController',
		controllerAs: 'fsoOverviewCtrl'
	};
});
app.controller('FsoOverviewController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	'$timeout',
	function FsoOverviewController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster,
		$timeout
	) {
		this.$onInit = function() {
			const entityClass = 'activate-report-pane-entity';
			const overviewEntitiesInfo = {
				totalCount: getEntityObj(
					cvLoc('entity.fsoOverview.label.clients').toUpperCase(),
					true,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">	
					<g><path fill="none" d="M32,33.227c-5.878,0-11.415-0.833-15.593-2.345c-2.26-0.819-4.005-1.802-5.176-2.899v11.074v0.308
						c0,1.678,2.102,3.399,5.765,4.725c3.993,1.445,9.321,2.24,15.004,2.24c5.684,0,11.012-0.795,15.004-2.24
						c3.663-1.327,5.766-3.049,5.766-4.725V27.982c-1.172,1.095-2.914,2.081-5.177,2.898C43.415,32.393,37.879,33.227,32,33.227z
						 M38.209,40.078C36.146,40.296,34.074,40.402,32,40.4c-2.596,0.006-5.19-0.166-7.763-0.51c-0.474-0.066-0.805-0.502-0.74-0.977
						c0.066-0.473,0.501-0.805,0.975-0.74c2.496,0.335,5.011,0.5,7.529,0.495c2.013,0.002,4.024-0.103,6.026-0.313
						c0.474-0.049,0.9,0.297,0.951,0.771C39.029,39.602,38.686,40.027,38.209,40.078z M44.552,40.398
						c-1.427-0.002-2.583-1.157-2.584-2.584c0-1.429,1.157-2.584,2.584-2.584c1.429,0,2.585,1.155,2.585,2.584
						S45.98,40.398,44.552,40.398z"></path>
					<circle fill="none" cx="44.552" cy="37.816" r="0.854"></circle>
					<path fill="none" d="M32,48.061c-5.878,0-11.415-0.832-15.593-2.345c-2.26-0.817-4.005-1.802-5.176-2.897v11.486
						c0,1.678,2.102,3.398,5.765,4.725c3.993,1.445,9.321,2.24,15.004,2.24c5.684,0,11.012-0.795,15.004-2.242
						c3.663-1.326,5.766-3.047,5.766-4.725V42.818c-1.172,1.095-2.914,2.08-5.177,2.897C43.415,47.229,37.879,48.061,32,48.061z
						 M38.208,54.693c-2.062,0.219-4.135,0.326-6.209,0.322c-2.596,0.006-5.19-0.164-7.763-0.511c-0.473-0.065-0.804-0.501-0.74-0.976
						c0.066-0.473,0.501-0.803,0.975-0.739c2.496,0.335,5.011,0.5,7.529,0.495c2.014,0.002,4.023-0.102,6.025-0.313
						c0.476-0.051,0.902,0.293,0.953,0.77C39.027,54.216,38.684,54.643,38.208,54.693z M44.552,55.016c-1.428,0-2.584-1.156-2.584-2.586
						c0-1.427,1.157-2.584,2.584-2.584c1.427,0.002,2.582,1.158,2.585,2.586C47.137,53.859,45.98,55.016,44.552,55.016z"></path>
					<path fill="none" d="M44.552,51.576c-0.471,0-0.854,0.382-0.854,0.855c0,0.471,0.383,0.854,0.854,0.854
						c0.47,0,0.853-0.383,0.854-0.854c0,0,0,0,0-0.002C45.406,51.959,45.023,51.576,44.552,51.576z"></path>
					<circle fill="none" cx="44.552" cy="23.199" r="0.854"></circle>
					<path fill="none" d="M47.003,4.972C43.009,3.526,37.682,2.73,32,2.73c-5.68,0-11.009,0.796-15.003,2.242
						c-3.664,1.327-5.766,3.048-5.766,4.722c0,1.676,2.102,3.398,5.766,4.724C20.991,15.864,26.32,16.66,32,16.66
						c5.682,0,11.009-0.797,15.003-2.241c3.664-1.327,5.767-3.048,5.767-4.724C52.77,8.02,50.666,6.3,47.003,4.972z"></path>
					<path fill="none" d="M32,18.39c-5.877,0-11.414-0.833-15.593-2.345c-2.26-0.818-4.005-1.803-5.176-2.899V24.53
						c0,1.677,2.102,3.398,5.765,4.724c3.993,1.445,9.321,2.241,15.004,2.241c5.684,0,11.012-0.796,15.004-2.241
						c3.663-1.326,5.766-3.048,5.766-4.724V13.146c-1.172,1.095-2.916,2.08-5.178,2.899C43.414,17.557,37.876,18.39,32,18.39z
						 M38.209,25.462c-2.063,0.216-4.135,0.323-6.209,0.322c-2.596,0.005-5.19-0.166-7.763-0.511c-0.469-0.067-0.795-0.499-0.734-0.967
						c0.061-0.474,0.495-0.808,0.969-0.747c2.496,0.334,5.011,0.5,7.529,0.495c2.013,0.002,4.024-0.103,6.026-0.313
						c0.474-0.051,0.9,0.293,0.951,0.769C39.029,24.985,38.686,25.411,38.209,25.462z M44.552,25.784
						c-1.427-0.001-2.583-1.158-2.584-2.584c0,0,0,0,0-0.001c0-1.427,1.157-2.584,2.584-2.584c1.429,0,2.585,1.157,2.585,2.584
						C47.137,24.627,45.98,25.784,44.552,25.784z"></path>
					<path d="M47.592,3.344C43.414,1.833,37.876,1,32,1S20.586,1.833,16.407,3.345C11.954,4.957,9.5,7.212,9.5,9.694v44.609
						c0,2.484,2.453,4.739,6.907,6.352C20.584,62.168,26.122,63,32,63c5.879,0,11.415-0.832,15.593-2.346
						c4.453-1.611,6.907-3.866,6.907-6.35V9.694C54.5,7.212,52.046,4.956,47.592,3.344z M52.77,54.303c0,1.678-2.103,3.398-5.766,4.725
						C43.012,60.475,37.684,61.27,32,61.27c-5.683,0-11.011-0.795-15.004-2.24c-3.663-1.326-5.765-3.047-5.765-4.725V42.818
						c1.171,1.096,2.916,2.08,5.176,2.897c4.178,1.513,9.715,2.345,15.593,2.345c5.879,0,11.415-0.832,15.593-2.345
						c2.263-0.817,4.005-1.803,5.177-2.897V54.303z M52.77,39.364c0,1.676-2.103,3.397-5.766,4.725c-3.992,1.445-9.32,2.24-15.004,2.24
						c-5.683,0-11.011-0.795-15.004-2.24c-3.663-1.325-5.765-3.047-5.765-4.725v-0.308V27.983c1.171,1.097,2.916,2.08,5.176,2.899
						c4.178,1.511,9.715,2.345,15.593,2.345c5.879,0,11.415-0.833,15.593-2.347c2.263-0.817,4.005-1.803,5.177-2.898V39.364z
						 M52.77,24.53c0,1.676-2.103,3.398-5.766,4.724c-3.992,1.445-9.32,2.241-15.004,2.241c-5.683,0-11.011-0.796-15.004-2.241
						c-3.663-1.326-5.765-3.047-5.765-4.724V13.146c1.171,1.096,2.916,2.081,5.176,2.899C20.586,17.557,26.123,18.39,32,18.39
						c5.876,0,11.414-0.833,15.592-2.345c2.262-0.819,4.006-1.804,5.178-2.899V24.53z M47.003,14.419
						C43.009,15.863,37.682,16.66,32,16.66c-5.68,0-11.009-0.796-15.003-2.242c-3.664-1.326-5.766-3.048-5.766-4.724
						c0-1.674,2.102-3.395,5.766-4.722C20.991,3.526,26.32,2.73,32,2.73c5.682,0,11.009,0.796,15.003,2.242
						C50.666,6.3,52.77,8.02,52.77,9.695C52.77,11.371,50.667,13.092,47.003,14.419z"></path>
					<path d="M38.027,23.741c-2.002,0.21-4.014,0.315-6.026,0.313c-2.518,0.005-5.033-0.161-7.529-0.495
						c-0.474-0.061-0.908,0.273-0.969,0.747c-0.061,0.468,0.265,0.9,0.734,0.967c2.573,0.345,5.167,0.516,7.763,0.511
						c2.074,0.001,4.146-0.106,6.209-0.322c0.477-0.051,0.82-0.477,0.77-0.952C38.928,24.034,38.501,23.69,38.027,23.741z"></path>
					<path d="M38.025,52.973c-2.002,0.211-4.012,0.314-6.025,0.313c-2.518,0.005-5.033-0.16-7.529-0.495
						c-0.474-0.063-0.909,0.267-0.975,0.739c-0.064,0.475,0.267,0.91,0.74,0.976c2.573,0.347,5.167,0.517,7.763,0.511
						c2.074,0.004,4.147-0.104,6.209-0.322c0.476-0.051,0.819-0.478,0.771-0.951C38.928,53.266,38.501,52.922,38.025,52.973z"></path>
					<path d="M44.552,20.615c-1.427,0-2.584,1.157-2.584,2.584c0,0.001,0,0.001,0,0.001c0.001,1.426,1.157,2.583,2.584,2.584
						c1.429,0,2.585-1.157,2.585-2.585C47.137,21.772,45.98,20.615,44.552,20.615z M44.552,24.053c-0.472,0-0.854-0.382-0.854-0.854
						c0.001-0.471,0.383-0.853,0.854-0.854c0.472,0,0.854,0.382,0.854,0.854C45.406,23.67,45.023,24.053,44.552,24.053z"></path>
					<path d="M38.027,38.355c-2.002,0.211-4.014,0.315-6.026,0.313c-2.518,0.005-5.033-0.16-7.529-0.495
						c-0.474-0.064-0.909,0.268-0.975,0.74c-0.065,0.475,0.266,0.91,0.74,0.977c2.573,0.344,5.167,0.516,7.763,0.51
						c2.074,0.002,4.146-0.104,6.209-0.322c0.477-0.051,0.82-0.477,0.77-0.952C38.928,38.652,38.501,38.307,38.027,38.355z"></path>
					<path d="M44.552,35.23c-1.427,0-2.584,1.155-2.584,2.584c0.001,1.427,1.157,2.582,2.584,2.584c1.429,0,2.585-1.155,2.585-2.584
						S45.98,35.23,44.552,35.23z M44.552,38.67c-0.472,0-0.854-0.383-0.854-0.854c0.001-0.473,0.383-0.854,0.854-0.854
						s0.854,0.382,0.854,0.854C45.406,38.287,45.023,38.67,44.552,38.67z"></path>
					<path d="M44.552,49.846c-1.427,0-2.584,1.157-2.584,2.584c0,1.43,1.156,2.586,2.584,2.586c1.429,0,2.585-1.156,2.585-2.584
						C47.134,51.004,45.979,49.848,44.552,49.846z M45.406,52.432c-0.002,0.471-0.385,0.854-0.854,0.854
						c-0.472,0-0.854-0.383-0.854-0.854c0-0.474,0.384-0.855,0.854-0.855c0.472,0,0.854,0.383,0.854,0.854
						C45.406,52.432,45.406,52.432,45.406,52.432z"></path></g>
				</svg>`,
					`#/analytics`
				),
				totalDocs: getEntityObj(
					cvLoc('entity.fsoOverview.label.files').toUpperCase(),
					true,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<g><path d="M7.635,13.212v48.849c0,0.52,0.42,0.939,0.939,0.939h35.697c0.519,0,0.938-0.421,0.938-0.939V22.606
						c0-0.021-0.011-0.039-0.013-0.059c-0.006-0.082-0.021-0.164-0.049-0.241c-0.01-0.03-0.018-0.06-0.029-0.089
						c-0.046-0.102-0.109-0.195-0.188-0.275l-9.396-9.394c-0.078-0.079-0.173-0.143-0.274-0.188c-0.029-0.012-0.058-0.022-0.088-0.031
						c-0.078-0.027-0.158-0.043-0.242-0.049c-0.017,0.002-0.035-0.007-0.055-0.007H8.574C8.055,12.273,7.635,12.693,7.635,13.212z
						 M42.004,21.667h-6.188V15.48L42.004,21.667z M9.513,14.151h24.424v8.455c0,0.519,0.422,0.939,0.938,0.939h8.455v37.577H9.513
						V14.151z"></path>
					<path d="M47.09,55.484v1.879h2.818c0.519,0,0.939-0.42,0.939-0.938V7.576c0-0.519-0.422-0.939-0.939-0.939H14.21
						c-0.519,0-0.939,0.42-0.939,0.939v2.818h1.879V8.515h33.818v46.969H47.09z"></path>
					<g>
						<rect x="15.15" y="25.424" width="22.545" height="1.878"></rect>
						<rect x="15.15" y="19.788" width="7.515" height="1.879"></rect>
						<rect x="15.15" y="31.061" width="15.03" height="1.878"></rect>
						<rect x="32.059" y="31.061" width="5.636" height="1.878"></rect>
						<rect x="15.15" y="36.695" width="22.545" height="1.881"></rect>
						<rect x="15.15" y="47.971" width="22.545" height="1.879"></rect>
						<rect x="23.604" y="42.334" width="14.091" height="1.878"></rect>
						<rect x="15.15" y="42.334" width="6.575" height="1.878"></rect>
						<rect x="15.15" y="53.605" width="3.757" height="1.879"></rect>
						<rect x="20.786" y="53.605" width="16.909" height="1.879"></rect>
					</g>
					<path d="M52.607,49.85v1.877h2.817c0.521,0,0.938-0.42,0.938-0.938V1.939C56.365,1.42,55.945,1,55.426,1H19.729
						C19.21,1,18.79,1.42,18.79,1.939v2.818h1.879V2.878h33.819v46.97h-1.881V49.85z"></path>
				</g></svg>`
				),
				totalSizeOfFiles: getEntityObj(
					cvLoc('entity.overview.label.size').toUpperCase(),
					false,
					`<svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
					<g><path fill="none" d="M32,14.419c-4.566,0-8.267,3.702-8.267,8.269s3.701,8.269,8.267,8.269c4.565,0,8.267-3.702,8.267-8.269
						C40.262,18.123,36.563,14.424,32,14.419z M32,27.856c-2.854,0-5.167-2.314-5.167-5.168c0.003-2.853,2.314-5.165,5.167-5.168
						c2.854,0,5.167,2.313,5.167,5.168S34.854,27.856,32,27.856z"></path>
					<circle fill="none" cx="32" cy="22.688" r="3.101"></circle>
					<path fill="none" d="M23.94,35.712l-2.791-3.721H3.067v28.941h57.867V36.125H24.767C24.441,36.125,24.135,35.972,23.94,35.712z"></path>
					<path fill="#CCCCCC" d="M42.333,22.688c0,0.777-0.088,1.533-0.251,2.261l9.124,1.834c0.285-1.342,0.431-2.714,0.427-4.095
						c-0.006-6.456-3.177-12.414-8.343-16.045l-5.885,7.236C40.361,15.697,42.333,18.962,42.333,22.688z"></path>
					<path d="M51.206,26.783l-9.124-1.834c-0.134,0.6-0.317,1.18-0.55,1.735l9.216,1.852
						C50.928,27.959,51.081,27.374,51.206,26.783z"></path>
					<path d="M37.405,13.878l5.885-7.236c-0.494-0.348-1.007-0.673-1.537-0.976l-6.009,7.388
						C36.325,13.281,36.881,13.556,37.405,13.878z"></path>
					<path d="M12.985,27.596c-1.893-7.366,0.637-15.163,6.493-20.014c5.856-4.851,13.986-5.883,20.868-2.65
						c0.482,0.227,0.95,0.473,1.407,0.734c0.53,0.303,1.043,0.628,1.537,0.976c5.166,3.631,8.337,9.59,8.343,16.045
						c0.004,1.381-0.142,2.753-0.427,4.095c-0.125,0.591-0.278,1.176-0.458,1.753c-0.29,0.93-0.649,1.84-1.078,2.722l1.86,0.901
						c1.437-2.95,2.179-6.189,2.17-9.471c-0.007-8.407-4.867-16.054-12.475-19.629c-7.607-3.574-16.594-2.433-23.067,2.93
						c-6.473,5.363-9.269,13.982-7.174,22.124L12.985,27.596z"></path>
					<path d="M32,17.52c-2.852,0.003-5.163,2.315-5.167,5.168c0,2.854,2.313,5.168,5.167,5.168s5.167-2.314,5.167-5.168
						S34.854,17.52,32,17.52z M32,25.789c-1.712,0-3.1-1.389-3.1-3.101c0-1.713,1.388-3.101,3.1-3.101s3.1,1.388,3.1,3.101
						C35.1,24.4,33.712,25.789,32,25.789z"></path>
					<path d="M42.082,24.949c0.163-0.728,0.251-1.484,0.251-2.261c0-3.726-1.972-6.991-4.928-8.81
						c-0.524-0.323-1.08-0.598-1.661-0.824c-1.161-0.452-2.423-0.703-3.744-0.703c-5.705,0.006-10.327,4.63-10.333,10.336
						c0,5.708,4.626,10.336,10.333,10.336c4.291,0,7.97-2.616,9.532-6.34C41.765,26.129,41.948,25.549,42.082,24.949z M32,30.957
						c-4.566,0-8.267-3.702-8.267-8.269s3.701-8.269,8.267-8.269c4.563,0.005,8.262,3.704,8.267,8.269
						C40.267,27.255,36.565,30.957,32,30.957z"></path>
					<path d="M61.967,23.722h-6.2v2.067h5.167v8.27h-35.65l-2.79-3.722c-0.195-0.26-0.501-0.413-0.827-0.413h-18.6
						v-4.135h5.167v-2.067h-6.2C1.463,23.722,1,24.184,1,24.755v37.21C1,62.537,1.463,63,2.033,63h59.934C62.537,63,63,62.537,63,61.966
						v-37.21C63,24.184,62.537,23.722,61.967,23.722z M60.934,60.933H3.067V31.991H21.15l2.791,3.721
						c0.194,0.26,0.501,0.413,0.826,0.413h36.167V60.933z"></path></g></svg>`
				)
			};
			function getEntityObj(title, addSeperator, image, detailsLink) {
				return {
					title: {
						value: title,
						placement: 'bottom'
					},
					type: PaneEntityTypes.OVERVIEW,
					entityClass: entityClass,
					addSeperator: addSeperator,
					svgSrc: image,
					detailsLink: detailsLink
				};
			}

			this.overviewPane = {
				title: cvLoc('fsoOverview.title'),
				titleDetailsLink: `#/analytics`,
				entities: Object.values(overviewEntitiesInfo)
			};

			this.getOverviewStats = () => {
				this.overviewPane.showDataLoader = true;
				const entities = [];
				const summaryType = 'FileSystemOptimization';
				reportsDashboardService
					.getActivateSummary(summaryType)
					.success(data => {
						this.overviewPane.showDataLoader = false;
						if (data.genericActivateSummary && data.genericActivateSummary.length) {
							data = data.genericActivateSummary[0];
							Object.keys(overviewEntitiesInfo).forEach(key => {
								const entity = overviewEntitiesInfo[key] || {};
								entity.value =
									key === 'totalSizeOfFiles'
										? reportsDashboardFactory.formatBytes(data[key])
										: reportsDashboardFactory.formatNumber(data[key]);
								entities.push(entity);
							});
							this.fsoLastCollectionTime = data.lastSyncTime;
						}
						this.overviewPane.entities = entities;
						const lastSyncTime = sessionStorage.getItem('lastSyncTime');
						// do polling if last data collection time is less than last sync operation time
						if (lastSyncTime && lastSyncTime > this.fsoLastCollectionTime) {
							this.statApiTimeout = $timeout(() => this.getOverviewStats(), 30000);
						} else if (this.statApiTimeout) {
							$timeout.cancel(this.statApiTimeout);
						}
					})
					.error(err => {
						cvToaster.showErrorMessage({
							message: err.errorMessage ? err.errorMessage : err
						});
					});
			};
			this.getOverviewStats();
		};
	}
]);
