import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvCommcellInfo', function() {
	return {
		restrict: 'E',
		scope: {},
		template: `<div class="meta-info">
					<span class="meta-item" ng-repeat="entity in ccInfo.entities">
						<span class="meta-name">{{entity.title}}:</span>
						<span class="meta-val" data-ng-if="!entity.detailsUrl">{{entity.value}}</span>
						<span class="meta-val" data-ng-if="!!entity.detailsUrl"><a data-ng-href="{{entity.detailsUrl}}">{{entity.value}}</a></span>
					</span>
				   </div>
				   <div class=clear-float></div>`,
		require: [],
		bindToController: {
			customClass: '='
		},
		controller: 'CommCellInfoController',
		controllerAs: 'ccInfo'
	};
});
app.controller('CommCellInfoController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvToaster',
	'$filter',
	function CommCellInfoController(cvLoc, reportsDashboardService, reportsDashboardFactory, cvToaster, $filter) {
		var self = this;
		this.$onInit = function() {
			var entitiesInfo = {
				ccId: {
					title: cvLoc('ccinfo.label.ccid'),
					value: ''
				},
				ccName: {
					title: cvLoc('ccinfo.label.name'),
					value: '',
					detailsUrl: '#/commCell'
				},
				version: {
					title: cvLoc('ccinfo.label.version'),
					value: ''
				}
			};

			reportsDashboardFactory
				.getCommCellInfo()
				.then(function(info) {
					if (info) {
						entitiesInfo.version.value = $filter('getVersionString')(info.version);
						entitiesInfo.ccName.value = info.ccName;
						entitiesInfo.ccId.value = info.ccId;
						self.entities = [entitiesInfo.ccId, entitiesInfo.ccName, entitiesInfo.version];
					}
				})
				.catch(function(err) {
					if (err.xhrStatus !== 'abort') {
						console.log(err);
						reportsDashboardFactory.showErrorMessage(err, 'CommCell Information');
					}
				});
		};
	}
]);
