import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

const app = reportsDashboardModule;

app.directive('cvReportsActivateJobStats', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: 'modules/reports/partials/activateJobStats.jsp',
		bindToController: true,
		controller: 'ActivateJobStatsController',
		controllerAs: 'activateJobStatsCtrl'
	};
});
app.controller('ActivateJobStatsController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	function UsageOverviewController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster
	) {
		this.$onInit = function() {
			this.data = {
				title: cvLoc('jobs.title'),
				titletooltip: cvLoc('jobs.title') /*,
				titleDetailsLink: ''*/
			};
			this.jobInfo = [
				{
					label: cvLoc('entity.jobStats.label.running').toUpperCase(),
					count: 'N/A',
					styleClass: 'border-gray',
					image: `<img data-ng-src="common/img/runningJobs.svg" src="common/img/runningJobs.svg"/>`
				},
				{
					label: cvLoc('entity.jobStats.label.completed').toUpperCase(),
					count: 'N/A',
					styleClass: 'border-success',
					image: `<img data-ng-src="common/img/successfulJobs.svg" src="common/img/successfulJobs.svg"/>`
				},
				{
					label: cvLoc('entity.jobStats.label.failed').toUpperCase(),
					count: 'N/A',
					styleClass: 'border-critical',
					image: `<img data-ng-src="common/img/failedJobs.svg" src="common/img/failedJobs.svg"/>`
				}
			];
		};
	}
]);
